# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetInstanceTypeResult',
    'AwaitableGetInstanceTypeResult',
    'get_instance_type',
    'get_instance_type_output',
]

@pulumi.output_type
class GetInstanceTypeResult:
    """
    A collection of values returned by getInstanceType.
    """
    def __init__(__self__, accelerated_devices=None, addons=None, class_=None, disk=None, id=None, label=None, memory=None, network_out=None, prices=None, region_prices=None, transfer=None, vcpus=None):
        if accelerated_devices and not isinstance(accelerated_devices, int):
            raise TypeError("Expected argument 'accelerated_devices' to be a int")
        pulumi.set(__self__, "accelerated_devices", accelerated_devices)
        if addons and not isinstance(addons, list):
            raise TypeError("Expected argument 'addons' to be a list")
        pulumi.set(__self__, "addons", addons)
        if class_ and not isinstance(class_, str):
            raise TypeError("Expected argument 'class_' to be a str")
        pulumi.set(__self__, "class_", class_)
        if disk and not isinstance(disk, int):
            raise TypeError("Expected argument 'disk' to be a int")
        pulumi.set(__self__, "disk", disk)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label and not isinstance(label, str):
            raise TypeError("Expected argument 'label' to be a str")
        pulumi.set(__self__, "label", label)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if network_out and not isinstance(network_out, int):
            raise TypeError("Expected argument 'network_out' to be a int")
        pulumi.set(__self__, "network_out", network_out)
        if prices and not isinstance(prices, list):
            raise TypeError("Expected argument 'prices' to be a list")
        pulumi.set(__self__, "prices", prices)
        if region_prices and not isinstance(region_prices, list):
            raise TypeError("Expected argument 'region_prices' to be a list")
        pulumi.set(__self__, "region_prices", region_prices)
        if transfer and not isinstance(transfer, int):
            raise TypeError("Expected argument 'transfer' to be a int")
        pulumi.set(__self__, "transfer", transfer)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)

    @_builtins.property
    @pulumi.getter(name="acceleratedDevices")
    def accelerated_devices(self) -> _builtins.int:
        """
        The number of VPUs this Linode Type offers.
        """
        return pulumi.get(self, "accelerated_devices")

    @_builtins.property
    @pulumi.getter
    def addons(self) -> Sequence['outputs.GetInstanceTypeAddonResult']:
        return pulumi.get(self, "addons")

    @_builtins.property
    @pulumi.getter(name="class")
    def class_(self) -> _builtins.str:
        """
        The class of the Linode Type. See all classes [here](https://techdocs.akamai.com/linode-api/reference/get-linode-type).
        """
        return pulumi.get(self, "class_")

    @_builtins.property
    @pulumi.getter
    def disk(self) -> _builtins.int:
        """
        The Disk size, in MB, of the Linode Type
        """
        return pulumi.get(self, "disk")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID representing the Linode Type
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def label(self) -> _builtins.str:
        """
        The Linode Type's label is for display purposes only
        """
        return pulumi.get(self, "label")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        The amount of RAM included in this Linode Type.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="networkOut")
    def network_out(self) -> _builtins.int:
        """
        The Mbits outbound bandwidth allocation.
        """
        return pulumi.get(self, "network_out")

    @_builtins.property
    @pulumi.getter
    def prices(self) -> Sequence['outputs.GetInstanceTypePriceResult']:
        return pulumi.get(self, "prices")

    @_builtins.property
    @pulumi.getter(name="regionPrices")
    def region_prices(self) -> Sequence['outputs.GetInstanceTypeRegionPriceResult']:
        return pulumi.get(self, "region_prices")

    @_builtins.property
    @pulumi.getter
    def transfer(self) -> _builtins.int:
        """
        The monthly outbound transfer amount, in MB.
        """
        return pulumi.get(self, "transfer")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> _builtins.int:
        """
        The number of VCPU cores this Linode Type offers.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetInstanceTypeResult(GetInstanceTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceTypeResult(
            accelerated_devices=self.accelerated_devices,
            addons=self.addons,
            class_=self.class_,
            disk=self.disk,
            id=self.id,
            label=self.label,
            memory=self.memory,
            network_out=self.network_out,
            prices=self.prices,
            region_prices=self.region_prices,
            transfer=self.transfer,
            vcpus=self.vcpus)


def get_instance_type(id: Optional[_builtins.str] = None,
                      label: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceTypeResult:
    """
    Provides information about a Linode instance type
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-linode-type).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode Instance type.

    ```python
    import pulumi
    import pulumi_linode as linode

    default = linode.get_instance_type(id="g6-standard-2")
    ```


    :param _builtins.str id: Label used to identify instance type
    :param _builtins.str label: The Linode Type's label is for display purposes only
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['label'] = label
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getInstanceType:getInstanceType', __args__, opts=opts, typ=GetInstanceTypeResult).value

    return AwaitableGetInstanceTypeResult(
        accelerated_devices=pulumi.get(__ret__, 'accelerated_devices'),
        addons=pulumi.get(__ret__, 'addons'),
        class_=pulumi.get(__ret__, 'class_'),
        disk=pulumi.get(__ret__, 'disk'),
        id=pulumi.get(__ret__, 'id'),
        label=pulumi.get(__ret__, 'label'),
        memory=pulumi.get(__ret__, 'memory'),
        network_out=pulumi.get(__ret__, 'network_out'),
        prices=pulumi.get(__ret__, 'prices'),
        region_prices=pulumi.get(__ret__, 'region_prices'),
        transfer=pulumi.get(__ret__, 'transfer'),
        vcpus=pulumi.get(__ret__, 'vcpus'))
def get_instance_type_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                             label: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceTypeResult]:
    """
    Provides information about a Linode instance type
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-linode-type).

    ## Example Usage

    The following example shows how one might use this data source to access information about a Linode Instance type.

    ```python
    import pulumi
    import pulumi_linode as linode

    default = linode.get_instance_type(id="g6-standard-2")
    ```


    :param _builtins.str id: Label used to identify instance type
    :param _builtins.str label: The Linode Type's label is for display purposes only
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['label'] = label
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getInstanceType:getInstanceType', __args__, opts=opts, typ=GetInstanceTypeResult)
    return __ret__.apply(lambda __response__: GetInstanceTypeResult(
        accelerated_devices=pulumi.get(__response__, 'accelerated_devices'),
        addons=pulumi.get(__response__, 'addons'),
        class_=pulumi.get(__response__, 'class_'),
        disk=pulumi.get(__response__, 'disk'),
        id=pulumi.get(__response__, 'id'),
        label=pulumi.get(__response__, 'label'),
        memory=pulumi.get(__response__, 'memory'),
        network_out=pulumi.get(__response__, 'network_out'),
        prices=pulumi.get(__response__, 'prices'),
        region_prices=pulumi.get(__response__, 'region_prices'),
        transfer=pulumi.get(__response__, 'transfer'),
        vcpus=pulumi.get(__response__, 'vcpus')))
