# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetPlacementGroupsResult',
    'AwaitableGetPlacementGroupsResult',
    'get_placement_groups',
    'get_placement_groups_output',
]

@pulumi.output_type
class GetPlacementGroupsResult:
    """
    A collection of values returned by getPlacementGroups.
    """
    def __init__(__self__, filters=None, id=None, order=None, order_by=None, placement_groups=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if order and not isinstance(order, str):
            raise TypeError("Expected argument 'order' to be a str")
        pulumi.set(__self__, "order", order)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if placement_groups and not isinstance(placement_groups, list):
            raise TypeError("Expected argument 'placement_groups' to be a list")
        pulumi.set(__self__, "placement_groups", placement_groups)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetPlacementGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "order_by")

    @_builtins.property
    @pulumi.getter(name="placementGroups")
    def placement_groups(self) -> Optional[Sequence['outputs.GetPlacementGroupsPlacementGroupResult']]:
        return pulumi.get(self, "placement_groups")


class AwaitableGetPlacementGroupsResult(GetPlacementGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPlacementGroupsResult(
            filters=self.filters,
            id=self.id,
            order=self.order,
            order_by=self.order_by,
            placement_groups=self.placement_groups)


def get_placement_groups(filters: Optional[Sequence[Union['GetPlacementGroupsFilterArgs', 'GetPlacementGroupsFilterArgsDict']]] = None,
                         order: Optional[_builtins.str] = None,
                         order_by: Optional[_builtins.str] = None,
                         placement_groups: Optional[Sequence[Union['GetPlacementGroupsPlacementGroupArgs', 'GetPlacementGroupsPlacementGroupArgsDict']]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPlacementGroupsResult:
    """
    Provides information about a list of Linode Placement Groups that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-placement-groups).

    ## Example Usage

    The following example shows how one might use this data source to list Placement Groups.

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_placement_groups()
    filtered = linode.get_placement_groups(filters=[{
        "name": "label",
        "values": ["my-label"],
    }])
    pulumi.export("all-pgs", all.placement_groups)
    pulumi.export("filtered-pgs", filtered.placement_groups)
    ```

    ## Filterable Fields

    * `id`

    * `label`

    * `region`

    * `placement_group_type`

    * `placement_group_policy`

    * `is_compliant`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    __args__['placementGroups'] = placement_groups
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('linode:index/getPlacementGroups:getPlacementGroups', __args__, opts=opts, typ=GetPlacementGroupsResult).value

    return AwaitableGetPlacementGroupsResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        order=pulumi.get(__ret__, 'order'),
        order_by=pulumi.get(__ret__, 'order_by'),
        placement_groups=pulumi.get(__ret__, 'placement_groups'))
def get_placement_groups_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetPlacementGroupsFilterArgs', 'GetPlacementGroupsFilterArgsDict']]]]] = None,
                                order: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                order_by: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                placement_groups: Optional[pulumi.Input[Optional[Sequence[Union['GetPlacementGroupsPlacementGroupArgs', 'GetPlacementGroupsPlacementGroupArgsDict']]]]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPlacementGroupsResult]:
    """
    Provides information about a list of Linode Placement Groups that match a set of filters.
    For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/get-placement-groups).

    ## Example Usage

    The following example shows how one might use this data source to list Placement Groups.

    ```python
    import pulumi
    import pulumi_linode as linode

    all = linode.get_placement_groups()
    filtered = linode.get_placement_groups(filters=[{
        "name": "label",
        "values": ["my-label"],
    }])
    pulumi.export("all-pgs", all.placement_groups)
    pulumi.export("filtered-pgs", filtered.placement_groups)
    ```

    ## Filterable Fields

    * `id`

    * `label`

    * `region`

    * `placement_group_type`

    * `placement_group_policy`

    * `is_compliant`
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['order'] = order
    __args__['orderBy'] = order_by
    __args__['placementGroups'] = placement_groups
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('linode:index/getPlacementGroups:getPlacementGroups', __args__, opts=opts, typ=GetPlacementGroupsResult)
    return __ret__.apply(lambda __response__: GetPlacementGroupsResult(
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        order=pulumi.get(__response__, 'order'),
        order_by=pulumi.get(__response__, 'order_by'),
        placement_groups=pulumi.get(__response__, 'placement_groups')))
