# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['InstanceSharedIpsArgs', 'InstanceSharedIps']

@pulumi.input_type
class InstanceSharedIpsArgs:
    def __init__(__self__, *,
                 addresses: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 linode_id: pulumi.Input[_builtins.int]):
        """
        The set of arguments for constructing a InstanceSharedIps resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: The set of IPs to share with the Linode.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to share the IPs to.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "linode_id", linode_id)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The set of IPs to share with the Linode.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "addresses", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Input[_builtins.int]:
        """
        The ID of the Linode to share the IPs to.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "linode_id", value)


@pulumi.input_type
class _InstanceSharedIpsState:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering InstanceSharedIps resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: The set of IPs to share with the Linode.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to share the IPs to.
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if linode_id is not None:
            pulumi.set(__self__, "linode_id", linode_id)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The set of IPs to share with the Linode.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "addresses", value)

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ID of the Linode to share the IPs to.
        """
        return pulumi.get(self, "linode_id")

    @linode_id.setter
    def linode_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "linode_id", value)


@pulumi.type_token("linode:index/instanceSharedIps:InstanceSharedIps")
class InstanceSharedIps(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages IPs shared to a Linode instance.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-share-ips).

        > **Beta Notice** IPv6 sharing is currently available through early access.
        To use early access resources, the `api_version` provider argument must be set to `v4beta`.
        To learn more, see the early access documentation.

        > **Notice** This resource should only be defined once per-instance and should not be used alongside the `shared_ipv4` field in `Instance`.

        ## Example Usage

        Share in IPv4 address between two instances:

        ```python
        import pulumi
        import pulumi_linode as linode

        # Create a single primary node
        primary_instance = linode.Instance("primary",
            label="node-primary",
            type="g6-nanode-1",
            region="eu-central")
        # Allocate an IP under the primary node
        primary = linode.InstanceIp("primary", linode_id=primary_instance.id)
        # Create a secondary node
        secondary = linode.Instance("secondary",
            label="node-secondary",
            type="g6-nanode-1",
            region="eu-central")
        # Share the IP with the secondary node
        share_primary = linode.InstanceSharedIps("share-primary",
            linode_id=secondary.id,
            addresses=[primary.address])
        ```

        Share an IPv6 address among a primary node and its replicas:

        ```python
        import pulumi
        import pulumi_linode as linode

        # Create a single primary node
        primary = linode.Instance("primary",
            label="node-primary",
            type="g6-nanode-1",
            region="eu-central")
        # Allocate an IPv6 range pointing at the primary node
        range_ipv6_range = linode.Ipv6Range("range",
            prefix_length=64,
            linode_id=primary.id)
        # Share with primary node
        share_primary = linode.InstanceSharedIps("share-primary",
            linode_id=primary.id,
            addresses=[range_ipv6_range.range])
        config = pulumi.Config()
        number_replicas = config.get_float("numberReplicas")
        if number_replicas is None:
            number_replicas = 2
        # Create two secondary nodes
        secondary = []
        for range in [{"value": i} for i in range(0, number_replicas)]:
            secondary.append(linode.Instance(f"secondary-{range['value']}",
                label=f"node-secondary-{range['value']}",
                type="g6-nanode-1",
                region="eu-central"))
        # Share with secondary nodes
        share_secondary = []
        for range in [{"value": i} for i in range(0, number_replicas)]:
            share_secondary.append(linode.InstanceSharedIps(f"share-secondary-{range['value']}",
                linode_id=secondary[range["value"]].id,
                addresses=[range_ipv6_range.range],
                opts = pulumi.ResourceOptions(depends_on=[share_primary])))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: The set of IPs to share with the Linode.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to share the IPs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceSharedIpsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages IPs shared to a Linode instance.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-share-ips).

        > **Beta Notice** IPv6 sharing is currently available through early access.
        To use early access resources, the `api_version` provider argument must be set to `v4beta`.
        To learn more, see the early access documentation.

        > **Notice** This resource should only be defined once per-instance and should not be used alongside the `shared_ipv4` field in `Instance`.

        ## Example Usage

        Share in IPv4 address between two instances:

        ```python
        import pulumi
        import pulumi_linode as linode

        # Create a single primary node
        primary_instance = linode.Instance("primary",
            label="node-primary",
            type="g6-nanode-1",
            region="eu-central")
        # Allocate an IP under the primary node
        primary = linode.InstanceIp("primary", linode_id=primary_instance.id)
        # Create a secondary node
        secondary = linode.Instance("secondary",
            label="node-secondary",
            type="g6-nanode-1",
            region="eu-central")
        # Share the IP with the secondary node
        share_primary = linode.InstanceSharedIps("share-primary",
            linode_id=secondary.id,
            addresses=[primary.address])
        ```

        Share an IPv6 address among a primary node and its replicas:

        ```python
        import pulumi
        import pulumi_linode as linode

        # Create a single primary node
        primary = linode.Instance("primary",
            label="node-primary",
            type="g6-nanode-1",
            region="eu-central")
        # Allocate an IPv6 range pointing at the primary node
        range_ipv6_range = linode.Ipv6Range("range",
            prefix_length=64,
            linode_id=primary.id)
        # Share with primary node
        share_primary = linode.InstanceSharedIps("share-primary",
            linode_id=primary.id,
            addresses=[range_ipv6_range.range])
        config = pulumi.Config()
        number_replicas = config.get_float("numberReplicas")
        if number_replicas is None:
            number_replicas = 2
        # Create two secondary nodes
        secondary = []
        for range in [{"value": i} for i in range(0, number_replicas)]:
            secondary.append(linode.Instance(f"secondary-{range['value']}",
                label=f"node-secondary-{range['value']}",
                type="g6-nanode-1",
                region="eu-central"))
        # Share with secondary nodes
        share_secondary = []
        for range in [{"value": i} for i in range(0, number_replicas)]:
            share_secondary.append(linode.InstanceSharedIps(f"share-secondary-{range['value']}",
                linode_id=secondary[range["value"]].id,
                addresses=[range_ipv6_range.range],
                opts = pulumi.ResourceOptions(depends_on=[share_primary])))
        ```

        :param str resource_name: The name of the resource.
        :param InstanceSharedIpsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceSharedIpsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 linode_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceSharedIpsArgs.__new__(InstanceSharedIpsArgs)

            if addresses is None and not opts.urn:
                raise TypeError("Missing required property 'addresses'")
            __props__.__dict__["addresses"] = addresses
            if linode_id is None and not opts.urn:
                raise TypeError("Missing required property 'linode_id'")
            __props__.__dict__["linode_id"] = linode_id
        super(InstanceSharedIps, __self__).__init__(
            'linode:index/instanceSharedIps:InstanceSharedIps',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            linode_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'InstanceSharedIps':
        """
        Get an existing InstanceSharedIps resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] addresses: The set of IPs to share with the Linode.
        :param pulumi.Input[_builtins.int] linode_id: The ID of the Linode to share the IPs to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceSharedIpsState.__new__(_InstanceSharedIpsState)

        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["linode_id"] = linode_id
        return InstanceSharedIps(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The set of IPs to share with the Linode.
        """
        return pulumi.get(self, "addresses")

    @_builtins.property
    @pulumi.getter(name="linodeId")
    def linode_id(self) -> pulumi.Output[_builtins.int]:
        """
        The ID of the Linode to share the IPs to.
        """
        return pulumi.get(self, "linode_id")

