# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 domain_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]]] = None,
                 firewall_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]]] = None,
                 global_grants: Optional[pulumi.Input['UserGlobalGrantsArgs']] = None,
                 image_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]]] = None,
                 linode_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]]] = None,
                 longview_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]]] = None,
                 nodebalancer_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]]] = None,
                 placement_group_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]]] = None,
                 restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 stackscript_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]]] = None,
                 volume_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]]] = None,
                 vpc_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] email: The email address of the user.
        :param pulumi.Input[_builtins.str] username: The username of the user.
        :param pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]] domain_grants: The domains the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]] firewall_grants: The firewalls the user has permissions access to.
        :param pulumi.Input['UserGlobalGrantsArgs'] global_grants: A structure containing the Account-level grants a User has.
        :param pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]] image_grants: The images the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]] linode_grants: The Linodes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]] longview_grants: The longview the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]] nodebalancer_grants: The NodeBalancers the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]] placement_group_grants: The Placement Groups the user has permissions access to.
        :param pulumi.Input[_builtins.bool] restricted: If true, this user will only have explicit permissions granted.
               
               * `global_grants` - (optional) A structure containing the Account-level grants a User has.
               
               The following arguments are sets of entity grants:
        :param pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]] stackscript_grants: The StackScripts the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]] volume_grants: The volumes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]] vpc_grants: The Virtual Private Clouds (VPCs) the user has permissions access to.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "username", username)
        if domain_grants is not None:
            pulumi.set(__self__, "domain_grants", domain_grants)
        if firewall_grants is not None:
            pulumi.set(__self__, "firewall_grants", firewall_grants)
        if global_grants is not None:
            pulumi.set(__self__, "global_grants", global_grants)
        if image_grants is not None:
            pulumi.set(__self__, "image_grants", image_grants)
        if linode_grants is not None:
            pulumi.set(__self__, "linode_grants", linode_grants)
        if longview_grants is not None:
            pulumi.set(__self__, "longview_grants", longview_grants)
        if nodebalancer_grants is not None:
            pulumi.set(__self__, "nodebalancer_grants", nodebalancer_grants)
        if placement_group_grants is not None:
            pulumi.set(__self__, "placement_group_grants", placement_group_grants)
        if restricted is not None:
            pulumi.set(__self__, "restricted", restricted)
        if stackscript_grants is not None:
            pulumi.set(__self__, "stackscript_grants", stackscript_grants)
        if volume_grants is not None:
            pulumi.set(__self__, "volume_grants", volume_grants)
        if vpc_grants is not None:
            pulumi.set(__self__, "vpc_grants", vpc_grants)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The username of the user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="domainGrants")
    def domain_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]]]:
        """
        The domains the user has permissions access to.
        """
        return pulumi.get(self, "domain_grants")

    @domain_grants.setter
    def domain_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]]]):
        pulumi.set(self, "domain_grants", value)

    @_builtins.property
    @pulumi.getter(name="firewallGrants")
    def firewall_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]]]:
        """
        The firewalls the user has permissions access to.
        """
        return pulumi.get(self, "firewall_grants")

    @firewall_grants.setter
    def firewall_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]]]):
        pulumi.set(self, "firewall_grants", value)

    @_builtins.property
    @pulumi.getter(name="globalGrants")
    def global_grants(self) -> Optional[pulumi.Input['UserGlobalGrantsArgs']]:
        """
        A structure containing the Account-level grants a User has.
        """
        return pulumi.get(self, "global_grants")

    @global_grants.setter
    def global_grants(self, value: Optional[pulumi.Input['UserGlobalGrantsArgs']]):
        pulumi.set(self, "global_grants", value)

    @_builtins.property
    @pulumi.getter(name="imageGrants")
    def image_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]]]:
        """
        The images the user has permissions access to.
        """
        return pulumi.get(self, "image_grants")

    @image_grants.setter
    def image_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]]]):
        pulumi.set(self, "image_grants", value)

    @_builtins.property
    @pulumi.getter(name="linodeGrants")
    def linode_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]]]:
        """
        The Linodes the user has permissions access to.
        """
        return pulumi.get(self, "linode_grants")

    @linode_grants.setter
    def linode_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]]]):
        pulumi.set(self, "linode_grants", value)

    @_builtins.property
    @pulumi.getter(name="longviewGrants")
    def longview_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]]]:
        """
        The longview the user has permissions access to.
        """
        return pulumi.get(self, "longview_grants")

    @longview_grants.setter
    def longview_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]]]):
        pulumi.set(self, "longview_grants", value)

    @_builtins.property
    @pulumi.getter(name="nodebalancerGrants")
    def nodebalancer_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]]]:
        """
        The NodeBalancers the user has permissions access to.
        """
        return pulumi.get(self, "nodebalancer_grants")

    @nodebalancer_grants.setter
    def nodebalancer_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]]]):
        pulumi.set(self, "nodebalancer_grants", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupGrants")
    def placement_group_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]]]:
        """
        The Placement Groups the user has permissions access to.
        """
        return pulumi.get(self, "placement_group_grants")

    @placement_group_grants.setter
    def placement_group_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]]]):
        pulumi.set(self, "placement_group_grants", value)

    @_builtins.property
    @pulumi.getter
    def restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, this user will only have explicit permissions granted.

        * `global_grants` - (optional) A structure containing the Account-level grants a User has.

        The following arguments are sets of entity grants:
        """
        return pulumi.get(self, "restricted")

    @restricted.setter
    def restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restricted", value)

    @_builtins.property
    @pulumi.getter(name="stackscriptGrants")
    def stackscript_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]]]:
        """
        The StackScripts the user has permissions access to.
        """
        return pulumi.get(self, "stackscript_grants")

    @stackscript_grants.setter
    def stackscript_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]]]):
        pulumi.set(self, "stackscript_grants", value)

    @_builtins.property
    @pulumi.getter(name="volumeGrants")
    def volume_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]]]:
        """
        The volumes the user has permissions access to.
        """
        return pulumi.get(self, "volume_grants")

    @volume_grants.setter
    def volume_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]]]):
        pulumi.set(self, "volume_grants", value)

    @_builtins.property
    @pulumi.getter(name="vpcGrants")
    def vpc_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]]]:
        """
        The Virtual Private Clouds (VPCs) the user has permissions access to.
        """
        return pulumi.get(self, "vpc_grants")

    @vpc_grants.setter
    def vpc_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]]]):
        pulumi.set(self, "vpc_grants", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 domain_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]]] = None,
                 global_grants: Optional[pulumi.Input['UserGlobalGrantsArgs']] = None,
                 image_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]]] = None,
                 linode_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]]] = None,
                 longview_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]]] = None,
                 nodebalancer_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]]] = None,
                 placement_group_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]]] = None,
                 restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 stackscript_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]]] = None,
                 tfa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]]] = None,
                 vpc_grants: Optional[pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]] domain_grants: The domains the user has permissions access to.
        :param pulumi.Input[_builtins.str] email: The email address of the user.
        :param pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]] firewall_grants: The firewalls the user has permissions access to.
        :param pulumi.Input['UserGlobalGrantsArgs'] global_grants: A structure containing the Account-level grants a User has.
        :param pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]] image_grants: The images the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]] linode_grants: The Linodes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]] longview_grants: The longview the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]] nodebalancer_grants: The NodeBalancers the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]] placement_group_grants: The Placement Groups the user has permissions access to.
        :param pulumi.Input[_builtins.bool] restricted: If true, this user will only have explicit permissions granted.
               
               * `global_grants` - (optional) A structure containing the Account-level grants a User has.
               
               The following arguments are sets of entity grants:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_keys: A list of the User's SSH keys.
        :param pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]] stackscript_grants: The StackScripts the user has permissions access to.
        :param pulumi.Input[_builtins.bool] tfa_enabled: Whether the user has two-factor-authentication enabled.
        :param pulumi.Input[_builtins.str] user_type: The type of this user.
        :param pulumi.Input[_builtins.str] username: The username of the user.
        :param pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]] volume_grants: The volumes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]] vpc_grants: The Virtual Private Clouds (VPCs) the user has permissions access to.
        """
        if domain_grants is not None:
            pulumi.set(__self__, "domain_grants", domain_grants)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if firewall_grants is not None:
            pulumi.set(__self__, "firewall_grants", firewall_grants)
        if global_grants is not None:
            pulumi.set(__self__, "global_grants", global_grants)
        if image_grants is not None:
            pulumi.set(__self__, "image_grants", image_grants)
        if linode_grants is not None:
            pulumi.set(__self__, "linode_grants", linode_grants)
        if longview_grants is not None:
            pulumi.set(__self__, "longview_grants", longview_grants)
        if nodebalancer_grants is not None:
            pulumi.set(__self__, "nodebalancer_grants", nodebalancer_grants)
        if placement_group_grants is not None:
            pulumi.set(__self__, "placement_group_grants", placement_group_grants)
        if restricted is not None:
            pulumi.set(__self__, "restricted", restricted)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if stackscript_grants is not None:
            pulumi.set(__self__, "stackscript_grants", stackscript_grants)
        if tfa_enabled is not None:
            pulumi.set(__self__, "tfa_enabled", tfa_enabled)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if volume_grants is not None:
            pulumi.set(__self__, "volume_grants", volume_grants)
        if vpc_grants is not None:
            pulumi.set(__self__, "vpc_grants", vpc_grants)

    @_builtins.property
    @pulumi.getter(name="domainGrants")
    def domain_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]]]:
        """
        The domains the user has permissions access to.
        """
        return pulumi.get(self, "domain_grants")

    @domain_grants.setter
    def domain_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserDomainGrantArgs']]]]):
        pulumi.set(self, "domain_grants", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="firewallGrants")
    def firewall_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]]]:
        """
        The firewalls the user has permissions access to.
        """
        return pulumi.get(self, "firewall_grants")

    @firewall_grants.setter
    def firewall_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserFirewallGrantArgs']]]]):
        pulumi.set(self, "firewall_grants", value)

    @_builtins.property
    @pulumi.getter(name="globalGrants")
    def global_grants(self) -> Optional[pulumi.Input['UserGlobalGrantsArgs']]:
        """
        A structure containing the Account-level grants a User has.
        """
        return pulumi.get(self, "global_grants")

    @global_grants.setter
    def global_grants(self, value: Optional[pulumi.Input['UserGlobalGrantsArgs']]):
        pulumi.set(self, "global_grants", value)

    @_builtins.property
    @pulumi.getter(name="imageGrants")
    def image_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]]]:
        """
        The images the user has permissions access to.
        """
        return pulumi.get(self, "image_grants")

    @image_grants.setter
    def image_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserImageGrantArgs']]]]):
        pulumi.set(self, "image_grants", value)

    @_builtins.property
    @pulumi.getter(name="linodeGrants")
    def linode_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]]]:
        """
        The Linodes the user has permissions access to.
        """
        return pulumi.get(self, "linode_grants")

    @linode_grants.setter
    def linode_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserLinodeGrantArgs']]]]):
        pulumi.set(self, "linode_grants", value)

    @_builtins.property
    @pulumi.getter(name="longviewGrants")
    def longview_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]]]:
        """
        The longview the user has permissions access to.
        """
        return pulumi.get(self, "longview_grants")

    @longview_grants.setter
    def longview_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserLongviewGrantArgs']]]]):
        pulumi.set(self, "longview_grants", value)

    @_builtins.property
    @pulumi.getter(name="nodebalancerGrants")
    def nodebalancer_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]]]:
        """
        The NodeBalancers the user has permissions access to.
        """
        return pulumi.get(self, "nodebalancer_grants")

    @nodebalancer_grants.setter
    def nodebalancer_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserNodebalancerGrantArgs']]]]):
        pulumi.set(self, "nodebalancer_grants", value)

    @_builtins.property
    @pulumi.getter(name="placementGroupGrants")
    def placement_group_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]]]:
        """
        The Placement Groups the user has permissions access to.
        """
        return pulumi.get(self, "placement_group_grants")

    @placement_group_grants.setter
    def placement_group_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserPlacementGroupGrantArgs']]]]):
        pulumi.set(self, "placement_group_grants", value)

    @_builtins.property
    @pulumi.getter
    def restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, this user will only have explicit permissions granted.

        * `global_grants` - (optional) A structure containing the Account-level grants a User has.

        The following arguments are sets of entity grants:
        """
        return pulumi.get(self, "restricted")

    @restricted.setter
    def restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "restricted", value)

    @_builtins.property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the User's SSH keys.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @_builtins.property
    @pulumi.getter(name="stackscriptGrants")
    def stackscript_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]]]:
        """
        The StackScripts the user has permissions access to.
        """
        return pulumi.get(self, "stackscript_grants")

    @stackscript_grants.setter
    def stackscript_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserStackscriptGrantArgs']]]]):
        pulumi.set(self, "stackscript_grants", value)

    @_builtins.property
    @pulumi.getter(name="tfaEnabled")
    def tfa_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the user has two-factor-authentication enabled.
        """
        return pulumi.get(self, "tfa_enabled")

    @tfa_enabled.setter
    def tfa_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "tfa_enabled", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of this user.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the user.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="volumeGrants")
    def volume_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]]]:
        """
        The volumes the user has permissions access to.
        """
        return pulumi.get(self, "volume_grants")

    @volume_grants.setter
    def volume_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserVolumeGrantArgs']]]]):
        pulumi.set(self, "volume_grants", value)

    @_builtins.property
    @pulumi.getter(name="vpcGrants")
    def vpc_grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]]]:
        """
        The Virtual Private Clouds (VPCs) the user has permissions access to.
        """
        return pulumi.get(self, "vpc_grants")

    @vpc_grants.setter
    def vpc_grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserVpcGrantArgs']]]]):
        pulumi.set(self, "vpc_grants", value)


@pulumi.type_token("linode:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserDomainGrantArgs', 'UserDomainGrantArgsDict']]]]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserFirewallGrantArgs', 'UserFirewallGrantArgsDict']]]]] = None,
                 global_grants: Optional[pulumi.Input[Union['UserGlobalGrantsArgs', 'UserGlobalGrantsArgsDict']]] = None,
                 image_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserImageGrantArgs', 'UserImageGrantArgsDict']]]]] = None,
                 linode_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserLinodeGrantArgs', 'UserLinodeGrantArgsDict']]]]] = None,
                 longview_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserLongviewGrantArgs', 'UserLongviewGrantArgsDict']]]]] = None,
                 nodebalancer_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserNodebalancerGrantArgs', 'UserNodebalancerGrantArgsDict']]]]] = None,
                 placement_group_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserPlacementGroupGrantArgs', 'UserPlacementGroupGrantArgsDict']]]]] = None,
                 restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 stackscript_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserStackscriptGrantArgs', 'UserStackscriptGrantArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserVolumeGrantArgs', 'UserVolumeGrantArgsDict']]]]] = None,
                 vpc_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserVpcGrantArgs', 'UserVpcGrantArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Linode User.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-user).

        ## Example Usage

        Create an unrestricted user:

        ```python
        import pulumi
        import pulumi_linode as linode

        john = linode.User("john",
            username="john123",
            email="john@acme.io")
        ```

        Create a restricted user with grants:

        ```python
        import pulumi
        import pulumi_linode as linode

        fooser = linode.User("fooser",
            username="cooluser123",
            email="cool@acme.io",
            restricted=True,
            global_grants={
                "add_linodes": True,
                "add_images": True,
            },
            linode_grants=[{
                "id": 12345,
                "permissions": "read_write",
            }])
        ```

        ## Global Grants

        * `account_access` - (optional) The level of access this User has to Account-level actions, like billing information. (`read_only`, `read_write`)

        * `add_domains` - (optional) If true, this User may add Domains.

        * `add_databases` - (optional) If true, this User may add Databases.

        * `add_firewalls` - (optional) If true, this User may add Firewalls.

        * `add_images` - (optional) If true, this User may add Images.

        * `add_linodes` - (optional) If true, this User may create Linodes.

        * `add_longview` - (optional) If true, this User may create Longview clients and view the current plan.

        * `add_nodebalancers` - (optional) If true, this User may add NodeBalancers.

        * `add_placement_groups` - (optional) If true, this User may add Placement Groups.

        * `add_stackscripts` - (optional) If true, this User may add StackScripts.

        * `add_vpcs` - (optional) If true, this User may add Virtual Private Clouds (VPCs).

        * `cancel_account` - (optional) If true, this User may cancel the entire Account.

        * `longview_subscription` - (optional) If true, this User may manage the Account’s Longview subscription.

        ## Entity Grants

        * `id` - (required) The ID of the entity this grant applies to.

        * `permissions` - (required) The level of access this User has to this entity. (`read_only`, `read_write`)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserDomainGrantArgs', 'UserDomainGrantArgsDict']]]] domain_grants: The domains the user has permissions access to.
        :param pulumi.Input[_builtins.str] email: The email address of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserFirewallGrantArgs', 'UserFirewallGrantArgsDict']]]] firewall_grants: The firewalls the user has permissions access to.
        :param pulumi.Input[Union['UserGlobalGrantsArgs', 'UserGlobalGrantsArgsDict']] global_grants: A structure containing the Account-level grants a User has.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserImageGrantArgs', 'UserImageGrantArgsDict']]]] image_grants: The images the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserLinodeGrantArgs', 'UserLinodeGrantArgsDict']]]] linode_grants: The Linodes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserLongviewGrantArgs', 'UserLongviewGrantArgsDict']]]] longview_grants: The longview the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserNodebalancerGrantArgs', 'UserNodebalancerGrantArgsDict']]]] nodebalancer_grants: The NodeBalancers the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserPlacementGroupGrantArgs', 'UserPlacementGroupGrantArgsDict']]]] placement_group_grants: The Placement Groups the user has permissions access to.
        :param pulumi.Input[_builtins.bool] restricted: If true, this user will only have explicit permissions granted.
               
               * `global_grants` - (optional) A structure containing the Account-level grants a User has.
               
               The following arguments are sets of entity grants:
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserStackscriptGrantArgs', 'UserStackscriptGrantArgsDict']]]] stackscript_grants: The StackScripts the user has permissions access to.
        :param pulumi.Input[_builtins.str] username: The username of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserVolumeGrantArgs', 'UserVolumeGrantArgsDict']]]] volume_grants: The volumes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserVpcGrantArgs', 'UserVpcGrantArgsDict']]]] vpc_grants: The Virtual Private Clouds (VPCs) the user has permissions access to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linode User.
        For more information, see the [Linode APIv4 docs](https://techdocs.akamai.com/linode-api/reference/post-user).

        ## Example Usage

        Create an unrestricted user:

        ```python
        import pulumi
        import pulumi_linode as linode

        john = linode.User("john",
            username="john123",
            email="john@acme.io")
        ```

        Create a restricted user with grants:

        ```python
        import pulumi
        import pulumi_linode as linode

        fooser = linode.User("fooser",
            username="cooluser123",
            email="cool@acme.io",
            restricted=True,
            global_grants={
                "add_linodes": True,
                "add_images": True,
            },
            linode_grants=[{
                "id": 12345,
                "permissions": "read_write",
            }])
        ```

        ## Global Grants

        * `account_access` - (optional) The level of access this User has to Account-level actions, like billing information. (`read_only`, `read_write`)

        * `add_domains` - (optional) If true, this User may add Domains.

        * `add_databases` - (optional) If true, this User may add Databases.

        * `add_firewalls` - (optional) If true, this User may add Firewalls.

        * `add_images` - (optional) If true, this User may add Images.

        * `add_linodes` - (optional) If true, this User may create Linodes.

        * `add_longview` - (optional) If true, this User may create Longview clients and view the current plan.

        * `add_nodebalancers` - (optional) If true, this User may add NodeBalancers.

        * `add_placement_groups` - (optional) If true, this User may add Placement Groups.

        * `add_stackscripts` - (optional) If true, this User may add StackScripts.

        * `add_vpcs` - (optional) If true, this User may add Virtual Private Clouds (VPCs).

        * `cancel_account` - (optional) If true, this User may cancel the entire Account.

        * `longview_subscription` - (optional) If true, this User may manage the Account’s Longview subscription.

        ## Entity Grants

        * `id` - (required) The ID of the entity this grant applies to.

        * `permissions` - (required) The level of access this User has to this entity. (`read_only`, `read_write`)

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserDomainGrantArgs', 'UserDomainGrantArgsDict']]]]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 firewall_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserFirewallGrantArgs', 'UserFirewallGrantArgsDict']]]]] = None,
                 global_grants: Optional[pulumi.Input[Union['UserGlobalGrantsArgs', 'UserGlobalGrantsArgsDict']]] = None,
                 image_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserImageGrantArgs', 'UserImageGrantArgsDict']]]]] = None,
                 linode_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserLinodeGrantArgs', 'UserLinodeGrantArgsDict']]]]] = None,
                 longview_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserLongviewGrantArgs', 'UserLongviewGrantArgsDict']]]]] = None,
                 nodebalancer_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserNodebalancerGrantArgs', 'UserNodebalancerGrantArgsDict']]]]] = None,
                 placement_group_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserPlacementGroupGrantArgs', 'UserPlacementGroupGrantArgsDict']]]]] = None,
                 restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 stackscript_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserStackscriptGrantArgs', 'UserStackscriptGrantArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserVolumeGrantArgs', 'UserVolumeGrantArgsDict']]]]] = None,
                 vpc_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserVpcGrantArgs', 'UserVpcGrantArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            __props__.__dict__["domain_grants"] = domain_grants
            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["firewall_grants"] = firewall_grants
            __props__.__dict__["global_grants"] = global_grants
            __props__.__dict__["image_grants"] = image_grants
            __props__.__dict__["linode_grants"] = linode_grants
            __props__.__dict__["longview_grants"] = longview_grants
            __props__.__dict__["nodebalancer_grants"] = nodebalancer_grants
            __props__.__dict__["placement_group_grants"] = placement_group_grants
            __props__.__dict__["restricted"] = restricted
            __props__.__dict__["stackscript_grants"] = stackscript_grants
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["volume_grants"] = volume_grants
            __props__.__dict__["vpc_grants"] = vpc_grants
            __props__.__dict__["ssh_keys"] = None
            __props__.__dict__["tfa_enabled"] = None
            __props__.__dict__["user_type"] = None
        super(User, __self__).__init__(
            'linode:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserDomainGrantArgs', 'UserDomainGrantArgsDict']]]]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            firewall_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserFirewallGrantArgs', 'UserFirewallGrantArgsDict']]]]] = None,
            global_grants: Optional[pulumi.Input[Union['UserGlobalGrantsArgs', 'UserGlobalGrantsArgsDict']]] = None,
            image_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserImageGrantArgs', 'UserImageGrantArgsDict']]]]] = None,
            linode_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserLinodeGrantArgs', 'UserLinodeGrantArgsDict']]]]] = None,
            longview_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserLongviewGrantArgs', 'UserLongviewGrantArgsDict']]]]] = None,
            nodebalancer_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserNodebalancerGrantArgs', 'UserNodebalancerGrantArgsDict']]]]] = None,
            placement_group_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserPlacementGroupGrantArgs', 'UserPlacementGroupGrantArgsDict']]]]] = None,
            restricted: Optional[pulumi.Input[_builtins.bool]] = None,
            ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            stackscript_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserStackscriptGrantArgs', 'UserStackscriptGrantArgsDict']]]]] = None,
            tfa_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            volume_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserVolumeGrantArgs', 'UserVolumeGrantArgsDict']]]]] = None,
            vpc_grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['UserVpcGrantArgs', 'UserVpcGrantArgsDict']]]]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserDomainGrantArgs', 'UserDomainGrantArgsDict']]]] domain_grants: The domains the user has permissions access to.
        :param pulumi.Input[_builtins.str] email: The email address of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserFirewallGrantArgs', 'UserFirewallGrantArgsDict']]]] firewall_grants: The firewalls the user has permissions access to.
        :param pulumi.Input[Union['UserGlobalGrantsArgs', 'UserGlobalGrantsArgsDict']] global_grants: A structure containing the Account-level grants a User has.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserImageGrantArgs', 'UserImageGrantArgsDict']]]] image_grants: The images the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserLinodeGrantArgs', 'UserLinodeGrantArgsDict']]]] linode_grants: The Linodes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserLongviewGrantArgs', 'UserLongviewGrantArgsDict']]]] longview_grants: The longview the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserNodebalancerGrantArgs', 'UserNodebalancerGrantArgsDict']]]] nodebalancer_grants: The NodeBalancers the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserPlacementGroupGrantArgs', 'UserPlacementGroupGrantArgsDict']]]] placement_group_grants: The Placement Groups the user has permissions access to.
        :param pulumi.Input[_builtins.bool] restricted: If true, this user will only have explicit permissions granted.
               
               * `global_grants` - (optional) A structure containing the Account-level grants a User has.
               
               The following arguments are sets of entity grants:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ssh_keys: A list of the User's SSH keys.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserStackscriptGrantArgs', 'UserStackscriptGrantArgsDict']]]] stackscript_grants: The StackScripts the user has permissions access to.
        :param pulumi.Input[_builtins.bool] tfa_enabled: Whether the user has two-factor-authentication enabled.
        :param pulumi.Input[_builtins.str] user_type: The type of this user.
        :param pulumi.Input[_builtins.str] username: The username of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserVolumeGrantArgs', 'UserVolumeGrantArgsDict']]]] volume_grants: The volumes the user has permissions access to.
        :param pulumi.Input[Sequence[pulumi.Input[Union['UserVpcGrantArgs', 'UserVpcGrantArgsDict']]]] vpc_grants: The Virtual Private Clouds (VPCs) the user has permissions access to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["domain_grants"] = domain_grants
        __props__.__dict__["email"] = email
        __props__.__dict__["firewall_grants"] = firewall_grants
        __props__.__dict__["global_grants"] = global_grants
        __props__.__dict__["image_grants"] = image_grants
        __props__.__dict__["linode_grants"] = linode_grants
        __props__.__dict__["longview_grants"] = longview_grants
        __props__.__dict__["nodebalancer_grants"] = nodebalancer_grants
        __props__.__dict__["placement_group_grants"] = placement_group_grants
        __props__.__dict__["restricted"] = restricted
        __props__.__dict__["ssh_keys"] = ssh_keys
        __props__.__dict__["stackscript_grants"] = stackscript_grants
        __props__.__dict__["tfa_enabled"] = tfa_enabled
        __props__.__dict__["user_type"] = user_type
        __props__.__dict__["username"] = username
        __props__.__dict__["volume_grants"] = volume_grants
        __props__.__dict__["vpc_grants"] = vpc_grants
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainGrants")
    def domain_grants(self) -> pulumi.Output[Sequence['outputs.UserDomainGrant']]:
        """
        The domains the user has permissions access to.
        """
        return pulumi.get(self, "domain_grants")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The email address of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="firewallGrants")
    def firewall_grants(self) -> pulumi.Output[Sequence['outputs.UserFirewallGrant']]:
        """
        The firewalls the user has permissions access to.
        """
        return pulumi.get(self, "firewall_grants")

    @_builtins.property
    @pulumi.getter(name="globalGrants")
    def global_grants(self) -> pulumi.Output['outputs.UserGlobalGrants']:
        """
        A structure containing the Account-level grants a User has.
        """
        return pulumi.get(self, "global_grants")

    @_builtins.property
    @pulumi.getter(name="imageGrants")
    def image_grants(self) -> pulumi.Output[Sequence['outputs.UserImageGrant']]:
        """
        The images the user has permissions access to.
        """
        return pulumi.get(self, "image_grants")

    @_builtins.property
    @pulumi.getter(name="linodeGrants")
    def linode_grants(self) -> pulumi.Output[Sequence['outputs.UserLinodeGrant']]:
        """
        The Linodes the user has permissions access to.
        """
        return pulumi.get(self, "linode_grants")

    @_builtins.property
    @pulumi.getter(name="longviewGrants")
    def longview_grants(self) -> pulumi.Output[Sequence['outputs.UserLongviewGrant']]:
        """
        The longview the user has permissions access to.
        """
        return pulumi.get(self, "longview_grants")

    @_builtins.property
    @pulumi.getter(name="nodebalancerGrants")
    def nodebalancer_grants(self) -> pulumi.Output[Sequence['outputs.UserNodebalancerGrant']]:
        """
        The NodeBalancers the user has permissions access to.
        """
        return pulumi.get(self, "nodebalancer_grants")

    @_builtins.property
    @pulumi.getter(name="placementGroupGrants")
    def placement_group_grants(self) -> pulumi.Output[Sequence['outputs.UserPlacementGroupGrant']]:
        """
        The Placement Groups the user has permissions access to.
        """
        return pulumi.get(self, "placement_group_grants")

    @_builtins.property
    @pulumi.getter
    def restricted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, this user will only have explicit permissions granted.

        * `global_grants` - (optional) A structure containing the Account-level grants a User has.

        The following arguments are sets of entity grants:
        """
        return pulumi.get(self, "restricted")

    @_builtins.property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of the User's SSH keys.
        """
        return pulumi.get(self, "ssh_keys")

    @_builtins.property
    @pulumi.getter(name="stackscriptGrants")
    def stackscript_grants(self) -> pulumi.Output[Sequence['outputs.UserStackscriptGrant']]:
        """
        The StackScripts the user has permissions access to.
        """
        return pulumi.get(self, "stackscript_grants")

    @_builtins.property
    @pulumi.getter(name="tfaEnabled")
    def tfa_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the user has two-factor-authentication enabled.
        """
        return pulumi.get(self, "tfa_enabled")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of this user.
        """
        return pulumi.get(self, "user_type")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The username of the user.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="volumeGrants")
    def volume_grants(self) -> pulumi.Output[Sequence['outputs.UserVolumeGrant']]:
        """
        The volumes the user has permissions access to.
        """
        return pulumi.get(self, "volume_grants")

    @_builtins.property
    @pulumi.getter(name="vpcGrants")
    def vpc_grants(self) -> pulumi.Output[Sequence['outputs.UserVpcGrant']]:
        """
        The Virtual Private Clouds (VPCs) the user has permissions access to.
        """
        return pulumi.get(self, "vpc_grants")

