# DeepSeek CLI

> This CLI is open source at https://github.com/PDFSage/deepseek_cli – collaborators and maintainers are welcome! Submit ideas, issues, or pull requests to help the project grow.

https://pypi.org/project/deepseek-agent/

Developer-focused command line tools for working with DeepSeek models. The CLI
packages both an interactive chat shell and an agentic coding assistant with
repository-aware tooling, plus configuration helpers and transcript logging.

## Features
- Agent mode (`deepseek agent`) orchestrates tool-aware coding sessions with the
  DeepSeek API, optional read-only mode, transcripts, and workspace controls.
- Chat mode (`deepseek chat`) supports single-response or interactive
  conversations with streaming output and transcript capture.
- Config mode (`deepseek config`) manages stored defaults while respecting
  environment variable overrides.
- Ships as a Python package with an executable entry point and Homebrew formula
  for distribution flexibility.

## Requirements
- Python 3.9 or newer.
- A DeepSeek API key exported as `DEEPSEEK_API_KEY` or stored via
  `deepseek config`.
- `pip` 23+ is recommended. Create a virtual environment for isolated installs.

## Installation

### From PyPI (recommended once released)
```bash
python -m pip install --upgrade pip
python -m pip install deepseek-agent
```

To update later, run `python -m pip install --upgrade deepseek-agent`.

### From GitHub
Install the latest commit directly from GitHub:
```bash
python -m pip install "git+https://github.com/PDFSage/deepseek_cli.git@main"
```
Specify a tag (for example `v0.1.7`) to pin a release:
```bash
python -m pip install "git+https://github.com/PDFSage/deepseek_cli.git@v0.1.7"
```

### From a local clone
```bash
git clone https://github.com/PDFSage/deepseek_cli.git
cd deepseek_cli
python -m venv .venv
source .venv/bin/activate  # On Windows use: .venv\\Scripts\\activate
python -m pip install --upgrade pip
python -m pip install -e .  # or `python -m pip install .` for a standard install
```

The editable install (`-e`) keeps the CLI synced with local source changes while
developing.

## Configuration
The CLI resolves settings in the following order:
1. Command line flags (`--api-key`, `--base-url`, `--model`, etc.).
2. Environment variables: `DEEPSEEK_API_KEY`, `DEEPSEEK_BASE_URL`,
   `DEEPSEEK_MODEL`, `DEEPSEEK_SYSTEM_PROMPT`.
3. Stored configuration file at `~/.config/deepseek-cli/config.json`.

Helpful commands:
```bash
deepseek config init        # Guided prompt to store your API key
deepseek config show        # Display the current configuration (API key redacted)
deepseek config show --raw  # Show the API key in plain text
deepseek config set model deepseek-reasoner  # Update an individual field
deepseek config unset model
```

If the config directory is unwritable, fall back to environment variables.

## Usage

### Interactive agent (default)
Running `deepseek` with no arguments launches the interactive coding agent,
similar to Claude Code or the Gemini CLI. The shell waits for the agent to
initialise, then prompts for your request. Commands starting with `:` adjust the
session (for example `:workspace`, `:model`, `:read-only`, `:transcript`, and
`:help`). Exit with `:quit` or `Ctrl+C`. Each request can include optional
follow-up lines; press Enter on an empty line to run the agent. The assistant
also appends an internal instruction to run automated tests and continue
iterating until they pass (or a clear justification is recorded).
Use `:global on` if you want the agent to edit files outside the current
workspace root (highly privileged; defaults to off).

If no API key is configured, the CLI exits with instructions to create one at
https://platform.deepseek.com/api_keys.

### Verify installation
```bash
deepseek --version
# or use the legacy alias if preferred
deepseek-cli --version
```

Get help for any subcommand:
```bash
deepseek --help
```

### Chat mode
```bash
deepseek chat "Summarise the last commit"

deepseek chat --interactive --model deepseek-reasoner \
  --transcript ~/Desktop/session.jsonl
```
- `--no-stream` disables live token streaming.
- `--temperature`, `--top-p`, and `--max-tokens` mirror the OpenAI Chat
  Completions API.
- Provide `--transcript` to log each exchange to JSONL for later review.

### Agent mode
```bash
deepseek agent "Refactor the HTTP client" \
  --workspace ~/code/project --max-steps 30 --transcript transcript.jsonl
```
- The agent uses repository-aware tools: list directories, read/write files,
  apply patches, run shell commands, and search text.
- Pass `--global` to permit edits outside the workspace root when you need
  system-wide changes.
- Add `--follow-up "Also add tests"` for additional prompts.
- Use `--read-only` to prevent write operations and `--quiet` to suppress
  progress logs.

### Transcripts and workspaces
- Relative transcript paths under agent mode are resolved within the selected
  workspace.
- Chat transcripts default to `~/.config/deepseek-cli/transcripts/` when a file
  name (not path) is supplied.

### Legacy shim
Running `python deepseek_agentic_cli.py` prints a compatibility notice and
forwards the call to `deepseek agent`, so existing automation keeps working.

## Publishing to PyPI
1. Update the version in `pyproject.toml` and commit your changes.
2. Remove old build artifacts:
   ```bash
   rm -rf build dist *.egg-info
   ```
3. Install packaging tooling:
   ```bash
   python -m pip install --upgrade build twine
   ```
4. Build the source and wheel distributions:
   ```bash
   python -m build
   ```
5. Verify the archives:
   ```bash
   python -m twine check dist/*
   ```
6. Upload to TestPyPI (optional but recommended):
   ```bash
   python -m twine upload --repository testpypi dist/*
   ```
7. Upload to PyPI:
   ```bash
   python -m twine upload dist/*
   ```

After publishing, users can install with `pip install deepseek-agent`.

## Development
- `python -m deepseek_cli --version` exercises the module entry point.
- `python -m deepseek_cli chat --help` shows chat-specific flags.
- `python -m deepseek_cli agent --help` lists agent options.
- Run `ruff`, `pytest`, or other tooling as required by your workflow.

Contributions welcome! Open issues or pull requests to extend functionality.
