"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var src_exports = {};
__export(src_exports, {
  determineAgent: () => determineAgent
});
module.exports = __toCommonJS(src_exports);
var import_promises = require("node:fs/promises");
var import_node_fs = require("node:fs");
const devinLocalPath = "/opt/.devin";
const CURSOR = "cursor";
const CURSOR_CLI = "cursor-cli";
const CLAUDE = "claude";
const DEVIN = "devin";
const REPLIT = "replit";
const GEMINI = "gemini";
const CODEX = "codex";
async function determineAgent() {
  if (process.env.AI_AGENT) {
    return process.env.AI_AGENT;
  }
  if (process.env.CURSOR_TRACE_ID) {
    return CURSOR;
  }
  if (process.env.CURSOR_AGENT) {
    return CURSOR_CLI;
  }
  if (process.env.GEMINI_CLI) {
    return GEMINI;
  }
  if (process.env.CODEX_SANDBOX) {
    return CODEX;
  }
  if (process.env.CLAUDECODE || process.env.CLAUDE_CODE) {
    return CLAUDE;
  }
  if (process.env.REPL_ID) {
    return REPLIT;
  }
  try {
    await (0, import_promises.access)(devinLocalPath, import_node_fs.constants.F_OK);
    return DEVIN;
  } catch (error) {
    return false;
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  determineAgent
});
