import subprocess
import os
import sys

class STARTFILE:
    def __init__(self, filename):
        self.filename = filename
    def start(self):
        if not os.path.exists(self.filename):
            print(f'[STARTFILE] Dosya bulunamadı: {self.filename}')
            return
        print(f'[STARTFILE] Çalıştırılıyor: {self.filename}')
        if self.filename.endswith('.py'):
            subprocess.Popen([sys.executable, self.filename])
        else:
            os.startfile(self.filename)

class NEWFILEOPEN:
    custom_code = ""
    def __init__(self, name, filetype):
        self.name = name
        self.filetype = filetype
    def create(self, shortcut_name=None):
        filename = f'{self.name}{self.filetype}'
        if shortcut_name:
            if hasattr(self, f"{shortcut_name}_custom_code"):
                code = getattr(self, f"{shortcut_name}_custom_code")
            else:
                code = ""
        else:
            code = """import tkinter as tk
a = tk.Tk()
a.geometry('250x500')
a.title('İsim')"""
        with open(filename, 'w', encoding='utf-8') as f:
            f.write(code)
        print(f'[NEWFILEOPEN] Yeni dosya oluşturuldu: {filename}')
        return filename

class GOSTART:
    def __init__(self):
        print('[GOSTART] Paket başlatıldı')
    def run(self, file):
        STARTFILE(file).start()

class StartSYScp:
    def __init__(self):
        print('[StartSYScp] Başlatıldı')

class SYS:
    def __init__(self):
        print('[SYS] Yardımcı sistem hazır')
