# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GatewayArgs', 'Gateway']

@pulumi.input_type
class GatewayArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 environment: pulumi.Input['GatewayEnvironmentArgs'],
                 aws_egress_private_link_gateway: Optional[pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs']] = None,
                 aws_private_network_interface_gateway: Optional[pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs']] = None,
                 azure_egress_private_link_gateway: Optional[pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs']] = None):
        """
        The set of arguments for constructing a Gateway resource.
        :param pulumi.Input[_builtins.str] display_name: The name of the Gateway.
        :param pulumi.Input['GatewayEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs'] aws_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs'] aws_private_network_interface_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs'] azure_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment", environment)
        if aws_egress_private_link_gateway is not None:
            pulumi.set(__self__, "aws_egress_private_link_gateway", aws_egress_private_link_gateway)
        if aws_private_network_interface_gateway is not None:
            pulumi.set(__self__, "aws_private_network_interface_gateway", aws_private_network_interface_gateway)
        if azure_egress_private_link_gateway is not None:
            pulumi.set(__self__, "azure_egress_private_link_gateway", azure_egress_private_link_gateway)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Gateway.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['GatewayEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['GatewayEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="awsEgressPrivateLinkGateway")
    def aws_egress_private_link_gateway(self) -> Optional[pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs']]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws_egress_private_link_gateway")

    @aws_egress_private_link_gateway.setter
    def aws_egress_private_link_gateway(self, value: Optional[pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs']]):
        pulumi.set(self, "aws_egress_private_link_gateway", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivateNetworkInterfaceGateway")
    def aws_private_network_interface_gateway(self) -> Optional[pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs']]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws_private_network_interface_gateway")

    @aws_private_network_interface_gateway.setter
    def aws_private_network_interface_gateway(self, value: Optional[pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs']]):
        pulumi.set(self, "aws_private_network_interface_gateway", value)

    @_builtins.property
    @pulumi.getter(name="azureEgressPrivateLinkGateway")
    def azure_egress_private_link_gateway(self) -> Optional[pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs']]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "azure_egress_private_link_gateway")

    @azure_egress_private_link_gateway.setter
    def azure_egress_private_link_gateway(self, value: Optional[pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs']]):
        pulumi.set(self, "azure_egress_private_link_gateway", value)


@pulumi.input_type
class _GatewayState:
    def __init__(__self__, *,
                 aws_egress_private_link_gateway: Optional[pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs']] = None,
                 aws_private_network_interface_gateway: Optional[pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs']] = None,
                 azure_egress_private_link_gateway: Optional[pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input['GatewayEnvironmentArgs']] = None):
        """
        Input properties used for looking up and filtering Gateway resources.
        :param pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs'] aws_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs'] aws_private_network_interface_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs'] azure_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input[_builtins.str] display_name: The name of the Gateway.
        :param pulumi.Input['GatewayEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        if aws_egress_private_link_gateway is not None:
            pulumi.set(__self__, "aws_egress_private_link_gateway", aws_egress_private_link_gateway)
        if aws_private_network_interface_gateway is not None:
            pulumi.set(__self__, "aws_private_network_interface_gateway", aws_private_network_interface_gateway)
        if azure_egress_private_link_gateway is not None:
            pulumi.set(__self__, "azure_egress_private_link_gateway", azure_egress_private_link_gateway)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)

    @_builtins.property
    @pulumi.getter(name="awsEgressPrivateLinkGateway")
    def aws_egress_private_link_gateway(self) -> Optional[pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs']]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws_egress_private_link_gateway")

    @aws_egress_private_link_gateway.setter
    def aws_egress_private_link_gateway(self, value: Optional[pulumi.Input['GatewayAwsEgressPrivateLinkGatewayArgs']]):
        pulumi.set(self, "aws_egress_private_link_gateway", value)

    @_builtins.property
    @pulumi.getter(name="awsPrivateNetworkInterfaceGateway")
    def aws_private_network_interface_gateway(self) -> Optional[pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs']]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws_private_network_interface_gateway")

    @aws_private_network_interface_gateway.setter
    def aws_private_network_interface_gateway(self, value: Optional[pulumi.Input['GatewayAwsPrivateNetworkInterfaceGatewayArgs']]):
        pulumi.set(self, "aws_private_network_interface_gateway", value)

    @_builtins.property
    @pulumi.getter(name="azureEgressPrivateLinkGateway")
    def azure_egress_private_link_gateway(self) -> Optional[pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs']]:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "azure_egress_private_link_gateway")

    @azure_egress_private_link_gateway.setter
    def azure_egress_private_link_gateway(self, value: Optional[pulumi.Input['GatewayAzureEgressPrivateLinkGatewayArgs']]):
        pulumi.set(self, "azure_egress_private_link_gateway", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Gateway.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['GatewayEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['GatewayEnvironmentArgs']]):
        pulumi.set(self, "environment", value)


@pulumi.type_token("confluentcloud:index/gateway:Gateway")
class Gateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_egress_private_link_gateway: Optional[pulumi.Input[Union['GatewayAwsEgressPrivateLinkGatewayArgs', 'GatewayAwsEgressPrivateLinkGatewayArgsDict']]] = None,
                 aws_private_network_interface_gateway: Optional[pulumi.Input[Union['GatewayAwsPrivateNetworkInterfaceGatewayArgs', 'GatewayAwsPrivateNetworkInterfaceGatewayArgsDict']]] = None,
                 azure_egress_private_link_gateway: Optional[pulumi.Input[Union['GatewayAzureEgressPrivateLinkGatewayArgs', 'GatewayAzureEgressPrivateLinkGatewayArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['GatewayEnvironmentArgs', 'GatewayEnvironmentArgsDict']]] = None,
                 __props__=None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `Gateway` provides a Gateway resource that enables creating, editing, and deleting Gateways on Confluent Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        main = confluentcloud.Gateway("main",
            display_name="my_gateway",
            environment={
                "id": development.id,
            },
            aws_egress_private_link_gateway={
                "region": "us-west-2",
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Gateway` resource:
          * enterprise-pni-aws-kafka-rbac: _Enterprise_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC
          * freight-aws-kafka-rbac: _Freight_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC

        ## Import

        You can import a Gateway by using Environment ID and Gateway ID, in the format `<Environment ID>/<Gateway ID>`. The following example shows how to import a Gateway:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/gateway:Gateway main env-abc123/gw-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GatewayAwsEgressPrivateLinkGatewayArgs', 'GatewayAwsEgressPrivateLinkGatewayArgsDict']] aws_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input[Union['GatewayAwsPrivateNetworkInterfaceGatewayArgs', 'GatewayAwsPrivateNetworkInterfaceGatewayArgsDict']] aws_private_network_interface_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input[Union['GatewayAzureEgressPrivateLinkGatewayArgs', 'GatewayAzureEgressPrivateLinkGatewayArgsDict']] azure_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input[_builtins.str] display_name: The name of the Gateway.
        :param pulumi.Input[Union['GatewayEnvironmentArgs', 'GatewayEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `Gateway` provides a Gateway resource that enables creating, editing, and deleting Gateways on Confluent Cloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        development = confluentcloud.Environment("development", display_name="Development")
        main = confluentcloud.Gateway("main",
            display_name="my_gateway",
            environment={
                "id": development.id,
            },
            aws_egress_private_link_gateway={
                "region": "us-west-2",
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `Gateway` resource:
          * enterprise-pni-aws-kafka-rbac: _Enterprise_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC
          * freight-aws-kafka-rbac: _Freight_ Kafka cluster on AWS that is accessible via Confluent Private Network Interface (PNI) with authorization using RBAC

        ## Import

        You can import a Gateway by using Environment ID and Gateway ID, in the format `<Environment ID>/<Gateway ID>`. The following example shows how to import a Gateway:

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/gateway:Gateway main env-abc123/gw-abc123
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param GatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_egress_private_link_gateway: Optional[pulumi.Input[Union['GatewayAwsEgressPrivateLinkGatewayArgs', 'GatewayAwsEgressPrivateLinkGatewayArgsDict']]] = None,
                 aws_private_network_interface_gateway: Optional[pulumi.Input[Union['GatewayAwsPrivateNetworkInterfaceGatewayArgs', 'GatewayAwsPrivateNetworkInterfaceGatewayArgsDict']]] = None,
                 azure_egress_private_link_gateway: Optional[pulumi.Input[Union['GatewayAzureEgressPrivateLinkGatewayArgs', 'GatewayAzureEgressPrivateLinkGatewayArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['GatewayEnvironmentArgs', 'GatewayEnvironmentArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GatewayArgs.__new__(GatewayArgs)

            __props__.__dict__["aws_egress_private_link_gateway"] = aws_egress_private_link_gateway
            __props__.__dict__["aws_private_network_interface_gateway"] = aws_private_network_interface_gateway
            __props__.__dict__["azure_egress_private_link_gateway"] = azure_egress_private_link_gateway
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
        super(Gateway, __self__).__init__(
            'confluentcloud:index/gateway:Gateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_egress_private_link_gateway: Optional[pulumi.Input[Union['GatewayAwsEgressPrivateLinkGatewayArgs', 'GatewayAwsEgressPrivateLinkGatewayArgsDict']]] = None,
            aws_private_network_interface_gateway: Optional[pulumi.Input[Union['GatewayAwsPrivateNetworkInterfaceGatewayArgs', 'GatewayAwsPrivateNetworkInterfaceGatewayArgsDict']]] = None,
            azure_egress_private_link_gateway: Optional[pulumi.Input[Union['GatewayAzureEgressPrivateLinkGatewayArgs', 'GatewayAzureEgressPrivateLinkGatewayArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            environment: Optional[pulumi.Input[Union['GatewayEnvironmentArgs', 'GatewayEnvironmentArgsDict']]] = None) -> 'Gateway':
        """
        Get an existing Gateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['GatewayAwsEgressPrivateLinkGatewayArgs', 'GatewayAwsEgressPrivateLinkGatewayArgsDict']] aws_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input[Union['GatewayAwsPrivateNetworkInterfaceGatewayArgs', 'GatewayAwsPrivateNetworkInterfaceGatewayArgsDict']] aws_private_network_interface_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input[Union['GatewayAzureEgressPrivateLinkGatewayArgs', 'GatewayAzureEgressPrivateLinkGatewayArgsDict']] azure_egress_private_link_gateway: (Optional Configuration Block) supports the following:
        :param pulumi.Input[_builtins.str] display_name: The name of the Gateway.
        :param pulumi.Input[Union['GatewayEnvironmentArgs', 'GatewayEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GatewayState.__new__(_GatewayState)

        __props__.__dict__["aws_egress_private_link_gateway"] = aws_egress_private_link_gateway
        __props__.__dict__["aws_private_network_interface_gateway"] = aws_private_network_interface_gateway
        __props__.__dict__["azure_egress_private_link_gateway"] = azure_egress_private_link_gateway
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment"] = environment
        return Gateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsEgressPrivateLinkGateway")
    def aws_egress_private_link_gateway(self) -> pulumi.Output['outputs.GatewayAwsEgressPrivateLinkGateway']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws_egress_private_link_gateway")

    @_builtins.property
    @pulumi.getter(name="awsPrivateNetworkInterfaceGateway")
    def aws_private_network_interface_gateway(self) -> pulumi.Output['outputs.GatewayAwsPrivateNetworkInterfaceGateway']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "aws_private_network_interface_gateway")

    @_builtins.property
    @pulumi.getter(name="azureEgressPrivateLinkGateway")
    def azure_egress_private_link_gateway(self) -> pulumi.Output['outputs.GatewayAzureEgressPrivateLinkGateway']:
        """
        (Optional Configuration Block) supports the following:
        """
        return pulumi.get(self, "azure_egress_private_link_gateway")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Gateway.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.GatewayEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

