# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDnsRecordResult',
    'AwaitableGetDnsRecordResult',
    'get_dns_record',
    'get_dns_record_output',
]

@pulumi.output_type
class GetDnsRecordResult:
    """
    A collection of values returned by getDnsRecord.
    """
    def __init__(__self__, display_name=None, domain=None, environment=None, gateways=None, id=None, private_link_access_points=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if environment and not isinstance(environment, dict):
            raise TypeError("Expected argument 'environment' to be a dict")
        pulumi.set(__self__, "environment", environment)
        if gateways and not isinstance(gateways, list):
            raise TypeError("Expected argument 'gateways' to be a list")
        pulumi.set(__self__, "gateways", gateways)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if private_link_access_points and not isinstance(private_link_access_points, list):
            raise TypeError("Expected argument 'private_link_access_points' to be a list")
        pulumi.set(__self__, "private_link_access_points", private_link_access_points)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        (Required String) A human-readable name for the DNS Record.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        (Required String) The fully qualified domain name of the DNS Record.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> 'outputs.GetDnsRecordEnvironmentResult':
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter
    def gateways(self) -> Sequence['outputs.GetDnsRecordGatewayResult']:
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "gateways")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        (Required String) The ID of the Private Link access point to which the DNS Record is associated, for example `ap-123abc`.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="privateLinkAccessPoints")
    def private_link_access_points(self) -> Sequence['outputs.GetDnsRecordPrivateLinkAccessPointResult']:
        """
        (Required Configuration Block) supports the following:
        """
        return pulumi.get(self, "private_link_access_points")


class AwaitableGetDnsRecordResult(GetDnsRecordResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDnsRecordResult(
            display_name=self.display_name,
            domain=self.domain,
            environment=self.environment,
            gateways=self.gateways,
            id=self.id,
            private_link_access_points=self.private_link_access_points)


def get_dns_record(environment: Optional[Union['GetDnsRecordEnvironmentArgs', 'GetDnsRecordEnvironmentArgsDict']] = None,
                   id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDnsRecordResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `DnsRecord` describes a DNS Record data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_dns_record(id="dnsrec-abc123",
        environment={
            "id": "env-123abc",
        })
    pulumi.export("dnsRecord", main)
    ```


    :param _builtins.str id: The ID of the DNS Record, for example, `dnsrec-abc123`.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getDnsRecord:getDnsRecord', __args__, opts=opts, typ=GetDnsRecordResult).value

    return AwaitableGetDnsRecordResult(
        display_name=pulumi.get(__ret__, 'display_name'),
        domain=pulumi.get(__ret__, 'domain'),
        environment=pulumi.get(__ret__, 'environment'),
        gateways=pulumi.get(__ret__, 'gateways'),
        id=pulumi.get(__ret__, 'id'),
        private_link_access_points=pulumi.get(__ret__, 'private_link_access_points'))
def get_dns_record_output(environment: Optional[pulumi.Input[Union['GetDnsRecordEnvironmentArgs', 'GetDnsRecordEnvironmentArgsDict']]] = None,
                          id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDnsRecordResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `DnsRecord` describes a DNS Record data source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    main = confluentcloud.get_dns_record(id="dnsrec-abc123",
        environment={
            "id": "env-123abc",
        })
    pulumi.export("dnsRecord", main)
    ```


    :param _builtins.str id: The ID of the DNS Record, for example, `dnsrec-abc123`.
    """
    __args__ = dict()
    __args__['environment'] = environment
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getDnsRecord:getDnsRecord', __args__, opts=opts, typ=GetDnsRecordResult)
    return __ret__.apply(lambda __response__: GetDnsRecordResult(
        display_name=pulumi.get(__response__, 'display_name'),
        domain=pulumi.get(__response__, 'domain'),
        environment=pulumi.get(__response__, 'environment'),
        gateways=pulumi.get(__response__, 'gateways'),
        id=pulumi.get(__response__, 'id'),
        private_link_access_points=pulumi.get(__response__, 'private_link_access_points')))
