# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetIpFilterResult',
    'AwaitableGetIpFilterResult',
    'get_ip_filter',
    'get_ip_filter_output',
]

@pulumi.output_type
class GetIpFilterResult:
    """
    A collection of values returned by getIpFilter.
    """
    def __init__(__self__, filter_name=None, id=None, ip_groups=None, operation_groups=None, resource_group=None, resource_scope=None):
        if filter_name and not isinstance(filter_name, str):
            raise TypeError("Expected argument 'filter_name' to be a str")
        pulumi.set(__self__, "filter_name", filter_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_groups and not isinstance(ip_groups, list):
            raise TypeError("Expected argument 'ip_groups' to be a list")
        pulumi.set(__self__, "ip_groups", ip_groups)
        if operation_groups and not isinstance(operation_groups, list):
            raise TypeError("Expected argument 'operation_groups' to be a list")
        pulumi.set(__self__, "operation_groups", operation_groups)
        if resource_group and not isinstance(resource_group, str):
            raise TypeError("Expected argument 'resource_group' to be a str")
        pulumi.set(__self__, "resource_group", resource_group)
        if resource_scope and not isinstance(resource_scope, str):
            raise TypeError("Expected argument 'resource_scope' to be a str")
        pulumi.set(__self__, "resource_scope", resource_scope)

    @_builtins.property
    @pulumi.getter(name="filterName")
    def filter_name(self) -> _builtins.str:
        """
        (Required String) A human-readable name for an IP Filter. Can contain any unicode letter or number, the ASCII space character, or any of the following special characters: `[`, `]`, `|`, `&`, `+`, `-`, `_`, `/`, `.`, `,`.
        """
        return pulumi.get(self, "filter_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipGroups")
    def ip_groups(self) -> Sequence[_builtins.str]:
        """
        (Required List of Strings) A list of IP Groups.
        """
        return pulumi.get(self, "ip_groups")

    @_builtins.property
    @pulumi.getter(name="operationGroups")
    def operation_groups(self) -> Sequence[_builtins.str]:
        """
        (Required List of Strings) Scope of resources covered by this IP Filter. Resource group must be set to 'multiple' in order to use this property. During update operations, note that the operation groups passed in will replace the list of existing operation groups (passing in an empty list will remove all operation groups) from the filter (in line with the behavior for `ip_groups` attribute).
        """
        return pulumi.get(self, "operation_groups")

    @_builtins.property
    @pulumi.getter(name="resourceGroup")
    def resource_group(self) -> _builtins.str:
        """
        (Required String) Scope of resources covered by this IP Filter. Available resource groups include `"management"` and `"multiple"`.
        """
        return pulumi.get(self, "resource_group")

    @_builtins.property
    @pulumi.getter(name="resourceScope")
    def resource_scope(self) -> _builtins.str:
        """
        (Required String) A CRN that specifies the scope of the IP Filter, specifically the organization or environment. Without specifying this property, the IP Filter would apply to the whole organization. For example, `"crn://confluent.cloud/organization=1111aaaa-11aa-11aa-11aa-111111aaaaaa"` or `data.confluent_organization.resource_name`.
        """
        return pulumi.get(self, "resource_scope")


class AwaitableGetIpFilterResult(GetIpFilterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpFilterResult(
            filter_name=self.filter_name,
            id=self.id,
            ip_groups=self.ip_groups,
            operation_groups=self.operation_groups,
            resource_group=self.resource_group,
            resource_scope=self.resource_scope)


def get_ip_filter(id: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpFilterResult:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `IpFilter` describes an IP Filter data source.

    > **Note:** See [IP Filtering on Confluent Cloud](https://docs.confluent.io/cloud/current/security/access-control/ip-filtering/overview.html) for more details about the IP Filtering feature, its prerequisites, and its limitations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_ip_filter(id="ipf-abc123")
    pulumi.export("example", example)
    ```


    :param _builtins.str id: The ID of the IP Group (e.g., `ipf-abc123`).
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('confluentcloud:index/getIpFilter:getIpFilter', __args__, opts=opts, typ=GetIpFilterResult).value

    return AwaitableGetIpFilterResult(
        filter_name=pulumi.get(__ret__, 'filter_name'),
        id=pulumi.get(__ret__, 'id'),
        ip_groups=pulumi.get(__ret__, 'ip_groups'),
        operation_groups=pulumi.get(__ret__, 'operation_groups'),
        resource_group=pulumi.get(__ret__, 'resource_group'),
        resource_scope=pulumi.get(__ret__, 'resource_scope'))
def get_ip_filter_output(id: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetIpFilterResult]:
    """
    [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

    `IpFilter` describes an IP Filter data source.

    > **Note:** See [IP Filtering on Confluent Cloud](https://docs.confluent.io/cloud/current/security/access-control/ip-filtering/overview.html) for more details about the IP Filtering feature, its prerequisites, and its limitations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_confluentcloud as confluentcloud

    example = confluentcloud.get_ip_filter(id="ipf-abc123")
    pulumi.export("example", example)
    ```


    :param _builtins.str id: The ID of the IP Group (e.g., `ipf-abc123`).
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('confluentcloud:index/getIpFilter:getIpFilter', __args__, opts=opts, typ=GetIpFilterResult)
    return __ret__.apply(lambda __response__: GetIpFilterResult(
        filter_name=pulumi.get(__response__, 'filter_name'),
        id=pulumi.get(__response__, 'id'),
        ip_groups=pulumi.get(__response__, 'ip_groups'),
        operation_groups=pulumi.get(__response__, 'operation_groups'),
        resource_group=pulumi.get(__response__, 'resource_group'),
        resource_scope=pulumi.get(__response__, 'resource_scope')))
