# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaAclArgs', 'KafkaAcl']

@pulumi.input_type
class KafkaAclArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 operation: pulumi.Input[_builtins.str],
                 pattern_type: pulumi.Input[_builtins.str],
                 permission: pulumi.Input[_builtins.str],
                 principal: pulumi.Input[_builtins.str],
                 resource_name: pulumi.Input[_builtins.str],
                 resource_type: pulumi.Input[_builtins.str],
                 credentials: Optional[pulumi.Input['KafkaAclCredentialsArgs']] = None,
                 kafka_cluster: Optional[pulumi.Input['KafkaAclKafkaClusterArgs']] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a KafkaAcl resource.
        :param pulumi.Input[_builtins.str] host: The host for the ACL.
        :param pulumi.Input[_builtins.str] operation: The operation type for the ACL. Accepted values are: `ALL`, `READ`, `WRITE`, `CREATE`, `DELETE`, `ALTER`, `DESCRIBE`, `CLUSTER_ACTION`, `DESCRIBE_CONFIGS`, `ALTER_CONFIGS`, and `IDEMPOTENT_WRITE`.  See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input[_builtins.str] pattern_type: The pattern type for the ACL. Accepted values are: `LITERAL` and `PREFIXED`.
        :param pulumi.Input[_builtins.str] permission: The permission for the ACL. Accepted values are: `DENY` and `ALLOW`.
        :param pulumi.Input[_builtins.str] principal: The principal for the ACL.
        :param pulumi.Input[_builtins.str] resource_name: The resource name for the ACL. Must be `kafka-cluster` if `resource_type` equals to `CLUSTER`.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource. Accepted values are: `TOPIC`, `GROUP`, `CLUSTER`, `TRANSACTIONAL_ID`, `DELEGATION_TOKEN`. See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find definitions of resource types and mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input['KafkaAclCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Kafka cluster, for example, `https://pkc-00000.us-central1.gcp.confluent.cloud:443`.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "pattern_type", pattern_type)
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "principal", principal)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if kafka_cluster is not None:
            pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The host for the ACL.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Input[_builtins.str]:
        """
        The operation type for the ACL. Accepted values are: `ALL`, `READ`, `WRITE`, `CREATE`, `DELETE`, `ALTER`, `DESCRIBE`, `CLUSTER_ACTION`, `DESCRIBE_CONFIGS`, `ALTER_CONFIGS`, and `IDEMPOTENT_WRITE`.  See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Input[_builtins.str]:
        """
        The pattern type for the ACL. Accepted values are: `LITERAL` and `PREFIXED`.
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pattern_type", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Input[_builtins.str]:
        """
        The permission for the ACL. Accepted values are: `DENY` and `ALLOW`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Input[_builtins.str]:
        """
        The principal for the ACL.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[_builtins.str]:
        """
        The resource name for the ACL. Must be `kafka-cluster` if `resource_type` equals to `CLUSTER`.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the resource. Accepted values are: `TOPIC`, `GROUP`, `CLUSTER`, `TRANSACTIONAL_ID`, `DELEGATION_TOKEN`. See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find definitions of resource types and mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['KafkaAclCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['KafkaAclCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> Optional[pulumi.Input['KafkaAclKafkaClusterArgs']]:
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: Optional[pulumi.Input['KafkaAclKafkaClusterArgs']]):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Kafka cluster, for example, `https://pkc-00000.us-central1.gcp.confluent.cloud:443`.
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)


@pulumi.input_type
class _KafkaAclState:
    def __init__(__self__, *,
                 credentials: Optional[pulumi.Input['KafkaAclCredentialsArgs']] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_cluster: Optional[pulumi.Input['KafkaAclKafkaClusterArgs']] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KafkaAcl resources.
        :param pulumi.Input['KafkaAclCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] host: The host for the ACL.
        :param pulumi.Input[_builtins.str] operation: The operation type for the ACL. Accepted values are: `ALL`, `READ`, `WRITE`, `CREATE`, `DELETE`, `ALTER`, `DESCRIBE`, `CLUSTER_ACTION`, `DESCRIBE_CONFIGS`, `ALTER_CONFIGS`, and `IDEMPOTENT_WRITE`.  See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input[_builtins.str] pattern_type: The pattern type for the ACL. Accepted values are: `LITERAL` and `PREFIXED`.
        :param pulumi.Input[_builtins.str] permission: The permission for the ACL. Accepted values are: `DENY` and `ALLOW`.
        :param pulumi.Input[_builtins.str] principal: The principal for the ACL.
        :param pulumi.Input[_builtins.str] resource_name: The resource name for the ACL. Must be `kafka-cluster` if `resource_type` equals to `CLUSTER`.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource. Accepted values are: `TOPIC`, `GROUP`, `CLUSTER`, `TRANSACTIONAL_ID`, `DELEGATION_TOKEN`. See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find definitions of resource types and mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Kafka cluster, for example, `https://pkc-00000.us-central1.gcp.confluent.cloud:443`.
        """
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if kafka_cluster is not None:
            pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if pattern_type is not None:
            pulumi.set(__self__, "pattern_type", pattern_type)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if principal is not None:
            pulumi.set(__self__, "principal", principal)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['KafkaAclCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['KafkaAclCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The host for the ACL.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> Optional[pulumi.Input['KafkaAclKafkaClusterArgs']]:
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: Optional[pulumi.Input['KafkaAclKafkaClusterArgs']]):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The operation type for the ACL. Accepted values are: `ALL`, `READ`, `WRITE`, `CREATE`, `DELETE`, `ALTER`, `DESCRIBE`, `CLUSTER_ACTION`, `DESCRIBE_CONFIGS`, `ALTER_CONFIGS`, and `IDEMPOTENT_WRITE`.  See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "operation", value)

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The pattern type for the ACL. Accepted values are: `LITERAL` and `PREFIXED`.
        """
        return pulumi.get(self, "pattern_type")

    @pattern_type.setter
    def pattern_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pattern_type", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permission for the ACL. Accepted values are: `DENY` and `ALLOW`.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter
    def principal(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The principal for the ACL.
        """
        return pulumi.get(self, "principal")

    @principal.setter
    def principal(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal", value)

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource name for the ACL. Must be `kafka-cluster` if `resource_type` equals to `CLUSTER`.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the resource. Accepted values are: `TOPIC`, `GROUP`, `CLUSTER`, `TRANSACTIONAL_ID`, `DELEGATION_TOKEN`. See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find definitions of resource types and mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The REST endpoint of the Kafka cluster, for example, `https://pkc-00000.us-central1.gcp.confluent.cloud:443`.
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rest_endpoint", value)


@pulumi.type_token("confluentcloud:index/kafkaAcl:KafkaAcl")
class KafkaAcl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Union['KafkaAclCredentialsArgs', 'KafkaAclCredentialsArgsDict']]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['KafkaAclKafkaClusterArgs', 'KafkaAclKafkaClusterArgsDict']]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `KafkaAcl` provides a Kafka ACL resource that enables creating and deleting Kafka ACLs on Confluent Cloud.

        ## Example Usage

        ### Option #1: Manage multiple Kafka clusters in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        describe_basic_cluster = confluentcloud.KafkaAcl("describe-basic-cluster",
            kafka_cluster={
                "id": basic_cluster["id"],
            },
            resource_type="CLUSTER",
            resource_name_="kafka-cluster",
            pattern_type="LITERAL",
            principal="User:sa-xyz123",
            host="*",
            operation="DESCRIBE",
            permission="ALLOW",
            rest_endpoint=basic_cluster["restEndpoint"],
            credentials={
                "key": app_manager_kafka_api_key["id"],
                "secret": app_manager_kafka_api_key["secret"],
            })
        ```

        ### Option #2: Manage a single Kafka cluster in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        describe_basic_cluster = confluentcloud.KafkaAcl("describe-basic-cluster",
            resource_type="CLUSTER",
            resource_name_="kafka-cluster",
            pattern_type="LITERAL",
            principal="User:sa-xyz123",
            host="*",
            operation="DESCRIBE",
            permission="ALLOW")
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `KafkaAcl` resource:
          * basic-kafka-acls: _Basic_ Kafka cluster with authorization using ACLs
          * basic-kafka-acls-with-alias: _Basic_ Kafka cluster with authorization using ACLs
          * standard-kafka-acls: _Standard_ Kafka cluster with authorization using ACLs
          * dedicated-public-kafka-acls: _Dedicated_ Kafka cluster that is accessible over the public internet with authorization using ACLs
          * dedicated-privatelink-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-privatelink-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using RBAC
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs

        ## Other Example Usages

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/issues/241
        app_producer_write_on_topic = confluentcloud.KafkaAcl("app-producer-write-on-topic",
            resource_type="TOPIC",
            resource_name_=orders["topicName"],
            pattern_type="LITERAL",
            principal=f"User:{this['id']}",
            host="*",
            operation="WRITE",
            permission="ALLOW")
        ```

        ## Import

        You can import Kafka ACLs by using the Kafka cluster ID and attributes of `confluent_kafka_acl` resource in the format `<Kafka cluster ID>/<Kafka ACL resource type>#<Kafka ACL resource name>#<Kafka ACL pattern type>#<Kafka ACL principal>#<Kafka ACL host>#<Kafka ACL operation>#<Kafka ACL permission>`, for example:

        Option #1: Manage multiple Kafka clusters in the same Pulumi Stack

        $ export IMPORT_KAFKA_API_KEY="<kafka_api_key>"

        $ export IMPORT_KAFKA_API_SECRET="<kafka_api_secret>"

        $ export IMPORT_KAFKA_REST_ENDPOINT="<kafka_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/kafkaAcl:KafkaAcl describe-cluster "lkc-12345/CLUSTER#kafka-cluster#LITERAL#User:sa-xyz123#*#DESCRIBE#ALLOW"
        ```

        Option #2: Manage a single Kafka cluster in the same Pulumi Stack

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/kafkaAcl:KafkaAcl describe-cluster "lkc-12345/CLUSTER#kafka-cluster#LITERAL#User:sa-xyz123#*#DESCRIBE#ALLOW"
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KafkaAclCredentialsArgs', 'KafkaAclCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] host: The host for the ACL.
        :param pulumi.Input[_builtins.str] operation: The operation type for the ACL. Accepted values are: `ALL`, `READ`, `WRITE`, `CREATE`, `DELETE`, `ALTER`, `DESCRIBE`, `CLUSTER_ACTION`, `DESCRIBE_CONFIGS`, `ALTER_CONFIGS`, and `IDEMPOTENT_WRITE`.  See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input[_builtins.str] pattern_type: The pattern type for the ACL. Accepted values are: `LITERAL` and `PREFIXED`.
        :param pulumi.Input[_builtins.str] permission: The permission for the ACL. Accepted values are: `DENY` and `ALLOW`.
        :param pulumi.Input[_builtins.str] principal: The principal for the ACL.
        :param pulumi.Input[_builtins.str] resource_name_: The resource name for the ACL. Must be `kafka-cluster` if `resource_type` equals to `CLUSTER`.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource. Accepted values are: `TOPIC`, `GROUP`, `CLUSTER`, `TRANSACTIONAL_ID`, `DELEGATION_TOKEN`. See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find definitions of resource types and mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Kafka cluster, for example, `https://pkc-00000.us-central1.gcp.confluent.cloud:443`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaAclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [![General Availability](https://img.shields.io/badge/Lifecycle%20Stage-General%20Availability-%2345c6e8)](https://docs.confluent.io/cloud/current/api.html#section/Versioning/API-Lifecycle-Policy)

        `KafkaAcl` provides a Kafka ACL resource that enables creating and deleting Kafka ACLs on Confluent Cloud.

        ## Example Usage

        ### Option #1: Manage multiple Kafka clusters in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        describe_basic_cluster = confluentcloud.KafkaAcl("describe-basic-cluster",
            kafka_cluster={
                "id": basic_cluster["id"],
            },
            resource_type="CLUSTER",
            resource_name_="kafka-cluster",
            pattern_type="LITERAL",
            principal="User:sa-xyz123",
            host="*",
            operation="DESCRIBE",
            permission="ALLOW",
            rest_endpoint=basic_cluster["restEndpoint"],
            credentials={
                "key": app_manager_kafka_api_key["id"],
                "secret": app_manager_kafka_api_key["secret"],
            })
        ```

        ### Option #2: Manage a single Kafka cluster in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        describe_basic_cluster = confluentcloud.KafkaAcl("describe-basic-cluster",
            resource_type="CLUSTER",
            resource_name_="kafka-cluster",
            pattern_type="LITERAL",
            principal="User:sa-xyz123",
            host="*",
            operation="DESCRIBE",
            permission="ALLOW")
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `KafkaAcl` resource:
          * basic-kafka-acls: _Basic_ Kafka cluster with authorization using ACLs
          * basic-kafka-acls-with-alias: _Basic_ Kafka cluster with authorization using ACLs
          * standard-kafka-acls: _Standard_ Kafka cluster with authorization using ACLs
          * dedicated-public-kafka-acls: _Dedicated_ Kafka cluster that is accessible over the public internet with authorization using ACLs
          * dedicated-privatelink-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-privatelink-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via PrivateLink connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using ACLs
          * dedicated-private-service-connect-gcp-kafka-rbac: _Dedicated_ Kafka cluster on GCP that is accessible via Private Service Connect connections with authorization using RBAC
          * dedicated-vnet-peering-azure-kafka-acls: _Dedicated_ Kafka cluster on Azure that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-vpc-peering-gcp-kafka-acls: _Dedicated_ Kafka cluster on GCP that is accessible via VPC Peering connections with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-acls: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using ACLs
          * dedicated-transit-gateway-attachment-aws-kafka-rbac: _Dedicated_ Kafka cluster on AWS that is accessible via Transit Gateway Endpoint with authorization using RBAC
          * enterprise-privatelinkattachment-aws-kafka-acls: _Enterprise_ Kafka cluster on AWS that is accessible via PrivateLink connections with authorization using ACLs

        ## Other Example Usages

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        # https://github.com/confluentinc/terraform-provider-confluent/issues/241
        app_producer_write_on_topic = confluentcloud.KafkaAcl("app-producer-write-on-topic",
            resource_type="TOPIC",
            resource_name_=orders["topicName"],
            pattern_type="LITERAL",
            principal=f"User:{this['id']}",
            host="*",
            operation="WRITE",
            permission="ALLOW")
        ```

        ## Import

        You can import Kafka ACLs by using the Kafka cluster ID and attributes of `confluent_kafka_acl` resource in the format `<Kafka cluster ID>/<Kafka ACL resource type>#<Kafka ACL resource name>#<Kafka ACL pattern type>#<Kafka ACL principal>#<Kafka ACL host>#<Kafka ACL operation>#<Kafka ACL permission>`, for example:

        Option #1: Manage multiple Kafka clusters in the same Pulumi Stack

        $ export IMPORT_KAFKA_API_KEY="<kafka_api_key>"

        $ export IMPORT_KAFKA_API_SECRET="<kafka_api_secret>"

        $ export IMPORT_KAFKA_REST_ENDPOINT="<kafka_rest_endpoint>"

        ```sh
        $ pulumi import confluentcloud:index/kafkaAcl:KafkaAcl describe-cluster "lkc-12345/CLUSTER#kafka-cluster#LITERAL#User:sa-xyz123#*#DESCRIBE#ALLOW"
        ```

        Option #2: Manage a single Kafka cluster in the same Pulumi Stack

        $ export CONFLUENT_CLOUD_API_KEY="<cloud_api_key>"

        $ export CONFLUENT_CLOUD_API_SECRET="<cloud_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/kafkaAcl:KafkaAcl describe-cluster "lkc-12345/CLUSTER#kafka-cluster#LITERAL#User:sa-xyz123#*#DESCRIBE#ALLOW"
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param KafkaAclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaAclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 credentials: Optional[pulumi.Input[Union['KafkaAclCredentialsArgs', 'KafkaAclCredentialsArgsDict']]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['KafkaAclKafkaClusterArgs', 'KafkaAclKafkaClusterArgsDict']]] = None,
                 operation: Optional[pulumi.Input[_builtins.str]] = None,
                 pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 principal: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaAclArgs.__new__(KafkaAclArgs)

            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["kafka_cluster"] = kafka_cluster
            if operation is None and not opts.urn:
                raise TypeError("Missing required property 'operation'")
            __props__.__dict__["operation"] = operation
            if pattern_type is None and not opts.urn:
                raise TypeError("Missing required property 'pattern_type'")
            __props__.__dict__["pattern_type"] = pattern_type
            if permission is None and not opts.urn:
                raise TypeError("Missing required property 'permission'")
            __props__.__dict__["permission"] = permission
            if principal is None and not opts.urn:
                raise TypeError("Missing required property 'principal'")
            __props__.__dict__["principal"] = principal
            if resource_name_ is None and not opts.urn:
                raise TypeError("Missing required property 'resource_name_'")
            __props__.__dict__["resource_name"] = resource_name_
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["rest_endpoint"] = rest_endpoint
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(KafkaAcl, __self__).__init__(
            'confluentcloud:index/kafkaAcl:KafkaAcl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            credentials: Optional[pulumi.Input[Union['KafkaAclCredentialsArgs', 'KafkaAclCredentialsArgsDict']]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            kafka_cluster: Optional[pulumi.Input[Union['KafkaAclKafkaClusterArgs', 'KafkaAclKafkaClusterArgsDict']]] = None,
            operation: Optional[pulumi.Input[_builtins.str]] = None,
            pattern_type: Optional[pulumi.Input[_builtins.str]] = None,
            permission: Optional[pulumi.Input[_builtins.str]] = None,
            principal: Optional[pulumi.Input[_builtins.str]] = None,
            resource_name_: Optional[pulumi.Input[_builtins.str]] = None,
            resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            rest_endpoint: Optional[pulumi.Input[_builtins.str]] = None) -> 'KafkaAcl':
        """
        Get an existing KafkaAcl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['KafkaAclCredentialsArgs', 'KafkaAclCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] host: The host for the ACL.
        :param pulumi.Input[_builtins.str] operation: The operation type for the ACL. Accepted values are: `ALL`, `READ`, `WRITE`, `CREATE`, `DELETE`, `ALTER`, `DESCRIBE`, `CLUSTER_ACTION`, `DESCRIBE_CONFIGS`, `ALTER_CONFIGS`, and `IDEMPOTENT_WRITE`.  See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input[_builtins.str] pattern_type: The pattern type for the ACL. Accepted values are: `LITERAL` and `PREFIXED`.
        :param pulumi.Input[_builtins.str] permission: The permission for the ACL. Accepted values are: `DENY` and `ALLOW`.
        :param pulumi.Input[_builtins.str] principal: The principal for the ACL.
        :param pulumi.Input[_builtins.str] resource_name_: The resource name for the ACL. Must be `kafka-cluster` if `resource_type` equals to `CLUSTER`.
        :param pulumi.Input[_builtins.str] resource_type: The type of the resource. Accepted values are: `TOPIC`, `GROUP`, `CLUSTER`, `TRANSACTIONAL_ID`, `DELEGATION_TOKEN`. See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find definitions of resource types and mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        :param pulumi.Input[_builtins.str] rest_endpoint: The REST endpoint of the Kafka cluster, for example, `https://pkc-00000.us-central1.gcp.confluent.cloud:443`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaAclState.__new__(_KafkaAclState)

        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["host"] = host
        __props__.__dict__["kafka_cluster"] = kafka_cluster
        __props__.__dict__["operation"] = operation
        __props__.__dict__["pattern_type"] = pattern_type
        __props__.__dict__["permission"] = permission
        __props__.__dict__["principal"] = principal
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        return KafkaAcl(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.KafkaAclCredentials']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The host for the ACL.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Output[Optional['outputs.KafkaAclKafkaCluster']]:
        return pulumi.get(self, "kafka_cluster")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> pulumi.Output[_builtins.str]:
        """
        The operation type for the ACL. Accepted values are: `ALL`, `READ`, `WRITE`, `CREATE`, `DELETE`, `ALTER`, `DESCRIBE`, `CLUSTER_ACTION`, `DESCRIBE_CONFIGS`, `ALTER_CONFIGS`, and `IDEMPOTENT_WRITE`.  See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter(name="patternType")
    def pattern_type(self) -> pulumi.Output[_builtins.str]:
        """
        The pattern type for the ACL. Accepted values are: `LITERAL` and `PREFIXED`.
        """
        return pulumi.get(self, "pattern_type")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Output[_builtins.str]:
        """
        The permission for the ACL. Accepted values are: `DENY` and `ALLOW`.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter
    def principal(self) -> pulumi.Output[_builtins.str]:
        """
        The principal for the ACL.
        """
        return pulumi.get(self, "principal")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[_builtins.str]:
        """
        The resource name for the ACL. Must be `kafka-cluster` if `resource_type` equals to `CLUSTER`.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the resource. Accepted values are: `TOPIC`, `GROUP`, `CLUSTER`, `TRANSACTIONAL_ID`, `DELEGATION_TOKEN`. See [Authorization using ACLs](https://docs.confluent.io/platform/current/kafka/authorization.html#operations) to find definitions of resource types and mappings of `(resource_type, operation)` to one or more Kafka APIs or request types.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The REST endpoint of the Kafka cluster, for example, `https://pkc-00000.us-central1.gcp.confluent.cloud:443`.
        """
        return pulumi.get(self, "rest_endpoint")

