# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TableflowTopicArgs', 'TableflowTopic']

@pulumi.input_type
class TableflowTopicArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 environment: pulumi.Input['TableflowTopicEnvironmentArgs'],
                 kafka_cluster: pulumi.Input['TableflowTopicKafkaClusterArgs'],
                 byob_aws: Optional[pulumi.Input['TableflowTopicByobAwsArgs']] = None,
                 credentials: Optional[pulumi.Input['TableflowTopicCredentialsArgs']] = None,
                 managed_storages: Optional[pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]]] = None,
                 record_failure_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 table_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a TableflowTopic resource.
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka topic for which Tableflow is enabled.
        :param pulumi.Input['TableflowTopicEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input['TableflowTopicByobAwsArgs'] byob_aws: supports the following (See [Quick Start with Custom Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-custom-storage-glue.html#cloud-tableflow-quick-start) for more details):
        :param pulumi.Input['TableflowTopicCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]] managed_storages: The configuration of the Confluent managed storage. See [Quick Start with Managed Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-managed-storage.html#cloud-tableflow-quick-start-managed-storage) for more details.
        :param pulumi.Input[_builtins.str] record_failure_strategy: The strategy to handle record failures in the Tableflow enabled topic during materialization. Accepted values are `SKIP`, `SUSPEND`. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        :param pulumi.Input[_builtins.str] retention_ms: The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] table_formats: The supported table formats for the Tableflow-enabled topic. Accepted values are `DELTA`, `ICEBERG`.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if byob_aws is not None:
            pulumi.set(__self__, "byob_aws", byob_aws)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if managed_storages is not None:
            pulumi.set(__self__, "managed_storages", managed_storages)
        if record_failure_strategy is not None:
            pulumi.set(__self__, "record_failure_strategy", record_failure_strategy)
        if retention_ms is not None:
            pulumi.set(__self__, "retention_ms", retention_ms)
        if table_formats is not None:
            pulumi.set(__self__, "table_formats", table_formats)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Kafka topic for which Tableflow is enabled.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Input['TableflowTopicEnvironmentArgs']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input['TableflowTopicEnvironmentArgs']):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Input['TableflowTopicKafkaClusterArgs']:
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: pulumi.Input['TableflowTopicKafkaClusterArgs']):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter(name="byobAws")
    def byob_aws(self) -> Optional[pulumi.Input['TableflowTopicByobAwsArgs']]:
        """
        supports the following (See [Quick Start with Custom Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-custom-storage-glue.html#cloud-tableflow-quick-start) for more details):
        """
        return pulumi.get(self, "byob_aws")

    @byob_aws.setter
    def byob_aws(self, value: Optional[pulumi.Input['TableflowTopicByobAwsArgs']]):
        pulumi.set(self, "byob_aws", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['TableflowTopicCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['TableflowTopicCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="managedStorages")
    def managed_storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]]]:
        """
        The configuration of the Confluent managed storage. See [Quick Start with Managed Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-managed-storage.html#cloud-tableflow-quick-start-managed-storage) for more details.
        """
        return pulumi.get(self, "managed_storages")

    @managed_storages.setter
    def managed_storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]]]):
        pulumi.set(self, "managed_storages", value)

    @_builtins.property
    @pulumi.getter(name="recordFailureStrategy")
    def record_failure_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The strategy to handle record failures in the Tableflow enabled topic during materialization. Accepted values are `SKIP`, `SUSPEND`. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        """
        return pulumi.get(self, "record_failure_strategy")

    @record_failure_strategy.setter
    def record_failure_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_failure_strategy", value)

    @_builtins.property
    @pulumi.getter(name="retentionMs")
    def retention_ms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        """
        return pulumi.get(self, "retention_ms")

    @retention_ms.setter
    def retention_ms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_ms", value)

    @_builtins.property
    @pulumi.getter(name="tableFormats")
    def table_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The supported table formats for the Tableflow-enabled topic. Accepted values are `DELTA`, `ICEBERG`.
        """
        return pulumi.get(self, "table_formats")

    @table_formats.setter
    def table_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "table_formats", value)


@pulumi.input_type
class _TableflowTopicState:
    def __init__(__self__, *,
                 byob_aws: Optional[pulumi.Input['TableflowTopicByobAwsArgs']] = None,
                 credentials: Optional[pulumi.Input['TableflowTopicCredentialsArgs']] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_compaction: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_partitioning: Optional[pulumi.Input[_builtins.bool]] = None,
                 environment: Optional[pulumi.Input['TableflowTopicEnvironmentArgs']] = None,
                 kafka_cluster: Optional[pulumi.Input['TableflowTopicKafkaClusterArgs']] = None,
                 managed_storages: Optional[pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]]] = None,
                 record_failure_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 suspended: Optional[pulumi.Input[_builtins.bool]] = None,
                 table_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 table_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TableflowTopic resources.
        :param pulumi.Input['TableflowTopicByobAwsArgs'] byob_aws: supports the following (See [Quick Start with Custom Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-custom-storage-glue.html#cloud-tableflow-quick-start) for more details):
        :param pulumi.Input['TableflowTopicCredentialsArgs'] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka topic for which Tableflow is enabled.
        :param pulumi.Input[_builtins.bool] enable_compaction: (Optional Boolean) This flag determines whether to enable compaction for the Tableflow enabled topic.
        :param pulumi.Input[_builtins.bool] enable_partitioning: (Optional Boolean) This flag determines whether to enable partitioning for the Tableflow enabled topic.
        :param pulumi.Input['TableflowTopicEnvironmentArgs'] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]] managed_storages: The configuration of the Confluent managed storage. See [Quick Start with Managed Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-managed-storage.html#cloud-tableflow-quick-start-managed-storage) for more details.
        :param pulumi.Input[_builtins.str] record_failure_strategy: The strategy to handle record failures in the Tableflow enabled topic during materialization. Accepted values are `SKIP`, `SUSPEND`. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        :param pulumi.Input[_builtins.str] retention_ms: The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        :param pulumi.Input[_builtins.bool] suspended: (Optional Boolean) Indicates whether the Tableflow should be suspended.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] table_formats: The supported table formats for the Tableflow-enabled topic. Accepted values are `DELTA`, `ICEBERG`.
        :param pulumi.Input[_builtins.str] table_path: (Optional String) The current storage path where the data and metadata is stored for this table.
        """
        if byob_aws is not None:
            pulumi.set(__self__, "byob_aws", byob_aws)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_compaction is not None:
            pulumi.set(__self__, "enable_compaction", enable_compaction)
        if enable_partitioning is not None:
            pulumi.set(__self__, "enable_partitioning", enable_partitioning)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if kafka_cluster is not None:
            pulumi.set(__self__, "kafka_cluster", kafka_cluster)
        if managed_storages is not None:
            pulumi.set(__self__, "managed_storages", managed_storages)
        if record_failure_strategy is not None:
            pulumi.set(__self__, "record_failure_strategy", record_failure_strategy)
        if retention_ms is not None:
            pulumi.set(__self__, "retention_ms", retention_ms)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if table_formats is not None:
            pulumi.set(__self__, "table_formats", table_formats)
        if table_path is not None:
            pulumi.set(__self__, "table_path", table_path)

    @_builtins.property
    @pulumi.getter(name="byobAws")
    def byob_aws(self) -> Optional[pulumi.Input['TableflowTopicByobAwsArgs']]:
        """
        supports the following (See [Quick Start with Custom Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-custom-storage-glue.html#cloud-tableflow-quick-start) for more details):
        """
        return pulumi.get(self, "byob_aws")

    @byob_aws.setter
    def byob_aws(self, value: Optional[pulumi.Input['TableflowTopicByobAwsArgs']]):
        pulumi.set(self, "byob_aws", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['TableflowTopicCredentialsArgs']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['TableflowTopicCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kafka topic for which Tableflow is enabled.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="enableCompaction")
    def enable_compaction(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Optional Boolean) This flag determines whether to enable compaction for the Tableflow enabled topic.
        """
        return pulumi.get(self, "enable_compaction")

    @enable_compaction.setter
    def enable_compaction(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_compaction", value)

    @_builtins.property
    @pulumi.getter(name="enablePartitioning")
    def enable_partitioning(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Optional Boolean) This flag determines whether to enable partitioning for the Tableflow enabled topic.
        """
        return pulumi.get(self, "enable_partitioning")

    @enable_partitioning.setter
    def enable_partitioning(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_partitioning", value)

    @_builtins.property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input['TableflowTopicEnvironmentArgs']]:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input['TableflowTopicEnvironmentArgs']]):
        pulumi.set(self, "environment", value)

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> Optional[pulumi.Input['TableflowTopicKafkaClusterArgs']]:
        return pulumi.get(self, "kafka_cluster")

    @kafka_cluster.setter
    def kafka_cluster(self, value: Optional[pulumi.Input['TableflowTopicKafkaClusterArgs']]):
        pulumi.set(self, "kafka_cluster", value)

    @_builtins.property
    @pulumi.getter(name="managedStorages")
    def managed_storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]]]:
        """
        The configuration of the Confluent managed storage. See [Quick Start with Managed Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-managed-storage.html#cloud-tableflow-quick-start-managed-storage) for more details.
        """
        return pulumi.get(self, "managed_storages")

    @managed_storages.setter
    def managed_storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TableflowTopicManagedStorageArgs']]]]):
        pulumi.set(self, "managed_storages", value)

    @_builtins.property
    @pulumi.getter(name="recordFailureStrategy")
    def record_failure_strategy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The strategy to handle record failures in the Tableflow enabled topic during materialization. Accepted values are `SKIP`, `SUSPEND`. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        """
        return pulumi.get(self, "record_failure_strategy")

    @record_failure_strategy.setter
    def record_failure_strategy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "record_failure_strategy", value)

    @_builtins.property
    @pulumi.getter(name="retentionMs")
    def retention_ms(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        """
        return pulumi.get(self, "retention_ms")

    @retention_ms.setter
    def retention_ms(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_ms", value)

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Optional Boolean) Indicates whether the Tableflow should be suspended.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @_builtins.property
    @pulumi.getter(name="tableFormats")
    def table_formats(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The supported table formats for the Tableflow-enabled topic. Accepted values are `DELTA`, `ICEBERG`.
        """
        return pulumi.get(self, "table_formats")

    @table_formats.setter
    def table_formats(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "table_formats", value)

    @_builtins.property
    @pulumi.getter(name="tablePath")
    def table_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional String) The current storage path where the data and metadata is stored for this table.
        """
        return pulumi.get(self, "table_path")

    @table_path.setter
    def table_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table_path", value)


@pulumi.type_token("confluentcloud:index/tableflowTopic:TableflowTopic")
class TableflowTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 byob_aws: Optional[pulumi.Input[Union['TableflowTopicByobAwsArgs', 'TableflowTopicByobAwsArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['TableflowTopicCredentialsArgs', 'TableflowTopicCredentialsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['TableflowTopicEnvironmentArgs', 'TableflowTopicEnvironmentArgsDict']]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['TableflowTopicKafkaClusterArgs', 'TableflowTopicKafkaClusterArgsDict']]] = None,
                 managed_storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableflowTopicManagedStorageArgs', 'TableflowTopicManagedStorageArgsDict']]]]] = None,
                 record_failure_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 table_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ### Option #1: Manage multiple Tableflow Topics in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.TableflowTopic("example",
            managed_storages=[{}],
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": staging_confluent_kafka_cluster["id"],
            },
            display_name=orders["topicName"],
            table_formats=[
                "ICEBERG",
                "DELTA",
            ],
            credentials={
                "key": env_admin_tableflow_api_key["id"],
                "secret": env_admin_tableflow_api_key["secret"],
            })
        ```

        ### Option #2: Manage a single Tableflow Topic in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.TableflowTopic("example",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": staging_confluent_kafka_cluster["id"],
            },
            display_name=orders["topicName"],
            byob_aws={
                "bucket_name": "bucket_1",
                "provider_integration_id": main["id"],
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `TableflowTopic` resource:
        * confluent-managed-storage: Tableflow topic with Confluent-managed storage.
        * byob-aws-storage: Tableflow topic with custom (BYOB AWS) storage.
        * datagen-connector-byob-aws-storage: Datagen Source connector with a Tableflow topic with custom (BYOB AWS) storage.
        * datagen-connector-confluent-managed-storage: Datagen Source connector with a Tableflow topic with Confluent-managed storage.

        ## Import

        You can import a Tableflow Topic by using the Tableflow Topic name, Environment ID, and Kafka Cluster ID, in the format `<Environment ID>/<Kafka Cluster ID>/<Tableflow Topic name>`, for example:

        Option #1: Manage multiple Tableflow Topics in the same Pulumi Stack

        $ export IMPORT_TABLEFLOW_API_KEY="<tableflow_api_key>"

        $ export IMPORT_TABLEFLOW_API_SECRET="<tableflow_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/tableflowTopic:TableflowTopic example env-abc123/lkc-abc123/orders
        ```

        Option #2: Manage a single Tableflow Topic in the same Pulumi Stack

        ```sh
        $ pulumi import confluentcloud:index/tableflowTopic:TableflowTopic example env-abc123/lkc-abc123/orders
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableflowTopicByobAwsArgs', 'TableflowTopicByobAwsArgsDict']] byob_aws: supports the following (See [Quick Start with Custom Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-custom-storage-glue.html#cloud-tableflow-quick-start) for more details):
        :param pulumi.Input[Union['TableflowTopicCredentialsArgs', 'TableflowTopicCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka topic for which Tableflow is enabled.
        :param pulumi.Input[Union['TableflowTopicEnvironmentArgs', 'TableflowTopicEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableflowTopicManagedStorageArgs', 'TableflowTopicManagedStorageArgsDict']]]] managed_storages: The configuration of the Confluent managed storage. See [Quick Start with Managed Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-managed-storage.html#cloud-tableflow-quick-start-managed-storage) for more details.
        :param pulumi.Input[_builtins.str] record_failure_strategy: The strategy to handle record failures in the Tableflow enabled topic during materialization. Accepted values are `SKIP`, `SUSPEND`. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        :param pulumi.Input[_builtins.str] retention_ms: The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] table_formats: The supported table formats for the Tableflow-enabled topic. Accepted values are `DELTA`, `ICEBERG`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableflowTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ### Option #1: Manage multiple Tableflow Topics in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.TableflowTopic("example",
            managed_storages=[{}],
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": staging_confluent_kafka_cluster["id"],
            },
            display_name=orders["topicName"],
            table_formats=[
                "ICEBERG",
                "DELTA",
            ],
            credentials={
                "key": env_admin_tableflow_api_key["id"],
                "secret": env_admin_tableflow_api_key["secret"],
            })
        ```

        ### Option #2: Manage a single Tableflow Topic in the same Pulumi Stack

        ```python
        import pulumi
        import pulumi_confluentcloud as confluentcloud

        example = confluentcloud.TableflowTopic("example",
            environment={
                "id": staging["id"],
            },
            kafka_cluster={
                "id": staging_confluent_kafka_cluster["id"],
            },
            display_name=orders["topicName"],
            byob_aws={
                "bucket_name": "bucket_1",
                "provider_integration_id": main["id"],
            })
        ```

        ## Getting Started

        The following end-to-end examples might help to get started with `TableflowTopic` resource:
        * confluent-managed-storage: Tableflow topic with Confluent-managed storage.
        * byob-aws-storage: Tableflow topic with custom (BYOB AWS) storage.
        * datagen-connector-byob-aws-storage: Datagen Source connector with a Tableflow topic with custom (BYOB AWS) storage.
        * datagen-connector-confluent-managed-storage: Datagen Source connector with a Tableflow topic with Confluent-managed storage.

        ## Import

        You can import a Tableflow Topic by using the Tableflow Topic name, Environment ID, and Kafka Cluster ID, in the format `<Environment ID>/<Kafka Cluster ID>/<Tableflow Topic name>`, for example:

        Option #1: Manage multiple Tableflow Topics in the same Pulumi Stack

        $ export IMPORT_TABLEFLOW_API_KEY="<tableflow_api_key>"

        $ export IMPORT_TABLEFLOW_API_SECRET="<tableflow_api_secret>"

        ```sh
        $ pulumi import confluentcloud:index/tableflowTopic:TableflowTopic example env-abc123/lkc-abc123/orders
        ```

        Option #2: Manage a single Tableflow Topic in the same Pulumi Stack

        ```sh
        $ pulumi import confluentcloud:index/tableflowTopic:TableflowTopic example env-abc123/lkc-abc123/orders
        ```

        !> **Warning:** Do not forget to delete terminal command history afterwards for security purposes.

        :param str resource_name: The name of the resource.
        :param TableflowTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableflowTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 byob_aws: Optional[pulumi.Input[Union['TableflowTopicByobAwsArgs', 'TableflowTopicByobAwsArgsDict']]] = None,
                 credentials: Optional[pulumi.Input[Union['TableflowTopicCredentialsArgs', 'TableflowTopicCredentialsArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 environment: Optional[pulumi.Input[Union['TableflowTopicEnvironmentArgs', 'TableflowTopicEnvironmentArgsDict']]] = None,
                 kafka_cluster: Optional[pulumi.Input[Union['TableflowTopicKafkaClusterArgs', 'TableflowTopicKafkaClusterArgsDict']]] = None,
                 managed_storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableflowTopicManagedStorageArgs', 'TableflowTopicManagedStorageArgsDict']]]]] = None,
                 record_failure_strategy: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_ms: Optional[pulumi.Input[_builtins.str]] = None,
                 table_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableflowTopicArgs.__new__(TableflowTopicArgs)

            __props__.__dict__["byob_aws"] = byob_aws
            __props__.__dict__["credentials"] = None if credentials is None else pulumi.Output.secret(credentials)
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            if kafka_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_cluster'")
            __props__.__dict__["kafka_cluster"] = kafka_cluster
            __props__.__dict__["managed_storages"] = managed_storages
            __props__.__dict__["record_failure_strategy"] = record_failure_strategy
            __props__.__dict__["retention_ms"] = retention_ms
            __props__.__dict__["table_formats"] = table_formats
            __props__.__dict__["enable_compaction"] = None
            __props__.__dict__["enable_partitioning"] = None
            __props__.__dict__["suspended"] = None
            __props__.__dict__["table_path"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["credentials"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TableflowTopic, __self__).__init__(
            'confluentcloud:index/tableflowTopic:TableflowTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            byob_aws: Optional[pulumi.Input[Union['TableflowTopicByobAwsArgs', 'TableflowTopicByobAwsArgsDict']]] = None,
            credentials: Optional[pulumi.Input[Union['TableflowTopicCredentialsArgs', 'TableflowTopicCredentialsArgsDict']]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enable_compaction: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_partitioning: Optional[pulumi.Input[_builtins.bool]] = None,
            environment: Optional[pulumi.Input[Union['TableflowTopicEnvironmentArgs', 'TableflowTopicEnvironmentArgsDict']]] = None,
            kafka_cluster: Optional[pulumi.Input[Union['TableflowTopicKafkaClusterArgs', 'TableflowTopicKafkaClusterArgsDict']]] = None,
            managed_storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TableflowTopicManagedStorageArgs', 'TableflowTopicManagedStorageArgsDict']]]]] = None,
            record_failure_strategy: Optional[pulumi.Input[_builtins.str]] = None,
            retention_ms: Optional[pulumi.Input[_builtins.str]] = None,
            suspended: Optional[pulumi.Input[_builtins.bool]] = None,
            table_formats: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            table_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'TableflowTopic':
        """
        Get an existing TableflowTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['TableflowTopicByobAwsArgs', 'TableflowTopicByobAwsArgsDict']] byob_aws: supports the following (See [Quick Start with Custom Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-custom-storage-glue.html#cloud-tableflow-quick-start) for more details):
        :param pulumi.Input[Union['TableflowTopicCredentialsArgs', 'TableflowTopicCredentialsArgsDict']] credentials: The Cluster API Credentials.
        :param pulumi.Input[_builtins.str] display_name: The name of the Kafka topic for which Tableflow is enabled.
        :param pulumi.Input[_builtins.bool] enable_compaction: (Optional Boolean) This flag determines whether to enable compaction for the Tableflow enabled topic.
        :param pulumi.Input[_builtins.bool] enable_partitioning: (Optional Boolean) This flag determines whether to enable partitioning for the Tableflow enabled topic.
        :param pulumi.Input[Union['TableflowTopicEnvironmentArgs', 'TableflowTopicEnvironmentArgsDict']] environment: Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TableflowTopicManagedStorageArgs', 'TableflowTopicManagedStorageArgsDict']]]] managed_storages: The configuration of the Confluent managed storage. See [Quick Start with Managed Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-managed-storage.html#cloud-tableflow-quick-start-managed-storage) for more details.
        :param pulumi.Input[_builtins.str] record_failure_strategy: The strategy to handle record failures in the Tableflow enabled topic during materialization. Accepted values are `SKIP`, `SUSPEND`. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        :param pulumi.Input[_builtins.str] retention_ms: The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        :param pulumi.Input[_builtins.bool] suspended: (Optional Boolean) Indicates whether the Tableflow should be suspended.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] table_formats: The supported table formats for the Tableflow-enabled topic. Accepted values are `DELTA`, `ICEBERG`.
        :param pulumi.Input[_builtins.str] table_path: (Optional String) The current storage path where the data and metadata is stored for this table.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableflowTopicState.__new__(_TableflowTopicState)

        __props__.__dict__["byob_aws"] = byob_aws
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_compaction"] = enable_compaction
        __props__.__dict__["enable_partitioning"] = enable_partitioning
        __props__.__dict__["environment"] = environment
        __props__.__dict__["kafka_cluster"] = kafka_cluster
        __props__.__dict__["managed_storages"] = managed_storages
        __props__.__dict__["record_failure_strategy"] = record_failure_strategy
        __props__.__dict__["retention_ms"] = retention_ms
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["table_formats"] = table_formats
        __props__.__dict__["table_path"] = table_path
        return TableflowTopic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="byobAws")
    def byob_aws(self) -> pulumi.Output[Optional['outputs.TableflowTopicByobAws']]:
        """
        supports the following (See [Quick Start with Custom Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-custom-storage-glue.html#cloud-tableflow-quick-start) for more details):
        """
        return pulumi.get(self, "byob_aws")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.TableflowTopicCredentials']]:
        """
        The Cluster API Credentials.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Kafka topic for which Tableflow is enabled.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="enableCompaction")
    def enable_compaction(self) -> pulumi.Output[_builtins.bool]:
        """
        (Optional Boolean) This flag determines whether to enable compaction for the Tableflow enabled topic.
        """
        return pulumi.get(self, "enable_compaction")

    @_builtins.property
    @pulumi.getter(name="enablePartitioning")
    def enable_partitioning(self) -> pulumi.Output[_builtins.bool]:
        """
        (Optional Boolean) This flag determines whether to enable partitioning for the Tableflow enabled topic.
        """
        return pulumi.get(self, "enable_partitioning")

    @_builtins.property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.TableflowTopicEnvironment']:
        """
        Environment objects represent an isolated namespace for your Confluent resources for organizational purposes.
        """
        return pulumi.get(self, "environment")

    @_builtins.property
    @pulumi.getter(name="kafkaCluster")
    def kafka_cluster(self) -> pulumi.Output['outputs.TableflowTopicKafkaCluster']:
        return pulumi.get(self, "kafka_cluster")

    @_builtins.property
    @pulumi.getter(name="managedStorages")
    def managed_storages(self) -> pulumi.Output[Optional[Sequence['outputs.TableflowTopicManagedStorage']]]:
        """
        The configuration of the Confluent managed storage. See [Quick Start with Managed Storage](https://docs.confluent.io/cloud/current/topics/tableflow/get-started/quick-start-managed-storage.html#cloud-tableflow-quick-start-managed-storage) for more details.
        """
        return pulumi.get(self, "managed_storages")

    @_builtins.property
    @pulumi.getter(name="recordFailureStrategy")
    def record_failure_strategy(self) -> pulumi.Output[_builtins.str]:
        """
        The strategy to handle record failures in the Tableflow enabled topic during materialization. Accepted values are `SKIP`, `SUSPEND`. For `SKIP`, we skip the bad records and move to the next record. For `SUSPEND`, we suspend the materialization of the topic.
        """
        return pulumi.get(self, "record_failure_strategy")

    @_builtins.property
    @pulumi.getter(name="retentionMs")
    def retention_ms(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The max age of snapshots (Iceberg) or versions (Delta) (snapshot/version expiration) to keep on the table in milliseconds for the Tableflow enabled topic.
        """
        return pulumi.get(self, "retention_ms")

    @_builtins.property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[_builtins.bool]:
        """
        (Optional Boolean) Indicates whether the Tableflow should be suspended.
        """
        return pulumi.get(self, "suspended")

    @_builtins.property
    @pulumi.getter(name="tableFormats")
    def table_formats(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The supported table formats for the Tableflow-enabled topic. Accepted values are `DELTA`, `ICEBERG`.
        """
        return pulumi.get(self, "table_formats")

    @_builtins.property
    @pulumi.getter(name="tablePath")
    def table_path(self) -> pulumi.Output[_builtins.str]:
        """
        (Optional String) The current storage path where the data and metadata is stored for this table.
        """
        return pulumi.get(self, "table_path")

