#MobileInventoryCLI is now radboy
from . import *
from collections import OrderedDict
from radboy.DB.db import ENGINE
import uuid,base64

#generated by google gemini
def generate_24_char_uuid():
    return Entry.cfmt(None,str(uuid.uuid4()).replace("-",''))

def get_bool(text):
    if text in (None,'',False,'n','N','NO','No','nO','False','false',0,'0'):
        return False
    elif text in (True,'y','yes',1,'1','True','true','YES','Yes','Y'):
        return True
    else:
        try:
            return eval(text)
        except Exception as e:
            print(e)
            return False
DateTimeFormats=(
'%m/%d/%Y@%H:%M:%S',
'%H:%M:%S on %m/%d/%Y',
'%m/%d/%Y@%H:%M',
'%H:%M on %m/%d/%Y',
)
'''
 bytes are stored as base64 string
 under neu
  af2e add field to Entry
  sf2e select a field name from searched/listed and add field to entry
   these searched/listed fieldnames would be collected from already created fields
   results=search by name or use '*' to show all
   name=select index from results and get name of object
   apply name to new extra
   apply type from result
   get value
   apply entry id
   commit result
 under esu
  when a product is searched the Extras Table for corresponding
  EntryId and display that info as well before printing next Entry
'''       
TYPES_FromText={
"string":{
'cmds':['str','text',],
"exec":str,
"desc":'anything that is meant to be text'
},
"integer":{
'cmds':['integer','int'],
'exec':int,
'desc':"numbers without decimal"
},
"float":{
'cmds':['float','decimal'],
'exec':float,
'desc':"numbers with a decimal"
},
"boolean":{
'cmds':['boolean','bool'],
'exec':get_bool,
'desc':"True or False,"
},
"DateTime":{
'cmds':['datetime'],
'exec':lambda x,format:datetime.datetime.strptime(format,x),
'desc':"date values from format and string"
},
"bytes":{
'cmds':['byte','bytes','base64bytes'],
'exec':lambda x: base64.b64decode(x.encode()),
'desc':"byte values stored as a base64 string"
},
}

DT_LastUsedFormat="%m/%d/%Y@%H:%M:%S"
#datetime.now().strftime
quality_scale='Grand[13]/Excellent[12]/Spectacular[11]/Magnificent[10]/Good[9]/Poor[8]/Useable[7]/Barely-Useable[6]/Unuseable[5]/For Parts[4]/For Looks[3]/Trash[2]/Complete Trash[1] or N/A or 1[Complete Trash(#YouLostYourTemper)]-13[Grand(#ExpectionsHaveBeenExceededByLargerThanLife)] or a pre-existing rating system already recognized by its target audience.'
async def ensure_extras_field_exists():
    with Session(ENGINE) as session:
        query_entry=session.query(Entry).all()
        ct=len(query_entry)
        for num,i in enumerate(query_entry):
            extras_query=session.query(EntryDataExtras).filter(and_(EntryDataExtras.EntryId==i.EntryId,EntryDataExtras.field_name=="DT_LastUsed")).all()
            print(extras_query,"#1")
            if len(extras_query) > 1:
                print("#2.0")
                extras_query_1=session.query(EntryDataExtras).filter(and_(EntryDataExtras.EntryId==i.EntryId,EntryDataExtras.field_name=="DT_LastUsed")).first()
                for num,i in enumerate(extras_query):
                    if num > 0:
                        session.delete(i)
                session.commit()
                extras_query=extras_query_1
                state=f"{Fore.light_green}[ Multiples Exist, Reducing To 1 ]{Style.reset}"
            elif len(extras_query) == 1:
                print('#2.1',extras_query,i.rebar())
                #extras_query=extras_query[0]
                state=f"{Fore.light_green}[ 1 Exists ]{Style.reset}"
                #print(i,extras_query)
            else:
                print('#2.3')
                extra=EntryDataExtras(EntryId=i.EntryId,field_name="DT_LastUsed",field_value=datetime.now().strftime(DT_LastUsedFormat),field_type="datetime")
                session.add(extra)
                state=f"{Fore.light_green}[ Added ]{Style.reset}"
            print('#3.0')
            if num % int(0.25*ct) == 0:
                session.commit()
            msg=f"{num}/{num+1} of {ct} -> {i.seeShort()} - {state}"
            print(msg)      
        session.commit()
    print(f"{Fore.light_steel_blue}ensure_extras_field_exists() ->{Fore.orange_red_1}Done!{Style.reset}")

class EntryDataExtrasMenu:
    '''
    Add,remove,list fields,create fields EntryDataExtras
    '''
    def rm_ede_id(self):
        with Session(ENGINE) as session:
            ede_ids=Prompt.__init2__(None,func=FormBuilderMkText,ptext="ExtryDataExtras.ede_id to delete,as comma separated list(SLOW)?",helpText="the id value for the EntryDataExtras that you wish to delete.",data="list")
            if ede_ids in [None,[]]:
                return
            try:
                for num,ede_id in enumerate(ede_ids):
                    try:
                        ede_id=int(ede_id)
                        ede=session.query(EntryDataExtras).filter(EntryDataExtras.ede_id==ede_id).first()
                        if ede:
                            session.delete(ede)
                            session.commit()
                            results=session.query(EntryDataExtras).all()
                            ct=len(results)
                            for num,i in enumerate(results):
                                msg=f"{Fore.orange_red_1}DEPENDENCY CHECK{Fore.dark_goldenrod}-> {Fore.cyan}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct} -> {i}"
                                print(msg)
                                check=session.query(Entry).filter(Entry.EntryId==i.EntryId).first()
                                check2=session.query(DayLog).filter(DayLog.EntryId==i.EntryId).first()
                                if not check and not check2:
                                    session.delete(i)
                                if num % 100 == 0:
                                    session.commit()
                            session.commit()
                            session.flush()
                    except Exception as ee:
                        print(ee)
            except Exception as e:
                print(e)

    def edee(self):
        event_loop=asyncio.new_event_loop()
        event_loop.run_until_complete(ensure_extras_field_exists())

    def enable_all_nutritional_facts(self):
        with Session(ENGINE) as session:
            try:
                toolid=-1
                try:
                    nutritional_facts_placeholder=session.query(Entry).filter(Entry.EntryId==toolid).first()
                    if nutritional_facts_placeholder is None:
                        nutritional_facts_placeholder=Entry(Name="Nutritional_Facts_PlaceHolder",Barcode="Nutritional_Facts_PlaceHolder",Code="Nutritional_Facts_PlaceHolder",InList=False,EntryId=toolid)
                        session.add(nutritional_facts_placeholder)
                        session.commit()
                        session.flush()
                        session.refresh(nutritional_facts_placeholder)
                except Exception as ee:
                    print(ee)

                nutrients=self.nutrients
                ct=len(nutrients)
                for num,k in enumerate(nutrients):
                    check=session.query(EntryDataExtras).filter(and_(EntryDataExtras.field_name.icontains(k),EntryDataExtras.field_value.icontains(nutrients[k]))).first()
                    if check is not None:
                        print(f"Skipping Pre-Existing {k}!")
                        continue
                    extra=EntryDataExtras(field_name=k,field_type="str",field_value=str(nutrients[k]),EntryId=toolid)
                    session.add(extra)
                    session.commit()
                    session.flush() 
                    session.refresh(extra)
                    print(f"{Fore.cyan}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct} -> {Fore.orange_red_1}Adding -> {extra}!{Style.reset}")
                session.commit()
            except Exception as e:
                print(e)

    def enable_all_diabetic_facts(self):
        with Session(ENGINE) as session:
            try:
                toolid=-1
                try:
                    diabetic_facts_placeholder=session.query(Entry).filter(Entry.EntryId==toolid).first()
                    if diabetic_facts_placeholder is None:
                        diabetic_facts_placeholder=Entry(Name="Diabetic_Facts_PlaceHolder",Barcode="Diabetic_Facts_PlaceHolder",Code="Diabetic_Facts_PlaceHolder",InList=False,EntryId=toolid)
                        session.add(diabetic_facts_placeholder)
                        session.commit()
                        session.flush()
                        session.refresh(diabetic_facts_placeholder)
                except Exception as ee:
                    print(ee)

                diabetic_fields=self.diabetic_fields
                ct=len(diabetic_fields)
                for num,k in enumerate(diabetic_fields):
                    check=session.query(EntryDataExtras).filter(and_(EntryDataExtras.field_name.icontains(k),EntryDataExtras.field_value.icontains(diabetic_fields[k]))).first()
                    if check is not None:
                        print(f"Skipping Pre-Existing {k}!")
                        continue
                    extra=EntryDataExtras(field_name=k,field_type="str",field_value=str(diabetic_fields[k]),EntryId=toolid)
                    session.add(extra)
                    session.commit()
                    session.flush() 
                    session.refresh(extra)
                    print(f"{Fore.cyan}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct} -> {Fore.orange_red_1}Adding -> {extra}!{Style.reset}")
                session.commit()
            except Exception as e:
                print(e)


    def delete_all_diabetic_facts(self):
        code=''.join([str(random.randint(0,9)) for i in range(10)])
        verification_protection=detectGetOrSet("Protect diabetic Facts From Delete",code,setValue=False,literal=True)
        while True:
            try:
                really=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Do You really want to delete all diabetic facts fields?",helpText="yes or no boolean,default is NO",data="boolean")
                if really in [None,]:
                    return
                elif really in ['d',False]:
                    return
                else:
                    pass
                really=Prompt.__init2__(None,func=FormBuilderMkText,ptext=f"To {Fore.orange_red_1}Delete everything completely,{Fore.light_steel_blue} What is todays date?{Style.reset}",helpText="type y/yes for prompt or type as m.d.Y",data="datetime")
                if really in [None,'d']:
                    return
                today=datetime.today()
                if really.day == today.day and really.month == today.month and really.year == today.year:
                    really=Prompt.__init2__(None,func=FormBuilderMkText,ptext=f"Please type the verification code {Style.reset}'{DayLog.cfmt(None,verification_protection)}'?",helpText=f"type '{DayLog.cfmt(None,verification_protection)}' to finalize!",data="string")
                    if really in [None,]:
                        return
                    elif really in ['d',False]:
                        return
                    elif really == verification_protection:
                        break
                else:
                    pass
            except Exception as e:
                print(e)
        with Session(ENGINE) as session:
            try:
                toolid=-1
                diabetic_facts_placeholder=session.query(Entry).filter(Entry.EntryId==toolid).all()
                diabetic_facts_placeholder_extras=session.query(EntryDataExtras).filter(EntryDataExtras.EntryId==toolid).all()

                print(f"{Fore.light_yellow}Deleting Diabetic_Facts_PlaceHolder{Style.reset}")   
                for i in diabetic_facts_placeholder:
                    print(f"{Fore.light_red}Deleting {i.seeShort()}{Style.reset}")
                    session.delete(i)
                print(f"{Fore.light_yellow}Deleting Diabetic_Facts_PlaceHolder_Extras{Style.reset}") 
                for i in diabetic_facts_placeholder_extras:
                    print(f"{Fore.light_red}Deleting {i.field_name}{Style.reset}")
                    session.delete(i)
                session.commit()
                dependency=Prompt.__init2__(None,func=FormBuilderMkText,ptext="check to see if its not needed elsewhere and delete it if it is not needed[Y/n]",helpText="yes(default) or no",data="boolean")
                if dependency is None:
                    return
                elif dependency in [True,'d']:
                    results=session.query(EntryDataExtras).all()
                    ct=len(results)
                    for num,i in enumerate(results):
                        msg=f"{Fore.orange_red_1}DEPENDENCY CHECK{Fore.dark_goldenrod}-> {Fore.cyan}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct} -> {i}"
                        print(msg)
                        check=session.query(Entry).filter(Entry.EntryId==i.EntryId).first()
                        check2=session.query(DayLog).filter(DayLog.EntryId==i.EntryId).first()
                        if not check and not check2:
                            session.delete(i)
                        if num % 100 == 0:
                            session.commit()
                    session.commit()
                    session.flush()
                else:
                    print(f"{Fore.light_yellow}Deleting All nutrients facts entry data extras{Style.reset}")
                    for fieldname in self.diabetic_fields:
                        print(f"{Fore.light_red}Deleting{Fore.cyan} {fieldname}{Style.reset}")
                        allOthers=session.query(EntryDataExtras).filter(EntryDataExtras.field_name==fieldname).delete()
                        session.commit()
                    print(f"{Fore.light_red}Done!{Style.reset}")
            except Exception as e:
                print(e)

    def enable_all_extraPresets_facts(self):
        with Session(ENGINE) as session:
            try:
                toolid=-1
                try:
                    extraPresets_facts_placeholder=session.query(Entry).filter(Entry.EntryId==toolid).first()
                    if extraPresets_facts_placeholder is None:
                        extraPresets_facts_placeholder=Entry(Name="Diabetic_Facts_PlaceHolder",Barcode="Diabetic_Facts_PlaceHolder",Code="Diabetic_Facts_PlaceHolder",InList=False,EntryId=toolid)
                        session.add(extraPresets_facts_placeholder)
                        session.commit()
                        session.flush()
                        session.refresh(extraPresets_facts_placeholder)
                except Exception as ee:
                    print(ee)

                extraPresets_fields=self.extraPresets_fields
                ct=len(extraPresets_fields)
                for num,k in enumerate(extraPresets_fields):
                    check=session.query(EntryDataExtras).filter(and_(EntryDataExtras.field_name.icontains(k),EntryDataExtras.field_value.icontains(extraPresets_fields[k]))).first()
                    if check is not None:
                        print(f"Skipping Pre-Existing {k}!")
                        continue
                    extra=EntryDataExtras(field_name=k,field_type="str",field_value=str(extraPresets_fields[k]),EntryId=toolid)
                    session.add(extra)
                    session.commit()
                    session.flush() 
                    session.refresh(extra)
                    print(f"{Fore.cyan}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct} -> {Fore.orange_red_1}Adding -> {extra}!{Style.reset}")
                session.commit()
            except Exception as e:
                print(e)


    def delete_all_extraPresets_facts(self):
        code=''.join([str(random.randint(0,9)) for i in range(10)])
        verification_protection=detectGetOrSet("Protect extraPresets Facts From Delete",code,setValue=False,literal=True)
        while True:
            try:
                really=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Do You really want to delete all extraPresets facts fields?",helpText="yes or no boolean,default is NO",data="boolean")
                if really in [None,]:
                    return
                elif really in ['d',False]:
                    return
                else:
                    pass
                really=Prompt.__init2__(None,func=FormBuilderMkText,ptext=f"To {Fore.orange_red_1}Delete everything completely,{Fore.light_steel_blue} What is todays date?{Style.reset}",helpText="type y/yes for prompt or type as m.d.Y",data="datetime")
                if really in [None,'d']:
                    return
                today=datetime.today()
                if really.day == today.day and really.month == today.month and really.year == today.year:
                    really=Prompt.__init2__(None,func=FormBuilderMkText,ptext=f"Please type the verification code {Style.reset}'{DayLog.cfmt(None,verification_protection)}'?",helpText=f"type '{DayLog.cfmt(None,verification_protection)}' to finalize!",data="string")
                    if really in [None,]:
                        return
                    elif really in ['d',False]:
                        return
                    elif really == verification_protection:
                        break
                else:
                    pass
            except Exception as e:
                print(e)
        with Session(ENGINE) as session:
            try:
                toolid=-1
                extraPresets_facts_placeholder=session.query(Entry).filter(Entry.EntryId==toolid).all()
                extraPresets_facts_placeholder_extras=session.query(EntryDataExtras).filter(EntryDataExtras.EntryId==toolid).all()

                print(f"{Fore.light_yellow}Deleting Diabetic_Facts_PlaceHolder{Style.reset}")   
                for i in extraPresets_facts_placeholder:
                    print(f"{Fore.light_red}Deleting {i.seeShort()}{Style.reset}")
                    session.delete(i)
                print(f"{Fore.light_yellow}Deleting Diabetic_Facts_PlaceHolder_Extras{Style.reset}") 
                for i in extraPresets_facts_placeholder_extras:
                    print(f"{Fore.light_red}Deleting {i.field_name}{Style.reset}")
                    session.delete(i)
                session.commit()
                dependency=Prompt.__init2__(None,func=FormBuilderMkText,ptext="check to see if its not needed elsewhere and delete it if it is not needed[Y/n]",helpText="yes(default) or no",data="boolean")
                if dependency is None:
                    return
                elif dependency in [True,'d']:
                    results=session.query(EntryDataExtras).all()
                    ct=len(results)
                    for num,i in enumerate(results):
                        msg=f"{Fore.orange_red_1}DEPENDENCY CHECK{Fore.dark_goldenrod}-> {Fore.cyan}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct} -> {i}"
                        print(msg)
                        check=session.query(Entry).filter(Entry.EntryId==i.EntryId).first()
                        check2=session.query(DayLog).filter(DayLog.EntryId==i.EntryId).first()
                        if not check and not check2:
                            session.delete(i)
                        if num % 100 == 0:
                            session.commit()
                    session.commit()
                    session.flush()
                else:
                    print(f"{Fore.light_yellow}Deleting All nutrients facts entry data extras{Style.reset}")
                    for fieldname in self.extraPresets_fields:
                        print(f"{Fore.light_red}Deleting{Fore.cyan} {fieldname}{Style.reset}")
                        allOthers=session.query(EntryDataExtras).filter(EntryDataExtras.field_name==fieldname).delete()
                        session.commit()
                    print(f"{Fore.light_red}Done!{Style.reset}")
            except Exception as e:
                print(e)

    extraPresets_fields=OrderedDict({
    'Radio-active':'Yes',
    'Carcinogen?':'Yes',
    'Toxic?':'Yes',
    'Poisonous?':'Yes',
    'Venomous?':'Yes',
    'Sharp Objects?':'Yes',
    'Bio-Hazard?':'Yes',
    'Pathogen Warning.':'N/A',
    'Caustic/Corrosive?':'Yes',

    'Hearing Protection Required?':'Yes',
    'Eye Protection Required?':'Yes',
    'PPE Required?':'Yes',
    'PPE Required Type?':'N/A',
    'PPE Required Name?':'N/A',

    'Explosive Under Pressure?':'Yes',
    'Hazmat Required??':'Yes',
    'Cut Level A1?':'Yes',
    'Cut Level A2?':'Yes',
    'Cut Level A3?':'Yes',

    'Contact Type Phone address/number/identifier':'N/A',
    'Contact Type Mobile/Cellular address/number/identifier':'N/A',
    'Contact Type Text Message address/number/identifier':'N/A',
    'Contact Type Email address/number/identifier':'N/A',
    'Contact Type Postal Mail address/number/identifier':'N/A',
    'Contact Type Mail Pigeon address/number/identifier':'N/A',
    'Contact Type Social address/number/identifier':'N/A',

    "SURGEON GENERAL'S WARNING 1(Smoke Related Tobacco Products)":"Smoking Causes Lung Cancer, Heart Disease, Emphysema, and May Complicate Pregnancy.",
    "SURGEON GENERAL'S WARNING 2(Smoke Related Tobacco Products)":"Quitting Smoking Now Greatly Reduces Serious Risks to Your Health.",
    "SURGEON GENERAL'S WARNING 3(Smoke Related Tobacco Products)":"Smoking By Pregnant Women May Result in Fetal Injury, Premature Birth, and Low Birth Weight.",
    "SURGEON GENERAL'S WARNING 4(Smoke Related Tobacco Products)":" Cigarette Smoke Contains Carbon Monoxide.",
    "GOVERNMENT WARNING(Alcohol)":"(1) According to the Surgeon General, women should not drink alcoholic beverages during pregnancy because of the risk of birth defects. (2) Consumption of alcoholic beverages impairs your ability to drive a car or operate machinery, and may cause health problems.",
    "GOVERNMENT WARNING(Cannabis[CA PROP 64])":"THIS PACKAGE CONTAINS CANNABIS, A SCHEDULE I CONTROLLED SUBSTANCE. KEEP OUT OF REACH OF CHILDREN AND ANIMALS. CANNABIS MAY ONLY BE POSSESSED OR CONSUMED BY PERSONS 21 YEARS OF AGE OR OLDER UNLESS THE PERSON IS A QUALIFIED PATIENT. CANNABIS USE WHILE PREGNANT OR BREASTFEEDING MAY BE HARMFUL. CONSUMPTION OF CANNABIS IMPAIRS YOUR ABILITY TO DRIVE AND OPERATE MACHINERY. PLEASE USE EXTREME CAUTION.",

    'Recycle Warning - Steel Can':'Steel Can; Please Recycle',
    'Recycle Warning - Plastic Bottle':'Plastic Bottle; Please Recycle',
    
    'Perishable Warning - Frozen':'Perishable; Keep Frozen',
    'Perishable Warning - Refrigerated':'Perishable; Keep Refrigerated',

    'Sharp Edge Warning':'Edges are Sharp when opened',
    'Suffocation Warning - Plastic Bag':'May Cause Suffocation if plastic bag clings to mouth and nose.',

    'Electrical Warning HV':'High Voltage',
    'Electrical Warning HA':'High Current',
    'Electrical Warning HAV':'High Current and Voltage',

    'Keep Out of Reach of Children under the age of':'6 years',

    'Alcohol! Age Restricted':'Yes',
    'Alcohol! Age Restriction':'18years',
    'Cannabis! Age Restricted':'Yes',
    'Cannabis! Age Restriction':'21y',

    'Controlled Substance':'Yes',
    'Smart Label':'',
    'URL':'https://www.google.com/',
    'Distributed By':'N/A',
    'Country Of Origin':'N/A/China/USA/etc',
    'CasePack/MasterPack Barcode':'N/A',

    'Total Cannabinoids %':'0%',
    'Total Cannabinoids mg':'0mg',
    'Total Cannabinoids %(mg)':'0%(0mg)',

    'THC Cannabinoids %':'0%',
    'THC Cannabinoids mg':'0mg',
    'THC Cannabinoids %(mg)':'0%(0mg)',

    'CBD Cannabinoids %':'0%',
    'CBD Cannabinoids mg':'0mg',
    'CBD Cannabinoids %(mg)':'0%(0mg)',
    'GOVERNMENT WARNING | CANNABIS':'GOVERNMENT WARNING: THIS PACKAGE CONTAINS CANNABIS, A SCHEDULE I CONTROLLED SUBSTANCE. KEEP OUT OF REACH OF CHILDREN AND ANIMALS. CANNABIS MAY ONLY BE POSSESSED OR CONSUMED BY PERSONS 21 YEARS OF AGE OR OLDER UNLESS THE PERSON IS A QUALIFIED PATIENT. CANNABIS USE WHILE PREGNANT OR BREASTFEEDING MAY BE HARMFUL. CONSUMPTION OF CANNABIS IMPAIRS YOUR ABILITY TO DRIVE AND OPERATE MACHINERY. PLEASE USE EXTREME CAUTION.',
    'P65 Warning':'Cancer and Reproductive Harm. See www.p65warnings.ca.gov',
    'Use Disclaimer':'This product is meant to be vaped.',
    'Battery/Power Source Disclaimer':'Battery sold separately.',
    'Manufactured By/Distributed By/Company':'SomeCorp inc., Mineapolis, MN 55440 USA',
    'Retailer':'',
    'Vendor':'',
    'Religious':'',
    'Genre':'',
    'Rating':'',

    'DDeC:000':'Generalities, Computer Science, Information & General Works',
    'DDeC:100':'Philosophy & Psychology.',
    'DDeC:200':'Religion',
    'DDeC:300':'Social Sciences',
    'DDeC:400':'Language',
    'DDeC:500':'Natural Sciences & Mathematics',
    'DDeC:600':'Technology (Applied Sciences)',
    'DDeC:700':'The Arts',
    'DDeC:800':'Literature & Rhetoric',
    'DDeC:900':'Geography & History',
    'DUI Decimal Number':'000.000',
    '*DDeC:NUM':'DUI DEC:Number of Category',
    'Location':'from Google Maps or From other Coordinate providing app',
    'Related Search Terms For External Source':'',
    'External Search Source':'www.google.com',
    'Related Search Terms For Local Search':'',

    'BatchId':'D.PR42B.BLD.A06.A08',
    'UID':generate_24_char_uuid(),
    'Manufacture Date':'N/A',
    'Expiration Date(Not Associated with the Expiry System) Period(From Date of Manufacture to Date of Expiration)':'N/A',
    'Expiration Date(Not Associated with the Expiry System)':'N/A',

    'Serial #':'N/A',
    'Serial No.':'N/A',
    'Serial Number':'N/A',

    'MAC Address':'FF:FF:FF:FF:FF:FF',
    'IMEID':'N/A',
    'ICCID':'N/A',
    'IMSI':'N/A',
    'IMEI':'N/A',
    'Carrier Name':'N/A',
    'Carrier Type':'N/A',
    'Service Type':'N/A',
    'Service Name':'N/A',

    'Taxable @ Locale':'Yes @/At Seaside(93955)',
    'Tax Type @ Locale for Tax Rate %':'Sales Tax at Seaside(93955) for 0.0925',
    'Locale Where Taxed @/At Tax Rate %':'Seaside(93955) for 0.0925',
    'Locale Tax Rate % @ Locale':'0.0925 at/@ seaside(93955)',

    'Prescription Rx?':'Yes',
    'Prescription Text':'N/A',
    'Prescription Name':'N/A',
    'Prescription ID':'N/A',
    'Homeopathic?':'Yes',
    'Herbal?':'Yes',

    'Intended Use?':'What is it used for?',
    'Initial Quality':quality_scale,
    'Used Quality':quality_scale,
    'General Quality':quality_scale,
    'Refurbished Quality':quality_scale,
    'Responsiveness [Quality]':quality_scale,

    'Speed [Quality]':quality_scale,
    'Scale [Quality]':quality_scale,
    'Torque [Quality]':quality_scale,
    'RPM [Quality]':quality_scale,
    'Taste [Quality]':quality_scale,
    'Texture [Quality]':quality_scale,
    'Flow [Quality]':quality_scale,
    'Density [Quality]':quality_scale,

    "Functionality":"Does the product perform as advertised and meet expectations?",
    "Durability":"How well does the product hold up over time and with regular use?",
    "Materials and Craftsmanship":"Describe the quality of the materials used and the overall build quality.",
    "Setup and Learning Curve":"How easy was it to set up and start using the product?",
    "Intuitive Design?":"Is the product's design easy to understand and navigate? No",
    "Ease of Maintenance":"For relevant products, mention how easy it is to clean and maintain.",
    "Quality Relative to Cost":"How does the product's price compare to similar products in the same category?",
    "Price Comparison":"Is the product's quality proportional to its price?",
    "Long-term Value":"Consider the long-term benefits and durability when assessing value. ",
    "Communication":"How responsive and helpful was the seller in addressing questions or concerns?",
    "Shipping and Delivery":"Was the product shipped on time and in good condition?",
    "Returns and Refunds":"How easy was the process if a return or refund was needed?",
    "Packaging":"Was the product well-packaged and protected during shipping?",
    "Accuracy of Description":"Does the product match the description provided on the listing?",
    "Visual Documentation":"Include photos or videos demonstrating the product's quality, features, and usability.",
    "Star Rating(x.z/total)":"0/10",
    "Compare To Product(UPC/Barcode/Name/Code/EAN)":"N/A",

    'Density':'N/A',
    'Mass':'N/A',

    'Date of Manufacture':'N/A',
    'Speed':'0mph/0kph',
    'Scale':'1:1',
    'Torque':'0 ft. lbs.',
    'RPM':'0rpm',

    'Single-Use':'Yes',
    'Refurbishable?':'N/A',
    'Repairable?':'No',
    'Consumable?':'Yes',
    'Refurbished?':'No',
    'Refurbished By?':'N/A',
    'User Rating @ Source:':'5 star @ amazon.com',
    'Target Audience':'N/A',



    })

    diabetic_fields=OrderedDict({
    'Unit':'U',
    'Carbohydrate':'0g',
    'Hypoglycemia Response(How to Treat)':'Treat with 15 Grams of Carbs.; Chew three(3) -/to four(4) glucose tablets; Consume 1 Tbsp of Honey; Drink 1/2 cup of Juice or regular soda.',
    
    'Sweets?':'No',
    'Dairy(Milk & Yogurt)?':'No',
    'Fruit?':'No',
    'Starch Vegatable?':'No',
    'Protien?':'No',
    'High in Omega-3 Fat?':'No',
    'Non-Starchy Vegatable?':'No',
    
    'Suggested Fruit Consumption':'1 small apple',
    'Suggested Dairy Consumption':'1 cup milk',
    'Suggested Grains Consumption':'1/3 Cup Quinoa or/|| 1/4 Bagel',
    'Suggested Starch Vegatables Consumption':'1 Cup Beets or/|| 1/2 Cup Corn',
    'Suggested Combo Foods Consumption':'1/2 Slice Pizza or/|| 1/2 Cup Ice Cream',

    '1 Serving':'15g',
    '2 Serving':'30g',
    '3 Serving':'45g',
    'Meals':'30g-60g(2 servings - 4 servings)',
    'Snacks':'>=(less than, or equal to)15 grams(>=[less than, or equal to]1 Serving)',

    'Insulin Type: Rapid Acting?':'No',
    'Insulin Type: Short Acting?':"No",
    'Insulin Type: Intermediate?':"No",
    'Insulin Type: Combination Intermediate/Rapid Acting?':"No",
    'Insulin Type: Long Acting?':'No',
    'Insulin Type: Combination Long Acting/Rapid Acting?':'No',
    'Insulin Type: Regular U-500?':'No',
    })

    nutrients=OrderedDict({
        "Caffiene Content Per Fluid Qty (20mg/15floz)":"20mg/15floz",
        'Protien':'0g',
        "Added sugars":    "50g",
        "Biotin":  "30mcg",
        "Calcium": "1300mg",
        "Chloride":    "2300mg",
        "Choline": "550mg",
        "Cholesterol": "300mg",
        "Chromium":    "35mcg",
        "Copper":  "0.9mg",
        "Dietary Fiber":   "28g",
        "Fat": "78g",
        "Folate/Folic Acid":   "400mcg DFE",
        "Iodine":  "150mcg",
        "Iron":    "18mg",
        "Magnesium":   "420mg",
        "Manganese":   "2.3mg",
        "Molybdenum":  "45mcg",
        "Niacin":  "16mg NE",
        "Pantothenic Acid":    "5mg",
        "Phosphorus":  "1250mg",
        "Potassium ":  "4700mg",
        "Protein": "50g",
        "Riboflavin ": "1.3mg",
        "Saturated fat":   "20g",
        "Selenium":    "55mcg",
        "Sodium":  "2300mg",
        "Thiamin": "1.2mg",
        "Total carbohydrate":  "275g",
        "Vitamin A":   "900mcg RAE",
        "Vitamin B6":  "1.7mg",
        "Vitamin B12": "2.4mcg",
        "Vitamin C":   "90mg",
        "Vitamin D":   "20mcg",
        "Vitamin E":   "15mg alpha-tocopherol",
        "Vitamin K":   "120mcg",
        "Zinc":    "11mg",
        "Serving Size":"1 cup",  
        "Calories":    "280" ,
        "Total Fat":   "9g",
        "Saturated Fat":   "4.5g",
        "Trans Fat":   "0g",
        "Cholesterol": "35mg",
        "Sodium":  "850mg",
        "Total Carbohydrate":  "34g",
        "Dietary Fiber":   "4g",
        "Total Sugars":    "6g",
        "Added Sugars":    "0g",
        "Protein 15g":     "30g",  
        "Vitamin D":   "0mcg",
        "Calcium": "320mg",
        "Iron":    "1.6mg",
        "Potassium":   "510mg",
    })


    def colorize(self,msg,num,ct):
        return f"{Fore.light_green}{num}/{Fore.light_cyan}{num+1} {Fore.light_red}of {ct}{Fore.dark_goldenrod} -> {Fore.grey_70}{msg}{Style.reset}"

    def list_nutrient_presets(self):
        ct=len(self.nutrients)
        for num,f in enumerate(self.nutrients):
            print(self.colorize(f"{f} = {self.nutrients[f]}",num,ct))

    def list_diabetic_presets(self):
        ct=len(self.diabetic_fields)
        for num,f in enumerate(self.diabetic_fields):
            print(self.colorize(f"{f} = {self.diabetic_fields[f]}",num,ct))

    def list_extraPresets_presets(self):
        ct=len(self.extraPresets_fields)
        for num,f in enumerate(self.extraPresets_fields):
            print(self.colorize(f"{f} = {self.extraPresets_fields[f]}",num,ct))

    def delete_all_nutritional_facts(self):
        code=''.join([str(random.randint(0,9)) for i in range(10)])
        verification_protection=detectGetOrSet("Protect Nutritional Facts From Delete",code,setValue=False,literal=True)
        while True:
            try:
                really=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Do You really want to delete all nutritional facts fields?",helpText="yes or no boolean,default is NO",data="boolean")
                if really in [None,]:
                    return
                elif really in ['d',False]:
                    return
                else:
                    pass
                really=Prompt.__init2__(None,func=FormBuilderMkText,ptext=f"To {Fore.orange_red_1}Delete everything completely,{Fore.light_steel_blue} What is todays date?{Style.reset}",helpText="type y/yes for prompt or type as m.d.Y",data="datetime")
                if really in [None,'d']:
                    return
                today=datetime.today()
                if really.day == today.day and really.month == today.month and really.year == today.year:
                    really=Prompt.__init2__(None,func=FormBuilderMkText,ptext=f"Please type the verification code {Style.reset}'{DayLog.cfmt(None,verification_protection)}'?",helpText=f"type '{DayLog.cfmt(None,verification_protection)}' to finalize!",data="string")
                    if really in [None,]:
                        return
                    elif really in ['d',False]:
                        return
                    elif really == verification_protection:
                        break
                else:
                    pass
            except Exception as e:
                print(e)
        with Session(ENGINE) as session:
            try:
                toolid=-1
                nutritional_facts_placeholder=session.query(Entry).filter(Entry.EntryId==toolid).all()
                nutritional_facts_placeholder_extras=session.query(EntryDataExtras).filter(EntryDataExtras.EntryId==toolid).all()

                print(f"{Fore.light_yellow}Deleting Nutritional_Facts_PlaceHolder{Style.reset}")   
                for i in nutritional_facts_placeholder:
                    print(f"{Fore.light_red}Deleting {i.seeShort()}{Style.reset}")
                    session.delete(i)
                print(f"{Fore.light_yellow}Deleting Nutritional_Facts_PlaceHolder_Extras{Style.reset}") 
                for i in nutritional_facts_placeholder_extras:
                    print(f"{Fore.light_red}Deleting {i.field_name}{Style.reset}")
                    session.delete(i)
                session.commit()
                dependency=Prompt.__init2__(None,func=FormBuilderMkText,ptext="check to see if its not needed elsewhere and delete it if it is not needed[Y/n]",helpText="yes(default) or no",data="boolean")
                if dependency is None:
                    return
                elif dependency in [True,'d']:
                    results=session.query(EntryDataExtras).all()
                    ct=len(results)
                    for num,i in enumerate(results):
                        msg=f"{Fore.orange_red_1}DEPENDENCY CHECK{Fore.dark_goldenrod}-> {Fore.cyan}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct} -> {i}"
                        print(msg)
                        check=session.query(Entry).filter(Entry.EntryId==i.EntryId).first()
                        check2=session.query(DayLog).filter(DayLog.EntryId==i.EntryId).first()
                        if not check and not check2:
                            session.delete(i)
                        if num % 100 == 0:
                            session.commit()
                    session.commit()
                    session.flush()
                else:
                    print(f"{Fore.light_yellow}Deleting All nutrients facts entry data extras{Style.reset}")
                    for fieldname in self.nutrients:
                        print(f"{Fore.light_red}Deleting{Fore.cyan} {fieldname}{Style.reset}")
                        allOthers=session.query(EntryDataExtras).filter(EntryDataExtras.field_name==fieldname).delete()
                        session.commit()
                    print(f"{Fore.light_red}Done!{Style.reset}")
            except Exception as e:
                print(e)


    def af2e(self,barcode=None):
        with Session(ENGINE) as session:
            if self.code is None or not isinstance(self.code,str):
                if barcode != None:
                    search=barcode
                else:
                    search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                    if search in [None]:
                        return
            else:
                search=self.code
            results=session.query(Entry).filter(or_(Entry.Barcode==search,Entry.Code==search,Entry.Barcode.icontains(search),Entry.Code.icontains(search),Entry.Name.icontains(search))).all()
            ct=len(results)
            if ct == 0:
                print("No Results were Found!")
                return
            msg=[]
            for num,i in enumerate(results):
                msg.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {i.seeShort()}")
            msg='\n'.join(msg)
            product=None
            while True:
                print(msg)
                index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg,data="integer")
                if index in [None,]:
                    return
                try:
                    product=results[index]
                    break
                except Exception as e:
                    print(e)
            if product in [None,]:
                return
            print("af2e()")
            field_name=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Field Name",helpText="make a field name",data="string")
            if field_name in [None,]:
                return
            msg=[]
            ct=len(TYPES_FromText)
            '''make a list of field types to refer to by index instead of key.'''
            ftypes=[i for i in TYPES_FromText]
            for num,i in enumerate(TYPES_FromText):
                msg.append(f'{num}/{num+1} of {ct} -> {TYPES_FromText[i]["cmds"]} - {TYPES_FromText[i]["desc"]}')
            msg='\n'.join(msg)
            print(msg)
            field_type=None
            while True:
                field_type=Prompt.__init2__(self,func=FormBuilderMkText,ptext="please select a type by index.",helpText=msg,data="integer")
                if field_type in [None,]:
                    return
                try:
                    field_type=ftypes[field_type]
                    break
                except Exception as e:
                    print(e)
            field_value=Prompt.__init2__(self,func=FormBuilderMkText,ptext="What do you wish to store as the value?",helpText=field_type,data=field_type)
            if field_value in [None,]:
                return

            print(field_name,field_type,field_value)
            extra=EntryDataExtras(field_name=field_name,field_type=field_type,field_value=field_value,EntryId=product.EntryId)
            session.add(extra)
            session.commit()
            session.refresh(extra)
            print(extra)

    def edit_extra_field_from_entry(self,barcode=None):
        with Session(ENGINE) as session:
            if self.code is None or not isinstance(self.code,str):
                if barcode != None:
                    search=barcode
                else:
                    search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                    if search in [None]:
                        return
            else:
                search=self.code
            results=session.query(Entry).filter(or_(Entry.Barcode==search,Entry.Code==search,Entry.Barcode.icontains(search),Entry.Code.icontains(search),Entry.Name.icontains(search))).all()
            ct=len(results)
            if ct == 0:
                print("No Results were Found!")
                return
            msg=[]
            for num,i in enumerate(results):
                msg.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {i.seeShort()}")
            msg='\n'.join(msg)
            product=None
            while True:
                print(msg)
                index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg,data="integer")
                if index in [None,]:
                    return
                try:
                    product=results[index]
                    break
                except Exception as e:
                    print(e)
            if product in [None,]:
                return
            print(f"edit_extra_field_from_entry(barcode={barcode})")
            product_extras=session.query(EntryDataExtras).filter(EntryDataExtras.EntryId==product.EntryId)
            LookUpState=db.detectGetOrSet('list maker lookup order',False,setValue=False,literal=False)
            if not isinstance(LookUpState,bool):
                LookUpState=db.detectGetOrSet('list maker lookup order',False,setValue=True,literal=False)
            if LookUpState == True:
                product_extras=product_extras.order_by(EntryDataExtras.doe.asc())
            else:
                product_extras=product_extras.order_by(EntryDataExtras.doe.desc())
            extras=product_extras.all()
            while True:
                ct=len(extras)
                lines=[]
                for num,i in enumerate(extras):
                    lines.append(self.colorize(f"{i.field_name}[{i.field_type}] = {i.field_value} {Fore.grey_70}#created on {i.doe}",num,ct))
                helpText='\n'.join(lines)
                print(helpText)
                which=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Which index(es) do you wish to edit?",helpText=helpText,data="list")
                if which in [None,]:
                    return
                elif isinstance(which,list):
                    for i in which:
                        try:
                            index=int(i)
                            if index in [i for i in range(len(extras))]:
                                extra=extras[index]
                                excludes=["doe","EntryId","ede_id","field_name","field_type"]
                                pth=f"{Fore.light_yellow}Editing {Fore.light_red}{extra.field_name}[{Fore.light_steel_blue}{extra.field_type}{Fore.light_red}]{Style.reset}"
                                print(pth)
                                data={i.name:{"default":getattr(extra,i.name),"type":str(i.type).lower()} for i in extra.__table__.columns if i.name not in excludes}
                                fd=FormBuilder(data=data,passThruText=pth)
                                if fd is None:
                                    print("User Chose to completely cancel!")
                                    return
                                toUpd8=session.query(EntryDataExtras).filter(EntryDataExtras.ede_id==extra.ede_id).update(fd)
                                session.commit()
                                session.refresh(extra)
                                print(extra)
                            else:
                                print(f"Unknown Index('{index}')")
                        except Exception as e:
                            print(e)
                else:
                    continue
                break

    def sf2e(self,barcode=None):
        with Session(ENGINE) as session:
            if self.code is None or not isinstance(self.code,str):
                if barcode != None:
                    search=barcode
                else:
                    search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                    if search in [None]:
                        return
            else:
                search=self.code
            results=session.query(Entry).filter(or_(Entry.Barcode==search,Entry.Code==search,Entry.Barcode.icontains(search),Entry.Code.icontains(search),Entry.Name.icontains(search))).all()
            ct=len(results)
            if ct == 0:
                print("No Results were Found!")
                return
            msg=[]
            for num,i in enumerate(results):
                msg.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {i.seeShort()}")
            msg='\n'.join(msg)
            product=None
            while True:
                print(msg)
                index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg,data="integer")
                if index in [None,]:
                    return
                try:
                    product=results[index]
                    break
                except Exception as e:
                    print(e)
            if product in [None,]:
                return
            print("sf2e()")
            query=session.query(EntryDataExtras)
            results_ede=query.group_by(EntryDataExtras.field_name,EntryDataExtras.field_type).all()
            field=None
            msg_ede=[]
            for num,i in enumerate(results_ede):
                if num%2==0:
                    color=Fore.cyan
                elif num%3==0:
                    color=Fore.light_cyan
                elif num%4==0:
                    color=Fore.light_steel_blue
                elif num%5==0:
                    color=Fore.light_green
                elif num%6==0:
                    color=Fore.turquoise_4
                elif num%7==0:
                    color=Fore.deep_sky_blue_3a
                elif num%8==0:
                    color=Fore.spring_green_3a
                elif num%9==0:
                    color=Fore.dark_cyan
                else:
                    color=Fore.light_blue
                msg_ede.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {color}{i.field_name}{Style.reset}:{i.field_type} ede_id={i.ede_id} doe={i.doe}")
            msg_ede='\n'.join(msg_ede)
            while True:
                try:
                    print(msg_ede)
                    index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg_ede,data="integer")
                    if index in [None,]:
                        return
                    try:
                        print(index)
                        if index <= len(results_ede)-1:
                            field=results_ede[index]
                        else:
                            print(f"index is not within 0-{len(results_ede)-1}")
                            continue
                        break
                    except Exception as e:
                        print(e)
                        break
                except Exception as e:
                    print(e)
            if field == None:
                return
            field_name=field.field_name
            field_type=field.field_type
            field_value=Prompt.__init2__(self,func=FormBuilderMkText,ptext="What do you wish to store as the value?",helpText=field_type,data=field_type)
            if field_value in [None,]:
                return
            
            print(field_name,field_type,field_value)
            extra=EntryDataExtras(field_name=field_name,field_type=field_type,field_value=field_value,EntryId=product.EntryId)
            session.add(extra)
            session.commit()
            session.refresh(extra)
            print(extra)
    
    def sch_f2e(self,barcode=None):
        with Session(ENGINE) as session:
            while True:
                try:
                    if self.code is None or not isinstance(self.code,str):
                        if barcode != None:
                            search=barcode
                        else:
                            search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                            if search in [None]:
                                return
                    else:
                        search=self.code

                    results=session.query(Entry).filter(or_(Entry.Barcode==search,Entry.Code==search,Entry.Barcode.icontains(search),Entry.Code.icontains(search),Entry.Name.icontains(search))).all()
                    ct=len(results)
                    if ct == 0:
                        print("No Results were Found!")
                        return
                    msg=[]
                    for num,i in enumerate(results):
                        msg.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {i.seeShort()}")
                    msg='\n'.join(msg)
                    product=None
                    while True:
                        print(msg)
                        index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg,data="integer")
                        if index in [None,]:
                            return
                        try:
                            product=results[index]
                            break
                        except Exception as e:
                            print(e)
                    if product in [None,]:
                        return
                    print("sf2e()")
                    while True:
                        while True:
                            try:
                                fs=[]
                                fse=session.query(EntryDataExtras).group_by(EntryDataExtras.field_name,EntryDataExtras.field_type).all()
                                ct_fse=len(fse)
                                for nunm,i in enumerate(fse):
                                    fs.append(f"{Fore.light_yellow}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct_fse} -> {Fore.light_magenta}{i.field_name}{Style.reset}")
                                fs='\n'.join(fs)
                                field_search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search field?",helpText=f"searches EntryDataExtras field_names:\n{fs}",data="string")
                                if field_search in [None]:
                                    return
                                elif field_search in ['d',]:
                                    field_search=''

                                query=session.query(EntryDataExtras).filter(
                                    and_(
                                        not_(EntryDataExtras.field_name.icontains("[Updated on")),
                                        or_(
                                            EntryDataExtras.field_name.icontains(field_search),
                                            EntryDataExtras.field_value.icontains(field_search),
                                            )
                                        )
                                    )
                                results_ede=query.group_by(EntryDataExtras.field_name,EntryDataExtras.field_type).all()
                                if len(results_ede) < 1:
                                    continue
                                break
                            except Exception as e:
                                print(e)
                        field=None
                        msg_ede=[]
                        for num,i in enumerate(results_ede):
                            if num%2==0:
                                color=Fore.cyan
                            elif num%3==0:
                                color=Fore.light_cyan
                            elif num%4==0:
                                color=Fore.light_steel_blue
                            elif num%5==0:
                                color=Fore.light_green
                            elif num%6==0:
                                color=Fore.turquoise_4
                            elif num%7==0:
                                color=Fore.deep_sky_blue_3a
                            elif num%8==0:
                                color=Fore.spring_green_3a
                            elif num%9==0:
                                color=Fore.dark_cyan
                            else:
                                color=Fore.light_blue
                            msg_ede.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {color}{i.field_name}[{i.field_type}]={Fore.light_steel_blue}{i.field_value}{Style.reset}:{i.field_type} ede_id={i.ede_id} doe={i.doe}")
                        msg_ede='\n'.join(msg_ede)
                        while True:
                            try:
                                print(msg_ede)
                                index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg_ede,data="integer")
                                if index in [None,]:
                                    return
                                if not isinstance(index,int):
                                    print(f"{Fore.light_red}Index must be an {Fore.light_cyan}integer{Style.reset}")
                                    continue
                                try:
                                    print(index)
                                    if index <= len(results_ede)-1:
                                        field=results_ede[index]
                                    else:
                                        print(f"index is not within 0-{len(results_ede)-1}")
                                        continue
                                    break
                                except Exception as e:
                                    print(e)
                                    break
                            except Exception as e:
                                print(e)
                        if field == None:
                            return
                        field_name=field.field_name
                        field_type=field.field_type
                        field_value=Prompt.__init2__(self,func=FormBuilderMkText,ptext="What do you wish to store as the value?",helpText=field_type,data=field_type)
                        if field_value in [None,]:
                            return
                        
                        print(field_name,field_type,field_value)
                        extra=EntryDataExtras(field_name=field_name,field_type=field_type,field_value=field_value,EntryId=product.EntryId)
                        session.add(extra)
                        session.commit()
                        session.refresh(extra)
                        print(extra)
                        anotherField=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Add another field to this product[y/n]?",helpText="yes/no/boolean",data="boolean")
                        if anotherField in [None,]:
                            return
                        elif anotherField in ['d',True]:
                            continue
                        else:
                            break
                    if barcode != None:
                        break
                except Exception as e:
                    print(e)
                    

    def sch_c2e(self,barcode=None):
        with Session(ENGINE) as session:
            if self.code is None or not isinstance(self.code,str):
                if barcode != None:
                    search=barcode
                else:
                    search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                    if search in [None]:
                        return
            else:
                search=self.code

            results=session.query(Entry).filter(or_(Entry.Barcode==search,Entry.Code==search,Entry.Barcode.icontains(search),Entry.Code.icontains(search),Entry.Name.icontains(search))).all()
            ct=len(results)
            if ct == 0:
                print("No Results were Found!")
                return
            msg=[]
            for num,i in enumerate(results):
                msg.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {i.seeShort()}")
            msg='\n'.join(msg)
            product=None
            while True:
                print(msg)
                index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg,data="integer")
                if index in [None,]:
                    return
                try:
                    product=results[index]
                    break
                except Exception as e:
                    print(e)
            if product in [None,]:
                return
            print("sch_c2e()")
            while True:
                try:
                    fs=[]
                    fse=session.query(EntryDataExtras).group_by(EntryDataExtras.field_name,EntryDataExtras.field_type).all()
                    ct_fse=len(fse)
                    for nunm,i in enumerate(fse):
                        fs.append(f"{Fore.light_yellow}{num}/{Fore.light_cyan}{num+1} of {Fore.light_red}{ct_fse} -> {Fore.light_magenta}{i.field_name}{Style.reset}")
                    fs='\n'.join(fs)
                    field_search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search field?",helpText=f"searches EntryDataExtras field_names:\n{fs}",data="string")
                    if field_search in [None]:
                        return
                    elif field_search in ['d',]:
                        field_search=''
                    query=session.query(EntryDataExtras).filter(
                        or_(
                            EntryDataExtras.field_name.icontains(field_search),
                            EntryDataExtras.field_value.icontains(field_search)
                            )
                        )
                    results_ede=query.group_by(EntryDataExtras.field_name,EntryDataExtras.field_type,EntryDataExtras.field_value).all()
                    if len(results_ede) < 1:
                        continue
                    break
                except Exception as e:
                    print(e)
            field=None
            msg_ede=[]
            for num,i in enumerate(results_ede):
                if num%2==0:
                    color=Fore.cyan
                elif num%3==0:
                    color=Fore.light_cyan
                elif num%4==0:
                    color=Fore.light_steel_blue
                elif num%5==0:
                    color=Fore.light_green
                elif num%6==0:
                    color=Fore.turquoise_4
                elif num%7==0:
                    color=Fore.deep_sky_blue_3a
                elif num%8==0:
                    color=Fore.spring_green_3a
                elif num%9==0:
                    color=Fore.dark_cyan
                else:
                    color=Fore.light_blue
                msg_ede.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {color}{i.field_name}[{i.field_type}]={Fore.light_steel_blue}{i.field_value}{Style.reset}:{i.field_type}={Fore.light_yellow}{i.field_value}{Style.reset} ede_id={i.ede_id} doe={i.doe}")
            msg_ede='\n'.join(msg_ede)
            while True:
                try:
                    print(msg_ede)
                    index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg_ede,data="integer")
                    if index in [None,]:
                        return
                    try:
                        print(index)
                        if index <= len(results_ede)-1:
                            field=results_ede[index]
                        else:
                            print(f"index is not within 0-{len(results_ede)-1}")
                            continue
                        break
                    except Exception as e:
                        print(e)
                        break
                except Exception as e:
                    print(e)
            if field == None:
                return
            field_name=field.field_name
            field_type=field.field_type
            field_value=field.field_value
            
            print(field_name,field_type,field_value)
            extra=EntryDataExtras(field_name=field_name,field_type=field_type,field_value=field_value,EntryId=product.EntryId)
            session.add(extra)
            session.commit()
            session.refresh(extra)
            print(extra)


    def massEntry(self):
        while True:
            cmds=[
            'n,nf - New Field',
            's,sf - Select Field',
            '1s,bsf - 1 Barcode Select Fields Loop',
            '1n,bnf - 1 Barcode New Fields Loop',
            'sch f2e,ssf2e - search select field',
            '1sch f2e,1ssf2e - search select field loop',
            "'cf2e','copy searched field to entry' - search select copy field to entry",
            ]
            cmds='\n'.join(cmds)
            print(cmds)
            doWhat=Prompt.__init2__(None,func=FormBuilderMkText,ptext="ExtrasMenu:MassEntry[n=New Field,s=Select Field]",helpText=cmds,data="string")
            if doWhat in [None,'d']:
                return
            elif doWhat.lower() in "sch f2e,ssf2e".split(","):
                self.sch_f2e()
            elif doWhat.lower() in "1sch f2e,1ssf2e".split(","):
                barcode=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                if barcode in [None]:
                    return
                while True:
                    self.sch_f2e(barcode)
                    another=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Another?[Y/n]",helpText="boolean value for yes and no, default is yes",data="boolean")
                    if another in [None,]:
                        return
                    elif another in ['d',True]:
                        continue
                    else:
                        break
            elif doWhat.lower() in ['cf2e','copy searched field to entry']:
                self.sch_c2e()
            elif doWhat.lower() in ['n','nf','New Field'.lower()]:
                self.af2e()
            elif doWhat.lower() in ['s','sf','Select Field'.lower()]:
                self.sf2e()
            elif doWhat.lower() in ['1s','bsf','Barcode Select Fields Loop'.lower()]:
                barcode=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                if barcode in [None]:
                    return
                while True:
                    self.sf2e(barcode)
                    another=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Another?[Y/n]",helpText="boolean value for yes and no, default is yes",data="boolean")
                    if another in [None,]:
                        return
                    elif another in ['d',True]:
                        continue
                    else:
                        break
            elif doWhat.lower() in ['1n','bnf','Barcode New Fields Loop'.lower()]:
                barcode=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                if barcode in [None]:
                    return
                while True:
                    self.af2e(barcode)
                    another=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Another?[Y/n]",helpText="boolean value for yes and no, default is yes",data="boolean")
                    if another in [None,]:
                        return
                    elif another in ['d',True]:
                        continue
                    else:
                        break

    def lookup(self):
        with Session(ENGINE) as session:
            if self.code is None or not isinstance(self.code,str):
                search=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                if search in [None]:
                    return
            else:
                search=self.code
            results=session.query(Entry).filter(or_(Entry.Barcode==search,Entry.Code==search,Entry.Barcode.icontains(search),Entry.Code.icontains(search),Entry.Name.icontains(search))).all()
            ct=len(results)
            if ct == 0:
                print("No Results were Found!")
                return
            msg=[]
            for num,i in enumerate(results):
                msg.append(f"{Fore.cyan}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct}{Fore.grey_50} -> {i.seeShort()}")
            msg='\n'.join(msg)
            product=None
            while True:
                print(msg)
                index=Prompt.__init2__(None,func=FormBuilderMkText,ptext="which index do you wish to use?",helpText=msg,data="integer")
                if index in [None,]:
                    return
                try:
                    product=results[index]
                    break
                except Exception as e:
                    print(e)
            if product in [None,]:
                return
            extras=session.query(EntryDataExtras).filter(EntryDataExtras.EntryId==product.EntryId).all()
            extras_ct=len(extras)
            if extras_ct == 0:
                print("No Extras Found For that Item")
                return
            mtext=[]
            for n,e in enumerate(extras):
                mtext.append(f"\t- {Fore.orange_red_1}{e.field_name}:{Fore.light_steel_blue}{e.field_type}={Fore.light_yellow}{e.field_value} {Fore.cyan}ede_id={e.ede_id} {Fore.light_magenta}doe={e.doe}{Style.reset}")
            mtext='\n'.join(mtext)
            print(product.seeShort())
            print(mtext)

    def list_all_fields_generator(self):
        print("laaf()")
        with Session(ENGINE) as session:
            fields=session.query(EntryDataExtras).group_by(EntryDataExtras.field_name,EntryDataExtras.field_type).order_by(EntryDataExtras.doe).all()
            ct=len(fields)
            for num,field in enumerate(fields):
                msg=f"""{Fore.light_green}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct} -> {Fore.orange_red_1}EntryDataExtra{Fore.light_cyan}(
ede_id={Fore.light_steel_blue}{field.ede_id}{Fore.light_cyan},
doe={Fore.light_steel_blue}{field.doe}{Fore.light_cyan},
field_name={Fore.light_steel_blue}{field.field_name}{Fore.light_cyan},
field_value={Fore.light_steel_blue}{field.field_value}{Fore.light_cyan},
){Style.reset}"""
                yield num,ct,field,msg

    def list_all_fields(self):
        with Session(ENGINE) as session:
            fields=session.query(EntryDataExtras).group_by(EntryDataExtras.field_name,EntryDataExtras.field_type).order_by(EntryDataExtras.doe).all()
            ct=len(fields)
            for num,field in enumerate(fields):
                msg=f"""{Fore.light_green}{num}/{Fore.light_yellow}{num+1} of {Fore.light_red}{ct} -> {Fore.orange_red_1}EntryDataExtra{Fore.light_cyan}(
ede_id={Fore.light_steel_blue}{field.ede_id}{Fore.light_cyan},
doe={Fore.light_steel_blue}{field.doe}{Fore.light_cyan},
field_name={Fore.light_steel_blue}{field.field_name}{Fore.light_cyan},
field_value={Fore.light_steel_blue}{field.field_value}{Fore.light_cyan},
){Style.reset}"""
                
                print(msg)

    def __init__(self,code=None):
        self.code=code
        cmds=OrderedDict({
            'list all extraPresets presets':{
            'cmds':['la-xp','laxp','la xp','ls xtr prst','list extra preset'],
            'exec':self.list_extraPresets_presets,
            'desc':"list extra preset[These are hardcoded]."
            },
            'list all diabetic presets':{
            'cmds':['la-dp','ladp','la dp','ls dbtc prst','list diabetic presets'],
            'exec':self.list_diabetic_presets,
            'desc':"list diabetic presets[These are hardcoded]."
            },
            'list all nutrients presets':{
            'cmds':['la-np','lanp','la np','ls ntrnt prst','list nutrients presets'],
            'exec':self.list_nutrient_presets,
            'desc':"list nutrients presets[These are hardcoded]."
            },
            'list all available fields':{
            'cmds':['la-af','laaf','la af','ls al avlbl flds','ls * flds','ls*flds','lsalflds'],
            'exec':self.list_all_fields,
            'desc':"list all available fields."
            },
            'enable all nutritional facts':{
            'cmds':['eanf','enable all nutrional facts'],
            'exec':self.enable_all_nutritional_facts,
            'desc':"add an Entry placeholder for nutritional facts and add all nutritional facts fields."
            },
            'delete and disable all nutritional facts':{
            'cmds':['dadanf','delete and disable all nutritional facts'],
            'exec':self.delete_all_nutritional_facts,
            'desc':"Delete Entry placeholder for nutritional facts and all of its EntryDataExtras, and all other nutritional facts fields. There is a triple prompt before proceeding!!!"
            },
            'enable all diabetic facts':{
            'cmds':['eadf','enable all diabetic facts','enable diabetes'],
            'exec':self.enable_all_diabetic_facts,
            'desc':"add an Entry placeholder for diabetic facts and add all diabetic facts fields."
            },
            'delete and disable all diabetic facts':{
            'cmds':['dadadf','delete and disable all diabetic facts','disable diabetes'],
            'exec':self.delete_all_diabetic_facts,
            'desc':"Delete Entry placeholder for diabetic facts and all of its EntryDataExtras, and all other diabetic facts fields. There is a triple prompt before proceeding!!!"
            },
            'enable all extraPresets facts':{
            'cmds':['eaxpf','enable all extrapresets facts','enable extrapresets'],
            'exec':self.enable_all_extraPresets_facts,
            'desc':"add an Entry placeholder for extraPresets facts and add all extraPresets facts fields."
            },
            'delete and disable all extraPresets facts':{
            'cmds':['dadaxpf','delete and disable all extrapresets facts','disable extrapresets'],
            'exec':self.delete_all_extraPresets_facts,
            'desc':"Delete Entry placeholder for extraPresets facts and all of its EntryDataExtras, and all other extraPresets facts fields. There is a triple prompt before proceeding!!!"
            },
            'af2e':{
            'cmds':['af2e','add field to entry','add field 2 entry'],
            'exec':self.af2e,
            'desc':"add field to Entry"
            },
            'sf2e':{
            'cmds':['sf2e','select field to entry','select field 2 entry'],
            'exec':self.sf2e,
            'desc':"select a stored field and add field to Entry"
            },
            'rm':{
            'cmds':['rm','delete','del','remove'],
            'exec':self.rm_ede_id,
            'desc':"delete an EntryDataExtras item"
            },
            'lookup':{
            'cmds':['s','search','lu','lookup'],
            'exec':self.lookup,
            'desc':"lookup an EntryDataExtras from Entry Data"
            },
            'massEntry':{
            'cmds':['m','massEntry','me',],
            'exec':self.massEntry,
            'desc':"Add Multiple Extras Menu"
            },
            'search select':{
                'cmds':"sch f2e,ssf2e".split(","),
                'exec':self.sch_f2e,
                'desc':'search for field, select field, set value'
            },
            'search select copy':{
                'cmds':"sch c2e,cf2e,sscf2e".split(","),
                'exec':self.sch_c2e,
                'desc':'search for field, select field, copy to entry'
            },
            'ensure_extras_field_exists':{
            'cmds':['edee','ensure_extras_field_exists'],
            'exec':self.edee,
            'desc':'ensures last used field is applied to all Entry\'s [SLOW!!!]',
            },
            'edit selected extra':{
                'cmds':"edit selected extra from entry,esxfe".split(","),
                'exec':self.edit_extra_field_from_entry,
                'desc':'edit a selected EntryDataExtra from Entry Selection'
            },
        })
        '''
elif doWhat.lower() in "sch f2e,ssf2e".split(","):
                self.sch_f2e()
            elif doWhat.lower() in "1sch f2e,1ssf2e".split(","):
                barcode=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Search? [Barcode,Code,Name]",helpText="searches Barcode,Code,Name",data="string")
                if barcode in [None]:
                    return
                while True:
                    self.sch_f2e(barcode)
                    another=Prompt.__init2__(None,func=FormBuilderMkText,ptext="Another?[Y/n]",helpText="boolean value for yes and no, default is yes",data="boolean")
                    if another in [None,]:
                        return
                    elif another in ['d',True]:
                        continue
                    else:
                        break
        '''
        helpText=[]
        ct=len(cmds)
        for num,m in enumerate(cmds):
            helpText.append(self.colorize(f"{Fore.light_steel_blue}{cmds[m]['cmds']}{Fore.grey_70} - {Fore.light_steel_blue}{cmds[m]['desc']}{Style.reset}",num,ct))
        helpText='\n'.join(helpText)
        while True:
            doWhat=Prompt.__init2__(None,func=FormBuilderMkText,ptext=f"EntryDataExtras@{Fore.light_green}Menu{Fore.light_yellow}",helpText=helpText,data="string")
            if doWhat in [None,]:
                return
            elif doWhat in ['d',]:
                print(helpText)
                continue
            for cmd in cmds:
                check=[i.lower() for i in cmds[cmd]['cmds']]
                if doWhat.lower() in check:
                    try:
                        cmds[cmd]['exec']()
                        break
                    except Exception as e:
                        print(e)