"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .searchstrategy import SearchStrategy
from langcache.types import BaseModel
import pydantic
from typing import Dict, List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SearchRequestTypedDict(TypedDict):
    prompt: str
    r"""The prompt to search for in the cache."""
    similarity_threshold: NotRequired[float]
    r"""The minimum similarity threshold for the cache entry (normalized cosine similarity)."""
    search_strategies: NotRequired[List[SearchStrategy]]
    r"""The search strategies to use for the search, ordered by priority."""
    attributes: NotRequired[Dict[str, str]]


class SearchRequest(BaseModel):
    prompt: str
    r"""The prompt to search for in the cache."""

    similarity_threshold: Annotated[
        Optional[float], pydantic.Field(alias="similarityThreshold")
    ] = None
    r"""The minimum similarity threshold for the cache entry (normalized cosine similarity)."""

    search_strategies: Annotated[
        Optional[List[SearchStrategy]], pydantic.Field(alias="searchStrategies")
    ] = None
    r"""The search strategies to use for the search, ordered by priority."""

    attributes: Optional[Dict[str, str]] = None
