"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from .httpclient import AsyncHttpClient, ClientOwner, HttpClient, close_clients
from .sdkconfiguration import SDKConfiguration
from .utils.logger import Logger, get_default_logger
from .utils.retries import RetryConfig
import httpx
from langcache import errors, models, utils
from langcache._hooks import HookContext, SDKHooks
from langcache.models import internal
from langcache.types import BaseModel, OptionalNullable, UNSET
from langcache.utils import get_security_from_env
from langcache.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Callable, Dict, List, Mapping, Optional, Union, cast
import weakref


class LangCache(BaseSDK):
    r"""LangCache: API for managing a [Redis LangCache](https://redis.io/docs/latest/develop/ai/langcache/) service."""

    def __init__(
        self,
        server_url: str,
        api_key: Optional[Union[Optional[str], Callable[[], Optional[str]]]] = None,
        cache_id: Optional[str] = None,
        client: Optional[HttpClient] = None,
        async_client: Optional[AsyncHttpClient] = None,
        retry_config: OptionalNullable[RetryConfig] = UNSET,
        timeout_ms: Optional[int] = None,
        debug_logger: Optional[Logger] = None,
    ) -> None:
        r"""Instantiates the SDK configuring it with the provided parameters.

        :param api_key: The api_key required for authentication
        :param cache_id: Configures the cache_id parameter for all supported operations
        :param server_idx: The index of the server to use for all methods
        :param server_url: The server URL to use for all methods
        :param url_params: Parameters to optionally template the server URL with
        :param client: The HTTP client to use for all synchronous methods
        :param async_client: The Async HTTP client to use for all asynchronous methods
        :param retry_config: The retry configuration to use for all supported methods
        :param timeout_ms: Optional request timeout applied to each operation in milliseconds
        """
        client_supplied = True
        if client is None:
            client = httpx.Client(follow_redirects=True)
            client_supplied = False

        assert issubclass(
            type(client), HttpClient
        ), "The provided client must implement the HttpClient protocol."

        async_client_supplied = True
        if async_client is None:
            async_client = httpx.AsyncClient(follow_redirects=True)
            async_client_supplied = False

        if debug_logger is None:
            debug_logger = get_default_logger()

        assert issubclass(
            type(async_client), AsyncHttpClient
        ), "The provided async_client must implement the AsyncHttpClient protocol."

        security: Any = None
        if callable(api_key):
            # pylint: disable=unnecessary-lambda-assignment
            security = lambda: models.Security(api_key=api_key())
        else:
            security = models.Security(api_key=api_key)

        _globals = internal.Globals(
            cache_id=utils.get_global_from_env(cache_id, "LANGCACHE_CACHE_ID", str),
        )

        BaseSDK.__init__(
            self,
            SDKConfiguration(
                client=client,
                client_supplied=client_supplied,
                async_client=async_client,
                async_client_supplied=async_client_supplied,
                globals=_globals,
                security=security,
                server_url=server_url,
                retry_config=retry_config,
                timeout_ms=timeout_ms,
                debug_logger=debug_logger,
            ),
            parent_ref=self,
        )

        hooks = SDKHooks()

        # pylint: disable=protected-access
        self.sdk_configuration.__dict__["_hooks"] = hooks

        self.sdk_configuration = hooks.sdk_init(self.sdk_configuration)

        weakref.finalize(
            self,
            close_clients,
            cast(ClientOwner, self.sdk_configuration),
            self.sdk_configuration.client,
            self.sdk_configuration.client_supplied,
            self.sdk_configuration.async_client,
            self.sdk_configuration.async_client_supplied,
        )

    def __enter__(self):
        return self

    async def __aenter__(self):
        return self

    def __exit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.client is not None
            and not self.sdk_configuration.client_supplied
        ):
            self.sdk_configuration.client.close()
        self.sdk_configuration.client = None

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        if (
            self.sdk_configuration.async_client is not None
            and not self.sdk_configuration.async_client_supplied
        ):
            await self.sdk_configuration.async_client.aclose()
        self.sdk_configuration.async_client = None

    def delete_query(
        self,
        *,
        attributes: Dict[str, str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteQueryResponse:
        r"""Deletes multiple cache entries based on specified attributes. If no attributes are provided, all entries in the cache are deleted.

        :param attributes:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteQueryRequest(
            attributes=attributes,
        )

        req = self._build_request(
            method="DELETE",
            path="/v1/caches/{cacheId}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteQueryGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.DeleteQueryRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteQuery",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DeleteQueryResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def delete_query_async(
        self,
        *,
        attributes: Dict[str, str],
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DeleteQueryResponse:
        r"""Deletes multiple cache entries based on specified attributes. If no attributes are provided, all entries in the cache are deleted.

        :param attributes:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteQueryRequest(
            attributes=attributes,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/v1/caches/{cacheId}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteQueryGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.DeleteQueryRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteQuery",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DeleteQueryResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def set(
        self,
        *,
        prompt: str,
        response: str,
        attributes: Optional[Dict[str, str]] = None,
        ttl_millis: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SetResponse:
        r"""Adds an entry to the cache with a prompt and response.

        :param prompt: The prompt for the entry.
        :param response: The response to the prompt for the entry.
        :param attributes:
        :param ttl_millis: The entry's time-to-live, in milliseconds. If not set, the cache's default TTL is used.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SetRequest(
            prompt=prompt,
            response=response,
            attributes=attributes,
            ttl_millis=ttl_millis,
        )

        req = self._build_request(
            method="POST",
            path="/v1/caches/{cacheId}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.SetGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SetRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="set",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.SetResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def set_async(
        self,
        *,
        prompt: str,
        response: str,
        attributes: Optional[Dict[str, str]] = None,
        ttl_millis: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SetResponse:
        r"""Adds an entry to the cache with a prompt and response.

        :param prompt: The prompt for the entry.
        :param response: The response to the prompt for the entry.
        :param attributes:
        :param ttl_millis: The entry's time-to-live, in milliseconds. If not set, the cache's default TTL is used.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SetRequest(
            prompt=prompt,
            response=response,
            attributes=attributes,
            ttl_millis=ttl_millis,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/caches/{cacheId}/entries",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.SetGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SetRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="set",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "201", "application/json"):
            return unmarshal_json_response(models.SetResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def search(
        self,
        *,
        prompt: str,
        similarity_threshold: Optional[float] = None,
        search_strategies: Optional[List[models.SearchStrategy]] = None,
        attributes: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SearchResponse:
        r"""Searches the cache for entries that match the prompt and attributes. If no entries are found, this endpoint returns an empty array.

        :param prompt: The prompt to search for in the cache.
        :param similarity_threshold: The minimum similarity threshold for the cache entry (normalized cosine similarity).
        :param search_strategies: The search strategies to use for the search, ordered by priority.
        :param attributes:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchRequest(
            prompt=prompt,
            similarity_threshold=similarity_threshold,
            search_strategies=search_strategies,
            attributes=attributes,
        )

        req = self._build_request(
            method="POST",
            path="/v1/caches/{cacheId}/entries/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.SearchGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SearchRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="search",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SearchResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def search_async(
        self,
        *,
        prompt: str,
        similarity_threshold: Optional[float] = None,
        search_strategies: Optional[List[models.SearchStrategy]] = None,
        attributes: Optional[Dict[str, str]] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SearchResponse:
        r"""Searches the cache for entries that match the prompt and attributes. If no entries are found, this endpoint returns an empty array.

        :param prompt: The prompt to search for in the cache.
        :param similarity_threshold: The minimum similarity threshold for the cache entry (normalized cosine similarity).
        :param search_strategies: The search strategies to use for the search, ordered by priority.
        :param attributes:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SearchRequest(
            prompt=prompt,
            similarity_threshold=similarity_threshold,
            search_strategies=search_strategies,
            attributes=attributes,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/caches/{cacheId}/entries/search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.SearchGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SearchRequest
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="search",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SearchResponse, http_res)
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def delete_by_id(
        self,
        *,
        entry_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Deletes a single cache entry by the entry ID.

        :param entry_id: Unique ID for the cache entry.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteByIDRequest(
            entry_id=entry_id,
        )

        req = self._build_request(
            method="DELETE",
            path="/v1/caches/{cacheId}/entries/{entryId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteByIDGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteById",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def delete_by_id_async(
        self,
        *,
        entry_id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Deletes a single cache entry by the entry ID.

        :param entry_id: Unique ID for the cache entry.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DeleteByIDRequest(
            entry_id=entry_id,
        )

        req = self._build_request_async(
            method="DELETE",
            path="/v1/caches/{cacheId}/entries/{entryId}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.DeleteByIDGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="deleteById",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def flush(
        self,
        *,
        request: Union[
            models.FlushRequest, models.FlushRequestTypedDict
        ] = models.FlushRequest(),
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Flushes all entries from the cache.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, models.FlushRequest)
        request = cast(models.FlushRequest, request)

        req = self._build_request(
            method="POST",
            path="/v1/caches/{cacheId}/flush",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.FlushGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Flush",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def flush_async(
        self,
        *,
        request: Union[
            models.FlushRequest, models.FlushRequestTypedDict
        ] = models.FlushRequest(),
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ):
        r"""Flushes all entries from the cache.

        :param request: The request object to send.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        if not isinstance(request, BaseModel):
            request = utils.unmarshal(request, models.FlushRequest)
        request = cast(models.FlushRequest, request)

        req = self._build_request_async(
            method="POST",
            path="/v1/caches/{cacheId}/flush",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            _globals=models.FlushGlobals(
                cache_id=self.sdk_configuration.globals.cache_id,
            ),
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="Flush",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "413",
                "424",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "204", "*"):
            return
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.BadRequestErrorResponseContentData, http_res
            )
            raise errors.BadRequestErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuthenticationErrorResponseContentData, http_res
            )
            raise errors.AuthenticationErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.ForbiddenErrorResponseContentData, http_res
            )
            raise errors.ForbiddenErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.NotFoundErrorResponseContentData, http_res
            )
            raise errors.NotFoundErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "413", "application/json"):
            response_data = unmarshal_json_response(
                errors.PayloadTooLargeErrorResponseContentData, http_res
            )
            raise errors.PayloadTooLargeErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "424", "application/json"):
            response_data = unmarshal_json_response(
                errors.ResourceUnavailableErrorResponseContentData, http_res
            )
            raise errors.ResourceUnavailableErrorResponseContent(
                response_data, http_res
            )
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.TooManyRequestsErrorResponseContentData, http_res
            )
            raise errors.TooManyRequestsErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.UnexpectedErrorResponseContentData, http_res
            )
            raise errors.UnexpectedErrorResponseContent(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
