# Scadere

Scadere is a TLS certificate renewal reminder.  It checks for certificates
that are about to expire and provides an Atom feed for notification.

## Installation

The recommended installtion method is through your distribution.
Installing from source should only be considered as a last resort;
if you are capable of doing so, please also package scadere
for your distribution.

Scadere requires Python 3.11 or later, and uses [flit] 3.12 or above
as the PEP 517 build backend.  Installation can be done
with `flit install` or `pip install .`.

With `scadere-check` and `scadere-listen` under `$prefix/bin`,
the manual pages can be built and installed using `make(1p)`,
GNU [help2man] and `install(1)`:

    cd doc
    make PREFIX=$prefix
    make install PREFIX=$prefix

(FYI, GNU make has an extension that allows specifying `--directory=doc`,
which can save you from having to change the directory.)

## Usage

### Expiration checking

```console
$ scadere-check --help
Usage: scadere-check [-h] [-v] [-d DAYS] [-o PATH] HOST[:PORT]...

Check TLS certificate expiration of HOST, where PORT defaults to 443.

Options:
  -h, --help            show this help message and exit
  -v, --version         show program's version number and exit
  -d DAYS, --days=DAYS  days before expiration (default to 7)
  -o PATH, --output=PATH
                        output file (default to stdout)
```

It is recommended to schedule `scadere-check` chronically.
See `contrib/scadere-check.*` for an example systemd timer configuration.

### Expiration notification

```console
$ scadere-listen --help
Usage: scadere-listen [-h] [-v] [-t TITLE] PATH URL [[HOST][:PORT]]

Serve at URL Atom feeds for TLS certificate renewal reminder.
It is possible for clients to filter domains
using one or more "domain" URL queries.

The certificate information is read from the file at PATH,
which is generated by scadere-check(1).

The server listens for TCP connections coming to HOST:PORT,
where HOST defaults to localhost and PORT is selected randomly
if not specified.

Options:
  -h, --help            show this help message and exit
  -v, --version         show program's version number and exit
  -t TITLE, --title=TITLE
                        title of Atom feeds (default to PATH's filename)
```

A sample `scadere-listen.service` for systemd
is also availble under the `contrib` directory.

## Hacking

Unit testing is done with [pytest], [pytest-asyncio],
[Hypothesis] and [trustme].  Since scadere itself does not depend
on any Python package, it is safe to be tested in-tree:

    PYTHONPATH=src pytest

## Contributing

Issues should be reported to [chung@loa.loang.net][loang mailing list].

The mailing list also welcomes patches.  Please maintain
a full branch [coverage], keep the [hobgoblins][flake8] happy,
and ensure the software is easy to [reuse]:

    PYTHONPATH=src coverage run && coverage report
    flake8
    reuse lint

Patches should be sent using [`git send-email`][git send-email]
with the following configuration:

    git config sendemail.to 'chung@loa.loang.net'
    git config format.subjectPrefix 'PATCH scadere'

## Copying

![AGPLv3](https://www.gnu.org/graphics/agplv3-155x51.png)

Scadere is free software: you can redistribute and/or modify it
under the terms of the GNU [Affero General Public License][agpl]
version 3 or later.

[flit]: https://flit.pypa.io
[help2man]: https://www.gnu.org/software/help2man
[pytest]: https://docs.pytest.org
[pytest-asyncio]: https://pytest-asyncio.rtfd.io
[Hypothesis]: https://hypothesis.rtfd.io
[trustme]: https://trustme.rtfd.io
[loang mailing list]: https://loa.loang.net/chung
[coverage]: https://coverage.rtfd.io
[flake8]: https://flake8.pycqa.org
[reuse]: https://reuse.software
[git send-email]: https://git-send-email.io
[agpl]: https://www.gnu.org/licenses/agpl
