<?xml version='1.0' encoding='utf-8'?>
<!-- Atom-to-XHTML transformation
     SPDX-FileCopyrightText: 2025 Nguyễn Gia Phong
     SPDX-License-Identifier: AGPL-3.0-or-later -->
<xsl:stylesheet version='1.0'
                xmlns:atom='http://www.w3.org/2005/Atom'
                xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
  <xsl:output method='html' version='1.0' encoding='UTF-8' indent='yes'/>

  <xsl:template match="atom:generator">
    <p>
      <xsl:text>This page is rendered by your browser </xsl:text>
      <xsl:text>from an Atom feed generated by </xsl:text>
      <a href='{@uri}'>
        <xsl:value-of select='.'/>
      </a>
      <xsl:text> </xsl:text>
      <xsl:value-of select='@version'/>
      <xsl:text>.</xsl:text>
    </p>
  </xsl:template>

  <xsl:template match="/atom:feed">
    <xsl:variable name='home' select='link'/>
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <meta charset='utf-8'/>
        <meta name='color-scheme' content='dark light'/>
        <meta name='viewport' content='width=device-width, initial-scale=1'/>
        <link rel='icon' href='data:,'/>
        <title><xsl:value-of select='atom:title'/></title>
      </head>
      <body>
        <h1><xsl:value-of select='atom:title'/></h1>
        <ul>
          <xsl:for-each select='atom:entry'>
            <li>
              <a href='{atom:link[@type="application/xhtml+xml"]/@href}'>
                <xsl:value-of select='atom:title'/>
              </a>
            </li>
          </xsl:for-each>
        </ul>
        <xsl:apply-templates select='atom:generator'/>
        <p>
          <xsl:text>You can subscribe </xsl:text>
          <xsl:text>from your favorite aggregator using </xsl:text>
          <a href='{atom:link[@rel="self"]/@href}'>
            <xsl:text>this URL</xsl:text>
          </a>
          <xsl:text>.</xsl:text>
        </p>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
