import md_to_code
from glob import glob
import importlib
import os


def test_readme():
    md_to_code.convert_to('test', 'README.md', 'tests/autogenerated_readme.py')
    import autogenerated_readme
    autogenerated_readme.run_test()


def test_example_code():
    filter = 'examples/*.md'

    files = glob(filter)
    for path in files:
        file_name = '.'.join(os.path.basename(path).split('.')[:-1])
        if not file_name.lower() == 'readme':
            print(f"> Test Example {file_name} ...")
            md_to_code.convert_to('test', path, f'tests/autogenerated_{file_name}.py')
            mod = importlib.import_module(f'autogenerated_{file_name}')
            mod.run_test()


if __name__ == "__main__":
    test_readme()
    test_example_code()
