"""Enumeration of standard error codes for UiPath runtime errors."""

from enum import Enum


class UiPathErrorCode(str, Enum):
    """Standard error codes for UiPath runtime errors."""

    # Entrypoint related errors
    ENTRYPOINT_MISSING = "ENTRYPOINT_MISSING"
    ENTRYPOINT_NOT_FOUND = "ENTRYPOINT_NOT_FOUND"
    ENTRYPOINT_FUNCTION_MISSING = "ENTRYPOINT_FUNCTION_MISSING"

    # Module and execution errors
    IMPORT_ERROR = "IMPORT_ERROR"
    MODULE_EXECUTION_ERROR = "MODULE_EXECUTION_ERROR"
    FUNCTION_EXECUTION_ERROR = "FUNCTION_EXECUTION_ERROR"
    EXECUTION_ERROR = "EXECUTION_ERROR"

    # Input validation errors
    INVALID_INPUT_FILE_EXTENSION = "INVALID_INPUT_FILE_EXTENSION"
    INPUT_INVALID_JSON = "INPUT_INVALID_JSON"

    # HITL (Human-In-The-Loop) related errors
    INVOKED_PROCESS_FAILURE = "INVOKED_PROCESS_FAILURE"
    CREATE_RESUME_TRIGGER_ERROR = "CREATE_RESUME_TRIGGER_ERROR"
    RETRIEVE_RESUME_TRIGGER_ERROR = "RETRIEVE_PAYLOAD_ERROR"
    UNKNOWN_HITL_MODEL = "UNKNOWN_HITL_MODEL"
    UNKNOWN_TRIGGER_TYPE = "UNKNOWN_TRIGGER_TYPE"

    # Runtime shutdown errors
    RUNTIME_SHUTDOWN_ERROR = "RUNTIME_SHUTDOWN_ERROR"
