# Guidelines

Before thinking about contributing to the project, it's **highly recommended** to read the guidelines following this page. They define the way everybody should do the stuff, from being polite to not use camelCase on the codebase. The following documents are:

1. **Code of Conduct**: defines expected behavior for contributors, promotes a welcoming and inclusive community, and outlines procedures for reporting unacceptable behavior. It helps maintain respectful collaboration and sets standards for communication and interaction.
1. **Coding Style**: defines the coding conventions and best practices contributors should follow in a project. It covers aspects like naming conventions, indentation, file structure, and formatting rules to ensure code consistency, readability, and maintainability across the codebase.
1. **Contributing**: provides guidelines for contributing to the project. It typically includes instructions for reporting issues, submitting pull requests, coding standards, and any required tools or setup. The goal is to help contributors understand how to effectively participate in the project's development.
1. **To Do**: lists planned features, improvements, bug fixes, or tasks that need to be completed in a project. It helps developers track what’s pending or upcoming and can guide contributors on where help is needed.
1. **Support**: provides information on how users and contributors can get help with the project. It typically includes links to documentation, forums, issue trackers, chat channels, or contact methods for reporting problems or asking questions.
