# RelationalAI Python API Reference

Here are all of the classes and methods that make up the RelationalAI Python API:

- [`Aggregates`](./Aggregates.md)
  - [`Aggregates.avg()`](./Aggregates.md#aggregatesavg)
  - [`Aggregates.count()`](./Aggregates.md#aggregatescount)
  - [`Aggregates.rank_asc()`](./Aggregates.md#aggregatesrank_asc)
  - [`Aggregates.rank_desc()`](./Aggregates.md#aggregatesrank_desc)
  - [`Aggregates.sum()`](./Aggregates.md#aggregatessum)
- [`Context`](./Context.md)
  - [`Context.__enter__()`](./Context.md#context__enter__)
  - [`Context.__exit__()`](./Context.md#context__exit__)
  - [`Context.__iter__()`](./Context.md#context__iter__)
  - [`Context.model`](./Context.md#contextmodel)
  - [`Context.results`](./Context.md#contextresults)
- [`ContextSelect`](./ContextSelect.md)
  - [`ContextSelect.add()`](./ContextSelect.md#contextselectadd)
  - [`ContextSelect.__call__()`](./ContextSelect.md#contextselect__call__)
  - [`ContextSelect.__getattribute__()`](./ContextSelect.md#contextselect__getattribute__)
- [`Expression`](./Expression.md)
- [`Instance`](./Expression.md)
  - [`Instance.persist()`](./Instance.md#instancepersist)
  - [`Instance.set()`](./Instance.md#instanceset)
  - [`Instance.unpersist()`](./Instance.md#instanceunpersist)
- [`InstanceProperty`](./InstanceProperty.md)
- [`Model`](./Model.md)
  - [`Model.aggregates`](./Model.md#modelaggregates)
  - [`Model.alias()`](./Model.md#modelalias)
  - [`Model.found()`](./Model.md#modelfound)
  - [`Model.name`](./Model.md#modelname)
  - [`Model.not_found()`](./Model.md#modelnot_found)
  - [`Model.ordered_choice()`](./Model.md#modelordered_choice)
  - [`Model.query()`](./Model.md#modelquery)
  - [`Model.rule()`](./Model.md#modelrule)
  - [`Model.scope()`](./Model.md#modelscope)
  - [`Model.Type()`](./Model.md#modeltype)
  - [`Model.union()`](./Model.md#modelunion)
  - [`Model.Vars()`](./Model.md#modelvars)
- [`Producer`](./Producer.md)
  - [`Producer.__add__()`](./Producer.md#producer__add__)
  - [`Producer.__radd__()`](./Producer.md#producer__radd__)
  - [`Producer.__mul__()`](./Producer.md#producer__mul__)
  - [`Producer.__rmul__()`](./Producer.md#producer__rmul__)
  - [`Producer.__sub__()`](./Producer.md#producer__sub__)
  - [`Producer.__rsub__()`](./Producer.md#producer__rsub__)
  - [`Producer.__truediv__()`](./Producer.md#producer__truediv__)
  - [`Producer.__rtruediv__()`](./Producer.md#producer__rtruediv__)
  - [`Producer.__gt__()`](./Producer.md#producer__gt__)
  - [`Producer.__ge__()`](./Producer.md#producer__ge__)
  - [`Producer.__lt__()`](./Producer.md#producer__lt__)
  - [`Producer.__le__()`](./Producer.md#producer__le__)
  - [`Producer.__eq__()`](./Producer.md#producer__eq__)
  - [`Producer.__ne__()`](./Producer.md#producer__ne__)
  - [`Producer.__enter__()`](./Producer.md#producer__enter__)
  - [`Producer.__exit__()`](./Producer.md#producer__exit__)
  - [`Producer.__getattribute__()`](./Producer.md#producer__getattribute__)
- [`Type`](./Type.md)
  - [`Type.add()`](./Type.md#typeadd)
  - [`Type.model`](./Type.md#typemodel)
  - [`Type.name`](./Type.md#typename)
  - [`Type.__call__()`](./Type.md#type__call__)
  - [`Type.__or__()`](./Type.md#type__or__)
