window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"streamlit_healthcheck": {"fullname": "streamlit_healthcheck", "modulename": "streamlit_healthcheck", "kind": "module", "doc": "<p>Streamlit Healthcheck provides lightweight, extensible utilities to run automated\nhealth checks, expose health endpoints, and collect basic metrics for Streamlit\napplications. It is designed to be CI/CD-friendly and to support reliable,\nobservable delivery pipelines.</p>\n\n<p>Key features</p>\n\n<ul>\n<li>Run synchronous or async health checks with timeouts and recovery hints</li>\n<li>Register custom checks (liveness, readiness, dependency checks)</li>\n<li>Expose HTTP/Streamlit endpoints for machine-readable and human-readable status</li>\n<li>Emit structured metrics/events suitable for scraping or CI validation</li>\n<li>Simple integration helpers for common backends (Redis, Postgres, external APIs)</li>\n</ul>\n\n<h2 id=\"quickstart\">Quickstart</h2>\n\n<p>1) Install:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>pip<span class=\"w\"> </span>install<span class=\"w\"> </span>streamlit_healthcheck\n</code></pre>\n</div>\n\n<p>2) Basic usage:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"kn\">from</span><span class=\"w\"> </span><span class=\"nn\">streamlit_healthcheck</span><span class=\"w\"> </span><span class=\"kn\">import</span> <span class=\"n\">healthcheck</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">report</span> <span class=\"o\">=</span> <span class=\"n\">healthcheck</span><span class=\"o\">.</span><span class=\"n\">run_all</span><span class=\"p\">(</span><span class=\"n\">timeout</span><span class=\"o\">=</span><span class=\"mi\">5</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">if</span> <span class=\"ow\">not</span> <span class=\"n\">report</span><span class=\"o\">.</span><span class=\"n\">ok</span><span class=\"p\">:</span>\n<span class=\"gp\">&gt;&gt;&gt; </span>     <span class=\"c1\"># handle degraded state (log, alert, fail pipeline)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span>     <span class=\"nb\">print</span><span class=\"p\">(</span><span class=\"n\">report</span><span class=\"o\">.</span><span class=\"n\">summary</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n\n<h2 id=\"api-common-surface\">API (common surface)</h2>\n\n<ul>\n<li><p>healthcheck.run_all(timeout: float = 5) -> HealthReport\nRuns all registered checks and returns a HealthReport object with:</p>\n\n<ul>\n<li>ok: bool</li>\n<li>summary: str</li>\n<li>details: dict</li>\n<li>duration: float</li>\n</ul></li>\n<li><p>healthcheck.register(name: str, fn: Callable, *, critical: bool = False)\nRegister a custom check function. Critical checks mark the whole service unhealthy.</p></li>\n<li><p>healthcheck.serve(endpoint: str = \"/health\", host: str = \"0.0.0.0\", port: int = 8000)\nExpose a simple HTTP endpoint (or embed in Streamlit) that returns JSON health status.</p></li>\n</ul>\n\n<h2 id=\"devops-alignment\">DevOps alignment</h2>\n\n<ul>\n<li>Reliable: Designed to reduce deployment failures and improve service uptime.</li>\n<li>Automatable: Designed to be executed in CI/CD pipelines (pre-deploy checks, post-deploy smoke tests).</li>\n<li>Observable: Emits structured outputs and metrics for dashboards and alerting.</li>\n<li>Lean: Small, focused checks to enable frequent, low-risk deployments.</li>\n<li>Measurable: Integrates with monitoring to improve MTTR and change failure rate.</li>\n<li>Shareable: Clear APIs, runbooks examples, and integration docs for teams.</li>\n</ul>\n\n<h2 id=\"integration-tips\">Integration tips</h2>\n\n<ul>\n<li>Use canary deployments or blue-green deployments to minimize impact during rollouts.</li>\n<li>Use feature flags or conditional checks to avoid noisy alerts during rollouts.</li>\n<li>Run healthcheck.run_all in CI as a gating step for deployments.</li>\n<li>Expose metrics to Prometheus or your metrics backend for SLA tracking.</li>\n</ul>\n\n<h2 id=\"configuration\">Configuration</h2>\n\n<ul>\n<li>Supports environment variables and optional YAML/JSON config for check registration.</li>\n<li>Default timeouts and thresholds are overridable per-check.</li>\n</ul>\n\n<h2 id=\"contributing\">Contributing</h2>\n\n<ul>\n<li>Tests, type hints, and small, focused PRs welcome.</li>\n<li>Follow the repository's CONTRIBUTING.md and code-of-conduct.</li>\n<li>Add unit tests for new checks and integrations; CI runs linting and tests.</li>\n<li>Use GitHub issues for bugs, feature requests, and discussions.</li>\n</ul>\n\n<h2 id=\"license\">License</h2>\n\n<p>GNU GENERAL PUBLIC LICENSE v3</p>\n"}, "streamlit_healthcheck.healthcheck": {"fullname": "streamlit_healthcheck.healthcheck", "modulename": "streamlit_healthcheck.healthcheck", "kind": "module", "doc": "<p></p>\n"}, "streamlit_healthcheck.healthcheck.logger": {"fullname": "streamlit_healthcheck.healthcheck.logger", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "logger", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Logger streamlit_healthcheck.healthcheck (INFO)&gt;"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor", "kind": "class", "doc": "<p>Singleton class that monitors and records errors occurring within Streamlit pages.\nIt captures both explicit Streamlit error messages (monkey-patching st.error) and\nuncaught exceptions raised during the execution of monitored page functions, and\npersists error details to a local SQLite database.</p>\n\n<p>Key responsibilities</p>\n\n<ul>\n<li>Intercept Streamlit error calls by monkey-patching st.error and record them with\na stack trace, timestamp, status, and type.</li>\n<li>Provide a decorator <code>monitor_page(page_name)</code> to set a page context, capture\nexceptions raised while rendering/executing a page, and record those exceptions.</li>\n<li>Store errors in an in-memory structure grouped by page and persist them to\nan SQLite database for later inspection.</li>\n<li>Provide utilities to load, deduplicate, clear, and query stored errors.</li>\n</ul>\n\n<p>Behavior and side effects</p>\n\n<ul>\n<li>Implements the Singleton pattern: only one instance exists per Python process.</li>\n<li>On first instantiation, optionally accepts a custom db_path and initializes\nthe SQLite database and its parent directory (creating it if necessary).</li>\n<li>Monkey-patches <code>streamlit.error</code> (st.error) to capture calls and still forward\nthem to the original st.error implementation.</li>\n<li>Records the following fields for each error: page, error, traceback, timestamp,\nstatus, type. The SQLite table <code>errors</code> mirrors these fields and includes an\nauto-incrementing <code>id</code>.</li>\n<li>Persists errors immediately to SQLite when captured; database IO errors are\nlogged but do not suppress the original exception (for monitored exceptions,\nthe exception is re-raised after recording).</li>\n</ul>\n\n<p>Public API (methods)</p>\n\n<ul>\n<li><p>__new__(cls, db_path=None)\n    Create or return the singleton StreamlitPageMonitor instance.</p>\n\n<pre><code>Parameters\n----------\ndb_path : Optional[str]\n    If provided on the first instantiation, overrides the class-level\n    database path used to persist captured Streamlit error information.\n\nReturns\n-------\nStreamlitPageMonitor\n    The singleton instance of the class.\n\nBehavior\n--------\n- On first instantiation (when cls._instance is None):\n- Allocates the singleton via super().__new__.\n- Optionally sets cls._db_path from the provided db_path.\n- Logs the configured DB path.\n- Monkey-patches streamlit.error (st.error) with a wrapper that:\n    - Builds an error record containing the error text, a formatted stack trace,\n    ISO timestamp, severity/status, an error type marker, and the current page.\n    - Normalizes a missing current page to \"unknown_page\".\n    - Stores the record in the in-memory cls._errors dictionary keyed by page.\n    - Attempts to persist the record to the SQLite DB using cls().save_errors_to_db,\n    logging any persistence errors without interrupting Streamlit's normal error display.\n    - Calls the original st.error to preserve expected UI behavior.\n- Initializes the SQLite DB via cls._init_db().\n- On subsequent calls:\n- Returns the existing singleton instance.\n- If db_path is provided, updates cls._db_path for future use.\n\nSide effects\n------------\n- Replaces st.error globally for the running process.\n- Writes error records to both an in-memory structure (cls._errors) and to the\nconfigured SQLite database (if persistence succeeds).\n- Logs informational and error messages.\n\nNotes\n-----\n- The method assumes the class defines/has: _instance, _db_path, _current_page,\n_errors, _st_error (original st.error), save_errors_to_db, and _init_db.\n- Exceptions raised during saving of individual errors are caught and logged;\nexceptions from instance creation or DB initialization may propagate.\n- The implementation is not explicitly thread-safe; concurrent instantiation\nattempts may require external synchronization if used in multi-threaded contexts.\n</code></pre></li>\n<li>set_page_context(cls, page_name: str)\nSet the current page name used when recording subsequent errors.</li>\n<li>monitor_page(cls, page_name: str) -> Callable\nDecorator for page rendering/execution functions. Sets the page context,\nclears previously recorded non-Streamlit errors for that page, runs the\nfunction, records and persists any raised exception, and re-raises it.</li>\n<li><p>_handle_st_error(cls, error_message: str)</p>\n\n<pre><code>Handles Streamlit-specific errors by recording error details for the current page.\n\nArgs:\n    error_message (str): The error message to be logged.\n\nSide Effects:\n    Updates the class-level _errors dictionary with error information for the current Streamlit page.\n\nError Information Stored:\n    - error: Formatted error message.\n    - traceback: Stack trace at the point of error.\n    - timestamp: Time when the error occurred (ISO format).\n    - status: Error severity ('critical').\n    - type: Error type ('streamlit_error').\n</code></pre></li>\n<li>get_page_errors(cls) -> dict\nLoad errors from the database and return a dictionary mapping page names to\nlists of error dicts. Performs basic deduplication by error message.</li>\n<li>save_errors_to_db(cls, errors: Iterable[dict])\nPersist a list of error dictionaries to the configured SQLite database.\nEnsures traceback is stored as a string (JSON if originally a list).</li>\n<li>clear_errors(cls, page_name: Optional[str] = None)\nClear in-memory errors for a specific page or all pages and delete matching\nrows from the database.</li>\n<li>_init_db(cls)\nEnsure the database directory exists and create the <code>errors</code> table if it\ndoes not exist.</li>\n<li>load_errors_from_db(cls, page=None, status=None, limit=None) -> List[dict]\nQuery the database for errors, optionally filtering by page and/or status,\nreturning a list of error dictionaries ordered by timestamp (descending)\nand limited if requested.</li>\n</ul>\n\n<p>Storage and format</p>\n\n<ul>\n<li>Default DB path: ~/local/share/streamlit-healthcheck/streamlit_page_errors.db (overridable).</li>\n<li>SQLite table <code>errors</code> columns: id, page, error, traceback, timestamp, status, type.</li>\n<li>Tracebacks may be stored as JSON strings (if originally lists) or plain strings.\nConcurrency and robustness</li>\n<li>Designed for single-process usage typical of Streamlit apps. The singleton and\nmonkey-patching are process-global.</li>\n<li>Database interactions use short-lived connections; callers should handle any\nexceptions arising from DB access (errors are logged internally).</li>\n<li>Decorator preserves original function metadata via functools.wraps.</li>\n</ul>\n\n<p>Examples</p>\n\n<ul>\n<li><p>Use as a decorator on page render function:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nd\">@StreamlitPageMonitor</span><span class=\"o\">.</span><span class=\"n\">monitor_page</span><span class=\"p\">(</span><span class=\"s2\">&quot;home&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">render_home</span><span class=\"p\">():</span>\n</code></pre>\n</div></li>\n<li><p>Set page context manually:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">StreamlitPageMonitor</span><span class=\"o\">.</span><span class=\"n\">set_page_context</span><span class=\"p\">(</span><span class=\"s2\">&quot;settings&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div></li>\n<li><p>Set custom DB path on first instantiation:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># Place this at the top of your Streamlit app once, before any error monitoring or decorator usage to ensure the sqlite</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># database is created properly at the specified path; otherwise it will default to a temp directory. The temp directory</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"c1\"># will be `~/local/share/streamlit-healthcheck/streamlit_page_errors.db`.</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">StreamlitPageMonitor</span><span class=\"p\">(</span><span class=\"n\">db_path</span><span class=\"o\">=</span><span class=\"s2\">&quot;/home/saradindu/dev/streamlit_page_errors.db&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">...</span>\n</code></pre>\n</div></li>\n</ul>\n\n<h2 id=\"sqlite-database-schema\">SQLite Database Schema</h2>\n\n<p>The following schema is used for persisting errors:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"k\">CREATE</span><span class=\"w\"> </span><span class=\"k\">TABLE</span><span class=\"w\"> </span><span class=\"k\">IF</span><span class=\"w\"> </span><span class=\"k\">NOT</span><span class=\"w\"> </span><span class=\"k\">EXISTS</span><span class=\"w\"> </span><span class=\"n\">errors</span><span class=\"w\"> </span><span class=\"p\">(</span>\n<span class=\"w\">    </span><span class=\"n\">id</span><span class=\"w\"> </span><span class=\"nb\">INTEGER</span><span class=\"w\"> </span><span class=\"k\">PRIMARY</span><span class=\"w\"> </span><span class=\"k\">KEY</span><span class=\"w\"> </span><span class=\"n\">AUTOINCREMENT</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"n\">page</span><span class=\"w\"> </span><span class=\"nb\">TEXT</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"n\">error</span><span class=\"w\"> </span><span class=\"nb\">TEXT</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"n\">traceback</span><span class=\"w\"> </span><span class=\"nb\">TEXT</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"k\">timestamp</span><span class=\"w\"> </span><span class=\"nb\">TEXT</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"n\">status</span><span class=\"w\"> </span><span class=\"nb\">TEXT</span><span class=\"p\">,</span>\n<span class=\"w\">    </span><span class=\"k\">type</span><span class=\"w\"> </span><span class=\"nb\">TEXT</span>\n<span class=\"p\">);</span>\n</code></pre>\n</div>\n\n<p>Field Descriptions:</p>\n\n<table>\n<thead>\n<tr>\n  <th>Column</th>\n  <th>Type</th>\n  <th>Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n  <td>id</td>\n  <td>INTEGER</td>\n  <td>Auto-incrementing primary key</td>\n</tr>\n<tr>\n  <td>page</td>\n  <td>TEXT</td>\n  <td>Name of the Streamlit page</td>\n</tr>\n<tr>\n  <td>error</td>\n  <td>TEXT</td>\n  <td>Error message</td>\n</tr>\n<tr>\n  <td>traceback</td>\n  <td>TEXT</td>\n  <td>Stack trace or traceback (as string/JSON)</td>\n</tr>\n<tr>\n  <td>timestamp</td>\n  <td>TEXT</td>\n  <td>ISO8601 timestamp of error occurrence</td>\n</tr>\n<tr>\n  <td>status</td>\n  <td>TEXT</td>\n  <td>Severity/status (e.g., 'critical')</td>\n</tr>\n<tr>\n  <td>type</td>\n  <td>TEXT</td>\n  <td>Error type ('streamlit_error', 'exception')</td>\n</tr>\n</tbody>\n</table>\n\n<p>Example:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"nd\">@StreamlitPageMonitor</span><span class=\"o\">.</span><span class=\"n\">monitor_page</span><span class=\"p\">(</span><span class=\"s2\">&quot;home&quot;</span><span class=\"p\">)</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"k\">def</span><span class=\"w\"> </span><span class=\"nf\">render_home</span><span class=\"p\">():</span>\n</code></pre>\n</div>\n\n<p>Notes</p>\n\n<ul>\n<li>The class monkey-patches st.error globally when first instantiated; ensure\nthis side effect is acceptable in your environment.</li>\n<li>Errors captured by st.error that occur outside any known page are recorded\nunder the page name \"unknown_page\".</li>\n<li>The schema is created/ensured in <code>_init_db()</code>.</li>\n<li>Tracebacks may be stored as JSON strings or plain text.</li>\n<li>Errors are persisted immediately upon capture.</li>\n</ul>\n"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor.__init__", "kind": "function", "doc": "<p>Create or return the singleton StreamlitPageMonitor instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">db_path</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor.set_page_context", "kind": "function", "doc": "<p>Set the current page context</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">page_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor.monitor_page", "kind": "function", "doc": "<p>Decorator to monitor and log exceptions for a specific Streamlit page.</p>\n\n<p>Args:\n    page_name (str): The name of the page to monitor.</p>\n\n<p>Returns:\n    Callable: A decorator that wraps the target function, sets the page context,\n    clears previous non-Streamlit errors, and logs any exceptions that occur during execution.</p>\n\n<p>The decorator performs the following actions:</p>\n\n<pre><code>- Sets the current page context using `cls.set_page_context`.\n- Clears previous exception errors for the page, retaining only those marked as 'streamlit_error'.\n- Executes the wrapped function.\n- If an exception occurs, logs detailed error information (error message, traceback, timestamp, status, type, and page)\n  to `cls._errors` under the given page name, then re-raises the exception.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">page_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor.get_page_errors", "kind": "function", "doc": "<p>Load error records from storage and return them grouped by page.\nThis class method calls cls().load_errors_from_db() to retrieve a sequence of error records\n(each expected to be a mapping). It normalizes each record to a dictionary with the keys:</p>\n\n<pre><code>- 'error' (str): error message, default \"Unknown error\"\n- 'traceback' (list): traceback frames or lines, default []\n- 'timestamp' (str): timestamp string, default \"\"\n- 'type' (str): error type/category, default \"unknown\"\n</code></pre>\n\n<p>Grouping and uniqueness:</p>\n\n<pre><code>- Records are grouped by the 'page' key; if a record has no 'page' key, the page name\n    \"unknown\" is used.\n- For each page, only unique errors are kept using the 'error' string as the deduplication\n    key. When multiple records for the same page have the same 'error' value, the last\n    occurrence in the loaded sequence will be retained.\n</code></pre>\n\n<p>Return value:</p>\n\n<pre><code>- dict[str, list[dict]]: mapping from page name to a list of normalized error dicts.\n</code></pre>\n\n<p>Error handling:</p>\n\n<pre><code>- Any exception raised while loading or processing records will be logged via logger.error.\n    The method will return the result accumulated so far (or an empty dict if nothing was\n    accumulated).\n</code></pre>\n\n<p>Notes:</p>\n\n<pre><code>- The class is expected to be instantiable (cls()) and to provide a load_errors_from_db()\n    method that yields or returns an iterable of mappings.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor.save_errors_to_db", "kind": "function", "doc": "<p>Save a sequence of error records into the SQLite database configured at cls._db_path.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>errors : Iterable[Mapping] | list[dict]</p>\n\n<pre><code>Sequence of error records to persist. Each record is expected to be a mapping with the\nfollowing keys (values are stored as provided, except for traceback which is normalized):\n\n  - \"page\": identifier or name of the page where the error occurred (str)\n  - \"error\": human-readable error message (str)\n  - \"traceback\": traceback information; may be a str, list, or None. If a list, it will be\n    JSON-encoded before storage. If None, an empty string is stored.\n  - \"timestamp\": timestamp for the error (stored as provided)\n  - \"status\": status associated with the error (str)\n  - \"type\": classification/type of the error (str)\n</code></pre>\n\n<h2 id=\"behavior\">Behavior</h2>\n\n<ul>\n<li>If <code>errors</code> is falsy (None or empty), the method returns immediately without touching the DB.</li>\n<li>Opens a SQLite connection to the path stored in <code>cls._db_path</code>.</li>\n<li>Iterates over the provided records and inserts each into the <code>errors</code> table with columns\n(page, error, traceback, timestamp, status, type).</li>\n<li>Ensures that the <code>traceback</code> value is always written as a string (list -> JSON string,\nother values -> str(), None -> \"\").</li>\n<li>Commits the transaction if all inserts succeed and always closes the connection in a finally block.</li>\n</ul>\n\n<h2 id=\"exceptions\">Exceptions</h2>\n\n<ul>\n<li>Underlying sqlite3 exceptions (e.g., sqlite3.Error) are not swallowed and will propagate to the caller\nif connection/execution fails.</li>\n</ul>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>None</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">errors</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor.clear_errors", "kind": "function", "doc": "<p>Clear stored health-check errors for a specific page or for all pages.\nThis classmethod updates both the in-memory error cache and the persistent\nSQLite-backed store.</p>\n\n<p>If <code>page_name</code> is provided:</p>\n\n<ul>\n<li>Remove the entry for that page from the class-level in-memory dictionary\nof errors (if present).</li>\n<li>Delete all rows in the SQLite <code>errors</code> table where <code>page</code> equals <code>page_name</code>.</li>\n</ul>\n\n<p>If <code>page_name</code> is None:</p>\n\n<ul>\n<li>Clear the entire in-memory errors dictionary.</li>\n<li>Delete all rows from the SQLite <code>errors</code> table.</li>\n</ul>\n\n<p>Args:\n        page_name (Optional[str]): Name of the page whose errors should be cleared.\n                If None, all errors are cleared.</p>\n\n<p>Returns:\n        None</p>\n\n<p>Side effects:</p>\n\n<pre><code>    - Mutates class-level state (clears entries in `cls._errors`).\n    - Opens a SQLite connection to `cls._db_path` and executes DELETE statements\n        against the `errors` table. Commits the transaction and closes the connection.\n</code></pre>\n\n<p>Error handling:</p>\n\n<pre><code>    - Database-related exceptions are caught and logged via the module logger;\n        they are not re-raised by this method. As a result, callers should not\n        rely on exceptions to detect DB failures.\n</code></pre>\n\n<p>Notes:</p>\n\n<pre><code>    - The method assumes `cls._db_path` points to a valid SQLite database file\n        and that an `errors` table exists with a `page` column.\n    - This method does not provide synchronization; callers should take care of\n        concurrent access to class state and the database if used from multiple\n        threads or processes.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">page_name</span><span class=\"p\">:</span> <span class=\"n\">Optional</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"fullname": "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "StreamlitPageMonitor.load_errors_from_db", "kind": "function", "doc": "<p>Load errors from the class SQLite database.\nThis classmethod connects to the SQLite database at cls._db_path, queries the\n'errors' table, and returns matching error records as a list of dictionaries.</p>\n\n<p>Parameters:</p>\n\n<pre><code>page (Optional[str]): If provided, filter results to rows where the 'page'\n    column equals this value.\nstatus (Optional[str]): If provided, filter results to rows where the 'status'\n    column equals this value.\nlimit (Optional[int|str]): If provided, limits the number of returned rows.\n    The value is cast to int internally; a non-convertible value will raise\n    ValueError.\n</code></pre>\n\n<p>Returns:</p>\n\n<pre><code>List[dict]: A list of dictionaries representing rows from the 'errors' table.\nEach dict contains the following keys:\n    - id: primary key (int)\n    - page: page identifier (str)\n    - error: short error message (str)\n    - traceback: full traceback or diagnostic text (str)\n    - timestamp: stored timestamp value as retrieved from the DB (type depends on schema)\n    - status: error status (str)\n    - type: error type/category (str)\n</code></pre>\n\n<p>Raises:</p>\n\n<pre><code>ValueError: If `limit` cannot be converted to int.\nsqlite3.Error: If an SQLite error occurs while executing the query.\n</code></pre>\n\n<p>Notes:</p>\n\n<pre><code>- Uses parameterized queries for the 'page' and 'status' filters to avoid SQL\n  injection. The `limit` is applied after casting to int.\n- Results are ordered by `timestamp` in descending order.\n- The database connection is always closed in a finally block to ensure cleanup.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">cls</span>, </span><span class=\"param\"><span class=\"n\">page</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">status</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">limit</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService", "kind": "class", "doc": "<p>A background-capable health monitoring service for a Streamlit-based application.\nThis class periodically executes a configurable set of checks (system metrics,\nexternal dependencies, Streamlit server and pages, and user-registered custom checks),\naggregates their results, and exposes a sanitized health snapshot suitable for UI\ndisplay or remote monitoring.</p>\n\n<p>Primary responsibilities</p>\n\n<ul>\n<li>Load and persist a JSON configuration that defines check intervals, thresholds,\ndependencies to probe, and Streamlit connection settings.</li>\n<li>Run periodic checks in a dedicated background thread (start/stop semantics).</li>\n<li>Collect system metrics (CPU, memory, disk) using psutil and apply configurable\nwarning/critical thresholds.</li>\n<li>Probe configured HTTP API endpoints and (placeholder) database checks.</li>\n<li>Verify Streamlit server liveness by calling a /healthz endpoint and inspect\nStreamlit page errors via StreamlitPageMonitor.</li>\n<li>Allow callers to register synchronous custom checks (functions returning dicts).</li>\n<li>Compute an aggregated overall status (critical &gt; warning &gt; unknown &gt; healthy).</li>\n<li>Provide a sanitized snapshot of health data with function references removed for safe\nserialization/display.</li>\n</ul>\n\n<p>Usage (high level)</p>\n\n<ul>\n<li>Instantiate: svc = HealthCheckService(config_path=\"path/to/config.json\")</li>\n<li>Optionally register custom checks: svc.register_custom_check(\"my_check\", my_check_func)\nwhere my_check_func() -> Dict[str, Any]</li>\n<li>Start background monitoring: svc.start()</li>\n<li>Stop monitoring: svc.stop()</li>\n<li>Retrieve current health snapshot for display or API responses: svc.get_health_data()</li>\n<li>Persist any changes to configuration: svc.save_config()</li>\n</ul>\n\n<p>Configuration (JSON)</p>\n\n<ul>\n<li>check_interval: int (seconds) \u2014 how often to run the checks (default 60)</li>\n<li>streamlit_url: str \u2014 base host (default \"http://localhost\")</li>\n<li>streamlit_port: int \u2014 port for Streamlit server (default 8501)</li>\n<li>system_checks: { \"cpu\": bool, \"memory\": bool, \"disk\": bool }</li>\n<li>dependencies:\n<ul>\n<li>api_endpoints: list of { \"name\": str, \"url\": str, \"timeout\": int }</li>\n<li>databases: list of { \"name\": str, \"type\": str, \"connection_string\": str }</li>\n</ul></li>\n<li>thresholds:\n<ul>\n<li>cpu_warning, cpu_critical, memory_warning, memory_critical, disk_warning, disk_critical</li>\n</ul></li>\n</ul>\n\n<p>Health data structure (conceptual)</p>\n\n<ul>\n<li>last_updated: ISO timestamp</li>\n<li>system: { \"cpu\": {...}, \"memory\": {...}, \"disk\": {...} }</li>\n<li>dependencies: { \"<name>\": {...}, ... }</li>\n<li>custom_checks: { \"<name>\": {...} }  (get_health_data() strips callable references)</li>\n<li>streamlit_server: {status, response_code/latency/error, message, url}</li>\n<li>streamlit_pages: {status, error_count, errors, details}</li>\n<li>overall_status: \"healthy\" | \"warning\" | \"critical\" | \"unknown\"</li>\n</ul>\n\n<p>Threading and safety</p>\n\n<ul>\n<li>The service runs checks in a daemon thread started by start(). stop() signals the\nthread to terminate and joins with a short timeout. Clients should avoid modifying\ninternal structures concurrently; get_health_data() returns a sanitized snapshot\nappropriate for concurrent reads.</li>\n</ul>\n\n<p>Custom checks</p>\n\n<ul>\n<li>register_custom_check(name, func): registers a synchronous function that returns a\ndict describing the check result (must include a \"status\" key with one of the\nrecognized values). The service stores the function reference internally but returns\nsanitized results via get_health_data().</li>\n</ul>\n\n<p>Error handling and logging</p>\n\n<ul>\n<li>Individual checks catch exceptions and surface errors in the corresponding\nhealth_data entry with status \"critical\" where appropriate.</li>\n<li>The Streamlit UI integration (st.* calls) is used for user-visible error messages\nwhen loading/saving configuration; the service also logs events to its configured\nlogger.</li>\n</ul>\n\n<p>Extensibility notes</p>\n\n<ul>\n<li>Database checks are left as placeholders; implement _check_database for specific DB\ndrivers/connections.</li>\n<li>Custom checks are synchronous; if long-running checks are required, adapt the\nregistration/run pattern to use async or worker pools.</li>\n</ul>\n"}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.__init__", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.__init__", "kind": "function", "doc": "<p>Initializes the HealthCheckService instance.</p>\n\n<p>Args:\n    config_path (str): Path to the health check configuration file. Defaults to \"health_check_config.json\".</p>\n\n<p>Attributes:</p>\n\n<ul>\n<li>logger (logging.Logger): Logger for the HealthCheckService.</li>\n<li>config_path (str): Path to the configuration file.</li>\n<li>health_data (Dict[str, Any]): Dictionary storing health check data.</li>\n<li>config (dict): Loaded configuration from the config file.</li>\n<li>check_interval (int): Interval in seconds between health checks. Defaults to 60.</li>\n<li>_running (bool): Indicates if the health check service is running.</li>\n<li>_thread (threading.Thread or None): Thread running the health check loop.</li>\n<li>streamlit_url (str): URL of the Streamlit service. Defaults to \"http://localhost\".</li>\n<li>streamlit_port (int): Port of the Streamlit service. Defaults to 8501.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">config_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;health_check_config.json&#39;</span></span>)</span>"}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.logger", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.logger", "kind": "variable", "doc": "<p></p>\n"}, "streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.config_path", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.config_path", "kind": "variable", "doc": "<p></p>\n"}, "streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.health_data", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.health_data", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Dict[str, Any]"}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.config", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.config", "kind": "variable", "doc": "<p></p>\n"}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.check_interval", "kind": "variable", "doc": "<p></p>\n"}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.streamlit_url", "kind": "variable", "doc": "<p></p>\n"}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.streamlit_port", "kind": "variable", "doc": "<p></p>\n"}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.start", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.start", "kind": "function", "doc": "<p>Start the periodic health-check background thread.\nIf the <code>healthcheck</code> runner is already active, this method is a no-op and returns\nimmediately. Otherwise, it marks the runner as running, creates a daemon thread\ntargeting self._run_checks_periodically, stores the thread on self._thread, and\nstarts it.</p>\n\n<p>Behavior and side effects:</p>\n\n<ul>\n<li>Idempotent while running: repeated calls will not create additional threads.</li>\n<li>Sets self._running to True.</li>\n<li>Assigns a daemon threading.Thread to self._thread and starts it.</li>\n<li>Non-blocking: returns after starting the background thread.</li>\n<li>The daemon thread will not prevent the process from exiting.</li>\n</ul>\n\n<p>Thread-safety:</p>\n\n<ul>\n<li>If start() may be called concurrently from multiple threads, callers should\nensure proper synchronization (e.g., external locking) to avoid race conditions.</li>\n</ul>\n\n<p>Returns:</p>\n\n<pre><code>    None\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.stop", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.stop", "kind": "function", "doc": "<p>Stop the health check service.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.run_all_checks", "kind": "function", "doc": "<p>Run all configured health checks and update health data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.check_cpu", "kind": "function", "doc": "<p>Checks the current CPU usage and updates the health status based on configured thresholds.\nMeasures the CPU usage percentage over a 1-second interval using psutil. Compares the result\nagainst warning and critical thresholds defined in the configuration. Sets the status to\n'healthy', 'warning', or 'critical' accordingly, and updates the health data dictionary.</p>\n\n<p>Returns:</p>\n\n<pre><code>None\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.check_memory", "kind": "function", "doc": "<p>Checks the system's memory usage and updates the health status accordingly.\nRetrieves the current memory usage statistics using psutil, compares the usage percentage\nagainst configured warning and critical thresholds, and sets the memory status to 'healthy',\n'warning', or 'critical'. Updates the health_data dictionary with total memory, available memory,\nusage percentage, and status.</p>\n\n<p>Returns:</p>\n\n<pre><code>None\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.check_disk", "kind": "function", "doc": "<p>Checks the disk usage of the root filesystem and updates the health status.\nRetrieves disk usage statistics using psutil, compares the usage percentage\nagainst configured warning and critical thresholds, and sets the disk status\naccordingly (<code>healthy</code>, <code>warning</code>, or <code>critical</code>). Updates the health_data\ndictionary with total disk size, free space, usage percentage, and status.</p>\n\n<p>Returns:</p>\n\n<pre><code>None\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.check_dependencies", "kind": "function", "doc": "<p>Checks the health of configured dependencies, including API endpoints and databases.\nIterates through the list of API endpoints and databases specified in the configuration,\nand performs health checks on each by invoking the corresponding internal methods.</p>\n\n<p>Raises:</p>\n\n<pre><code>Exception: If any dependency check fails.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.register_custom_check", "kind": "function", "doc": "<p>Register a custom health check function.</p>\n\n<p>Args:</p>\n\n<pre><code>name: Name of the custom check\ncheck_func: Function that performs the check and returns a dictionary with results\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">check_func</span><span class=\"p\">:</span> <span class=\"n\">Callable</span><span class=\"p\">[[],</span> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.run_custom_checks", "kind": "function", "doc": "<p>Run all registered custom health checks.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.get_health_data", "kind": "function", "doc": "<p>Get the latest health check data.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span>:</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.save_config", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.save_config", "kind": "function", "doc": "<p>Saves the current health check configuration to a JSON file.\nAttempts to write the configuration stored in <code>self.config</code> to the file specified by <code>self.config_path</code>.\nDisplays a success message in the Streamlit app upon successful save.\nHandles and displays appropriate error messages for file not found, permission issues, JSON decoding errors, and other exceptions.</p>\n\n<p>Raises:</p>\n\n<pre><code>FileNotFoundError: If the configuration file path does not exist.\nPermissionError: If there are insufficient permissions to write to the file.\njson.JSONDecodeError: If there is an error decoding the JSON data.\nException: For any other exceptions encountered during the save process.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.check_streamlit_pages", "kind": "function", "doc": "<p>Checks for errors in Streamlit pages and updates the health data accordingly.\nThis method retrieves page errors using StreamlitPageMonitor.get_page_errors().\nIf errors are found, it sets the 'streamlit_pages' status to 'critical' and updates\nthe overall health status to 'critical'. If no errors are found, it marks the\n'streamlit_pages' status as 'healthy'.</p>\n\n<p>Updates:</p>\n\n<pre><code>self.health_data[\"streamlit_pages\"]: Dict containing status, error count, errors, and details.\nself.health_data[\"overall_status\"]: Set to 'critical' if errors are detected.\nself.health_data[\"streamlit_pages\"][\"details\"]: A summary of the errors found.\n</code></pre>\n\n<p>Returns:</p>\n\n<pre><code>None\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"fullname": "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "HealthCheckService.check_streamlit_server", "kind": "function", "doc": "<p>Checks the health status of the Streamlit server by sending a GET request to the /healthz endpoint.</p>\n\n<p>Returns:</p>\n\n<pre><code>Dict[str, Any]: A dictionary containing the health status, response code, latency in milliseconds,\n                message, and the URL checked. If the server is healthy (HTTP 200), status is \"healthy\".\n                Otherwise, status is \"critical\" with error details.\n</code></pre>\n\n<p>Handles:</p>\n\n<pre><code>- Connection errors: Returns critical status with connection error details.\n- Timeout errors: Returns critical status with timeout error details.\n- Other exceptions: Returns critical status with unknown error details.\n</code></pre>\n\n<p>Logs:</p>\n\n<pre><code>- The URL being checked.\n- The response status code and text.\n- Health status and response time if healthy.\n- Warnings and errors for unhealthy or failed checks.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Dict</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"n\">Any</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, "streamlit_healthcheck.healthcheck.health_check": {"fullname": "streamlit_healthcheck.healthcheck.health_check", "modulename": "streamlit_healthcheck.healthcheck", "qualname": "health_check", "kind": "function", "doc": "<p>Displays an interactive Streamlit dashboard for monitoring application health.\nThis function initializes and manages a health check service, presenting real-time system metrics,\ndependency statuses, custom checks, and Streamlit page health in a user-friendly dashboard.\nUsers can manually refresh health checks, view detailed error information, and adjust configuration\nthresholds and intervals directly from the UI.</p>\n\n<p>Args:</p>\n\n<pre><code>config_path (str, optional): Path to the health check configuration JSON file.\n    Defaults to \"health_check_config.json\".\n</code></pre>\n\n<p>Features:</p>\n\n<pre><code>- Displays overall health status with color-coded indicators.\n- Shows last updated timestamp for health data.\n- Monitors Streamlit server status, latency, and errors.\n- Provides tabs for:\n    * System Resources (CPU, Memory, Disk usage and status)\n    * Dependencies (external services and their health)\n    * Custom Checks (user-defined health checks)\n    * Streamlit Pages (page-specific errors and status)\n- Allows configuration of system thresholds, check intervals, and Streamlit server settings.\n- Supports manual refresh and saving configuration changes.\n</code></pre>\n\n<p>Raises:</p>\n\n<pre><code>Displays error messages in the UI for any exceptions encountered during health data retrieval or processing.\n</code></pre>\n\n<p>Returns:</p>\n\n<pre><code>None. The dashboard is rendered in the Streamlit app.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">config_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;health_check_config.json&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.server": {"fullname": "streamlit_healthcheck.server", "modulename": "streamlit_healthcheck.server", "kind": "module", "doc": "<p>This module implements a FastAPI server for monitoring the health of a Streamlit application.</p>\n\n<p>Features:</p>\n\n<ul>\n<li>Provides REST API endpoints to report health status of system resources, dependencies, and Streamlit pages.</li>\n<li>Uses a configurable health check service to gather health data.</li>\n<li>Supports startup and shutdown events for proper initialization and cleanup of the health check service.</li>\n<li>Includes endpoints:\n<ul>\n<li><code>/health</code>: Returns complete health status.</li>\n<li><code>/health/system</code>: Returns system resource health (CPU, Memory, Disk).</li>\n<li><code>/health/dependencies</code>: Returns dependencies health status.</li>\n<li><code>/health/pages</code>: Returns Streamlit pages health status.</li>\n</ul></li>\n<li>Configurable via command-line arguments for host, port, and health check config file.</li>\n<li>Uses logging for operational visibility.</li>\n</ul>\n\n<p>Global Variables:</p>\n\n<ul>\n<li><code>health_service</code>: Instance of HealthCheckService, manages health checks.</li>\n<li><code>config_file</code>: Path to health check configuration file.</li>\n</ul>\n\n<p>Usage:</p>\n\n<p>Run as a standalone server or import as a module.</p>\n"}, "streamlit_healthcheck.server.logger": {"fullname": "streamlit_healthcheck.server.logger", "modulename": "streamlit_healthcheck.server", "qualname": "logger", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Logger streamlit_healthcheck.server (INFO)&gt;"}, "streamlit_healthcheck.server.health_service": {"fullname": "streamlit_healthcheck.server.health_service", "modulename": "streamlit_healthcheck.server", "qualname": "health_service", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[streamlit_healthcheck.healthcheck.HealthCheckService]", "default_value": "None"}, "streamlit_healthcheck.server.config_file": {"fullname": "streamlit_healthcheck.server.config_file", "modulename": "streamlit_healthcheck.server", "qualname": "config_file", "kind": "variable", "doc": "<p></p>\n", "annotation": ": Optional[str]", "default_value": "None"}, "streamlit_healthcheck.server.lifespan": {"fullname": "streamlit_healthcheck.server.lifespan", "modulename": "streamlit_healthcheck.server", "qualname": "lifespan", "kind": "function", "doc": "<p>Lifespan context manager for FastAPI application</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">app</span><span class=\"p\">:</span> <span class=\"n\">fastapi</span><span class=\"o\">.</span><span class=\"n\">applications</span><span class=\"o\">.</span><span class=\"n\">FastAPI</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, "streamlit_healthcheck.server.app": {"fullname": "streamlit_healthcheck.server.app", "modulename": "streamlit_healthcheck.server", "qualname": "app", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;fastapi.applications.FastAPI object&gt;"}, "streamlit_healthcheck.server.root": {"fullname": "streamlit_healthcheck.server.root", "modulename": "streamlit_healthcheck.server", "qualname": "root", "kind": "function", "doc": "<p>Asynchronous handler for the application root (\"/\") endpoint.\nReturns a JSONResponse containing basic service metadata intended for health\nchecks and simple API discovery. The returned JSON includes the service name,\nversion, a short description, and a mapping of available health-related\nendpoints.</p>\n\n<p>Returns:</p>\n\n<pre><code>JSONResponse: HTTP 200 response with a JSON body.\n</code></pre>\n\n<p>Notes:</p>\n\n<pre><code>- This function is asynchronous and suitable for use with Starlette or FastAPI.\n- No input parameters are required.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, "streamlit_healthcheck.server.get_health_status": {"fullname": "streamlit_healthcheck.server.get_health_status", "modulename": "streamlit_healthcheck.server", "qualname": "get_health_status", "kind": "function", "doc": "<p>Asynchronous endpoint that retrieves and returns the application's health status as a JSON response.\nThis coroutine uses the module-level <code>health_service</code> to obtain health data and returns it wrapped in a\nfastapi.responses.JSONResponse. It logs unexpected errors and maps them to appropriate HTTP error responses.</p>\n\n<p>Behavior:</p>\n\n<ul>\n<li>If the global <code>health_service</code> is not initialized or falsy, raises HTTPException(status_code=503).</li>\n<li>If <code>health_service.get_health_data()</code> succeeds, returns a JSONResponse with the health data (typically a dict).</li>\n<li>If any exception occurs while obtaining health data, the exception is logged and an HTTPException(status_code=500) is raised with the original error message.</li>\n</ul>\n\n<p>Returns:</p>\n\n<pre><code>    fastapi.responses.JSONResponse: A JSONResponse containing the health data returned by `health_service.get_health_data()`.\n</code></pre>\n\n<p>Raises:</p>\n\n<pre><code>    fastapi.HTTPException: With status_code=503 when the health service is not initialized.\n    fastapi.HTTPException: With status_code=500 when an unexpected error occurs while retrieving health data.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, "streamlit_healthcheck.server.get_system_health": {"fullname": "streamlit_healthcheck.server.get_system_health", "modulename": "streamlit_healthcheck.server", "qualname": "get_system_health", "kind": "function", "doc": "<p>Asynchronously retrieve the system health payload from the global health service and return it\nas a JSONResponse suitable for use in a FastAPI/Starlette endpoint.</p>\n\n<p>Behavior:</p>\n\n<ul>\n<li>Verifies that the module-level 'health_service' is initialized; if not, raises HTTPException(503).</li>\n<li>Calls health_service.get_health_data() to obtain health information.</li>\n<li>Extracts the \"system\" sub-dictionary from the returned health data (defaults to an empty dict).</li>\n<li>Returns a fastapi.responses.JSONResponse with content {\"system\": <system_data>}.</li>\n<li>If any unexpected error occurs while obtaining or processing health data, logs the error and\nraises HTTPException(500) with the error message.</li>\n</ul>\n\n<p>Returns:</p>\n\n<pre><code>    fastapi.responses.JSONResponse: JSON response containing the \"system\" health data.\n</code></pre>\n\n<p>Raises:</p>\n\n<pre><code>    HTTPException: with status_code=503 if the health service is not initialized.\n    HTTPException: with status_code=500 if an unexpected error occurs while retrieving health data.\n</code></pre>\n\n<p>Notes:</p>\n\n<ul>\n<li>Relies on the module-level 'health_service' and 'logger' variables.</li>\n<li>Designed to be used as an async request handler in a web application.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, "streamlit_healthcheck.server.get_dependencies_health": {"fullname": "streamlit_healthcheck.server.get_dependencies_health", "modulename": "streamlit_healthcheck.server", "qualname": "get_dependencies_health", "kind": "function", "doc": "<p>Asynchronously retrieve and return the health status of external dependencies.\nThis function relies on a module-level <code>health_service</code> object. If the service is\nnot initialized, it raises an HTTPException with status 503. Otherwise it calls\n<code>health_service.get_health_data()</code> and returns a JSONResponse containing the\n\"dependencies\" entry from the returned health data (an empty dict is returned\nif that key is missing). Any unexpected error during retrieval is logged and\npropagated as an HTTPException with status 500.</p>\n\n<p>Returns:</p>\n\n<pre><code>JSONResponse: A JSON response with the shape {\"dependencies\": {...}}.\n</code></pre>\n\n<p>Raises:</p>\n\n<pre><code>HTTPException: 503 if the global health_service is not initialized.\nHTTPException: 500 for any unexpected error while fetching health data.\n</code></pre>\n\n<p>Notes:</p>\n\n<pre><code>- The function is asynchronous but calls a synchronous `get_health_data()` on\n  the health service; the service implementation should be safe to call from\n  an async context.\n- Errors are logged using the module-level `logger`.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, "streamlit_healthcheck.server.get_pages_health": {"fullname": "streamlit_healthcheck.server.get_pages_health", "modulename": "streamlit_healthcheck.server", "qualname": "get_pages_health", "kind": "function", "doc": "<p>Asynchronously run health checks and return the health status for Streamlit pages.\nThis coroutine depends on a module-level <code>health_service</code> which must be initialized\nbefore calling. It triggers a fresh health check by calling <code>health_service.run_all_checks()</code>\nand then retrieves the aggregated health data via <code>health_service.get_health_data()</code>.\nOnly the \"streamlit_pages\" portion of the health data is returned in a FastAPI\nJSONResponse (defaults to an empty dict if the key is absent).</p>\n\n<p>Returns:</p>\n\n<pre><code>fastapi.responses.JSONResponse: A JSON response with the shape\n    {\"streamlit_pages\": {...}}.\n</code></pre>\n\n<p>Raises:</p>\n\n<pre><code>fastapi.HTTPException: If `health_service` is not initialized (status_code=503).\nfastapi.HTTPException: If any unexpected error occurs while running checks or\n    retrieving data (status_code=500). The exception detail contains the original\n    error message.\n</code></pre>\n\n<p>Side effects:</p>\n\n<pre><code>- Calls `health_service.run_all_checks()` which may perform I/O or long-running checks.\n- Logs errors to the module logger when exceptions occur.\n</code></pre>\n\n<p>Notes:</p>\n\n<pre><code>- This function is intended to be used in an ASGI/FastAPI context and must be awaited.\n- Only the `\"streamlit_pages\"` key from the health payload is exposed to the caller.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "async def"}, "streamlit_healthcheck.server.start_api_server": {"fullname": "streamlit_healthcheck.server.start_api_server", "modulename": "streamlit_healthcheck.server", "qualname": "start_api_server", "kind": "function", "doc": "<p>Start the API server using uvicorn and set the global configuration file.\nSets the module-level variable <code>config_file</code> to the provided <code>config</code> path\nand then starts the ASGI server by calling <code>uvicorn.run(app, host=host, port=port)</code>.\nThe call is blocking and will run until the server is stopped.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>host : str, optional\n    Host interface to bind the server to. Defaults to \"0.0.0.0\" (all interfaces).\nport : int, optional\n    TCP port to listen on. Defaults to 8000.\nconfig : str, optional\n    Path to the health check configuration file. Defaults to \"health_check_config.json\".\n    This value is assigned to the module-level <code>config_file</code> variable before the server starts.</p>\n\n<h2 id=\"returns\">Returns</h2>\n\n<p>None\n    This function does not return; it blocks while the server is running.</p>\n\n<h2 id=\"raises\">Raises</h2>\n\n<p>OSError\n    If the server cannot bind to the given host/port (for example, if the port is already in use).</p>\n\n<p>Exception\n    Any exceptions raised by uvicorn or the ASGI application are propagated.</p>\n\n<h2 id=\"example\">Example</h2>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">start_api_server</span><span class=\"p\">(</span><span class=\"n\">host</span><span class=\"o\">=</span><span class=\"s2\">&quot;127.0.0.1&quot;</span><span class=\"p\">,</span> <span class=\"n\">port</span><span class=\"o\">=</span><span class=\"mi\">8080</span><span class=\"p\">,</span> <span class=\"n\">config</span><span class=\"o\">=</span><span class=\"s2\">&quot;my_config.json&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">host</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;0.0.0.0&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">port</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">8000</span>,</span><span class=\"param\">\t<span class=\"n\">config</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;health_check_config.json&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.server.parse_args": {"fullname": "streamlit_healthcheck.server.parse_args", "modulename": "streamlit_healthcheck.server", "qualname": "parse_args", "kind": "function", "doc": "<p>Parse command-line arguments for the Streamlit Health Check API Server.</p>\n\n<p>Defines and parses the following command-line options:\n    --host   (str)  Host address to bind. Default: \"0.0.0.0\".\n    --port   (int)  Port to run the server on. Default: 8000.\n    --config (str)  Path to the health check configuration file. Default: \"health_check_config.json\".</p>\n\n<p>Returns:</p>\n\n<pre><code>    argparse.Namespace: The parsed arguments with attributes `host`, `port`, and `config`.\n</code></pre>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"fullname": "streamlit_healthcheck.streamlit-healthcheck-cli", "modulename": "streamlit_healthcheck.streamlit-healthcheck-cli", "kind": "module", "doc": "<p>This module provides a command-line interface (CLI) for monitoring the health of Streamlit applications.\nIt offers commands to start an API server for health checks and to initialize a new health check configuration file.</p>\n\n<h2 id=\"commands\">Commands:</h2>\n\n<ul>\n<li><p>serve:\nStarts the health check API server.</p>\n\n<p>Options:</p>\n\n<pre><code>--host: Host address to bind the server (default: '0.0.0.0')\n--port: Port to run the server on (default: 8000)\n--config: Path to health check configuration file (default: 'config/health_check_config.json')\n--log-level: Set the logging level (choices: DEBUG, INFO, WARNING, ERROR, CRITICAL; default: INFO)\n</code></pre></li>\n<li><p>init:\nInitializes a new health check configuration file.</p>\n\n<p>Options:</p>\n\n<pre><code>--config: Path to health check configuration file (default: 'config/health_check_config.json')\n</code></pre></li>\n</ul>\n\n<h2 id=\"usage\">Usage:</h2>\n\n<p>Run the CLI using the following command:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>python<span class=\"w\"> </span>-m<span class=\"w\"> </span>streamlit-healthcheck.streamlit-healthcheck-cli<span class=\"w\"> </span><span class=\"o\">[</span>COMMAND<span class=\"o\">]</span><span class=\"w\"> </span><span class=\"o\">[</span>OPTIONS<span class=\"o\">]</span>\n</code></pre>\n</div>\n\n<h2 id=\"example\">Example:</h2>\n\n<p>Start the server with default configuration</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>python<span class=\"w\"> </span>-m<span class=\"w\"> </span>streamlit-healthcheck.streamlit-healthcheck-cli<span class=\"w\"> </span>serve\n</code></pre>\n</div>\n\n<p>Start the server with custom configuration</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>python<span class=\"w\"> </span>-m<span class=\"w\"> </span>streamlit-healthcheck.streamlit-healthcheck-cli<span class=\"w\"> </span>serve<span class=\"w\"> </span>--host<span class=\"w\"> </span><span class=\"m\">127</span>.0.0.1<span class=\"w\"> </span>--port<span class=\"w\"> </span><span class=\"m\">8080</span><span class=\"w\"> </span>--config<span class=\"w\"> </span>my_config.json<span class=\"w\"> </span>--log-level<span class=\"w\"> </span>DEBUG\n</code></pre>\n</div>\n\n<p>Initialize a new configuration file</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code>python<span class=\"w\"> </span>-m<span class=\"w\"> </span>streamlit-healthcheck.streamlit-healthcheck-cli<span class=\"w\"> </span>init<span class=\"w\"> </span>--config<span class=\"w\"> </span>my_config.json\n</code></pre>\n</div>\n\n<h2 id=\"logging\">Logging:</h2>\n\n<p>Logging is configured to output to stdout with customizable log levels.</p>\n\n<h2 id=\"error-handling\">Error Handling:</h2>\n\n<p>All commands handle exceptions gracefully and provide informative error messages.</p>\n"}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"fullname": "streamlit_healthcheck.streamlit-healthcheck-cli.logger", "modulename": "streamlit_healthcheck.streamlit-healthcheck-cli", "qualname": "logger", "kind": "variable", "doc": "<p></p>\n", "default_value": "&lt;Logger streamlit_healthcheck.streamlit-healthcheck-cli (INFO)&gt;"}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"fullname": "streamlit_healthcheck.streamlit-healthcheck-cli.cli", "modulename": "streamlit_healthcheck.streamlit-healthcheck-cli", "qualname": "cli", "kind": "variable", "doc": "<p>Command-line entry point for the streamlit-healthcheck tool.\nThis function implements the command-line interface (CLI) used to run\nhealth checks against a Streamlit application or to serve a small\nhealthcheck UI. It is intended to be registered as a console_script\nentry point for the package.</p>\n\n<h2 id=\"behavior\">Behavior</h2>\n\n<ul>\n<li>Parse command-line arguments (e.g. target URL of the Streamlit app,\ntimeout values, logging/verbosity flags, and optional configuration\nfile path).</li>\n<li>Validate arguments and configuration.</li>\n<li>Execute one or more health checks (HTTP / status checks, simple page\ncontent assertions, or custom checks defined in a config).</li>\n<li>Optionally start a lightweight HTTP server that exposes the healthcheck\nresults or a human-readable status page.</li>\n<li>Emit structured logs and progress information to stdout/stderr.</li>\n<li>Exit with a zero status on success and non-zero on failure or error.</li>\n</ul>\n\n<h2 id=\"arguments\">Arguments</h2>\n\n<ul>\n<li>None (reads configuration from sys.argv and environment).\nReturn</li>\n<li>None. On completion the function typically calls sys.exit() with an\nappropriate exit code.</li>\n</ul>\n\n<h2 id=\"exit-codes\">Exit codes</h2>\n\n<ul>\n<li>0: All health checks passed.</li>\n<li>1: One or more health checks failed.</li>\n<li>2: Invalid usage or configuration.</li>\n<li>3: Unexpected runtime error (network failure, internal exception).</li>\n</ul>\n\n<h2 id=\"side-effects\">Side effects</h2>\n\n<ul>\n<li>Network requests to the target Streamlit instance.</li>\n<li>May bind to a local port if serving a status UI.</li>\n<li>Configures global logging and may call sys.exit().</li>\n</ul>\n\n<h2 id=\"examples\">Examples</h2>\n\n<ul>\n<li>Run checks against a local Streamlit app:\nstreamlit-healthcheck --url <a href=\"http://localhost:8501\">http://localhost:8501</a> --timeout 5</li>\n<li><p>Serve a status UI on port 9000:\n    streamlit-healthcheck --serve --port 9000 --config /path/to/config.yml</p>\n\n<h2 id=\"notes\">Notes</h2></li>\n<li><p>The exact CLI flags and behavior are defined by the implemented argument\nparser; this docstring describes the intended responsibilities and\nobservable outcomes of the CLI entry point.</p></li>\n</ul>\n", "default_value": "&lt;Group cli&gt;"}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"fullname": "streamlit_healthcheck.streamlit-healthcheck-cli.serve", "modulename": "streamlit_healthcheck.streamlit-healthcheck-cli", "qualname": "serve", "kind": "variable", "doc": "<p>Start the health check API server.\nSets the global logging level, prints startup information to the console, and\ninvokes the underlying server start function. Any exception raised during\nstartup is logged and re-raised as a click.ClickException.</p>\n\n<h2 id=\"parameters\">Parameters</h2>\n\n<p>host : str\n    Hostname or IP address to bind the server to (e.g. \"0.0.0.0\" or \"127.0.0.1\").\nport : int\n    TCP port number to listen on.\nconfig : str\n    Filesystem path to the configuration file used to configure the health check API.\nlog_level : str\n    Logging level name (case-insensitive), e.g. \"DEBUG\", \"INFO\", \"WARNING\", \"ERROR\", \"CRITICAL\".</p>\n\n<h2 id=\"raises\">Raises</h2>\n\n<p>click.ClickException\n    If an unexpected error occurs while starting the server; the underlying\n    exception message is propagated.</p>\n\n<h2 id=\"side-effects\">Side effects</h2>\n\n<ul>\n<li>Calls logging.getLogger().setLevel to adjust the global logging level.</li>\n<li>Emits informational messages via click.echo.</li>\n<li>Calls start_api_server(host, port, config) to start the service.</li>\n<li>On failure, logs the error via logger.error before raising a click.ClickException.</li>\n</ul>\n", "default_value": "&lt;Command serve&gt;"}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"fullname": "streamlit_healthcheck.streamlit-healthcheck-cli.init", "modulename": "streamlit_healthcheck.streamlit-healthcheck-cli", "qualname": "init", "kind": "variable", "doc": "<p>Initialize and persist a healthcheck service configuration.\nCreates a HealthCheckService for the given configuration path, writes the default\nconfiguration to disk, and prints a success message to stdout. Any failure during\nservice creation or saving is logged and re-raised as a click.ClickException so\nCLI callers receive a clean, user-facing error.</p>\n\n<p>Args:\n    config (str): Path to the configuration file to create.</p>\n\n<p>Raises:\n    click.ClickException: If the configuration file could not be created or saved.</p>\n", "default_value": "&lt;Command init&gt;"}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"fullname": "streamlit_healthcheck.streamlit-healthcheck-cli.main", "modulename": "streamlit_healthcheck.streamlit-healthcheck-cli", "qualname": "main", "kind": "function", "doc": "<p>Run the command-line interface and handle top-level exceptions.\nThis function acts as the script entry point. It calls the module-level cli()\nfunction to execute the command-line interface. Any exception raised during\ncli() execution is caught, logged via the module-level logger, and causes the\nprocess to exit with status code 1.</p>\n\n<p>Behavior:</p>\n\n<ul>\n<li>Calls cli().</li>\n<li>On successful completion, returns normally (None).</li>\n<li>On any Exception, logs an error message with logger.error and terminates\nthe process by calling sys.exit(1).</li>\n</ul>\n\n<p>Dependencies:</p>\n\n<ul>\n<li>Expects cli, logger, and sys to be available in the module namespace.</li>\n</ul>\n\n<p>Usage:</p>\n\n<p>Intended to be invoked when the package/script is run as a program (e.g. from\nif __name__ == \"__main__\": main()).</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}}, "docInfo": {"streamlit_healthcheck": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 639}, "streamlit_healthcheck.healthcheck": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.logger": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1730}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 15, "bases": 0, "doc": 10}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 7}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 129}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 248}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 284}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 35, "bases": 0, "doc": 291}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"qualname": 5, "fullname": 8, "annotation": 0, "default_value": 0, "signature": 41, "bases": 0, "doc": 244}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 703}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 29, "bases": 0, "doc": 160}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"qualname": 3, "fullname": 6, "annotation": 3, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 165}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 8}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 12}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 65}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 66}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 72}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 53}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 50, "bases": 0, "doc": 36}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 9}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 14, "bases": 0, "doc": 9}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 112}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 116}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"qualname": 4, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 133}, "streamlit_healthcheck.healthcheck.health_check": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 31, "bases": 0, "doc": 210}, "streamlit_healthcheck.server": {"qualname": 0, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 199}, "streamlit_healthcheck.server.logger": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 9, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.server.health_service": {"qualname": 2, "fullname": 5, "annotation": 5, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.server.config_file": {"qualname": 2, "fullname": 5, "annotation": 2, "default_value": 1, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.server.lifespan": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 8}, "streamlit_healthcheck.server.app": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 8, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.server.root": {"qualname": 1, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 87}, "streamlit_healthcheck.server.get_health_status": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 194}, "streamlit_healthcheck.server.get_system_health": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 212}, "streamlit_healthcheck.server.get_dependencies_health": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 180}, "streamlit_healthcheck.server.get_pages_health": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 229}, "streamlit_healthcheck.server.start_api_server": {"qualname": 3, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 74, "bases": 0, "doc": 264}, "streamlit_healthcheck.server.parse_args": {"qualname": 2, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 80}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"qualname": 0, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 381}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 11, "signature": 0, "bases": 0, "doc": 3}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 362}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 194}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 6, "signature": 0, "bases": 0, "doc": 86}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"qualname": 1, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 7, "bases": 0, "doc": 149}}, "length": 53, "save": true}, "index": {"qualname": {"root": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.lifespan": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 4, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.health_service": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 2}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.server.config_file": {"tf": 1}}, "df": 4}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}, "i": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 9, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 6}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 4}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "b": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.config_file": {"tf": 1}}, "df": 1}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.health_service": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 8, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 22}}}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.server.app": {"tf": 1}}, "df": 1}, "i": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 1}}}}}}, "fullname": {"root": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.server.health_service": {"tf": 1}, "streamlit_healthcheck.server.config_file": {"tf": 1}, "streamlit_healthcheck.server.lifespan": {"tf": 1}, "streamlit_healthcheck.server.app": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 53, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 8}}}}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.server.health_service": {"tf": 1}, "streamlit_healthcheck.server.config_file": {"tf": 1}, "streamlit_healthcheck.server.lifespan": {"tf": 1}, "streamlit_healthcheck.server.app": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 14}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.health_service": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 2}}}, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.health_service": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 8, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.server.health_service": {"tf": 1}, "streamlit_healthcheck.server.config_file": {"tf": 1}, "streamlit_healthcheck.server.lifespan": {"tf": 1}, "streamlit_healthcheck.server.app": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 53, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 22}}}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.lifespan": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.server.config_file": {"tf": 1}}, "df": 4}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}, "i": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 6}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 9, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}}, "df": 2}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 6}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 4}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "b": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "f": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.config_file": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}}, "df": 2}}, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.server.app": {"tf": 1}}, "df": 1}, "i": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 1}}}}}}, "annotation": {"root": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}, "streamlit_healthcheck.server.health_service": {"tf": 1}, "streamlit_healthcheck.server.config_file": {"tf": 1}}, "df": 3, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}}, "df": 1}}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.server.config_file": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.health_service": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.server.health_service": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.health_service": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}, "default_value": {"root": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.app": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}}, "df": 7, "l": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.server.app": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 7}, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1, "r": {"docs": {"streamlit_healthcheck.server.logger": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.logger": {"tf": 1}, "streamlit_healthcheck.server.logger": {"tf": 1}, "streamlit_healthcheck.server.app": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 7}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.health_service": {"tf": 1}, "streamlit_healthcheck.server.config_file": {"tf": 1}}, "df": 2}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"streamlit_healthcheck.server.app": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.app": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.app": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2}}}}}}}}}, "signature": {"root": {"0": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 2}}, "df": 1}, "3": {"9": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 2}}, "df": 3}, "docs": {}, "df": 0}, "8": {"0": {"0": {"0": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 3.4641016151377544}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 4.242640687119285}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 4.242640687119285}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 5.385164807134504}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 5.830951894845301}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 4.47213595499958}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 6.4031242374328485}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 3.4641016151377544}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 4.69041575982343}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 4.69041575982343}, "streamlit_healthcheck.server.lifespan": {"tf": 4.69041575982343}, "streamlit_healthcheck.server.root": {"tf": 2.6457513110645907}, "streamlit_healthcheck.server.get_health_status": {"tf": 2.6457513110645907}, "streamlit_healthcheck.server.get_system_health": {"tf": 2.6457513110645907}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 2.6457513110645907}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2.6457513110645907}, "streamlit_healthcheck.server.start_api_server": {"tf": 7.416198487095663}, "streamlit_healthcheck.server.parse_args": {"tf": 2.6457513110645907}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 2.6457513110645907}}, "df": 31, "d": {"docs": {}, "df": 0, "b": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 3}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 3}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 4}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 4}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 6}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 4}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}}, "df": 8}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 13}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 3}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 3}}}}, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"streamlit_healthcheck.server.lifespan": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 2}}, "p": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.server.lifespan": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.lifespan": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}}, "bases": {"root": {"docs": {}, "df": 0}}, "doc": {"root": {"0": {"docs": {"streamlit_healthcheck": {"tf": 2}, "streamlit_healthcheck.server.start_api_server": {"tf": 2.449489742783178}, "streamlit_healthcheck.server.parse_args": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.449489742783178}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2.449489742783178}}, "df": 6}, "1": {"2": {"7": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 3}, "docs": {}, "df": 0}, "docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 7}, "2": {"0": {"0": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}, "3": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}, "5": {"0": {"0": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 4}, "3": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}, "6": {"0": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "8": {"0": {"0": {"0": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 4}, "docs": {}, "df": 0}, "8": {"0": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "5": {"0": {"1": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 2}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "9": {"0": {"0": {"0": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"streamlit_healthcheck": {"tf": 15.652475842498529}, "streamlit_healthcheck.healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.logger": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 24.08318915758459}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 4.242640687119285}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 6.708203932499369}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 8.12403840463596}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 8.306623862918075}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 5.916079783099616}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 14.38749456993816}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 7.14142842854285}, "streamlit_healthcheck.healthcheck.HealthCheckService.logger": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.config_path": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.health_data": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.config": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_interval": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_url": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.streamlit_port": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 6.557438524302}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 4}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 4.58257569495584}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 5.0990195135927845}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 6.082762530298219}, "streamlit_healthcheck.server": {"tf": 8.426149773176359}, "streamlit_healthcheck.server.logger": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.health_service": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.config_file": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.lifespan": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.app": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.root": {"tf": 4.358898943540674}, "streamlit_healthcheck.server.get_health_status": {"tf": 6.48074069840786}, "streamlit_healthcheck.server.get_system_health": {"tf": 7.483314773547883}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 5.916079783099616}, "streamlit_healthcheck.server.get_pages_health": {"tf": 6.928203230275509}, "streamlit_healthcheck.server.start_api_server": {"tf": 9.16515138991168}, "streamlit_healthcheck.server.parse_args": {"tf": 3.7416573867739413}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 12.96148139681572}, "streamlit_healthcheck.streamlit-healthcheck-cli.logger": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 9.643650760992955}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 5.916079783099616}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 3.1622776601683795}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 5.744562646538029}}, "df": 53, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 4, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.4641016151377544}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2, "r": {"docs": {"streamlit_healthcheck": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 13, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.872983346207417}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 3.3166247903554}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 2.449489742783178}, "streamlit_healthcheck.server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 3}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.6457513110645907}}, "df": 14, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}}, "df": 4}}}}}}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2, "d": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1}, "/": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 3}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 2}, "streamlit_healthcheck.server": {"tf": 2}, "streamlit_healthcheck.server.get_health_status": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 19, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}}, "df": 2, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 2}}}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}}, "df": 1}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2}}, "df": 6, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}}, "df": 2}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 5}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 3}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 3}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 4}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}}}}, "b": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 2}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 3, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 2}}}}}}}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 3}}}}}}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 2, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 2}}, "df": 5}}}}}, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}}, "df": 2}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 6}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.root": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.get_system_health": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 2.449489742783178}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}}, "df": 13, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}}, "df": 3, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 2.8284271247461903}, "streamlit_healthcheck.server.parse_args": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.449489742783178}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2.23606797749979}}, "df": 9}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 7, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 9}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 3}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}}, "df": 3}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 4}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 5}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "q": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"3": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}, "docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.4641016151377544}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}}, "df": 4}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 1}, "d": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 3}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}}, "df": 1}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 5}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.449489742783178}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 3.3166247903554}, "streamlit_healthcheck.server": {"tf": 3.7416573867739413}, "streamlit_healthcheck.server.root": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 3.605551275463989}, "streamlit_healthcheck.server.get_system_health": {"tf": 3.4641016151377544}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 3}, "streamlit_healthcheck.server.get_pages_health": {"tf": 3.4641016151377544}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.6457513110645907}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}}, "df": 29, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck": {"tf": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.8284271247461903}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 5, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 4}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "z": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 2}, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.7320508075688772}}, "df": 6}, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}}}}}}, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 6, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}}}}, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 2, ":": {"8": {"5": {"0": {"1": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 2}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 2}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 3}, "r": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.parse_args": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}}, "df": 7, "/": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}}, "df": 1, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}}}}}}}}, "w": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 5, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 4}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 5}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 4, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 2, "d": {"docs": {"streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 3}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}}, "df": 1}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 2.449489742783178}, "streamlit_healthcheck.server.parse_args": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.7320508075688772}}, "df": 9, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 2, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 4}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 2}}}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1.4142135623730951}}, "df": 3}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 6.557438524302}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 3}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 3}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 11, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2}}, "df": 7}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}}}, "h": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}}, "df": 15, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 6}, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 1}, "d": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 1}, "r": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 4}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}}}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 6, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}, "[": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 4}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.lifespan": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 4, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 8}, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.7320508075688772}}, "df": 9}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2}}, "df": 7, "/": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 10}}, "w": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 2, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}}}}}}}, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 4, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.7320508075688772}}, "df": 11, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 3}}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 6, "x": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 6}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 2}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}, "d": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 3}}, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 2, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 11, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 12}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 6, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 5}}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 5}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 7.14142842854285}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 3.3166247903554}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_system_health": {"tf": 2}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 20, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 5.916079783099616}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 14}}}}}, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 6}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 5}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 2}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 2}}}}}}}}, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 11}}}, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 6, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 8}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 3}, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 11}}}}, "n": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 4}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 6}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}}, "df": 6}, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 2}}}, "i": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}}, "df": 4}, "r": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 4}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 4.69041575982343}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2}, "streamlit_healthcheck.server.start_api_server": {"tf": 3.1622776601683795}, "streamlit_healthcheck.server.parse_args": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.8284271247461903}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.449489742783178}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2.8284271247461903}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 2}}, "df": 28, "p": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 2}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 2}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 3, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 7}}}}}}}, "p": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 7.416198487095663}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 3.3166247903554}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 3.4641016151377544}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 4}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 3.3166247903554}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 2.23606797749979}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.root": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_health_status": {"tf": 2.8284271247461903}, "streamlit_healthcheck.server.get_system_health": {"tf": 3.1622776601683795}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 3.1622776601683795}, "streamlit_healthcheck.server.get_pages_health": {"tf": 3.4641016151377544}, "streamlit_healthcheck.server.start_api_server": {"tf": 4}, "streamlit_healthcheck.server.parse_args": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 3}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 3.3166247903554}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 3.4641016151377544}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 3}}, "df": 36, "m": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 3}, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 3}, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 12}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}}, "df": 6}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 3}}, "df": 4, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}}, "df": 2}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 3}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 17}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 2}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 3}}, "m": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}}, "df": 1, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}}}}}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 7, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}}}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 4}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 12, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 3}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 6}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 5, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 2}}}}, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 4}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 4}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "/": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}, "l": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 8, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 2}, "streamlit_healthcheck.server.root": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 25}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 6}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 4, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 5}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 3}}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}}}}}}}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 7, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 4}}}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 4}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2}}}}}}, "t": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 8}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 13}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "w": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2}}, "df": 3}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {"streamlit_healthcheck": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 4.123105625617661}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.root": {"tf": 2}, "streamlit_healthcheck.server.get_health_status": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.get_system_health": {"tf": 2}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 2}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 3.3166247903554}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 26, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 2}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 17, "d": {"docs": {"streamlit_healthcheck": {"tf": 4.123105625617661}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 5.196152422706632}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 3.4641016151377544}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 3.1622776601683795}, "streamlit_healthcheck.server": {"tf": 2}, "streamlit_healthcheck.server.root": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.parse_args": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.8284271247461903}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 2}}, "df": 32, "/": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 17}}, "p": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 5, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.lifespan": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 9, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 4}}}}}}}}}, "i": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.7320508075688772}}, "df": 10, "s": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 18, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 4, "h": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 3}}}}}}}}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}}}, "g": {"docs": {}, "df": 0, "i": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}}, "df": 1, "/": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 10, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 2}}}}}}, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 4}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 3}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 13}, "g": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 7}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}}, "df": 3}}}}}}, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "j": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}}, "df": 4}}}}}}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 1}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 3}}}}, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 2}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 2}}}}}}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 5}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}}}}}}}, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 3}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.stop": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 2}, "streamlit_healthcheck.server": {"tf": 2}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.6457513110645907}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}}, "df": 17, "s": {"docs": {"streamlit_healthcheck": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 3.872983346207417}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 2}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.6457513110645907}}, "df": 18}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 3}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 2}}}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 2.6457513110645907}, "streamlit_healthcheck.server.parse_args": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.8284271247461903}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 12, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 2}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.6457513110645907}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 2.23606797749979}}, "df": 14}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}}, "df": 2}}}}, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 9}, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.lifespan": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 6, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 7}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}}, "df": 5, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 7, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "d": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}}, "df": 2}}, "l": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 2}}}}}}}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}}}}}}, "i": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}}, "df": 1, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_custom_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 8, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 1}}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.set_page_context": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 7}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 4}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 10}, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 5}}, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 4}}}}}, "n": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 3}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 10}}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 4, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}}, "df": 1}}}, "n": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "p": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 4}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 6}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.449489742783178}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 2}}, "df": 4, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 4}}}, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 3}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}}, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 13, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 7}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 5}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}}, "d": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 13}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 5}}}}, "m": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2}}, "df": 1, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 3, "/": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}}, "df": 6, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 2}}}}, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 14, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 6}}}}}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 6}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "r": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 1}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}}, "df": 2}}}, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 5}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2}, "r": {"docs": {"streamlit_healthcheck.server.lifespan": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 6}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.7320508075688772}}, "df": 9}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 1}}}}}}}}}}}, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}}, "df": 2}}}, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}}, "df": 3}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck": {"tf": 3.3166247903554}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.605551275463989}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.8284271247461903}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 2}, "streamlit_healthcheck.server": {"tf": 2}, "streamlit_healthcheck.server.lifespan": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 24, "w": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 6}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 13}}, "e": {"docs": {}, "df": 0, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 3}}}}}}, "t": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 4, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 2}}}, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {"streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.lifespan": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2}}, "df": 6, "/": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 2}}}}, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 13, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.start_api_server": {"tf": 2}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}}, "df": 11, "s": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 14, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1, "[": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 2}}}}}}}, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 2.449489742783178}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.start_api_server": {"tf": 2.23606797749979}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 23, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 2}}}}, "o": {"8": {"6": {"0": {"1": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}, "n": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 20, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 7, "e": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 3}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 3, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}}, "df": 2}}}}, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 4}}}}}, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}}, "df": 1}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 5}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}}, "df": 1}}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}}}}}}}, "u": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 1}}}}}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}}, "df": 2, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 4}, "d": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}}, "df": 4}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2}}}}}}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 7, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 1}}}}}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 2}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}, "d": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 3}}}}}}}}}}, "f": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.1622776601683795}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_system_health": {"tf": 2}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 23}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1}}}}}}}}}, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "/": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1}}, "p": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 3}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 2, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}}, "df": 2}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 3}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 6}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 2}}, "df": 1}}}}}}}}}, "g": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 2}}, "df": 5}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.parse_args": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2.449489742783178}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 7, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.7320508075688772}}, "df": 5}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}}, "df": 2, "/": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 3}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 2}}}}}}}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 11, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 10}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 3}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 4}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "k": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 5}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 9}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.run_all_checks": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 2.6457513110645907}, "streamlit_healthcheck.server.get_system_health": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 2}, "streamlit_healthcheck.server.get_pages_health": {"tf": 2}}, "df": 15, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.7416573867739413}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}}, "df": 5, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.4142135623730951}}, "df": 2}}}}}}}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 4}}}, "b": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 5.196152422706632}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 6}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 2}}}}}}}}, "j": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 2}}}}}}}}, "r": {"docs": {"streamlit_healthcheck": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2.6457513110645907}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1.4142135623730951}}, "df": 23, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 3, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}}}}}}, "k": {"docs": {"streamlit_healthcheck": {"tf": 1.4142135623730951}}, "df": 1}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 4, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}}, "[": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 3}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "|": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 1}}}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}}, "df": 2, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 2}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 3}}}}}}, "f": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 3.3166247903554}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 2}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 21, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 3, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 2}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 6}}}}}, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_dependencies": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 2}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 15, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}}, "df": 4}}, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 3}, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 3, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}}, "df": 4}}}}}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}}, "df": 7, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 3}}, "p": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 2}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1.4142135623730951}}, "df": 20, "i": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 6}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 10}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 6}, "r": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}}, "df": 4}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "b": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 2}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 6, "/": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}}, "v": {"3": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}}, "df": 1, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}}, "df": 4, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 3}}}}}}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 8}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"streamlit_healthcheck.healthcheck.health_check": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.server.get_system_health": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1}}, "df": 1}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}}, "df": 2}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.8284271247461903}, "streamlit_healthcheck.server.start_api_server": {"tf": 2}}, "df": 2}}}}, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 6, "t": {"docs": {"streamlit_healthcheck": {"tf": 3.872983346207417}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 5.196152422706632}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.7320508075688772}}, "df": 4}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1}}, "df": 1}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.server": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 3}}}}, "n": {"docs": {}, "df": 0, "u": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 2}, "streamlit_healthcheck.healthcheck.HealthCheckService.get_health_data": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_server": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}}, "df": 9, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.server": {"tf": 1}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1.4142135623730951}}, "df": 8, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}}, "df": 4, "t": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.init": {"tf": 1}}, "df": 12, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 10}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}, "n": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 5, "e": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.449489742783178}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.start": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_cpu": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_memory": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_disk": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.check_streamlit_pages": {"tf": 1}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 13}}, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 2}, "d": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 2.6457513110645907}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.monitor_page": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.clear_errors": {"tf": 2.23606797749979}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.register_custom_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.root": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 11, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.main": {"tf": 1}}, "df": 2}}}}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 1.7320508075688772}}, "df": 3}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.load_errors_from_db": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli.serve": {"tf": 1}}, "df": 2}}}}}}, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor.save_errors_to_db": {"tf": 1.4142135623730951}, "streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1.7320508075688772}, "streamlit_healthcheck.healthcheck.HealthCheckService.__init__": {"tf": 1}, "streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 2}, "streamlit_healthcheck.healthcheck.health_check": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.root": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 1}, "streamlit_healthcheck.server.get_system_health": {"tf": 1}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1}, "streamlit_healthcheck.server.start_api_server": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.parse_args": {"tf": 1}, "streamlit_healthcheck.streamlit-healthcheck-cli": {"tf": 2}}, "df": 15, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService.save_config": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"streamlit_healthcheck.server.root": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_health_status": {"tf": 2}, "streamlit_healthcheck.server.get_system_health": {"tf": 1.7320508075688772}, "streamlit_healthcheck.server.get_dependencies_health": {"tf": 1.4142135623730951}, "streamlit_healthcheck.server.get_pages_health": {"tf": 1.4142135623730951}}, "df": 5}}}}}}}}}}}, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.HealthCheckService": {"tf": 1}}, "df": 1}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {"streamlit_healthcheck": {"tf": 1}, "streamlit_healthcheck.healthcheck.StreamlitPageMonitor": {"tf": 1.4142135623730951}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "j": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"streamlit_healthcheck": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"streamlit_healthcheck.healthcheck.StreamlitPageMonitor.get_page_errors": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "l": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1}}, "df": 1}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"streamlit_healthcheck.streamlit-healthcheck-cli.cli": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();