# 📧 IonQ Azure Quantum Access Request

**Status**: ⏳ Opcional - Por si también quieres solicitar IonQ
**Fecha creación**: October 3, 2025

---

## 📋 Información de tu Azure Subscription

**Azure Subscription ID**: `3874d707-c862-40b9-8e5c-2e1474cbce4f`
**Subscription Name**: Azure subscription 1
**Resource Group**: bioql-quantum-rg
**Tenant ID**: 7a5f1b94-f738-467b-aaa0-32644452eade
**Location**: eastus

---

## ✉️ EMAIL PARA ENVIAR

**Para**: partnerships@ionq.co
**Asunto**: Azure Quantum Access Request - BioQL Quantum Drug Discovery Platform

**Cuerpo del email**:

```
Dear IonQ Partnerships Team,

I am writing to request access to IonQ quantum computing services through Azure Quantum for our BioQL project, a quantum bioinformatics platform focused on accelerating drug discovery and molecular simulations.

PROJECT DETAILS:
================

Project Name: BioQL (Biological Query Language)
Purpose: Quantum-accelerated drug discovery and molecular simulation
Website: https://pypi.org/project/bioql/
Version: 3.1.0 (Production - deployed on PyPI)

Use Cases:
- Quantum molecular docking simulations
- Protein-ligand interaction modeling
- Drug candidate screening using quantum algorithms
- Molecular energy calculations with VQE
- Optimization of drug compounds using QAOA

AZURE QUANTUM DETAILS:
=====================

Azure Subscription ID: 3874d707-c862-40b9-8e5c-2e1474cbce4f
Subscription Name: Azure subscription 1
Tenant ID: 7a5f1b94-f738-467b-aaa0-32644452eade
Resource Group: bioql-quantum-rg
Workspace Name: bioql-quantum-workspace (pending creation)
Location: eastus

Requested SKU: committed-subscription-2 (or any available pay-as-you-go option)
Provider: IonQ

TECHNICAL BACKGROUND:
====================

BioQL is a production-ready platform (v3.1.0) that provides:
- Natural language interface to quantum algorithms
- Pre-built quantum circuits for drug discovery
- Multi-backend support (IBM Quantum, simulators, and expanding to IonQ)
- Advanced circuit optimization and cost management
- Deployed on PyPI with active users

We are specifically interested in IonQ's trapped-ion quantum systems because:
- High-fidelity qubits ideal for chemistry simulations
- All-to-all qubit connectivity beneficial for molecular modeling
- Excellent coherence times for complex drug discovery algorithms

Expected Usage:
- Integration and testing (Q4 2025)
- Production drug discovery workflows
- Benchmarking against other quantum backends
- Academic research collaboration

INFRASTRUCTURE READY:
====================

We have already configured:
✅ Azure Resource Group (bioql-quantum-rg)
✅ Storage Account (bioqlstorage39472)
✅ Microsoft.Quantum provider registered
✅ Microsoft.Storage provider registered
✅ BioQL platform v3.1.0 deployed and tested

We are ready to create the Azure Quantum Workspace immediately upon approval.

PROJECT IMPACT:
==============

BioQL aims to democratize quantum-accelerated drug discovery by:
- Making quantum computing accessible to bioinformatics researchers
- Providing optimized quantum circuits for molecular simulations
- Enabling multi-vendor quantum hardware comparison
- Accelerating the drug discovery pipeline

Access to IonQ's quantum systems would:
- Enable high-fidelity molecular simulations
- Provide users with industry-leading quantum hardware
- Advance quantum bioinformatics research
- Demonstrate real-world quantum advantage in drug discovery

CONTACT INFORMATION:
===================

Project: BioQL v3.1.0
Azure Subscription: 3874d707-c862-40b9-8e5c-2e1474cbce4f
Location: eastus

I am available for a call or meeting to discuss our use case, expected usage patterns, and partnership opportunities.

Please advise on the next steps to enable IonQ access through Azure Quantum.

Thank you for your consideration.

Best regards,

[YOUR NAME]
[YOUR TITLE/AFFILIATION]
[YOUR EMAIL]
[YOUR PHONE - optional]

---

Additional Information:
- BioQL on PyPI: https://pypi.org/project/bioql/
- Project GitHub: [if applicable]
- LinkedIn: [if applicable]
```

---

## 📝 INSTRUCCIONES PARA ENVIAR

### Paso 1: Copiar el Email
Copia el texto desde "Dear IonQ Partnerships Team..." hasta tu firma.

### Paso 2: Personalizar
Reemplaza:
- `[YOUR NAME]`
- `[YOUR TITLE/AFFILIATION]`
- `[YOUR EMAIL]`
- `[YOUR PHONE - optional]`

### Paso 3: Enviar
1. **Para**: partnerships@ionq.co
2. **Asunto**: Azure Quantum Access Request - BioQL Quantum Drug Discovery Platform
3. Pega el email personalizado
4. Enviar desde el email de tu cuenta Azure

---

## ⏱️ Timeline Esperado

- Email enviado: Hoy
- Respuesta inicial: 3-7 días
- Revisión: 1-2 semanas
- Aprobación: 2-4 semanas total

---

**💡 Nota**: IonQ también requiere aprobación, pero puedes solicitar acceso a ambos (IonQ y Quantinuum) simultáneamente para tener más opciones.

*Creado: October 3, 2025*
