-- noqa: disable=all
-- This sql was autogenerated as a reference example using the library
-- CLI. Its format is tied to the specific database it was run against,
-- and it may not be correct for all databases. Use the CLI's build 
-- option to derive the best SQL for your dataset.

-- ###########################################################

CREATE TABLE core__condition_dn_category AS (
    WITH

    flattened_rows AS (
        WITH
        data_and_row_num AS (
            SELECT
                t.id AS id,
                generate_subscripts(t."category", 1) AS row,
                UNNEST(t."category") AS "category" -- must unnest in SELECT here
            FROM condition AS t
        )
        SELECT
            id,
            row,
            "category"
        FROM data_and_row_num
    ),

    system_category_0 AS (
        SELECT DISTINCT
            s.id AS id,
            s.row,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            flattened_rows AS s,
            UNNEST(s.category.coding) AS u (coding)
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            row,
            system,
            code,
            display,
            userSelected
        FROM system_category_0
        
    )
    SELECT
        id,
        row,
        code,
        system,
        display,
        userSelected
    FROM union_table
);


-- ###########################################################

CREATE TABLE core__condition_dn_clinical_status AS (
    WITH

    system_clinicalStatus_0 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '0' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.clinicalStatus.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://terminology\.hl7\.org/CodeSystem/condition-clinical$')
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_clinicalStatus_0
        
    ),

    partitioned_table AS (
        SELECT
            id,
            row,
            code,
            system,
            display,
            userSelected,
            priority,
            ROW_NUMBER()
                OVER (
                    PARTITION BY id
                    ORDER BY priority ASC, code ASC
                ) AS available_priority
        FROM union_table
        GROUP BY
            id, row, priority, system, code, display, userSelected
    )

    SELECT
        id,
        code,
        system,
        display,
        userSelected
    FROM partitioned_table
    WHERE available_priority = 1
);


-- ###########################################################

CREATE TABLE core__condition_codable_concepts_display AS (
    WITH

    system_code_0 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '0' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://snomed\.info/sct$')
    ), --noqa: LT07

    system_code_1 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '1' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://hl7\.org/fhir/sid/icd-10-cm$')
    ), --noqa: LT07

    system_code_2 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '2' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://hl7\.org/fhir/sid/icd-9-cm$')
    ), --noqa: LT07

    system_code_3 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '3' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://hl7\.org/fhir/sid/icd-9-cm/diagnosis$')
    ), --noqa: LT07

    system_code_4 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '4' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^urn:oid:1\.2\.840\.114350\.1\.13\.71\.2\.7\.2\.728286$')
    ), --noqa: LT07

    system_code_5 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '5' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^urn:oid:1\.2\.840\.114350\.1\.13\.71\.2\.7\.4\.698084\.10375$')
    ), --noqa: LT07

    system_code_6 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '6' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://terminology\.hl7\.org/CodeSystem/data-absent-reason$')
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_code_0
        UNION
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_code_1
        UNION
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_code_2
        UNION
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_code_3
        UNION
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_code_4
        UNION
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_code_5
        UNION
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_code_6
        
    ),

    partitioned_table AS (
        SELECT
            id,
            row,
            code,
            system,
            display,
            userSelected,
            priority,
            ROW_NUMBER()
                OVER (
                    PARTITION BY id
                    ORDER BY priority ASC, code ASC
                ) AS available_priority
        FROM union_table
        GROUP BY
            id, row, priority, system, code, display, userSelected
    )

    SELECT
        id,
        code,
        system,
        display,
        userSelected
    FROM partitioned_table
    WHERE available_priority = 1
);


-- ###########################################################

CREATE TABLE core__condition_codable_concepts_all AS (
    WITH

    system_code_0 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.code.coding) AS u (coding)
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            row,
            system,
            code,
            display,
            userSelected
        FROM system_code_0
        
    )
    SELECT
        id,
        code,
        system,
        display,
        userSelected
    FROM union_table
);


-- ###########################################################

CREATE TABLE core__condition_dn_verification_status AS (
    WITH

    system_verificationStatus_0 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            '0' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            condition AS s,
            UNNEST(s.verificationStatus.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://terminology\.hl7\.org/CodeSystem/condition-ver-status$')
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_verificationStatus_0
        
    ),

    partitioned_table AS (
        SELECT
            id,
            row,
            code,
            system,
            display,
            userSelected,
            priority,
            ROW_NUMBER()
                OVER (
                    PARTITION BY id
                    ORDER BY priority ASC, code ASC
                ) AS available_priority
        FROM union_table
        GROUP BY
            id, row, priority, system, code, display, userSelected
    )

    SELECT
        id,
        code,
        system,
        display,
        userSelected
    FROM partitioned_table
    WHERE available_priority = 1
);


-- ###########################################################



CREATE TABLE core__condition AS
WITH temp_condition AS (
    SELECT
        c.id,
        c.subject.reference AS subject_ref,
        c.encounter.reference AS encounter_ref,
        cca.code,
        cca.system,
        cca.display,
        cast(from_iso8601_timestamp(c.recordedDate) AS date) AS recordedDate,
        date_trunc('week', cast(from_iso8601_timestamp(c."recordedDate") AS date))
            AS recordedDate_week,
        date_trunc('month', cast(from_iso8601_timestamp(c."recordedDate") AS date))
            AS recordedDate_month,
        date_trunc('year', cast(from_iso8601_timestamp(c."recordedDate") AS date))
            AS recordedDate_year
    FROM condition AS c
    LEFT JOIN core__condition_codable_concepts_all AS cca ON c.id = cca.id
)

SELECT
    tc.id,
    cdc.code AS category_code,
    cdc.system AS category_system,
    cdc.display AS category_display,
    tc.code,
    tc.system,
    tc.display AS code_display,
    tc.subject_ref,
    tc.encounter_ref,
    concat('Condition/', tc.id) AS condition_ref,
    tc.recordedDate,
    tc.recordedDate_week,
    tc.recordedDate_month,
    tc.recordedDate_year,
    cdcs.code AS clinicalStatus_code,
    cdvs.code AS verificationStatus_code
FROM temp_condition AS tc
LEFT JOIN core__condition_dn_category AS cdc ON tc.id = cdc.id
LEFT JOIN core__condition_dn_clinical_status AS cdcs ON tc.id = cdcs.id
LEFT JOIN core__condition_dn_verification_status AS cdvs ON tc.id = cdvs.id;
