-- noqa: disable=all
-- This sql was autogenerated as a reference example using the library
-- CLI. Its format is tied to the specific database it was run against,
-- and it may not be correct for all databases. Use the CLI's build 
-- option to derive the best SQL for your dataset.

-- ###########################################################

CREATE TABLE core__documentreference_dn_type AS (
    WITH

    system_type_0 AS (
        SELECT DISTINCT
            s.id AS id,
            0 AS row,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            documentreference AS s,
            UNNEST(s.type.coding) AS u (coding)
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            row,
            system,
            code,
            display,
            userSelected
        FROM system_type_0
        
    )
    SELECT
        id,
        code,
        system,
        display,
        userSelected
    FROM union_table
);


-- ###########################################################

CREATE TABLE core__documentreference_dn_category AS (
    WITH

    flattened_rows AS (
        WITH
        data_and_row_num AS (
            SELECT
                t.id AS id,
                generate_subscripts(t."category", 1) AS row,
                UNNEST(t."category") AS "category" -- must unnest in SELECT here
            FROM documentreference AS t
        )
        SELECT
            id,
            row,
            "category"
        FROM data_and_row_num
    ),

    system_category_0 AS (
        SELECT DISTINCT
            s.id AS id,
            s.row,
            '0' AS priority,
            u.coding.code,
            u.coding.display,
            u.coding.system,
            u.coding.userSelected
        FROM
            flattened_rows AS s,
            UNNEST(s.category.coding) AS u (coding)
        WHERE
            REGEXP_LIKE(u.coding.system, '^http://hl7\.org/fhir/us/core/ValueSet/us-core-documentreference-category$')
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            row,
            priority,
            system,
            code,
            display,
            userSelected
        FROM system_category_0
        
    ),

    partitioned_table AS (
        SELECT
            id,
            row,
            code,
            system,
            display,
            userSelected,
            priority,
            ROW_NUMBER()
                OVER (
                    PARTITION BY id
                    ORDER BY priority ASC, code ASC
                ) AS available_priority
        FROM union_table
        GROUP BY
            id, row, priority, system, code, display, userSelected
    )

    SELECT
        id,
        row,
        code,
        system,
        display,
        userSelected
    FROM partitioned_table
    WHERE available_priority = 1
);


-- ###########################################################

CREATE TABLE core__documentreference_dn_format AS (
    WITH

    system_format_0 AS (
        SELECT DISTINCT
            s.id AS id,
            u.parent_col.format.code,
            u.parent_col.format.display,
            u.parent_col.format.system
        FROM
            documentreference AS s,
            UNNEST(s.content) AS u (parent_col)
    ), --noqa: LT07

    union_table AS (
        SELECT
            id,
            system,
            code,
            display
        FROM system_format_0
        
    )
    SELECT
        id,
        code,
        system,
        display
    FROM union_table
);


-- ###########################################################


-- noqa: PRS
CREATE TABLE core__documentreference AS
WITH temp_documentreference AS (
    SELECT DISTINCT
        dr.id,
        dr.status,
        dr.docStatus,
        dr.context,
        dr.subject.reference AS subject_ref,
        cast(from_iso8601_timestamp(dr.date) AS date) AS date,
        date_trunc('day', cast(from_iso8601_timestamp(dr."context"."period"."start") AS date))
            AS author_day,
        date_trunc('week', cast(from_iso8601_timestamp(dr."context"."period"."start") AS date))
            AS author_week,
        date_trunc('month', cast(from_iso8601_timestamp(dr."context"."period"."start") AS date))
            AS author_month,
        date_trunc('year', cast(from_iso8601_timestamp(dr."context"."period"."start") AS date))
            AS author_year,
        cdrt.code as type_code,
        cdrt.system as type_system,
        cdrt.display as type_display,
        cdrc.code as category_code,
        cdrf.code as format_code
    FROM documentreference AS dr
    LEFT JOIN core__documentreference_dn_type AS cdrt ON dr.id = cdrt.id
    LEFT JOIN core__documentreference_dn_category AS cdrc ON dr.id = cdrc.id
    LEFT JOIN core__documentreference_dn_format AS cdrf ON dr.id = cdrf.id
),

temp_encounters AS (
    SELECT
        tdr.id,


        context_encounter.encounter.reference AS encounter_ref
    FROM temp_documentreference AS tdr,
         unnest(context.encounter) AS context_encounter (encounter) --noqa


)

SELECT DISTINCT
    tdr.id,
    tdr.status,
    tdr.type_code,
    tdr.type_system,
    tdr.type_display,
    tdr.category_code,
    tdr.docStatus,
    tdr."date",
    tdr.author_day,
    tdr.author_week,
    tdr.author_month,
    tdr.author_year,
    tdr.format_code,
    tdr.subject_ref,
    te.encounter_ref,
    concat('DocumentReference/', tdr.id) AS documentreference_ref
FROM temp_documentreference AS tdr
LEFT JOIN temp_encounters AS te ON tdr.id = te.id;
