<!-- The Begin and End comments throughout this document are used in order to pull specific sections of the readme into the main GUI window at runtime. -->

# Randovania

Welcome to Randovania, a randomizer platform for a multitude of games.

New here or looking to install? Check [our website](https://randovania.org/). It also contains the list of supported games.

<!-- Begin WELCOME -->

Randovania can randomize many aspects of its supported games, all while still ensuring they're completable
without using any glitches or exploits. Its features include:

* Randomizing what can be found in each item location. Weapons, keys, and more can end up in
  completely new places.

* Use Multiworld sessions to shuffle items between multiple separate games, alone or with friends.
  All Multiworld games are compatible with each other - mix and match as you like!

* Randomize how areas connect to one another, or what resources are required to travel between areas.
  These options are highly customizable, letting you limit or unleash the chaos.

* Randomize your starting equipment and location. Feeling brave? You can even shuffle items
  you normally start with.

Have fun and start randomizing!

<!-- End WELCOME -->

# Installation

In the [releases page](https://github.com/randovania/randovania/releases), we have zip files
with everything ready to use. Just extract and run!

For Linux users, we recommend using our [Flatpak](https://flathub.org/apps/io.github.randovania.Randovania) instead.

<!-- Begin COMMUNITY -->

# Community

Join the Randovania Discord: <https://discord.gg/M23gCxj6fw>

Invite links for specific games' servers can be found in the `#game-communities` channel in our server.

<!-- End COMMUNITY -->

<!-- Begin CREDITS -->

# Credits

GUI and logic written by [Henrique Gemignani](https://github.com/henriquegemignani/), with contributions
by [SpaghettiToastBook](https://www.twitch.tv/spaghettitoastbook), [gollop](https://github.com/gollop) and [many others](https://github.com/randovania/randovania/graphs/contributors).

[BashPrime](https://www.twitch.tv/bashprime), [Pwootage](https://github.com/Pwootage), and [April Wade](https://github.com/aprilwade) made <https://randomizer.metroidprime.run/>, from which the GUI was based.

Website created by [Hugoshido](https://twitch.tv/hugoshido) and [duncathan_salt](https://twitter.com/duncathan_salt). portfolYOU Jekyll theme by Youssef Raafat. Free for personal and commercial use under the [MIT license](https://github.com/YoussefRaafatNasry/portfolYOU/blob/master/LICENSE).

Installer is powered by [Advanced Installer](https://www.advancedinstaller.com/), which has graciously provided us with an open source license.

Linux Flatpak build contributed by [Ethan Lee](https://flibitijibibo.com/).

## Games

### Metroid Prime
* Game patching via [randomprime](https://github.com/randovania/randomprime). Originally authored by [April Wade](https://github.com/aprilwade), it is now maintained and developed by [toasterparty](https://github.com/toasterparty) with contributions from [others](https://github.com/randovania/randomprime/graphs/contributors)
* Room data collected by UltiNaruto, [EthanArmbrust](https://github.com/EthanArmbrust) and [SolventMercury](https://github.com/SolventMercury).
* Converting Metroid Prime 2 models by [Migs](https://www.twitch.tv/migslive).

### Metroid Prime 2: Echoes
* Game patching written by [Claris](https://www.twitch.tv/claris).
* Room data initially collected by Claris, revamped by [Dyceron](https://www.twitch.tv/dyceron).
* [Menu Mod](https://www.dropbox.com/s/yhqqafaxfo3l4vn/Echoes%20Menu.7z) created by Claris. For more information, see the
[Menu Mod README](https://www.dropbox.com/s/yhqqafaxfo3l4vn/Echoes%20Menu.7z?file_subpath=%2FEchoes+Menu%2Freadme.txt).
* Converting Metroid Prime models by [Migs](https://www.twitch.tv/migslive).

### Cave Story
* Patcher and logic written by [duncathan_salt](https://twitter.com/duncathan_salt).
* Based on the [original randomizer](https://shru.itch.io/cave-story-randomizer) by shru.
* Features contributions from [many others](https://github.com/cave-story-randomizer/cave-story-randomizer/graphs/contributors).

### Metroid Dread
* Game Patching by:
  * [Henrique "Darkszero" Gemignani](https://github.com/henriquegemignani/)
  * [duncathan_salt](https://twitter.com/duncathan_salt)
  * [ScorelessPine](https://github.com/ScorelessPine)
  * [Arcanox](https://twitter.com/ArcanoxDragon)
  * [Migs](https://www.twitch.tv/migslive)
  * [hyperbola0](https://github.com/steven11sjf)
  * [Thanatos](https://github.com/ThanatosGit)

* Logic Database by:
  * [KirbymastaH](https://www.twitch.tv/kirbymastah)
  * [Dyceron](https://www.twitch.tv/dyceron)
  * [XenoWars](https://www.twitch.tv/xenowars1)
  * [Mayberry](https://github.com/MayberryZoom)
  * [Hugoshido](https://twitch.tv/hugoshido)
  * [Tyranisaur](https://github.com/Tyranisaur)

* Assets by:
  * Morph Ball and Speed Booster pickup textures created by [BigSharkZ](https://www.youtube.com/BigSharkZ).
  * Spider Magnet pickup texture by duncathan_salt with help from BigSharkZ.
  * New map icons by [SkyTheLucario](https://github.com/TheSkyknight100).

### Another Metroid 2 Remake
* Game Patching by:
  * [Miepee](https://github.com/Miepee)
  * [JesRight](https://github.com/Jesright73)

* Logic Database by:
  * [Miepee](https://github.com/Miepee)
  * [DruidVorse](https://www.youtube.com/@DruidVorse)
  * [JeffGainsNGames](https://www.youtube.com/@jeffgainsngames)

* Assets by:
  * Morph Ball, and the Missile Launcher sprites were made by ShirtyScarab554 licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).
  * Power Grip and the Shiny Nothing Orb were made by ShirtyScarab554, used under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/), modified by [AbyssalCreature](https://github.com/AbyssalCreature) and licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).
  * New door sprites and other AM2R item sprites were made by [AbyssalCreature](https://github.com/AbyssalCreature) licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

### Metroid: Samus Returns
* Game Patching by:
  * [Dyceron](https://www.twitch.tv/dyceron)
  * [Thanatos](https://github.com/ThanatosGit)
  * [Henrique "Darkszero" Gemignani](https://github.com/henriquegemignani/)
  * [duncathan_salt](https://twitter.com/duncathan_salt)
  * Merikatt
  * [Athebyne](https://github.com/f-raZ0R)

* Logic Database by:
  * [Dyceron](https://www.twitch.tv/dyceron)
  * [Miepee](https://github.com/Miepee)
  * [Haxaplax](https://github.com/haxaplax)

## Auto Tracker

### Primes
* Game theme assets were provided by [MaskedTAS](https://twitter.com/MaskedTAS).
* Pixel theme assets were provided by [Uncle Reggie](https://www.twitch.tv/unclereggie).

### AM2R
* AM2R 1.5.5 item sprites were made by [Eskimode7](https://twitter.com/shmegleskimo) licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).
* The AM2R DNA sprite was made by [AbyssalCreature](https://github.com/AbyssalCreature) licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).
* The AM2R Morph Ball and Power Grip sprites were made by ShirtyScarab554 licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/).

### Metroid: Samus Returns

* Game theme assets were provided by [Dyceron](https://www.twitch.tv/dyceron).

## Multiworld
Server and logic written by [Henrique "Darkszero" Gemignani](https://github.com/henriquegemignani/).

### Primes
Dolphin and Nintendont integrations written by [Henrique "Darkszero" Gemignani](https://github.com/henriquegemignani/). These were based on [Dolphin Memory Engine](https://github.com/aldelaro5/Dolphin-memory-engine) and Pwootage's Nintendont fork, respectively. In-game message alert initially written by [encounter](https://github.com/encounter).

### Cave Story
Cave Story Doukutsu and CSE2 Tweaked integations written by [duncathan_salt](https://twitter.com/duncathan_salt), [periwinkle](https://github.com/periwinkle9) and [ikuyo](https://github.com/calvarado194).

### Metroid Dread
Integration written by [Thanatos](https://github.com/ThanatosGit) and [Henrique "Darkszero" Gemignani](https://github.com/henriquegemignani/).
The "unplug" icon is by tezar tantular from [Noun Project](https://thenounproject.com/browse/icons/term/unplug/) (licensed under [CC BY 3.0](https://creativecommons.org/licenses/by/3.0/)).

### Another Metroid 2 Remake
Integration written by [Miepee](https://github.com/Miepee). Offworld sprites are licensed under [CC BY-SA 4.0](https://creativecommons.org/licenses/by-sa/4.0/) and are made by [AbyssalCreature](https://github.com/AbyssalCreature), ShirtyScarab554 and [many others](https://github.com/randovania/YAMS/blob/main/YAMS-LIB/sprites/Attribution.md).

### Metroid: Samus Returns
Integration written by [Thanatos](https://github.com/ThanatosGit).

<!-- End CREDITS -->

# Developer Help

## Dependencies

* [Git](https://git-scm.com/downloads)
* [UV](https://docs.astral.sh/uv/getting-started/installation/)
  * This is installed automatically during step 3 of `Getting started`.

## Setup

Getting started:
   1. Clone this repository. If you want to clone your fork, make sure that during the forking process you **uncheck** the `Copy main branch only` checkbox. Because the git history is needed, downloading the zip is *not* supported and will not work.
   2. Open a terminal in the repository root
   3. Run the following file:
      1. Windows: `tools/prepare_virtual_env.bat --thin`
      2. Linux/macOS: `tools/prepare_virtual_env.sh --thin`
   4. You should see "Setup finished successfully." visible when the command finishes.
   5. For certain use cases, such as exporting games or running tests, replace `--thin` with `--full`.

In order to start Randovania, open:
   1. Windows: `tools/start_client.bat`
   2. Linux/macOS: `tools/start_client.sh`

In order to update your repository:
   1. Update the git repository. (With `git pull` or anything else)
   2. Make sure that Randovania is closed.
   3. Re-run the steps from "Getting Started", starting at step 2.
      1. In case of unexpected errors, delete the `.venv` in the root of the repository and start again.
   4. Open Randovania normally.

In order to be able to export games:
   1. Run the "Getting started" step with `--full` instead of `--thin`.
   2. Start Randovania normally.

In order to run the tests:
   1. Run the "Getting started" step with `--full` instead of `--thin`.
   2. Run `uv run pytest`.

In order to run the server:
   1. Run the "Getting started" step.
   2. Run `uv run tools/prepare_dev_server_config.py` once.
   3. If you wish to use any Discord functionality, you'll need to create an app in Discord
   and fill both ids in `tools/dev-server-configuration.json`.
   4. Run the server and client. You can this on
      1. Windows with `tools/start_dev_server.bat` for the server and `tools/start_debug_client.bat` for the client
      2. Linux/macOS with `tools/start_dev_server.sh` for the server and `tools_start_debug_client.sh` for client

This repository uses [pre-commit](https://pre-commit.com/). The hook is automatically configured with
the `prepare_virtual_env` scripts.

Suggested IDE: [PyCharm Community](https://www.jetbrains.com/pycharm/download/)

## Visual Studio Code

Clone this repository and open the folder in Visual Studio Code. It suggests several useful plugins for developing which you should download and install.

If your Python is setup properly, you can use the `Create venv with all exporters` task by pressing CTRL+SHIFT+P, type in `Task`, select `Tasks: Run task` and then select the task. It will create the venv with all the dependencies installed for you.

Then make sure that the Python extension is installed and select the Python installation from the venv via CTRL+SHIFT+P and `Select Python: Interpreter`.

There is also a task defined to run all tests. To run individual tests you can utilise the `Testing` section of Visual Studio Code. You can simply run or debug a test there.

To start Randovania you can press CTRL+F5. If you only press F5, Randovania will start with a debugger. Be aware that starting with a debugger makes the application much slower.

## UV Commands

Updating a single package:
```
uv lock --upgrade-package my-dependency
```

Installing your patcher as editable:
```
uv pip install -e ..\factorio-randovania-mod\
```

## UI Files

The python files associated with the Qt Creator's UI files are created with the `tools/uic_wrapper.py` script.
It is called automatically when commiting via `pre-commit`, but you can run it manually via:

```
uvx pre-commit run qtui -a
```

# Documentation

- Unfamiliar with a term? Check the [glossary](docs/Glossary.md).
- Adding a new game? Check the [dedicated guide](docs/New%20Game.md).
- Changing a data format? Check the [migrations documentation](docs/Migrations.md).
- Working with the logic database?
  - [Read how the database is organized](docs/Database%20Format.md).
  - Read the [unfinished script for a video](docs/Database%20Editor.md) on how to use the data editor.
