from __future__ import annotations

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from randovania.gui.lib.window_manager import WindowManager
    from randovania.gui.preset_settings.preset_tab import PresetTab
    from randovania.interface_common.preset_editor import PresetEditor


def preset_tabs(editor: PresetEditor, window_manager: WindowManager) -> list[type[PresetTab]]:
    from randovania.games.prime_hunters.gui.preset_settings.prime_hunters_force_fields_tab import (
        PresetHuntersForceFields,
    )
    from randovania.games.prime_hunters.gui.preset_settings.prime_hunters_goal_tab import PresetHuntersGoal
    from randovania.games.prime_hunters.gui.preset_settings.prime_hunters_patches_tab import PresetHuntersPatches
    from randovania.games.prime_hunters.gui.preset_settings.prime_hunters_teleporters_tab import (
        PresetTeleportersHunters,
    )
    from randovania.gui.preset_settings.dock_rando_tab import PresetDockRando
    from randovania.gui.preset_settings.generation_tab import PresetGeneration
    from randovania.gui.preset_settings.hints_tab import PresetHints
    from randovania.gui.preset_settings.location_pool_tab import PresetLocationPool
    from randovania.gui.preset_settings.metroid_pickup_pool_tab import MetroidPresetPickupPool
    from randovania.gui.preset_settings.trick_level_tab import PresetTrickLevel

    return [
        PresetTrickLevel,
        PresetGeneration,
        PresetHints,
        PresetLocationPool,
        MetroidPresetPickupPool,
        PresetHuntersGoal,
        PresetHuntersPatches,
        PresetTeleportersHunters,
        PresetHuntersForceFields,
        PresetDockRando,
    ]
