"""Add user_id to log_record

Revision ID: 004150514536
Revises: 6da8778318cb
Create Date: 2025-06-27 14:27:41.163987

"""

from typing import Sequence

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "004150514536"  # pragma: allowlist secret
down_revision: str | Sequence[str] | None = "6da8778318cb"  # pragma: allowlist secret
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("log_record", schema=None) as batch_op:
        batch_op.add_column(sa.Column("user_id", sa.Integer(), nullable=True))
        batch_op.create_foreign_key(
            "fk_log_record_user_id", "app_user", ["user_id"], ["id"]
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("log_record", schema=None) as batch_op:
        batch_op.drop_constraint("fk_log_record_user_id", type_="foreignkey")
        batch_op.drop_column("user_id")

    # ### end Alembic commands ###
