# csv_embeddings_creator v1.0.4 by Bowen Chiu

這東西可以把 google sheet 或者任意 .csv 變成知識庫，未來就能拿 .pt 檔案群來做句子相似度比對了。

`csv_embeddings_creator` 是一個 Python 套件，用於從 CSV 文件中創建句子嵌入。它使用 Hugging Face Transformers 的 `paraphrase-multilingual-MiniLM-L12-v2` 模型為文本生成嵌入。該套件將文本轉換為 txt 格式並將嵌入保存為 PyTorch 張量文件。

## 安裝

在安裝 `csv_embeddings_creator` 之前，請確保您的系統已安裝 Python 3.6 或更高版本。

要安裝 `csv_embeddings_creator`，請運行以下命令：

```bash
pip install csv-embeddings-creator
```

## 使用方法

### CLI 示範用法

您可以通過以下 CLI 呼叫方法使用 `csv_embeddings_creator`：

```bash
python3 -m csv_embeddings_creator --input-folder 'input_csv_files' --output-txt-folder 'output_txt_files' --embeddings-folder 'output_embeddings' [--force]
```

其中：

- `--input-folder`：包含 CSV 文件的輸入文件夾。
- `--output-txt-folder`：輸出 txt 文件的文件夾。
- `--embeddings-folder`：輸出嵌入文件的文件夾。
- `--force`（可選）：強制重新創建嵌入，即使它們已經存在。

### Python API 示範用法

要在 Python 腳本中使用 `csv_embeddings_creator`，請按照以下步驟操作：

1. 導入 `csv_embeddings_creator`：

   ```python
   import csv_embeddings_creator
   ```

2. 使用 `create_embeddings` 函數創建嵌入：

   ```python
   input_folder = 'input_csv_files'
   output_txt_folder = 'output_txt_files'
   output_embeddings_folder = 'output_embeddings'
   force = False

   csv_embeddings_creator.create_embeddings(input_folder, output_txt_folder, output_embeddings_folder, force)
   ```

   其中：

   - `input_folder`：包含 CSV 文件的輸入文件夾。
   - `output_txt_folder`：輸出 txt 文件的文件夾。
   - `output_embeddings_folder`：輸出嵌入文件的文件夾。
   - `force`（可選）：強制重新創建嵌入，即使它們已經存在。

## 常見問題

如果您在使用 `csv_embeddings_creator` 時遇到問題，請查看以下常見問題解答。如果您仍無法解決問題，請在 GitHub 存儲庫中創建一個問題。

### Q: 我可以使用其他 Transformer 模型生成嵌入嗎？

A: 是的，您可以在 `csv_embeddings_creator.py` 文件中修改 `SentenceTransformer('paraphrase-multilingual-MiniLM-L12-v2')` 以使用其他 Hugging Face Transformer 模型。確保您已安裝所需的模型及其依賴項。

### Q: 句子嵌入的尺寸是多少？

A: 使用 `paraphrase-multilingual-MiniLM-L12-v2` 模型生成的句子嵌入的尺寸為 384。不同的 Transformer 模型可能具有不同的嵌入尺寸。

## 貢獻

我們歡迎您為 `csv_embeddings_creator` 做出貢獻！如果您有任何建議、改進或修復錯誤，請在 GitHub 存儲庫中創建一個 Pull 請求。
