# generated by datamodel-codegen:
#   filename:  declarative_component_schema.yaml

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic.v1 import BaseModel, Extra, Field
from typing_extensions import Literal


class AuthFlowType(Enum):
    oauth2_0 = 'oauth2.0'
    oauth1_0 = 'oauth1.0'


class BasicHttpAuthenticator(BaseModel):
    type: Literal['BasicHttpAuthenticator']
    username: str = Field(
        ...,
        description='The username that will be combined with the password, base64 encoded and used to make requests. Fill it in the user inputs.',
        examples=["{{ config['username'] }}", "{{ config['api_key'] }}"],
        title='Username',
    )
    password: Optional[str] = Field(
        '',
        description='The password that will be combined with the username, base64 encoded and used to make requests. Fill it in the user inputs.',
        examples=["{{ config['password'] }}", ''],
        title='Password',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class BearerAuthenticator(BaseModel):
    type: Literal['BearerAuthenticator']
    api_token: str = Field(
        ...,
        description='Token to inject as request header for authenticating with the API.',
        examples=["{{ config['api_key'] }}", "{{ config['token'] }}"],
        title='Bearer Token',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CheckStream(BaseModel):
    type: Literal['CheckStream']
    stream_names: List[str] = Field(
        ...,
        description='Names of the streams to try reading from when running a check operation.',
        examples=[['users'], ['users', 'contacts']],
        title='Stream Names',
    )


class ConstantBackoffStrategy(BaseModel):
    type: Literal['ConstantBackoffStrategy']
    backoff_time_in_seconds: Union[float, str] = Field(
        ...,
        description='Backoff time in seconds.',
        examples=[30, 30.5, "{{ config['backoff_time'] }}"],
        title='Backoff Time',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomAuthenticator(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomAuthenticator']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom authentication strategy. Has to be a sub class of DeclarativeAuthenticator. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.ShortLivedTokenAuthenticator'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomBackoffStrategy(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomBackoffStrategy']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom backoff strategy. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomBackoffStrategy'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomErrorHandler(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomErrorHandler']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom error handler. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomErrorHandler'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomIncrementalSync(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomIncrementalSync']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom incremental sync. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomIncrementalSync'],
        title='Class Name',
    )
    cursor_field: str = Field(
        ...,
        description='The location of the value on a record that will be used as a bookmark during sync.',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomPaginationStrategy(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomPaginationStrategy']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom pagination strategy. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomPaginationStrategy'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomRecordExtractor(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomRecordExtractor']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom record extraction strategy. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomRecordExtractor'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomRecordFilter(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomRecordFilter']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom record filter strategy. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomCustomRecordFilter'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomRequester(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomRequester']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom requester strategy. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomRecordExtractor'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomRetriever(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomRetriever']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom retriever strategy. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomRetriever'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomPartitionRouter(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomPartitionRouter']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom partition router. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomPartitionRouter'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomSchemaLoader(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomSchemaLoader']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom schema loader. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomSchemaLoader'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomStateMigration(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomStateMigration']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom state migration. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomStateMigration'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class CustomTransformation(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['CustomTransformation']
    class_name: str = Field(
        ...,
        description='Fully-qualified name of the class that will be implementing the custom transformation. The format is `source_<name>.<package>.<class_name>`.',
        examples=['source_railz.components.MyCustomTransformation'],
        title='Class Name',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class LegacyToPerPartitionStateMigration(BaseModel):
    class Config:
        extra = Extra.allow

    type: Optional[Literal['LegacyToPerPartitionStateMigration']] = None


class Algorithm(Enum):
    HS256 = 'HS256'
    HS384 = 'HS384'
    HS512 = 'HS512'
    ES256 = 'ES256'
    ES256K = 'ES256K'
    ES384 = 'ES384'
    ES512 = 'ES512'
    RS256 = 'RS256'
    RS384 = 'RS384'
    RS512 = 'RS512'
    PS256 = 'PS256'
    PS384 = 'PS384'
    PS512 = 'PS512'
    EdDSA = 'EdDSA'


class JwtHeaders(BaseModel):
    class Config:
        extra = Extra.forbid

    kid: Optional[str] = Field(
        None,
        description='Private key ID for user account.',
        examples=["{{ config['kid'] }}"],
        title='Key Identifier',
    )
    typ: Optional[str] = Field(
        'JWT',
        description='The media type of the complete JWT.',
        examples=['JWT'],
        title='Type',
    )
    cty: Optional[str] = Field(
        None,
        description='Content type of JWT header.',
        examples=['JWT'],
        title='Content Type',
    )


class JwtPayload(BaseModel):
    class Config:
        extra = Extra.forbid

    iss: Optional[str] = Field(
        None,
        description='The user/principal that issued the JWT. Commonly a value unique to the user.',
        examples=["{{ config['iss'] }}"],
        title='Issuer',
    )
    sub: Optional[str] = Field(
        None,
        description='The subject of the JWT. Commonly defined by the API.',
        title='Subject',
    )
    aud: Optional[str] = Field(
        None,
        description='The recipient that the JWT is intended for. Commonly defined by the API.',
        examples=['appstoreconnect-v1'],
        title='Audience',
    )


class JwtAuthenticator(BaseModel):
    type: Literal['JwtAuthenticator']
    secret_key: str = Field(
        ...,
        description='Secret used to sign the JSON web token.',
        examples=["{{ config['secret_key'] }}"],
    )
    base64_encode_secret_key: Optional[bool] = Field(
        False,
        description='When set to true, the secret key will be base64 encoded prior to being encoded as part of the JWT. Only set to "true" when required by the API.',
    )
    algorithm: Algorithm = Field(
        ...,
        description='Algorithm used to sign the JSON web token.',
        examples=['ES256', 'HS256', 'RS256', "{{ config['algorithm'] }}"],
    )
    token_duration: Optional[int] = Field(
        1200,
        description='The amount of time in seconds a JWT token can be valid after being issued.',
        examples=[1200, 3600],
        title='Token Duration',
    )
    header_prefix: Optional[str] = Field(
        None,
        description='The prefix to be used within the Authentication header.',
        examples=['Bearer', 'Basic'],
        title='Header Prefix',
    )
    jwt_headers: Optional[JwtHeaders] = Field(
        None,
        description='JWT headers used when signing JSON web token.',
        title='JWT Headers',
    )
    additional_jwt_headers: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional headers to be included with the JWT headers object.',
        title='Additional JWT Headers',
    )
    jwt_payload: Optional[JwtPayload] = Field(
        None,
        description='JWT Payload used when signing JSON web token.',
        title='JWT Payload',
    )
    additional_jwt_payload: Optional[Dict[str, Any]] = Field(
        None,
        description='Additional properties to be added to the JWT payload.',
        title='Additional JWT Payload Properties',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class RefreshTokenUpdater(BaseModel):
    refresh_token_name: Optional[str] = Field(
        'refresh_token',
        description='The name of the property which contains the updated refresh token in the response from the token refresh endpoint.',
        examples=['refresh_token'],
        title='Refresh Token Property Name',
    )
    access_token_config_path: Optional[List[str]] = Field(
        ['credentials', 'access_token'],
        description='Config path to the access token. Make sure the field actually exists in the config.',
        examples=[['credentials', 'access_token'], ['access_token']],
        title='Config Path To Access Token',
    )
    refresh_token_config_path: Optional[List[str]] = Field(
        ['credentials', 'refresh_token'],
        description='Config path to the access token. Make sure the field actually exists in the config.',
        examples=[['credentials', 'refresh_token'], ['refresh_token']],
        title='Config Path To Refresh Token',
    )
    token_expiry_date_config_path: Optional[List[str]] = Field(
        ['credentials', 'token_expiry_date'],
        description='Config path to the expiry date. Make sure actually exists in the config.',
        examples=[['credentials', 'token_expiry_date']],
        title='Config Path To Expiry Date',
    )
    refresh_token_error_status_codes: Optional[List[int]] = Field(
        [],
        description='Status Codes to Identify refresh token error in response (Refresh Token Error Key and Refresh Token Error Values should be also specified). Responses with one of the error status code and containing an error value will be flagged as a config error',
        examples=[[400, 500]],
        title='Refresh Token Error Status Codes',
    )
    refresh_token_error_key: Optional[str] = Field(
        '',
        description='Key to Identify refresh token error in response (Refresh Token Error Status Codes and Refresh Token Error Values should be also specified).',
        examples=['error'],
        title='Refresh Token Error Key',
    )
    refresh_token_error_values: Optional[List[str]] = Field(
        [],
        description='List of values to check for exception during token refresh process. Used to check if the error found in the response matches the key from the Refresh Token Error Key field (e.g. response={"error": "invalid_grant"}). Only responses with one of the error status code and containing an error value will be flagged as a config error',
        examples=[['invalid_grant', 'invalid_permissions']],
        title='Refresh Token Error Values',
    )


class OAuthAuthenticator(BaseModel):
    type: Literal['OAuthAuthenticator']
    client_id: str = Field(
        ...,
        description='The OAuth client ID. Fill it in the user inputs.',
        examples=["{{ config['client_id }}", "{{ config['credentials']['client_id }}"],
        title='Client ID',
    )
    client_secret: str = Field(
        ...,
        description='The OAuth client secret. Fill it in the user inputs.',
        examples=[
            "{{ config['client_secret }}",
            "{{ config['credentials']['client_secret }}",
        ],
        title='Client Secret',
    )
    refresh_token: Optional[str] = Field(
        None,
        description='Credential artifact used to get a new access token.',
        examples=[
            "{{ config['refresh_token'] }}",
            "{{ config['credentials]['refresh_token'] }}",
        ],
        title='Refresh Token',
    )
    token_refresh_endpoint: str = Field(
        ...,
        description='The full URL to call to obtain a new access token.',
        examples=['https://connect.squareup.com/oauth2/token'],
        title='Token Refresh Endpoint',
    )
    access_token_name: Optional[str] = Field(
        'access_token',
        description='The name of the property which contains the access token in the response from the token refresh endpoint.',
        examples=['access_token'],
        title='Access Token Property Name',
    )
    expires_in_name: Optional[str] = Field(
        'expires_in',
        description='The name of the property which contains the expiry date in the response from the token refresh endpoint.',
        examples=['expires_in'],
        title='Token Expiry Property Name',
    )
    grant_type: Optional[str] = Field(
        'refresh_token',
        description='Specifies the OAuth2 grant type. If set to refresh_token, the refresh_token needs to be provided as well. For client_credentials, only client id and secret are required. Other grant types are not officially supported.',
        examples=['refresh_token', 'client_credentials'],
        title='Grant Type',
    )
    refresh_request_body: Optional[Dict[str, Any]] = Field(
        None,
        description='Body of the request sent to get a new access token.',
        examples=[
            {
                'applicationId': "{{ config['application_id'] }}",
                'applicationSecret': "{{ config['application_secret'] }}",
                'token': "{{ config['token'] }}",
            }
        ],
        title='Refresh Request Body',
    )
    scopes: Optional[List[str]] = Field(
        None,
        description='List of scopes that should be granted to the access token.',
        examples=[
            ['crm.list.read', 'crm.objects.contacts.read', 'crm.schema.contacts.read']
        ],
        title='Scopes',
    )
    token_expiry_date: Optional[str] = Field(
        None,
        description='The access token expiry date.',
        examples=['2023-04-06T07:12:10.421833+00:00', 1680842386],
        title='Token Expiry Date',
    )
    token_expiry_date_format: Optional[str] = Field(
        None,
        description='The format of the time to expiration datetime. Provide it if the time is returned as a date-time string instead of seconds.',
        examples=['%Y-%m-%d %H:%M:%S.%f+00:00'],
        title='Token Expiry Date Format',
    )
    refresh_token_updater: Optional[RefreshTokenUpdater] = Field(
        None,
        description='When the token updater is defined, new refresh tokens, access tokens and the access token expiry date are written back from the authentication response to the config object. This is important if the refresh token can only used once.',
        title='Token Updater',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class ExponentialBackoffStrategy(BaseModel):
    type: Literal['ExponentialBackoffStrategy']
    factor: Optional[Union[float, str]] = Field(
        5,
        description='Multiplicative constant applied on each retry.',
        examples=[5, 5.5, '10'],
        title='Factor',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class SessionTokenRequestBearerAuthenticator(BaseModel):
    type: Literal['Bearer']


class HttpMethod(Enum):
    GET = 'GET'
    POST = 'POST'


class Action(Enum):
    SUCCESS = 'SUCCESS'
    FAIL = 'FAIL'
    RETRY = 'RETRY'
    IGNORE = 'IGNORE'
    RATE_LIMITED = 'RATE_LIMITED'


class FailureType(Enum):
    system_error = 'system_error'
    config_error = 'config_error'
    transient_error = 'transient_error'


class HttpResponseFilter(BaseModel):
    type: Literal['HttpResponseFilter']
    action: Optional[Action] = Field(
        None,
        description='Action to execute if a response matches the filter.',
        examples=['SUCCESS', 'FAIL', 'RETRY', 'IGNORE', 'RATE_LIMITED'],
        title='Action',
    )
    failure_type: Optional[FailureType] = Field(
        None,
        description='Failure type of traced exception if a response matches the filter.',
        examples=['system_error', 'config_error', 'transient_error'],
        title='Failure Type',
    )
    error_message: Optional[str] = Field(
        None,
        description='Error Message to display if the response matches the filter.',
        title='Error Message',
    )
    error_message_contains: Optional[str] = Field(
        None,
        description='Match the response if its error message contains the substring.',
        example=['This API operation is not enabled for this site'],
        title='Error Message Substring',
    )
    http_codes: Optional[List[int]] = Field(
        None,
        description='Match the response if its HTTP code is included in this list.',
        examples=[[420, 429], [500]],
        title='HTTP Codes',
    )
    predicate: Optional[str] = Field(
        None,
        description='Match the response if the predicate evaluates to true.',
        examples=[
            "{{ 'Too much requests' in response }}",
            "{{ 'error_code' in response and response['error_code'] == 'ComplexityException' }}",
        ],
        title='Predicate',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class InlineSchemaLoader(BaseModel):
    type: Literal['InlineSchemaLoader']
    schema_: Optional[Dict[str, Any]] = Field(
        None,
        alias='schema',
        description='Describes a streams\' schema. Refer to the <a href="https://docs.airbyte.com/understanding-airbyte/supported-data-types/">Data Types documentation</a> for more details on which types are valid.',
        title='Schema',
    )


class JsonFileSchemaLoader(BaseModel):
    type: Literal['JsonFileSchemaLoader']
    file_path: Optional[str] = Field(
        None,
        description="Path to the JSON file defining the schema. The path is relative to the connector module's root.",
        example=['./schemas/users.json'],
        title='File Path',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class JsonDecoder(BaseModel):
    type: Literal['JsonDecoder']


class JsonlDecoder(BaseModel):
    type: Literal['JsonlDecoder']


class IterableDecoder(BaseModel):
    type: Literal['IterableDecoder']


class MinMaxDatetime(BaseModel):
    type: Literal['MinMaxDatetime']
    datetime: str = Field(
        ...,
        description='Datetime value.',
        examples=['2021-01-01', '2021-01-01T00:00:00Z', "{{ config['start_time'] }}"],
        title='Datetime',
    )
    datetime_format: Optional[str] = Field(
        '',
        description='Format of the datetime value. Defaults to "%Y-%m-%dT%H:%M:%S.%f%z" if left empty. Use placeholders starting with "%" to describe the format the API is using. The following placeholders are available:\n  * **%s**: Epoch unix timestamp - `1686218963`\n  * **%s_as_float**: Epoch unix timestamp in seconds as float with microsecond precision - `1686218963.123456`\n  * **%ms**: Epoch unix timestamp - `1686218963123`\n  * **%a**: Weekday (abbreviated) - `Sun`\n  * **%A**: Weekday (full) - `Sunday`\n  * **%w**: Weekday (decimal) - `0` (Sunday), `6` (Saturday)\n  * **%d**: Day of the month (zero-padded) - `01`, `02`, ..., `31`\n  * **%b**: Month (abbreviated) - `Jan`\n  * **%B**: Month (full) - `January`\n  * **%m**: Month (zero-padded) - `01`, `02`, ..., `12`\n  * **%y**: Year (without century, zero-padded) - `00`, `01`, ..., `99`\n  * **%Y**: Year (with century) - `0001`, `0002`, ..., `9999`\n  * **%H**: Hour (24-hour, zero-padded) - `00`, `01`, ..., `23`\n  * **%I**: Hour (12-hour, zero-padded) - `01`, `02`, ..., `12`\n  * **%p**: AM/PM indicator\n  * **%M**: Minute (zero-padded) - `00`, `01`, ..., `59`\n  * **%S**: Second (zero-padded) - `00`, `01`, ..., `59`\n  * **%f**: Microsecond (zero-padded to 6 digits) - `000000`, `000001`, ..., `999999`\n  * **%z**: UTC offset - `(empty)`, `+0000`, `-04:00`\n  * **%Z**: Time zone name - `(empty)`, `UTC`, `GMT`\n  * **%j**: Day of the year (zero-padded) - `001`, `002`, ..., `366`\n  * **%U**: Week number of the year (Sunday as first day) - `00`, `01`, ..., `53`\n  * **%W**: Week number of the year (Monday as first day) - `00`, `01`, ..., `53`\n  * **%c**: Date and time representation - `Tue Aug 16 21:30:00 1988`\n  * **%x**: Date representation - `08/16/1988`\n  * **%X**: Time representation - `21:30:00`\n  * **%%**: Literal \'%\' character\n\n  Some placeholders depend on the locale of the underlying system - in most cases this locale is configured as en/US. For more information see the [Python documentation](https://docs.python.org/3/library/datetime.html#strftime-and-strptime-format-codes).\n',
        examples=['%Y-%m-%dT%H:%M:%S.%f%z', '%Y-%m-%d', '%s'],
        title='Datetime Format',
    )
    max_datetime: Optional[str] = Field(
        None,
        description='Ceiling applied on the datetime value. Must be formatted with the datetime_format field.',
        examples=['2021-01-01T00:00:00Z', '2021-01-01'],
        title='Max Datetime',
    )
    min_datetime: Optional[str] = Field(
        None,
        description='Floor applied on the datetime value. Must be formatted with the datetime_format field.',
        examples=['2010-01-01T00:00:00Z', '2010-01-01'],
        title='Min Datetime',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class NoAuth(BaseModel):
    type: Literal['NoAuth']
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class NoPagination(BaseModel):
    type: Literal['NoPagination']


class OAuthConfigSpecification(BaseModel):
    class Config:
        extra = Extra.allow

    oauth_user_input_from_connector_config_specification: Optional[Dict[str, Any]] = (
        Field(
            None,
            description="OAuth specific blob. This is a Json Schema used to validate Json configurations used as input to OAuth.\nMust be a valid non-nested JSON that refers to properties from ConnectorSpecification.connectionSpecification\nusing special annotation 'path_in_connector_config'.\nThese are input values the user is entering through the UI to authenticate to the connector, that might also shared\nas inputs for syncing data via the connector.\nExamples:\nif no connector values is shared during oauth flow, oauth_user_input_from_connector_config_specification=[]\nif connector values such as 'app_id' inside the top level are used to generate the API url for the oauth flow,\n  oauth_user_input_from_connector_config_specification={\n    app_id: {\n      type: string\n      path_in_connector_config: ['app_id']\n    }\n  }\nif connector values such as 'info.app_id' nested inside another object are used to generate the API url for the oauth flow,\n  oauth_user_input_from_connector_config_specification={\n    app_id: {\n      type: string\n      path_in_connector_config: ['info', 'app_id']\n    }\n  }",
            examples=[
                {'app_id': {'type': 'string', 'path_in_connector_config': ['app_id']}},
                {
                    'app_id': {
                        'type': 'string',
                        'path_in_connector_config': ['info', 'app_id'],
                    }
                },
            ],
            title='OAuth user input',
        )
    )
    complete_oauth_output_specification: Optional[Dict[str, Any]] = Field(
        None,
        description="OAuth specific blob. This is a Json Schema used to validate Json configurations produced by the OAuth flows as they are\nreturned by the distant OAuth APIs.\nMust be a valid JSON describing the fields to merge back to `ConnectorSpecification.connectionSpecification`.\nFor each field, a special annotation `path_in_connector_config` can be specified to determine where to merge it,\nExamples:\n    complete_oauth_output_specification={\n      refresh_token: {\n        type: string,\n        path_in_connector_config: ['credentials', 'refresh_token']\n      }\n    }",
        examples=[
            {
                'refresh_token': {
                    'type': 'string,',
                    'path_in_connector_config': ['credentials', 'refresh_token'],
                }
            }
        ],
        title='OAuth output specification',
    )
    complete_oauth_server_input_specification: Optional[Dict[str, Any]] = Field(
        None,
        description='OAuth specific blob. This is a Json Schema used to validate Json configurations persisted as Airbyte Server configurations.\nMust be a valid non-nested JSON describing additional fields configured by the Airbyte Instance or Workspace Admins to be used by the\nserver when completing an OAuth flow (typically exchanging an auth code for refresh token).\nExamples:\n    complete_oauth_server_input_specification={\n      client_id: {\n        type: string\n      },\n      client_secret: {\n        type: string\n      }\n    }',
        examples=[
            {'client_id': {'type': 'string'}, 'client_secret': {'type': 'string'}}
        ],
        title='OAuth input specification',
    )
    complete_oauth_server_output_specification: Optional[Dict[str, Any]] = Field(
        None,
        description="OAuth specific blob. This is a Json Schema used to validate Json configurations persisted as Airbyte Server configurations that\nalso need to be merged back into the connector configuration at runtime.\nThis is a subset configuration of `complete_oauth_server_input_specification` that filters fields out to retain only the ones that\nare necessary for the connector to function with OAuth. (some fields could be used during oauth flows but not needed afterwards, therefore\nthey would be listed in the `complete_oauth_server_input_specification` but not `complete_oauth_server_output_specification`)\nMust be a valid non-nested JSON describing additional fields configured by the Airbyte Instance or Workspace Admins to be used by the\nconnector when using OAuth flow APIs.\nThese fields are to be merged back to `ConnectorSpecification.connectionSpecification`.\nFor each field, a special annotation `path_in_connector_config` can be specified to determine where to merge it,\nExamples:\n      complete_oauth_server_output_specification={\n        client_id: {\n          type: string,\n          path_in_connector_config: ['credentials', 'client_id']\n        },\n        client_secret: {\n          type: string,\n          path_in_connector_config: ['credentials', 'client_secret']\n        }\n      }",
        examples=[
            {
                'client_id': {
                    'type': 'string,',
                    'path_in_connector_config': ['credentials', 'client_id'],
                },
                'client_secret': {
                    'type': 'string,',
                    'path_in_connector_config': ['credentials', 'client_secret'],
                },
            }
        ],
        title='OAuth server output specification',
    )


class OffsetIncrement(BaseModel):
    type: Literal['OffsetIncrement']
    page_size: Optional[Union[int, str]] = Field(
        None,
        description='The number of records to include in each pages.',
        examples=[100, "{{ config['page_size'] }}"],
        title='Limit',
    )
    inject_on_first_request: Optional[bool] = Field(
        False,
        description='Using the `offset` with value `0` during the first request',
        title='Inject Offset',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class PageIncrement(BaseModel):
    type: Literal['PageIncrement']
    page_size: Optional[Union[int, str]] = Field(
        None,
        description='The number of records to include in each pages.',
        examples=[100, '100', "{{ config['page_size'] }}"],
        title='Page Size',
    )
    start_from_page: Optional[int] = Field(
        0,
        description='Index of the first page to request.',
        examples=[0, 1],
        title='Start From Page',
    )
    inject_on_first_request: Optional[bool] = Field(
        False,
        description='Using the `page number` with value defined by `start_from_page` during the first request',
        title='Inject Page Number',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class PrimaryKey(BaseModel):
    __root__: Union[str, List[str], List[List[str]]] = Field(
        ...,
        description='The stream field to be used to distinguish unique records. Can either be a single field, an array of fields representing a composite key, or an array of arrays representing a composite key where the fields are nested fields.',
        examples=['id', ['code', 'type']],
        title='Primary Key',
    )


class RecordFilter(BaseModel):
    type: Literal['RecordFilter']
    condition: Optional[str] = Field(
        '',
        description='The predicate to filter a record. Records will be removed if evaluated to False.',
        examples=[
            "{{ record['created_at'] >= stream_interval['start_time'] }}",
            "{{ record.status in ['active', 'expired'] }}",
        ],
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class SchemaNormalization(Enum):
    None_ = 'None'
    Default = 'Default'


class RemoveFields(BaseModel):
    type: Literal['RemoveFields']
    condition: Optional[str] = Field(
        '',
        description='The predicate to filter a property by a property value. Property will be removed if it is empty OR expression is evaluated to True.,',
        examples=[
            "{{ property|string == '' }}",
            '{{ property is integer }}',
            '{{ property|length > 5 }}',
            "{{ property == 'some_string_to_match' }}",
        ],
    )
    field_pointers: List[List[str]] = Field(
        ...,
        description='Array of paths defining the field to remove. Each item is an array whose field describe the path of a field to remove.',
        examples=[['tags'], [['content', 'html'], ['content', 'plain_text']]],
        title='Field Paths',
    )


class RequestPath(BaseModel):
    type: Literal['RequestPath']


class InjectInto(Enum):
    request_parameter = 'request_parameter'
    header = 'header'
    body_data = 'body_data'
    body_json = 'body_json'


class RequestOption(BaseModel):
    type: Literal['RequestOption']
    field_name: str = Field(
        ...,
        description='Configures which key should be used in the location that the descriptor is being injected into',
        examples=['segment_id'],
        title='Request Option',
    )
    inject_into: InjectInto = Field(
        ...,
        description='Configures where the descriptor should be set on the HTTP requests. Note that request parameters that are already encoded in the URL path will not be duplicated.',
        examples=['request_parameter', 'header', 'body_data', 'body_json'],
        title='Inject Into',
    )


class Schemas(BaseModel):
    pass

    class Config:
        extra = Extra.allow


class LegacySessionTokenAuthenticator(BaseModel):
    type: Literal['LegacySessionTokenAuthenticator']
    header: str = Field(
        ...,
        description='The name of the session token header that will be injected in the request',
        examples=['X-Session'],
        title='Session Request Header',
    )
    login_url: str = Field(
        ...,
        description='Path of the login URL (do not include the base URL)',
        examples=['session'],
        title='Login Path',
    )
    session_token: Optional[str] = Field(
        None,
        description='Session token to use if using a pre-defined token. Not needed if authenticating with username + password pair',
        example=["{{ config['session_token'] }}"],
        title='Session Token',
    )
    session_token_response_key: str = Field(
        ...,
        description='Name of the key of the session token to be extracted from the response',
        examples=['id'],
        title='Response Token Response Key',
    )
    username: Optional[str] = Field(
        None,
        description='Username used to authenticate and obtain a session token',
        examples=[" {{ config['username'] }}"],
        title='Username',
    )
    password: Optional[str] = Field(
        '',
        description='Password used to authenticate and obtain a session token',
        examples=["{{ config['password'] }}", ''],
        title='Password',
    )
    validate_session_url: str = Field(
        ...,
        description='Path of the URL to use to validate that the session token is valid (do not include the base URL)',
        examples=['user/current'],
        title='Validate Session Path',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class ValueType(Enum):
    string = 'string'
    number = 'number'
    integer = 'integer'
    boolean = 'boolean'


class WaitTimeFromHeader(BaseModel):
    type: Literal['WaitTimeFromHeader']
    header: str = Field(
        ...,
        description='The name of the response header defining how long to wait before retrying.',
        examples=['Retry-After'],
        title='Response Header Name',
    )
    regex: Optional[str] = Field(
        None,
        description='Optional regex to apply on the header to extract its value. The regex should define a capture group defining the wait time.',
        examples=['([-+]?\\d+)'],
        title='Extraction Regex',
    )
    max_waiting_time_in_seconds: Optional[float] = Field(
        None,
        description='Given the value extracted from the header is greater than this value, stop the stream.',
        examples=[3600],
        title='Max Waiting Time in Seconds',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class WaitUntilTimeFromHeader(BaseModel):
    type: Literal['WaitUntilTimeFromHeader']
    header: str = Field(
        ...,
        description='The name of the response header defining how long to wait before retrying.',
        examples=['wait_time'],
        title='Response Header',
    )
    min_wait: Optional[Union[float, str]] = Field(
        None,
        description='Minimum time to wait before retrying.',
        examples=[10, '60'],
        title='Minimum Wait Time',
    )
    regex: Optional[str] = Field(
        None,
        description='Optional regex to apply on the header to extract its value. The regex should define a capture group defining the wait time.',
        examples=['([-+]?\\d+)'],
        title='Extraction Regex',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class AddedFieldDefinition(BaseModel):
    type: Literal['AddedFieldDefinition']
    path: List[str] = Field(
        ...,
        description='List of strings defining the path where to add the value on the record.',
        examples=[['segment_id'], ['metadata', 'segment_id']],
        title='Path',
    )
    value: str = Field(
        ...,
        description="Value of the new field. Use {{ record['existing_field'] }} syntax to refer to other fields in the record.",
        examples=[
            "{{ record['updates'] }}",
            "{{ record['MetaData']['LastUpdatedTime'] }}",
            "{{ stream_partition['segment_id'] }}",
        ],
        title='Value',
    )
    value_type: Optional[ValueType] = Field(
        None,
        description='Type of the value. If not specified, the type will be inferred from the value.',
        title='Value Type',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class AddFields(BaseModel):
    type: Literal['AddFields']
    fields: List[AddedFieldDefinition] = Field(
        ...,
        description='List of transformations (path and corresponding value) that will be added to the record.',
        title='Fields',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class ApiKeyAuthenticator(BaseModel):
    type: Literal['ApiKeyAuthenticator']
    api_token: Optional[str] = Field(
        None,
        description='The API key to inject in the request. Fill it in the user inputs.',
        examples=["{{ config['api_key'] }}", "Token token={{ config['api_key'] }}"],
        title='API Key',
    )
    header: Optional[str] = Field(
        None,
        description='The name of the HTTP header that will be set to the API key. This setting is deprecated, use inject_into instead. Header and inject_into can not be defined at the same time.',
        examples=['Authorization', 'Api-Token', 'X-Auth-Token'],
        title='Header Name',
    )
    inject_into: Optional[RequestOption] = Field(
        None,
        description='Configure how the API Key will be sent in requests to the source API. Either inject_into or header has to be defined.',
        examples=[
            {'inject_into': 'header', 'field_name': 'Authorization'},
            {'inject_into': 'request_parameter', 'field_name': 'authKey'},
        ],
        title='Inject API Key Into Outgoing HTTP Request',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class AuthFlow(BaseModel):
    auth_flow_type: Optional[AuthFlowType] = Field(
        None, description='The type of auth to use', title='Auth flow type'
    )
    predicate_key: Optional[List[str]] = Field(
        None,
        description='JSON path to a field in the connectorSpecification that should exist for the advanced auth to be applicable.',
        examples=[['credentials', 'auth_type']],
        title='Predicate key',
    )
    predicate_value: Optional[str] = Field(
        None,
        description='Value of the predicate_key fields for the advanced auth to be applicable.',
        examples=['Oauth'],
        title='Predicate value',
    )
    oauth_config_specification: Optional[OAuthConfigSpecification] = None


class CursorPagination(BaseModel):
    type: Literal['CursorPagination']
    cursor_value: str = Field(
        ...,
        description='Value of the cursor defining the next page to fetch.',
        examples=[
            '{{ headers.link.next.cursor }}',
            "{{ last_record['key'] }}",
            "{{ response['nextPage'] }}",
        ],
        title='Cursor Value',
    )
    page_size: Optional[int] = Field(
        None,
        description='The number of records to include in each pages.',
        examples=[100],
        title='Page Size',
    )
    stop_condition: Optional[str] = Field(
        None,
        description='Template string evaluating when to stop paginating.',
        examples=[
            '{{ response.data.has_more is false }}',
            "{{ 'next' not in headers['link'] }}",
        ],
        title='Stop Condition',
    )
    decoder: Optional[JsonDecoder] = Field(
        None,
        description='Component decoding the response so records can be extracted.',
        title='Decoder',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class DatetimeBasedCursor(BaseModel):
    type: Literal['DatetimeBasedCursor']
    cursor_field: str = Field(
        ...,
        description='The location of the value on a record that will be used as a bookmark during sync. To ensure no data loss, the API must return records in ascending order based on the cursor field. Nested fields are not supported, so the field must be at the top level of the record. You can use a combination of Add Field and Remove Field transformations to move the nested field to the top.',
        examples=['created_at', "{{ config['record_cursor'] }}"],
        title='Cursor Field',
    )
    datetime_format: str = Field(
        ...,
        description='The datetime format used to format the datetime values that are sent in outgoing requests to the API. Use placeholders starting with "%" to describe the format the API is using. The following placeholders are available:\n  * **%s**: Epoch unix timestamp - `1686218963`\n  * **%s_as_float**: Epoch unix timestamp in seconds as float with microsecond precision - `1686218963.123456`\n  * **%ms**: Epoch unix timestamp (milliseconds) - `1686218963123`\n  * **%a**: Weekday (abbreviated) - `Sun`\n  * **%A**: Weekday (full) - `Sunday`\n  * **%w**: Weekday (decimal) - `0` (Sunday), `6` (Saturday)\n  * **%d**: Day of the month (zero-padded) - `01`, `02`, ..., `31`\n  * **%b**: Month (abbreviated) - `Jan`\n  * **%B**: Month (full) - `January`\n  * **%m**: Month (zero-padded) - `01`, `02`, ..., `12`\n  * **%y**: Year (without century, zero-padded) - `00`, `01`, ..., `99`\n  * **%Y**: Year (with century) - `0001`, `0002`, ..., `9999`\n  * **%H**: Hour (24-hour, zero-padded) - `00`, `01`, ..., `23`\n  * **%I**: Hour (12-hour, zero-padded) - `01`, `02`, ..., `12`\n  * **%p**: AM/PM indicator\n  * **%M**: Minute (zero-padded) - `00`, `01`, ..., `59`\n  * **%S**: Second (zero-padded) - `00`, `01`, ..., `59`\n  * **%f**: Microsecond (zero-padded to 6 digits) - `000000`\n  * **%z**: UTC offset - `(empty)`, `+0000`, `-04:00`\n  * **%Z**: Time zone name - `(empty)`, `UTC`, `GMT`\n  * **%j**: Day of the year (zero-padded) - `001`, `002`, ..., `366`\n  * **%U**: Week number of the year (starting Sunday) - `00`, ..., `53`\n  * **%W**: Week number of the year (starting Monday) - `00`, ..., `53`\n  * **%c**: Date and time - `Tue Aug 16 21:30:00 1988`\n  * **%x**: Date standard format - `08/16/1988`\n  * **%X**: Time standard format - `21:30:00`\n  * **%%**: Literal \'%\' character\n\n  Some placeholders depend on the locale of the underlying system - in most cases this locale is configured as en/US. For more information see the [Python documentation](https://docs.python.org/3/library/datetime.html#strftime-and-strptime-format-codes).\n',
        examples=['%Y-%m-%dT%H:%M:%S.%f%z', '%Y-%m-%d', '%s', '%ms', '%s_as_float'],
        title='Outgoing Datetime Format',
    )
    start_datetime: Union[str, MinMaxDatetime] = Field(
        ...,
        description='The datetime that determines the earliest record that should be synced.',
        examples=['2020-01-1T00:00:00Z', "{{ config['start_time'] }}"],
        title='Start Datetime',
    )
    cursor_datetime_formats: Optional[List[str]] = Field(
        None,
        description='The possible formats for the cursor field, in order of preference. The first format that matches the cursor field value will be used to parse it. If not provided, the `datetime_format` will be used.',
        title='Cursor Datetime Formats',
    )
    cursor_granularity: Optional[str] = Field(
        None,
        description='Smallest increment the datetime_format has (ISO 8601 duration) that is used to ensure the start of a slice does not overlap with the end of the previous one, e.g. for %Y-%m-%d the granularity should be P1D, for %Y-%m-%dT%H:%M:%SZ the granularity should be PT1S. Given this field is provided, `step` needs to be provided as well.',
        examples=['PT1S'],
        title='Cursor Granularity',
    )
    end_datetime: Optional[Union[str, MinMaxDatetime]] = Field(
        None,
        description='The datetime that determines the last record that should be synced. If not provided, `{{ now_utc() }}` will be used.',
        examples=['2021-01-1T00:00:00Z', '{{ now_utc() }}', '{{ day_delta(-1) }}'],
        title='End Datetime',
    )
    end_time_option: Optional[RequestOption] = Field(
        None,
        description='Optionally configures how the end datetime will be sent in requests to the source API.',
        title='Inject End Time Into Outgoing HTTP Request',
    )
    is_data_feed: Optional[bool] = Field(
        None,
        description='A data feed API is an API that does not allow filtering and paginates the content from the most recent to the least recent. Given this, the CDK needs to know when to stop paginating and this field will generate a stop condition for pagination.',
        title='Whether the target API is formatted as a data feed',
    )
    is_client_side_incremental: Optional[bool] = Field(
        None,
        description='If the target API endpoint does not take cursor values to filter records and returns all records anyway, the connector with this cursor will filter out records locally, and only emit new records from the last sync, hence incremental. This means that all records would be read from the API, but only new records will be emitted to the destination.',
        title='Whether the target API does not support filtering and returns all data (the cursor filters records in the client instead of the API side)',
    )
    is_compare_strictly: Optional[bool] = Field(
        False,
        description='Set to True if the target API does not accept queries where the start time equal the end time.',
        title='Whether to skip requests if the start time equals the end time',
    )
    lookback_window: Optional[str] = Field(
        None,
        description='Time interval before the start_datetime to read data for, e.g. P1M for looking back one month.',
        examples=['P1D', "P{{ config['lookback_days'] }}D"],
        title='Lookback Window',
    )
    partition_field_end: Optional[str] = Field(
        None,
        description='Name of the partition start time field.',
        examples=['ending_time'],
        title='Partition Field End',
    )
    partition_field_start: Optional[str] = Field(
        None,
        description='Name of the partition end time field.',
        examples=['starting_time'],
        title='Partition Field Start',
    )
    start_time_option: Optional[RequestOption] = Field(
        None,
        description='Optionally configures how the start datetime will be sent in requests to the source API.',
        title='Inject Start Time Into Outgoing HTTP Request',
    )
    step: Optional[str] = Field(
        None,
        description='The size of the time window (ISO8601 duration). Given this field is provided, `cursor_granularity` needs to be provided as well.',
        examples=['P1W', "{{ config['step_increment'] }}"],
        title='Step',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class DefaultErrorHandler(BaseModel):
    type: Literal['DefaultErrorHandler']
    backoff_strategies: Optional[
        List[
            Union[
                ConstantBackoffStrategy,
                CustomBackoffStrategy,
                ExponentialBackoffStrategy,
                WaitTimeFromHeader,
                WaitUntilTimeFromHeader,
            ]
        ]
    ] = Field(
        None,
        description='List of backoff strategies to use to determine how long to wait before retrying a retryable request.',
        title='Backoff Strategies',
    )
    max_retries: Optional[int] = Field(
        5,
        description='The maximum number of time to retry a retryable request before giving up and failing.',
        examples=[5, 0, 10],
        title='Max Retry Count',
    )
    response_filters: Optional[List[HttpResponseFilter]] = Field(
        None,
        description="List of response filters to iterate on when deciding how to handle an error. When using an array of multiple filters, the filters will be applied sequentially and the response will be selected if it matches any of the filter's predicate.",
        title='Response Filters',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class DefaultPaginator(BaseModel):
    type: Literal['DefaultPaginator']
    pagination_strategy: Union[
        CursorPagination, CustomPaginationStrategy, OffsetIncrement, PageIncrement
    ] = Field(
        ...,
        description='Strategy defining how records are paginated.',
        title='Pagination Strategy',
    )
    decoder: Optional[JsonDecoder] = Field(
        None,
        description='Component decoding the response so records can be extracted.',
        title='Decoder',
    )
    page_size_option: Optional[RequestOption] = None
    page_token_option: Optional[Union[RequestOption, RequestPath]] = None
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class DpathExtractor(BaseModel):
    type: Literal['DpathExtractor']
    field_path: List[str] = Field(
        ...,
        description='List of potentially nested fields describing the full path of the field to extract. Use "*" to extract all values from an array. See more info in the [docs](https://docs.airbyte.com/connector-development/config-based/understanding-the-yaml-file/record-selector).',
        examples=[
            ['data'],
            ['data', 'records'],
            ['data', '{{ parameters.name }}'],
            ['data', '*', 'record'],
        ],
        title='Field Path',
    )
    decoder: Optional[Union[JsonDecoder, JsonlDecoder, IterableDecoder]] = Field(
        None, title='Decoder'
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class SessionTokenRequestApiKeyAuthenticator(BaseModel):
    type: Literal['ApiKey']
    inject_into: RequestOption = Field(
        ...,
        description='Configure how the API Key will be sent in requests to the source API.',
        examples=[
            {'inject_into': 'header', 'field_name': 'Authorization'},
            {'inject_into': 'request_parameter', 'field_name': 'authKey'},
        ],
        title='Inject API Key Into Outgoing HTTP Request',
    )


class ListPartitionRouter(BaseModel):
    type: Literal['ListPartitionRouter']
    cursor_field: str = Field(
        ...,
        description='While iterating over list values, the name of field used to reference a list value. The partition value can be accessed with string interpolation. e.g. "{{ stream_partition[\'my_key\'] }}" where "my_key" is the value of the cursor_field.',
        examples=['section', "{{ config['section_key'] }}"],
        title='Current Partition Value Identifier',
    )
    values: Union[str, List[str]] = Field(
        ...,
        description='The list of attributes being iterated over and used as input for the requests made to the source API.',
        examples=[['section_a', 'section_b', 'section_c'], "{{ config['sections'] }}"],
        title='Partition Values',
    )
    request_option: Optional[RequestOption] = Field(
        None,
        description='A request option describing where the list value should be injected into and under what field name if applicable.',
        title='Inject Partition Value Into Outgoing HTTP Request',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class RecordSelector(BaseModel):
    type: Literal['RecordSelector']
    extractor: Union[CustomRecordExtractor, DpathExtractor]
    record_filter: Optional[Union[CustomRecordFilter, RecordFilter]] = Field(
        None,
        description='Responsible for filtering records to be emitted by the Source.',
        title='Record Filter',
    )
    schema_normalization: Optional[SchemaNormalization] = SchemaNormalization.None_
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class Spec(BaseModel):
    type: Literal['Spec']
    connection_specification: Dict[str, Any] = Field(
        ...,
        description='A connection specification describing how a the connector can be configured.',
        title='Connection Specification',
    )
    documentation_url: Optional[str] = Field(
        None,
        description="URL of the connector's documentation page.",
        examples=['https://docs.airbyte.com/integrations/sources/dremio'],
        title='Documentation URL',
    )
    advanced_auth: Optional[AuthFlow] = Field(
        None,
        description='Advanced specification for configuring the authentication flow.',
        title='Advanced Auth',
    )


class CompositeErrorHandler(BaseModel):
    type: Literal['CompositeErrorHandler']
    error_handlers: List[Union[CompositeErrorHandler, DefaultErrorHandler]] = Field(
        ...,
        description='List of error handlers to iterate on to determine how to handle a failed response.',
        title='Error Handlers',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class DeclarativeSource(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Literal['DeclarativeSource']
    check: CheckStream
    streams: List[DeclarativeStream]
    version: str = Field(
        ...,
        description='The version of the Airbyte CDK used to build and test the source.',
    )
    schemas: Optional[Schemas] = None
    definitions: Optional[Dict[str, Any]] = None
    spec: Optional[Spec] = None
    metadata: Optional[Dict[str, Any]] = Field(
        None,
        description='For internal Airbyte use only - DO NOT modify manually. Used by consumers of declarative manifests for storing related metadata.',
    )
    description: Optional[str] = Field(
        None,
        description='A description of the connector. It will be presented on the Source documentation page.',
    )


class SelectiveAuthenticator(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['SelectiveAuthenticator']
    authenticator_selection_path: List[str] = Field(
        ...,
        description='Path of the field in config with selected authenticator name',
        examples=[['auth'], ['auth', 'type']],
        title='Authenticator Selection Path',
    )
    authenticators: Dict[
        str,
        Union[
            ApiKeyAuthenticator,
            BasicHttpAuthenticator,
            BearerAuthenticator,
            CustomAuthenticator,
            OAuthAuthenticator,
            JwtAuthenticator,
            NoAuth,
            SessionTokenAuthenticator,
            LegacySessionTokenAuthenticator,
        ],
    ] = Field(
        ...,
        description='Authenticators to select from.',
        examples=[
            {
                'authenticators': {
                    'token': '#/definitions/ApiKeyAuthenticator',
                    'oauth': '#/definitions/OAuthAuthenticator',
                    'jwt': '#/definitions/JwtAuthenticator',
                }
            }
        ],
        title='Authenticators',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class DeclarativeStream(BaseModel):
    class Config:
        extra = Extra.allow

    type: Literal['DeclarativeStream']
    retriever: Union[CustomRetriever, SimpleRetriever] = Field(
        ...,
        description='Component used to coordinate how records are extracted across stream slices and request pages.',
        title='Retriever',
    )
    incremental_sync: Optional[Union[CustomIncrementalSync, DatetimeBasedCursor]] = (
        Field(
            None,
            description='Component used to fetch data incrementally based on a time field in the data.',
            title='Incremental Sync',
        )
    )
    name: Optional[str] = Field(
        '', description='The stream name.', example=['Users'], title='Name'
    )
    primary_key: Optional[PrimaryKey] = Field(
        '', description='The primary key of the stream.', title='Primary Key'
    )
    schema_loader: Optional[
        Union[InlineSchemaLoader, JsonFileSchemaLoader, CustomSchemaLoader]
    ] = Field(
        None,
        description='Component used to retrieve the schema for the current stream.',
        title='Schema Loader',
    )
    transformations: Optional[
        List[Union[AddFields, CustomTransformation, RemoveFields]]
    ] = Field(
        None,
        description='A list of transformations to be applied to each output record.',
        title='Transformations',
    )
    state_migrations: Optional[
        List[Union[LegacyToPerPartitionStateMigration, CustomStateMigration]]
    ] = Field(
        [],
        description='Array of state migrations to be applied on the input state',
        title='State Migrations',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class SessionTokenAuthenticator(BaseModel):
    type: Literal['SessionTokenAuthenticator']
    login_requester: HttpRequester = Field(
        ...,
        description='Description of the request to perform to obtain a session token to perform data requests. The response body is expected to be a JSON object with a session token property.',
        examples=[
            {
                'type': 'HttpRequester',
                'url_base': 'https://my_api.com',
                'path': '/login',
                'authenticator': {
                    'type': 'BasicHttpAuthenticator',
                    'username': '{{ config.username }}',
                    'password': '{{ config.password }}',
                },
            }
        ],
        title='Login Requester',
    )
    session_token_path: List[str] = Field(
        ...,
        description='The path in the response body returned from the login requester to the session token.',
        examples=[['access_token'], ['result', 'token']],
        title='Session Token Path',
    )
    expiration_duration: Optional[str] = Field(
        None,
        description='The duration in ISO 8601 duration notation after which the session token expires, starting from the time it was obtained. Omitting it will result in the session token being refreshed for every request.',
        examples=['PT1H', 'P1D'],
        title='Expiration Duration',
    )
    request_authentication: Union[
        SessionTokenRequestApiKeyAuthenticator, SessionTokenRequestBearerAuthenticator
    ] = Field(
        ...,
        description='Authentication method to use for requests sent to the API, specifying how to inject the session token.',
        title='Data Request Authentication',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class HttpRequester(BaseModel):
    type: Literal['HttpRequester']
    url_base: str = Field(
        ...,
        description='Base URL of the API source. Do not put sensitive information (e.g. API tokens) into this field - Use the Authentication component for this.',
        examples=[
            'https://connect.squareup.com/v2',
            "{{ config['base_url'] or 'https://app.posthog.com'}}/api/",
        ],
        title='API Base URL',
    )
    path: str = Field(
        ...,
        description='Path the specific API endpoint that this stream represents. Do not put sensitive information (e.g. API tokens) into this field - Use the Authentication component for this.',
        examples=[
            '/products',
            "/quotes/{{ stream_partition['id'] }}/quote_line_groups",
            "/trades/{{ config['symbol_id'] }}/history",
        ],
        title='URL Path',
    )
    authenticator: Optional[
        Union[
            ApiKeyAuthenticator,
            BasicHttpAuthenticator,
            BearerAuthenticator,
            CustomAuthenticator,
            OAuthAuthenticator,
            JwtAuthenticator,
            NoAuth,
            SessionTokenAuthenticator,
            LegacySessionTokenAuthenticator,
            SelectiveAuthenticator,
        ]
    ] = Field(
        None,
        description='Authentication method to use for requests sent to the API.',
        title='Authenticator',
    )
    error_handler: Optional[
        Union[DefaultErrorHandler, CustomErrorHandler, CompositeErrorHandler]
    ] = Field(
        None,
        description='Error handler component that defines how to handle errors.',
        title='Error Handler',
    )
    http_method: Optional[HttpMethod] = Field(
        HttpMethod.GET,
        description='The HTTP method used to fetch data from the source (can be GET or POST).',
        examples=['GET', 'POST'],
        title='HTTP Method',
    )
    request_body_data: Optional[Union[str, Dict[str, str]]] = Field(
        None,
        description='Specifies how to populate the body of the request with a non-JSON payload. Plain text will be sent as is, whereas objects will be converted to a urlencoded form.',
        examples=[
            '[{"clause": {"type": "timestamp", "operator": 10, "parameters":\n    [{"value": {{ stream_interval[\'start_time\'] | int * 1000 }} }]\n  }, "orderBy": 1, "columnName": "Timestamp"}]/\n'
        ],
        title='Request Body Payload (Non-JSON)',
    )
    request_body_json: Optional[Union[str, Dict[str, Any]]] = Field(
        None,
        description='Specifies how to populate the body of the request with a JSON payload. Can contain nested objects.',
        examples=[
            {'sort_order': 'ASC', 'sort_field': 'CREATED_AT'},
            {'key': "{{ config['value'] }}"},
            {'sort': {'field': 'updated_at', 'order': 'ascending'}},
        ],
        title='Request Body JSON Payload',
    )
    request_headers: Optional[Union[str, Dict[str, str]]] = Field(
        None,
        description='Return any non-auth headers. Authentication headers will overwrite any overlapping headers returned from this method.',
        examples=[{'Output-Format': 'JSON'}, {'Version': "{{ config['version'] }}"}],
        title='Request Headers',
    )
    request_parameters: Optional[Union[str, Dict[str, str]]] = Field(
        None,
        description='Specifies the query parameters that should be set on an outgoing HTTP request given the inputs.',
        examples=[
            {'unit': 'day'},
            {
                'query': 'last_event_time BETWEEN TIMESTAMP "{{ stream_interval.start_time }}" AND TIMESTAMP "{{ stream_interval.end_time }}"'
            },
            {'searchIn': "{{ ','.join(config.get('search_in', [])) }}"},
            {'sort_by[asc]': 'updated_at'},
        ],
        title='Query Parameters',
    )
    use_cache: Optional[bool] = Field(
        False,
        description='Enables stream requests caching. This field is automatically set by the CDK.',
        title='Use Cache',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class ParentStreamConfig(BaseModel):
    type: Literal['ParentStreamConfig']
    parent_key: str = Field(
        ...,
        description='The primary key of records from the parent stream that will be used during the retrieval of records for the current substream. This parent identifier field is typically a characteristic of the child records being extracted from the source API.',
        examples=['id', "{{ config['parent_record_id'] }}"],
        title='Parent Key',
    )
    stream: DeclarativeStream = Field(
        ..., description='Reference to the parent stream.', title='Parent Stream'
    )
    partition_field: str = Field(
        ...,
        description='While iterating over parent records during a sync, the parent_key value can be referenced by using this field.',
        examples=['parent_id', "{{ config['parent_partition_field'] }}"],
        title='Current Parent Key Value Identifier',
    )
    request_option: Optional[RequestOption] = Field(
        None,
        description='A request option describing where the parent key value should be injected into and under what field name if applicable.',
        title='Request Option',
    )
    incremental_dependency: Optional[bool] = Field(
        False,
        description='Indicates whether the parent stream should be read incrementally based on updates in the child stream.',
        title='Incremental Dependency',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class SimpleRetriever(BaseModel):
    type: Literal['SimpleRetriever']
    record_selector: RecordSelector = Field(
        ...,
        description='Component that describes how to extract records from a HTTP response.',
    )
    requester: Union[CustomRequester, HttpRequester] = Field(
        ...,
        description='Requester component that describes how to prepare HTTP requests to send to the source API.',
    )
    paginator: Optional[Union[DefaultPaginator, NoPagination]] = Field(
        None,
        description="Paginator component that describes how to navigate through the API's pages.",
    )
    ignore_stream_slicer_parameters_on_paginated_requests: Optional[bool] = Field(
        False,
        description='If true, the partition router and incremental request options will be ignored when paginating requests. Request options set directly on the requester will not be ignored.',
    )
    partition_router: Optional[
        Union[
            CustomPartitionRouter,
            ListPartitionRouter,
            SubstreamPartitionRouter,
            List[
                Union[
                    CustomPartitionRouter, ListPartitionRouter, SubstreamPartitionRouter
                ]
            ],
        ]
    ] = Field(
        [],
        description='PartitionRouter component that describes how to partition the stream, enabling incremental syncs and checkpointing.',
        title='Partition Router',
    )
    decoder: Optional[Union[JsonDecoder, JsonlDecoder, IterableDecoder]] = Field(
        None,
        description='Component decoding the response so records can be extracted.',
        title='Decoder',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


class SubstreamPartitionRouter(BaseModel):
    type: Literal['SubstreamPartitionRouter']
    parent_stream_configs: List[ParentStreamConfig] = Field(
        ...,
        description='Specifies which parent streams are being iterated over and how parent records should be used to partition the child stream data set.',
        title='Parent Stream Configs',
    )
    parameters: Optional[Dict[str, Any]] = Field(None, alias='$parameters')


CompositeErrorHandler.update_forward_refs()
DeclarativeSource.update_forward_refs()
SelectiveAuthenticator.update_forward_refs()
DeclarativeStream.update_forward_refs()
SessionTokenAuthenticator.update_forward_refs()
SimpleRetriever.update_forward_refs()
