# RPC Client

Auto-generated WebSocket RPC Client with Environment Detection.

## Installation

```bash
pip install -r requirements.txt
```

## Usage

### Auto-detect environment

```python
from client import RPCClient

# Auto-detect from DJANGO_ENV or ENV
client = RPCClient()
await client.connect()

# Or use factory method
client = RPCClient.from_env()
await client.connect()
```

### Explicit environment

```python
client = RPCClient.from_env("production")
await client.connect()
```

### Custom URL

```python
client = RPCClient("wss://custom.api.com/ws")
await client.connect()
```

### Custom Logger Configuration

```python
from client import RPCClient
from logger import ClientLoggerConfig

# Configure logger
logger_config = ClientLoggerConfig(
    log_dir="./my_logs",
    level="DEBUG",
    log_rpc_calls=True,
    console_output=True
)

# Create client with custom logger
client = RPCClient(logger_config=logger_config)
await client.connect()

# Or disable logging entirely
client = RPCClient(enable_logging=False)
await client.connect()
```

## Environment Variables

The client detects environment in this priority order:
1. `DJANGO_ENV` (for Django projects)
2. `ENV` (generic fallback)
3. `DEBUG` flag (true=development, false=production)
4. Default: `development`

### Supported aliases:
- `dev`, `devel`, `develop`, `local` → `development`
- `prod` → `production`
- `stage` → `staging`
- `test` → `testing`

## Logging

The client automatically logs all RPC calls with detailed metrics:

- **Structured JSON logs** in `./client_logs/client.log`
- **RPC-specific logs** in `./client_logs/client_rpc.log`
- **Request/response tracking** with correlation IDs
- **Performance metrics** (duration in milliseconds)
- **Success/failure status** for each call

Log files are automatically rotated when they reach 10MB (configurable).

## Example

```python
import asyncio
import os
from client import RPCClient
from logger import ClientLoggerConfig
from models import CreateUserParams

async def main():
    # Set environment
    os.environ["DJANGO_ENV"] = "production"

    # Configure logger
    logger_config = ClientLoggerConfig(
        log_dir="./logs",
        level="INFO",
        log_rpc_calls=True
    )

    # Client auto-detects and uses production URL
    client = RPCClient.from_env(logger_config=logger_config)
    await client.connect()

    try:
        # Call RPC methods - automatically logged with timing and status
        result = await client.create_user(params)
        result = await client.get_user(params)
        result = await client.list_users(params)
    finally:
        await client.disconnect()

if __name__ == "__main__":
    asyncio.run(main())
```

## Generated by

django_cfg_rpc codegen