# mypy-boto3-elasticache

[![PyPI - mypy-boto3-elasticache](https://img.shields.io/pypi/v/mypy-boto3-elasticache.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticache)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elasticache.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticache)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElastiCache 1.12.30](https://boto3.amazonaws.com/v1/documentation/api/1.12.30/reference/services/elasticache.html#ElastiCache) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.6](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-elasticache](#mypy-boto3-elasticache)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `ElastiCache` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-elasticache]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import elasticache
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_elasticache as elasticache

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("elasticache")
client: elasticache.ElastiCacheClient = boto3.client("elasticache")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: elasticache.ElastiCacheClient = session.client("elasticache")


# Waiters need type annotation on creation
cache_cluster_available_waiter: elasticache.CacheClusterAvailableWaiter = client.get_waiter("cache_cluster_available")
cache_cluster_deleted_waiter: elasticache.CacheClusterDeletedWaiter = client.get_waiter("cache_cluster_deleted")
replication_group_available_waiter: elasticache.ReplicationGroupAvailableWaiter = client.get_waiter("replication_group_available")
replication_group_deleted_waiter: elasticache.ReplicationGroupDeletedWaiter = client.get_waiter("replication_group_deleted")

# Paginators need type annotation on creation
describe_cache_clusters_paginator: elasticache.DescribeCacheClustersPaginator = client.get_paginator("describe_cache_clusters")
describe_cache_engine_versions_paginator: elasticache.DescribeCacheEngineVersionsPaginator = client.get_paginator("describe_cache_engine_versions")
describe_cache_parameter_groups_paginator: elasticache.DescribeCacheParameterGroupsPaginator = client.get_paginator("describe_cache_parameter_groups")
describe_cache_parameters_paginator: elasticache.DescribeCacheParametersPaginator = client.get_paginator("describe_cache_parameters")
describe_cache_security_groups_paginator: elasticache.DescribeCacheSecurityGroupsPaginator = client.get_paginator("describe_cache_security_groups")
describe_cache_subnet_groups_paginator: elasticache.DescribeCacheSubnetGroupsPaginator = client.get_paginator("describe_cache_subnet_groups")
describe_engine_default_parameters_paginator: elasticache.DescribeEngineDefaultParametersPaginator = client.get_paginator("describe_engine_default_parameters")
describe_events_paginator: elasticache.DescribeEventsPaginator = client.get_paginator("describe_events")
describe_global_replication_groups_paginator: elasticache.DescribeGlobalReplicationGroupsPaginator = client.get_paginator("describe_global_replication_groups")
describe_replication_groups_paginator: elasticache.DescribeReplicationGroupsPaginator = client.get_paginator("describe_replication_groups")
describe_reserved_cache_nodes_paginator: elasticache.DescribeReservedCacheNodesPaginator = client.get_paginator("describe_reserved_cache_nodes")
describe_reserved_cache_nodes_offerings_paginator: elasticache.DescribeReservedCacheNodesOfferingsPaginator = client.get_paginator("describe_reserved_cache_nodes_offerings")
describe_service_updates_paginator: elasticache.DescribeServiceUpdatesPaginator = client.get_paginator("describe_service_updates")
describe_snapshots_paginator: elasticache.DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_update_actions_paginator: elasticache.DescribeUpdateActionsPaginator = client.get_paginator("describe_update_actions")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.