# Generated by Django 5.2.6 on 2025-09-20 16:57

import uuid

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AgentDefinition',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(db_index=True, max_length=100, unique=True)),
                ('display_name', models.CharField(blank=True, max_length=200)),
                ('description', models.TextField()),
                ('instructions', models.TextField(help_text='System prompt for the agent')),
                ('deps_type', models.CharField(help_text='Python class name for dependencies', max_length=100)),
                ('output_type', models.CharField(help_text='Python class name for output', max_length=100)),
                ('model', models.CharField(default='openai:gpt-4o-mini', max_length=100)),
                ('timeout', models.PositiveIntegerField(default=300, help_text='Timeout in seconds')),
                ('max_retries', models.PositiveIntegerField(default=3)),
                ('enable_caching', models.BooleanField(default=True)),
                ('tools_config', models.JSONField(blank=True, default=dict, help_text='Configuration for agent tools')),
                ('is_active', models.BooleanField(db_index=True, default=True)),
                ('is_public', models.BooleanField(default=False, help_text='Available to all users')),
                ('category', models.CharField(blank=True, db_index=True, max_length=50)),
                ('tags', models.JSONField(blank=True, default=list, help_text='List of tags')),
                ('version', models.CharField(default='1.0.0', max_length=20)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('usage_count', models.PositiveIntegerField(default=0)),
                ('last_used_at', models.DateTimeField(blank=True, null=True)),
                ('allowed_groups', models.ManyToManyField(blank=True, help_text='Groups allowed to use this agent', related_name='allowed_agents', to='auth.group')),
                ('allowed_users', models.ManyToManyField(blank=True, help_text='Users allowed to use this agent', related_name='allowed_agents', to=settings.AUTH_USER_MODEL)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='created_agents', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_agent_definitions',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='AgentExecution',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('agent_name', models.CharField(db_index=True, max_length=100)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('cancelled', 'Cancelled')], db_index=True, default='pending', max_length=20)),
                ('input_prompt', models.TextField()),
                ('output_data', models.JSONField(blank=True, null=True)),
                ('error_message', models.TextField(blank=True)),
                ('execution_time', models.FloatField(blank=True, help_text='Execution time in seconds', null=True)),
                ('tokens_used', models.IntegerField(default=0)),
                ('cost', models.DecimalField(decimal_places=6, default=0, max_digits=10)),
                ('cached', models.BooleanField(default=False)),
                ('execution_order', models.PositiveIntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                ('agent_definition', models.ForeignKey(blank=True, help_text='Agent definition used for this execution', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='executions', to='django_cfg_agents.agentdefinition')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_agent_executions',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='AgentTemplate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField()),
                ('template_config', models.JSONField(help_text='Template configuration')),
                ('default_instructions', models.TextField()),
                ('recommended_model', models.CharField(default='openai:gpt-4o-mini', max_length=100)),
                ('category', models.CharField(db_index=True, max_length=50)),
                ('use_cases', models.JSONField(default=list, help_text='List of use cases')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('is_active', models.BooleanField(default=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_agent_templates',
                'ordering': ['category', 'name'],
            },
        ),
        migrations.CreateModel(
            name='ApprovalLog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('approval_id', models.CharField(db_index=True, max_length=100, unique=True)),
                ('tool_name', models.CharField(max_length=100)),
                ('tool_args', models.JSONField()),
                ('justification', models.TextField(blank=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('approved', 'Approved'), ('rejected', 'Rejected'), ('expired', 'Expired')], db_index=True, default='pending', max_length=20)),
                ('rejection_reason', models.TextField(blank=True)),
                ('requested_at', models.DateTimeField(auto_now_add=True)),
                ('decided_at', models.DateTimeField(blank=True, null=True)),
                ('expires_at', models.DateTimeField(blank=True, null=True)),
                ('approved_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='approvals_given', to=settings.AUTH_USER_MODEL)),
                ('rejected_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='rejections_given', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='approval_requests', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_approval_logs',
                'ordering': ['-requested_at'],
            },
        ),
        migrations.CreateModel(
            name='ToolExecution',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('tool_name', models.CharField(db_index=True, max_length=100)),
                ('toolset_name', models.CharField(blank=True, max_length=100)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed')], db_index=True, default='pending', max_length=20)),
                ('arguments', models.JSONField(help_text='Tool arguments')),
                ('result', models.JSONField(blank=True, help_text='Tool execution result', null=True)),
                ('error_message', models.TextField(blank=True)),
                ('execution_time', models.FloatField(blank=True, null=True)),
                ('retry_count', models.PositiveIntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                ('agent_execution', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tool_executions', to='django_cfg_agents.agentexecution')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_tool_executions',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='ToolPermission',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('tool_name', models.CharField(db_index=True, max_length=100)),
                ('permission', models.CharField(choices=[('allow', 'Allow'), ('deny', 'Deny'), ('require_approval', 'Require Approval')], default='allow', max_length=20)),
                ('conditions', models.JSONField(blank=True, default=dict, help_text='Conditions for permission (e.g., argument limits)')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='tool_permissions_created', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_tool_permissions',
            },
        ),
        migrations.CreateModel(
            name='ToolsetConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True)),
                ('description', models.TextField()),
                ('toolset_class', models.CharField(help_text='Python class path', max_length=200)),
                ('config', models.JSONField(default=dict, help_text='Toolset configuration')),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('allowed_groups', models.ManyToManyField(blank=True, related_name='allowed_toolsets', to='auth.group')),
                ('allowed_users', models.ManyToManyField(blank=True, related_name='allowed_toolsets', to=settings.AUTH_USER_MODEL)),
                ('created_by', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_toolset_configurations',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='WorkflowExecution',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('name', models.CharField(blank=True, max_length=200)),
                ('pattern', models.CharField(choices=[('sequential', 'Sequential'), ('parallel', 'Parallel'), ('conditional', 'Conditional'), ('custom', 'Custom')], default='sequential', max_length=20)),
                ('agent_names', models.JSONField(help_text='List of agent names in execution order')),
                ('input_prompt', models.TextField()),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('running', 'Running'), ('completed', 'Completed'), ('failed', 'Failed'), ('cancelled', 'Cancelled'), ('paused', 'Paused')], db_index=True, default='pending', max_length=20)),
                ('current_step', models.PositiveIntegerField(default=0)),
                ('total_steps', models.PositiveIntegerField(default=0)),
                ('config', models.JSONField(blank=True, default=dict, help_text='Workflow configuration')),
                ('final_output', models.JSONField(blank=True, null=True)),
                ('error_message', models.TextField(blank=True)),
                ('total_execution_time', models.FloatField(blank=True, null=True)),
                ('total_tokens_used', models.IntegerField(default=0)),
                ('total_cost', models.DecimalField(decimal_places=6, default=0, max_digits=10)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True)),
                ('started_at', models.DateTimeField(blank=True, null=True)),
                ('completed_at', models.DateTimeField(blank=True, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'orchestrator_workflow_executions',
                'ordering': ['-created_at'],
            },
        ),
        migrations.AddField(
            model_name='agentexecution',
            name='workflow_execution',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='agent_executions', to='django_cfg_agents.workflowexecution'),
        ),
        migrations.AddIndex(
            model_name='agentdefinition',
            index=models.Index(fields=['is_active', 'category'], name='orchestrato_is_acti_f9af43_idx'),
        ),
        migrations.AddIndex(
            model_name='agentdefinition',
            index=models.Index(fields=['created_by', '-created_at'], name='orchestrato_created_718e45_idx'),
        ),
        migrations.AddIndex(
            model_name='agentdefinition',
            index=models.Index(fields=['-usage_count'], name='orchestrato_usage_c_334175_idx'),
        ),
        migrations.AddIndex(
            model_name='approvallog',
            index=models.Index(fields=['status', 'requested_at'], name='orchestrato_status_8a3b00_idx'),
        ),
        migrations.AddIndex(
            model_name='approvallog',
            index=models.Index(fields=['user', '-requested_at'], name='orchestrato_user_id_5e6a95_idx'),
        ),
        migrations.AddIndex(
            model_name='approvallog',
            index=models.Index(fields=['approved_by', '-decided_at'], name='orchestrato_approve_c60dbe_idx'),
        ),
        migrations.AddIndex(
            model_name='toolexecution',
            index=models.Index(fields=['tool_name', 'status'], name='orchestrato_tool_na_1408d7_idx'),
        ),
        migrations.AddIndex(
            model_name='toolexecution',
            index=models.Index(fields=['user', '-created_at'], name='orchestrato_user_id_189593_idx'),
        ),
        migrations.AddIndex(
            model_name='toolexecution',
            index=models.Index(fields=['agent_execution', 'created_at'], name='orchestrato_agent_e_e6203f_idx'),
        ),
        migrations.AddIndex(
            model_name='toolpermission',
            index=models.Index(fields=['user', 'tool_name'], name='orchestrato_user_id_bb2dd9_idx'),
        ),
        migrations.AddIndex(
            model_name='toolpermission',
            index=models.Index(fields=['tool_name', 'permission'], name='orchestrato_tool_na_c47a6e_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='toolpermission',
            unique_together={('user', 'tool_name')},
        ),
        migrations.AddIndex(
            model_name='workflowexecution',
            index=models.Index(fields=['status', 'created_at'], name='orchestrato_status_52c411_idx'),
        ),
        migrations.AddIndex(
            model_name='workflowexecution',
            index=models.Index(fields=['user', '-created_at'], name='orchestrato_user_id_daaa84_idx'),
        ),
        migrations.AddIndex(
            model_name='workflowexecution',
            index=models.Index(fields=['pattern', 'status'], name='orchestrato_pattern_dd9e33_idx'),
        ),
        migrations.AddIndex(
            model_name='agentexecution',
            index=models.Index(fields=['status', 'created_at'], name='orchestrato_status_a92529_idx'),
        ),
        migrations.AddIndex(
            model_name='agentexecution',
            index=models.Index(fields=['agent_name', 'user'], name='orchestrato_agent_n_741302_idx'),
        ),
        migrations.AddIndex(
            model_name='agentexecution',
            index=models.Index(fields=['user', '-created_at'], name='orchestrato_user_id_cd3699_idx'),
        ),
        migrations.AddIndex(
            model_name='agentexecution',
            index=models.Index(fields=['workflow_execution', 'execution_order'], name='orchestrato_workflo_d227b5_idx'),
        ),
    ]
