/*
 *  Copyright (C) GridGain Systems. All Rights Reserved.
 *  _________        _____ __________________        _____
 *  __  ____/___________(_)______  /__  ____/______ ____(_)_______
 *  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
 *  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
 *  \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/
 */

/**
 * @file
 * Declares ignite::ssl_mode.
 */

#pragma once

namespace ignite
{

/** SSL Mode. */
enum class ssl_mode
{
    /** Do not try establish SSL/TLS connection. */
    DISABLE = 0,

    /** Try to establish SSL/TLS connection. Fail if the server does not support SSL/TLS. */
    REQUIRE = 1
};

} // namespace ignite
