# Copyright (C) GridGain Systems. All Rights Reserved.
# _________        _____ __________________        _____
# __  ____/___________(_)______  /__  ____/______ ____(_)_______
# _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \
# / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /
# \____/   /_/     /_/   \_,__/   \____/   \__,_/  /_/   /_/ /_/


class BasicAuthenticator:
    """
    Basic Authenticator.
    Uses username and password to authenticate.
    """

    def __init__(self, username: str, password: str):
        """
        Initialize basic authenticator.

        :param username: Username to use for authentication.
        :param password: Password to use for authentication.
        """
        self._username = username
        self._password = password

    @property
    def username(self) -> str:
        return self._username

    @property
    def password(self) -> str:
        return self._password
