import enum

class NTStatus(enum.Enum):
	SUCCESS = 0x00000000
	WAIT_0 = 0x00000000
	WAIT_1 = 0x00000001
	WAIT_2 = 0x00000002
	WAIT_3 = 0x00000003
	WAIT_63 = 0x0000003F
	ABANDONED = 0x00000080
	ABANDONED_WAIT_0 = 0x00000080
	ABANDONED_WAIT_63 = 0x000000BF
	USER_APC = 0x000000C0
	KERNEL_APC = 0x00000100
	ALERTED = 0x00000101
	TIMEOUT = 0x00000102
	PENDING = 0x00000103
	REPARSE = 0x00000104
	MORE_ENTRIES = 0x00000105
	NOT_ALL_ASSIGNED = 0x00000106
	SOME_NOT_MAPPED = 0x00000107
	OPLOCK_BREAK_IN_PROGRESS = 0x00000108
	VOLUME_MOUNTED = 0x00000109
	RXACT_COMMITTED = 0x0000010A
	NOTIFY_CLEANUP = 0x0000010B
	NOTIFY_ENUM_DIR = 0x0000010C
	NO_QUOTAS_FOR_ACCOUNT = 0x0000010D
	PRIMARY_TRANSPORT_CONNECT_FAILED = 0x0000010E
	PAGE_FAULT_TRANSITION = 0x00000110
	PAGE_FAULT_DEMAND_ZERO = 0x00000111
	PAGE_FAULT_COPY_ON_WRITE = 0x00000112
	PAGE_FAULT_GUARD_PAGE = 0x00000113
	PAGE_FAULT_PAGING_FILE = 0x00000114
	CACHE_PAGE_LOCKED = 0x00000115
	CRASH_DUMP = 0x00000116
	BUFFER_ALL_ZEROS = 0x00000117
	REPARSE_OBJECT = 0x00000118
	RESOURCE_REQUIREMENTS_CHANGED = 0x00000119
	TRANSLATION_COMPLETE = 0x00000120
	DS_MEMBERSHIP_EVALUATED_LOCALLY = 0x00000121
	NOTHING_TO_TERMINATE = 0x00000122
	PROCESS_NOT_IN_JOB = 0x00000123
	PROCESS_IN_JOB = 0x00000124
	VOLSNAP_HIBERNATE_READY = 0x00000125
	FSFILTER_OP_COMPLETED_SUCCESSFULLY = 0x00000126
	INTERRUPT_VECTOR_ALREADY_CONNECTED = 0x00000127
	INTERRUPT_STILL_CONNECTED = 0x00000128
	PROCESS_CLONED = 0x00000129
	FILE_LOCKED_WITH_ONLY_READERS = 0x0000012A
	FILE_LOCKED_WITH_WRITERS = 0x0000012B
	RESOURCEMANAGER_READ_ONLY = 0x00000202
	RING_PREVIOUSLY_EMPTY = 0x00000210
	RING_PREVIOUSLY_FULL = 0x00000211
	RING_PREVIOUSLY_ABOVE_QUOTA = 0x00000212
	RING_NEWLY_EMPTY = 0x00000213
	RING_SIGNAL_OPPOSITE_ENDPOINT = 0x00000214
	OPLOCK_SWITCHED_TO_NEW_HANDLE = 0x00000215
	OPLOCK_HANDLE_CLOSED = 0x00000216
	WAIT_FOR_OPLOCK = 0x00000367
	FLT_IO_COMPLETE = 0x001C0001
	DIS_ATTRIBUTE_BUILT = 0x003C0001
	OBJECT_NAME_EXISTS = 0x40000000
	THREAD_WAS_SUSPENDED = 0x40000001
	WORKING_SET_LIMIT_RANGE = 0x40000002
	IMAGE_NOT_AT_BASE = 0x40000003
	RXACT_STATE_CREATED = 0x40000004
	SEGMENT_NOTIFICATION = 0x40000005
	LOCAL_USER_SESSION_KEY = 0x40000006
	BAD_CURRENT_DIRECTORY = 0x40000007
	SERIAL_MORE_WRITES = 0x40000008
	REGISTRY_RECOVERED = 0x40000009
	FT_READ_RECOVERY_FROM_BACKUP = 0x4000000A
	FT_WRITE_RECOVERY = 0x4000000B
	SERIAL_COUNTER_TIMEOUT = 0x4000000C
	NULL_LM_PASSWORD = 0x4000000D
	IMAGE_MACHINE_TYPE_MISMATCH = 0x4000000E
	RECEIVE_PARTIAL = 0x4000000F
	RECEIVE_EXPEDITED = 0x40000010
	RECEIVE_PARTIAL_EXPEDITED = 0x40000011
	EVENT_DONE = 0x40000012
	EVENT_PENDING = 0x40000013
	CHECKING_FILE_SYSTEM = 0x40000014
	FATAL_APP_EXIT = 0x40000015
	PREDEFINED_HANDLE = 0x40000016
	WAS_UNLOCKED = 0x40000017
	SERVICE_NOTIFICATION = 0x40000018
	WAS_LOCKED = 0x40000019
	LOG_HARD_ERROR = 0x4000001A
	ALREADY_WIN32 = 0x4000001B
	WX86_UNSIMULATE = 0x4000001C
	WX86_CONTINUE = 0x4000001D
	WX86_SINGLE_STEP = 0x4000001E
	WX86_BREAKPOINT = 0x4000001F
	WX86_EXCEPTION_CONTINUE = 0x40000020
	WX86_EXCEPTION_LASTCHANCE = 0x40000021
	WX86_EXCEPTION_CHAIN = 0x40000022
	IMAGE_MACHINE_TYPE_MISMATCH_EXE = 0x40000023
	NO_YIELD_PERFORMED = 0x40000024
	TIMER_RESUME_IGNORED = 0x40000025
	ARBITRATION_UNHANDLED = 0x40000026
	CARDBUS_NOT_SUPPORTED = 0x40000027
	WX86_CREATEWX86TIB = 0x40000028
	MP_PROCESSOR_MISMATCH = 0x40000029
	HIBERNATED = 0x4000002A
	RESUME_HIBERNATION = 0x4000002B
	FIRMWARE_UPDATED = 0x4000002C
	DRIVERS_LEAKING_LOCKED_PAGES = 0x4000002D
	MESSAGE_RETRIEVED = 0x4000002E
	SYSTEM_POWERSTATE_TRANSITION = 0x4000002F
	ALPC_CHECK_COMPLETION_LIST = 0x40000030
	SYSTEM_POWERSTATE_COMPLEX_TRANSITION = 0x40000031
	ACCESS_AUDIT_BY_POLICY = 0x40000032
	ABANDON_HIBERFILE = 0x40000033
	BIZRULES_NOT_ENABLED = 0x40000034
	HEURISTIC_DAMAGE_POSSIBLE = 0x40190001
	GUARD_PAGE_VIOLATION = 0x80000001
	DATATYPE_MISALIGNMENT = 0x80000002
	BREAKPOINT = 0x80000003
	SINGLE_STEP = 0x80000004
	BUFFER_OVERFLOW = 0x80000005
	NO_MORE_FILES = 0x80000006
	WAKE_SYSTEM_DEBUGGER = 0x80000007
	HANDLES_CLOSED = 0x8000000A
	NO_INHERITANCE = 0x8000000B
	GUID_SUBSTITUTION_MADE = 0x8000000C
	PARTIAL_COPY = 0x8000000D
	DEVICE_PAPER_EMPTY = 0x8000000E
	DEVICE_POWERED_OFF = 0x8000000F
	DEVICE_OFF_LINE = 0x80000010
	DEVICE_BUSY = 0x80000011
	NO_MORE_EAS = 0x80000012
	INVALID_EA_NAME = 0x80000013
	EA_LIST_INCONSISTENT = 0x80000014
	INVALID_EA_FLAG = 0x80000015
	VERIFY_REQUIRED = 0x80000016
	EXTRANEOUS_INFORMATION = 0x80000017
	RXACT_COMMIT_NECESSARY = 0x80000018
	NO_MORE_ENTRIES = 0x8000001A
	FILEMARK_DETECTED = 0x8000001B
	MEDIA_CHANGED = 0x8000001C
	BUS_RESET = 0x8000001D
	END_OF_MEDIA = 0x8000001E
	BEGINNING_OF_MEDIA = 0x8000001F
	MEDIA_CHECK = 0x80000020
	SETMARK_DETECTED = 0x80000021
	NO_DATA_DETECTED = 0x80000022
	REDIRECTOR_HAS_OPEN_HANDLES = 0x80000023
	SERVER_HAS_OPEN_HANDLES = 0x80000024
	ALREADY_DISCONNECTED = 0x80000025
	LONGJUMP = 0x80000026
	CLEANER_CARTRIDGE_INSTALLED = 0x80000027
	PLUGPLAY_QUERY_VETOED = 0x80000028
	UNWIND_CONSOLIDATE = 0x80000029
	REGISTRY_HIVE_RECOVERED = 0x8000002A
	DLL_MIGHT_BE_INSECURE = 0x8000002B
	DLL_MIGHT_BE_INCOMPATIBLE = 0x8000002C
	STOPPED_ON_SYMLINK = 0x8000002D
	CANNOT_GRANT_REQUESTED_OPLOCK = 0x8000002E
	NO_ACE_CONDITION = 0x8000002F
	CLUSTER_NODE_ALREADY_UP = 0x80130001
	CLUSTER_NODE_ALREADY_DOWN = 0x80130002
	CLUSTER_NETWORK_ALREADY_ONLINE = 0x80130003
	CLUSTER_NETWORK_ALREADY_OFFLINE = 0x80130004
	CLUSTER_NODE_ALREADY_MEMBER = 0x80130005
	FLT_BUFFER_TOO_SMALL = 0x801C0001
	FVE_PARTIAL_METADATA = 0x80210001
	FVE_TRANSIENT_STATE = 0x80210002
	UNSUCCESSFUL = 0xC0000001
	NOT_IMPLEMENTED = 0xC0000002
	INVALID_INFO_CLASS = 0xC0000003
	INFO_LENGTH_MISMATCH = 0xC0000004
	ACCESS_VIOLATION = 0xC0000005
	IN_PAGE_ERROR = 0xC0000006
	PAGEFILE_QUOTA = 0xC0000007
	INVALID_HANDLE = 0xC0000008
	BAD_INITIAL_STACK = 0xC0000009
	BAD_INITIAL_PC = 0xC000000A
	INVALID_CID = 0xC000000B
	TIMER_NOT_CANCELED = 0xC000000C
	INVALID_PARAMETER = 0xC000000D
	NO_SUCH_DEVICE = 0xC000000E
	NO_SUCH_FILE = 0xC000000F
	INVALID_DEVICE_REQUEST = 0xC0000010
	END_OF_FILE = 0xC0000011
	WRONG_VOLUME = 0xC0000012
	NO_MEDIA_IN_DEVICE = 0xC0000013
	UNRECOGNIZED_MEDIA = 0xC0000014
	NONEXISTENT_SECTOR = 0xC0000015
	MORE_PROCESSING_REQUIRED = 0xC0000016
	NO_MEMORY = 0xC0000017
	CONFLICTING_ADDRESSES = 0xC0000018
	NOT_MAPPED_VIEW = 0xC0000019
	UNABLE_TO_FREE_VM = 0xC000001A
	UNABLE_TO_DELETE_SECTION = 0xC000001B
	INVALID_SYSTEM_SERVICE = 0xC000001C
	ILLEGAL_INSTRUCTION = 0xC000001D
	INVALID_LOCK_SEQUENCE = 0xC000001E
	INVALID_VIEW_SIZE = 0xC000001F
	INVALID_FILE_FOR_SECTION = 0xC0000020
	ALREADY_COMMITTED = 0xC0000021
	ACCESS_DENIED = 0xC0000022
	BUFFER_TOO_SMALL = 0xC0000023
	OBJECT_TYPE_MISMATCH = 0xC0000024
	NONCONTINUABLE_EXCEPTION = 0xC0000025
	INVALID_DISPOSITION = 0xC0000026
	UNWIND = 0xC0000027
	BAD_STACK = 0xC0000028
	INVALID_UNWIND_TARGET = 0xC0000029
	NOT_LOCKED = 0xC000002A
	PARITY_ERROR = 0xC000002B
	UNABLE_TO_DECOMMIT_VM = 0xC000002C
	NOT_COMMITTED = 0xC000002D
	INVALID_PORT_ATTRIBUTES = 0xC000002E
	PORT_MESSAGE_TOO_LONG = 0xC000002F
	INVALID_PARAMETER_MIX = 0xC0000030
	INVALID_QUOTA_LOWER = 0xC0000031
	DISK_CORRUPT_ERROR = 0xC0000032
	OBJECT_NAME_INVALID = 0xC0000033
	OBJECT_NAME_NOT_FOUND = 0xC0000034
	OBJECT_NAME_COLLISION = 0xC0000035
	PORT_DISCONNECTED = 0xC0000037
	DEVICE_ALREADY_ATTACHED = 0xC0000038
	OBJECT_PATH_INVALID = 0xC0000039
	OBJECT_PATH_NOT_FOUND = 0xC000003A
	OBJECT_PATH_SYNTAX_BAD = 0xC000003B
	DATA_OVERRUN = 0xC000003C
	DATA_LATE_ERROR = 0xC000003D
	DATA_ERROR = 0xC000003E
	CRC_ERROR = 0xC000003F
	SECTION_TOO_BIG = 0xC0000040
	PORT_CONNECTION_REFUSED = 0xC0000041
	INVALID_PORT_HANDLE = 0xC0000042
	SHARING_VIOLATION = 0xC0000043
	QUOTA_EXCEEDED = 0xC0000044
	INVALID_PAGE_PROTECTION = 0xC0000045
	MUTANT_NOT_OWNED = 0xC0000046
	SEMAPHORE_LIMIT_EXCEEDED = 0xC0000047
	PORT_ALREADY_SET = 0xC0000048
	SECTION_NOT_IMAGE = 0xC0000049
	SUSPEND_COUNT_EXCEEDED = 0xC000004A
	THREAD_IS_TERMINATING = 0xC000004B
	BAD_WORKING_SET_LIMIT = 0xC000004C
	INCOMPATIBLE_FILE_MAP = 0xC000004D
	SECTION_PROTECTION = 0xC000004E
	EAS_NOT_SUPPORTED = 0xC000004F
	EA_TOO_LARGE = 0xC0000050
	NONEXISTENT_EA_ENTRY = 0xC0000051
	NO_EAS_ON_FILE = 0xC0000052
	EA_CORRUPT_ERROR = 0xC0000053
	FILE_LOCK_CONFLICT = 0xC0000054
	LOCK_NOT_GRANTED = 0xC0000055
	DELETE_PENDING = 0xC0000056
	CTL_FILE_NOT_SUPPORTED = 0xC0000057
	UNKNOWN_REVISION = 0xC0000058
	REVISION_MISMATCH = 0xC0000059
	INVALID_OWNER = 0xC000005A
	INVALID_PRIMARY_GROUP = 0xC000005B
	NO_IMPERSONATION_TOKEN = 0xC000005C
	CANT_DISABLE_MANDATORY = 0xC000005D
	NO_LOGON_SERVERS = 0xC000005E
	NO_SUCH_LOGON_SESSION = 0xC000005F
	NO_SUCH_PRIVILEGE = 0xC0000060
	PRIVILEGE_NOT_HELD = 0xC0000061
	INVALID_ACCOUNT_NAME = 0xC0000062
	USER_EXISTS = 0xC0000063
	NO_SUCH_USER = 0xC0000064
	GROUP_EXISTS = 0xC0000065
	NO_SUCH_GROUP = 0xC0000066
	MEMBER_IN_GROUP = 0xC0000067
	MEMBER_NOT_IN_GROUP = 0xC0000068
	LAST_ADMIN = 0xC0000069
	WRONG_PASSWORD = 0xC000006A
	ILL_FORMED_PASSWORD = 0xC000006B
	PASSWORD_RESTRICTION = 0xC000006C
	LOGON_FAILURE = 0xC000006D
	ACCOUNT_RESTRICTION = 0xC000006E
	INVALID_LOGON_HOURS = 0xC000006F
	INVALID_WORKSTATION = 0xC0000070
	PASSWORD_EXPIRED = 0xC0000071
	ACCOUNT_DISABLED = 0xC0000072
	NONE_MAPPED = 0xC0000073
	TOO_MANY_LUIDS_REQUESTED = 0xC0000074
	LUIDS_EXHAUSTED = 0xC0000075
	INVALID_SUB_AUTHORITY = 0xC0000076
	INVALID_ACL = 0xC0000077
	INVALID_SID = 0xC0000078
	INVALID_SECURITY_DESCR = 0xC0000079
	PROCEDURE_NOT_FOUND = 0xC000007A
	INVALID_IMAGE_FORMAT = 0xC000007B
	NO_TOKEN = 0xC000007C
	BAD_INHERITANCE_ACL = 0xC000007D
	RANGE_NOT_LOCKED = 0xC000007E
	DISK_FULL = 0xC000007F
	SERVER_DISABLED = 0xC0000080
	SERVER_NOT_DISABLED = 0xC0000081
	TOO_MANY_GUIDS_REQUESTED = 0xC0000082
	GUIDS_EXHAUSTED = 0xC0000083
	INVALID_ID_AUTHORITY = 0xC0000084
	AGENTS_EXHAUSTED = 0xC0000085
	INVALID_VOLUME_LABEL = 0xC0000086
	SECTION_NOT_EXTENDED = 0xC0000087
	NOT_MAPPED_DATA = 0xC0000088
	RESOURCE_DATA_NOT_FOUND = 0xC0000089
	RESOURCE_TYPE_NOT_FOUND = 0xC000008A
	RESOURCE_NAME_NOT_FOUND = 0xC000008B
	ARRAY_BOUNDS_EXCEEDED = 0xC000008C
	FLOAT_DENORMAL_OPERAND = 0xC000008D
	FLOAT_DIVIDE_BY_ZERO = 0xC000008E
	FLOAT_INEXACT_RESULT = 0xC000008F
	FLOAT_INVALID_OPERATION = 0xC0000090
	FLOAT_OVERFLOW = 0xC0000091
	FLOAT_STACK_CHECK = 0xC0000092
	FLOAT_UNDERFLOW = 0xC0000093
	INTEGER_DIVIDE_BY_ZERO = 0xC0000094
	INTEGER_OVERFLOW = 0xC0000095
	PRIVILEGED_INSTRUCTION = 0xC0000096
	TOO_MANY_PAGING_FILES = 0xC0000097
	FILE_INVALID = 0xC0000098
	ALLOTTED_SPACE_EXCEEDED = 0xC0000099
	INSUFFICIENT_RESOURCES = 0xC000009A
	DFS_EXIT_PATH_FOUND = 0xC000009B
	DEVICE_DATA_ERROR = 0xC000009C
	DEVICE_NOT_CONNECTED = 0xC000009D
	DEVICE_POWER_FAILURE = 0xC000009E
	FREE_VM_NOT_AT_BASE = 0xC000009F
	MEMORY_NOT_ALLOCATED = 0xC00000A0
	WORKING_SET_QUOTA = 0xC00000A1
	MEDIA_WRITE_PROTECTED = 0xC00000A2
	DEVICE_NOT_READY = 0xC00000A3
	INVALID_GROUP_ATTRIBUTES = 0xC00000A4
	BAD_IMPERSONATION_LEVEL = 0xC00000A5
	CANT_OPEN_ANONYMOUS = 0xC00000A6
	BAD_VALIDATION_CLASS = 0xC00000A7
	BAD_TOKEN_TYPE = 0xC00000A8
	BAD_MASTER_BOOT_RECORD = 0xC00000A9
	INSTRUCTION_MISALIGNMENT = 0xC00000AA
	INSTANCE_NOT_AVAILABLE = 0xC00000AB
	PIPE_NOT_AVAILABLE = 0xC00000AC
	INVALID_PIPE_STATE = 0xC00000AD
	PIPE_BUSY = 0xC00000AE
	ILLEGAL_FUNCTION = 0xC00000AF
	PIPE_DISCONNECTED = 0xC00000B0
	PIPE_CLOSING = 0xC00000B1
	PIPE_CONNECTED = 0xC00000B2
	PIPE_LISTENING = 0xC00000B3
	INVALID_READ_MODE = 0xC00000B4
	IO_TIMEOUT = 0xC00000B5
	FILE_FORCED_CLOSED = 0xC00000B6
	PROFILING_NOT_STARTED = 0xC00000B7
	PROFILING_NOT_STOPPED = 0xC00000B8
	COULD_NOT_INTERPRET = 0xC00000B9
	FILE_IS_A_DIRECTORY = 0xC00000BA
	NOT_SUPPORTED = 0xC00000BB
	REMOTE_NOT_LISTENING = 0xC00000BC
	DUPLICATE_NAME = 0xC00000BD
	BAD_NETWORK_PATH = 0xC00000BE
	NETWORK_BUSY = 0xC00000BF
	DEVICE_DOES_NOT_EXIST = 0xC00000C0
	TOO_MANY_COMMANDS = 0xC00000C1
	ADAPTER_HARDWARE_ERROR = 0xC00000C2
	INVALID_NETWORK_RESPONSE = 0xC00000C3
	UNEXPECTED_NETWORK_ERROR = 0xC00000C4
	BAD_REMOTE_ADAPTER = 0xC00000C5
	PRINT_QUEUE_FULL = 0xC00000C6
	NO_SPOOL_SPACE = 0xC00000C7
	PRINT_CANCELLED = 0xC00000C8
	NETWORK_NAME_DELETED = 0xC00000C9
	NETWORK_ACCESS_DENIED = 0xC00000CA
	BAD_DEVICE_TYPE = 0xC00000CB
	BAD_NETWORK_NAME = 0xC00000CC
	TOO_MANY_NAMES = 0xC00000CD
	TOO_MANY_SESSIONS = 0xC00000CE
	SHARING_PAUSED = 0xC00000CF
	REQUEST_NOT_ACCEPTED = 0xC00000D0
	REDIRECTOR_PAUSED = 0xC00000D1
	NET_WRITE_FAULT = 0xC00000D2
	PROFILING_AT_LIMIT = 0xC00000D3
	NOT_SAME_DEVICE = 0xC00000D4
	FILE_RENAMED = 0xC00000D5
	VIRTUAL_CIRCUIT_CLOSED = 0xC00000D6
	NO_SECURITY_ON_OBJECT = 0xC00000D7
	CANT_WAIT = 0xC00000D8
	PIPE_EMPTY = 0xC00000D9
	CANT_ACCESS_DOMAIN_INFO = 0xC00000DA
	CANT_TERMINATE_SELF = 0xC00000DB
	INVALID_SERVER_STATE = 0xC00000DC
	INVALID_DOMAIN_STATE = 0xC00000DD
	INVALID_DOMAIN_ROLE = 0xC00000DE
	NO_SUCH_DOMAIN = 0xC00000DF
	DOMAIN_EXISTS = 0xC00000E0
	DOMAIN_LIMIT_EXCEEDED = 0xC00000E1
	OPLOCK_NOT_GRANTED = 0xC00000E2
	INVALID_OPLOCK_PROTOCOL = 0xC00000E3
	INTERNAL_DB_CORRUPTION = 0xC00000E4
	INTERNAL_ERROR = 0xC00000E5
	GENERIC_NOT_MAPPED = 0xC00000E6
	BAD_DESCRIPTOR_FORMAT = 0xC00000E7
	INVALID_USER_BUFFER = 0xC00000E8
	UNEXPECTED_IO_ERROR = 0xC00000E9
	UNEXPECTED_MM_CREATE_ERR = 0xC00000EA
	UNEXPECTED_MM_MAP_ERROR = 0xC00000EB
	UNEXPECTED_MM_EXTEND_ERR = 0xC00000EC
	NOT_LOGON_PROCESS = 0xC00000ED
	LOGON_SESSION_EXISTS = 0xC00000EE
	INVALID_PARAMETER_1 = 0xC00000EF
	INVALID_PARAMETER_2 = 0xC00000F0
	INVALID_PARAMETER_3 = 0xC00000F1
	INVALID_PARAMETER_4 = 0xC00000F2
	INVALID_PARAMETER_5 = 0xC00000F3
	INVALID_PARAMETER_6 = 0xC00000F4
	INVALID_PARAMETER_7 = 0xC00000F5
	INVALID_PARAMETER_8 = 0xC00000F6
	INVALID_PARAMETER_9 = 0xC00000F7
	INVALID_PARAMETER_10 = 0xC00000F8
	INVALID_PARAMETER_11 = 0xC00000F9
	INVALID_PARAMETER_12 = 0xC00000FA
	REDIRECTOR_NOT_STARTED = 0xC00000FB
	REDIRECTOR_STARTED = 0xC00000FC
	STACK_OVERFLOW = 0xC00000FD
	NO_SUCH_PACKAGE = 0xC00000FE
	BAD_FUNCTION_TABLE = 0xC00000FF
	VARIABLE_NOT_FOUND = 0xC0000100
	DIRECTORY_NOT_EMPTY = 0xC0000101
	FILE_CORRUPT_ERROR = 0xC0000102
	NOT_A_DIRECTORY = 0xC0000103
	BAD_LOGON_SESSION_STATE = 0xC0000104
	LOGON_SESSION_COLLISION = 0xC0000105
	NAME_TOO_LONG = 0xC0000106
	FILES_OPEN = 0xC0000107
	CONNECTION_IN_USE = 0xC0000108
	MESSAGE_NOT_FOUND = 0xC0000109
	PROCESS_IS_TERMINATING = 0xC000010A
	INVALID_LOGON_TYPE = 0xC000010B
	NO_GUID_TRANSLATION = 0xC000010C
	CANNOT_IMPERSONATE = 0xC000010D
	IMAGE_ALREADY_LOADED = 0xC000010E
	ABIOS_NOT_PRESENT = 0xC000010F
	ABIOS_LID_NOT_EXIST = 0xC0000110
	ABIOS_LID_ALREADY_OWNED = 0xC0000111
	ABIOS_NOT_LID_OWNER = 0xC0000112
	ABIOS_INVALID_COMMAND = 0xC0000113
	ABIOS_INVALID_LID = 0xC0000114
	ABIOS_SELECTOR_NOT_AVAILABLE = 0xC0000115
	ABIOS_INVALID_SELECTOR = 0xC0000116
	NO_LDT = 0xC0000117
	INVALID_LDT_SIZE = 0xC0000118
	INVALID_LDT_OFFSET = 0xC0000119
	INVALID_LDT_DESCRIPTOR = 0xC000011A
	INVALID_IMAGE_NE_FORMAT = 0xC000011B
	RXACT_INVALID_STATE = 0xC000011C
	RXACT_COMMIT_FAILURE = 0xC000011D
	MAPPED_FILE_SIZE_ZERO = 0xC000011E
	TOO_MANY_OPENED_FILES = 0xC000011F
	CANCELLED = 0xC0000120
	CANNOT_DELETE = 0xC0000121
	INVALID_COMPUTER_NAME = 0xC0000122
	FILE_DELETED = 0xC0000123
	SPECIAL_ACCOUNT = 0xC0000124
	SPECIAL_GROUP = 0xC0000125
	SPECIAL_USER = 0xC0000126
	MEMBERS_PRIMARY_GROUP = 0xC0000127
	FILE_CLOSED = 0xC0000128
	TOO_MANY_THREADS = 0xC0000129
	THREAD_NOT_IN_PROCESS = 0xC000012A
	TOKEN_ALREADY_IN_USE = 0xC000012B
	PAGEFILE_QUOTA_EXCEEDED = 0xC000012C
	COMMITMENT_LIMIT = 0xC000012D
	INVALID_IMAGE_LE_FORMAT = 0xC000012E
	INVALID_IMAGE_NOT_MZ = 0xC000012F
	INVALID_IMAGE_PROTECT = 0xC0000130
	INVALID_IMAGE_WIN_16 = 0xC0000131
	LOGON_SERVER_CONFLICT = 0xC0000132
	TIME_DIFFERENCE_AT_DC = 0xC0000133
	SYNCHRONIZATION_REQUIRED = 0xC0000134
	DLL_NOT_FOUND = 0xC0000135
	OPEN_FAILED = 0xC0000136
	IO_PRIVILEGE_FAILED = 0xC0000137
	ORDINAL_NOT_FOUND = 0xC0000138
	ENTRYPOINT_NOT_FOUND = 0xC0000139
	CONTROL_C_EXIT = 0xC000013A
	LOCAL_DISCONNECT = 0xC000013B
	REMOTE_DISCONNECT = 0xC000013C
	REMOTE_RESOURCES = 0xC000013D
	LINK_FAILED = 0xC000013E
	LINK_TIMEOUT = 0xC000013F
	INVALID_CONNECTION = 0xC0000140
	INVALID_ADDRESS = 0xC0000141
	DLL_INIT_FAILED = 0xC0000142
	MISSING_SYSTEMFILE = 0xC0000143
	UNHANDLED_EXCEPTION = 0xC0000144
	APP_INIT_FAILURE = 0xC0000145
	PAGEFILE_CREATE_FAILED = 0xC0000146
	NO_PAGEFILE = 0xC0000147
	INVALID_LEVEL = 0xC0000148
	WRONG_PASSWORD_CORE = 0xC0000149
	ILLEGAL_FLOAT_CONTEXT = 0xC000014A
	PIPE_BROKEN = 0xC000014B
	REGISTRY_CORRUPT = 0xC000014C
	REGISTRY_IO_FAILED = 0xC000014D
	NO_EVENT_PAIR = 0xC000014E
	UNRECOGNIZED_VOLUME = 0xC000014F
	SERIAL_NO_DEVICE_INITED = 0xC0000150
	NO_SUCH_ALIAS = 0xC0000151
	MEMBER_NOT_IN_ALIAS = 0xC0000152
	MEMBER_IN_ALIAS = 0xC0000153
	ALIAS_EXISTS = 0xC0000154
	LOGON_NOT_GRANTED = 0xC0000155
	TOO_MANY_SECRETS = 0xC0000156
	SECRET_TOO_LONG = 0xC0000157
	INTERNAL_DB_ERROR = 0xC0000158
	FULLSCREEN_MODE = 0xC0000159
	TOO_MANY_CONTEXT_IDS = 0xC000015A
	LOGON_TYPE_NOT_GRANTED = 0xC000015B
	NOT_REGISTRY_FILE = 0xC000015C
	NT_CROSS_ENCRYPTION_REQUIRED = 0xC000015D
	DOMAIN_CTRLR_CONFIG_ERROR = 0xC000015E
	FT_MISSING_MEMBER = 0xC000015F
	ILL_FORMED_SERVICE_ENTRY = 0xC0000160
	ILLEGAL_CHARACTER = 0xC0000161
	UNMAPPABLE_CHARACTER = 0xC0000162
	UNDEFINED_CHARACTER = 0xC0000163
	FLOPPY_VOLUME = 0xC0000164
	FLOPPY_ID_MARK_NOT_FOUND = 0xC0000165
	FLOPPY_WRONG_CYLINDER = 0xC0000166
	FLOPPY_UNKNOWN_ERROR = 0xC0000167
	FLOPPY_BAD_REGISTERS = 0xC0000168
	DISK_RECALIBRATE_FAILED = 0xC0000169
	DISK_OPERATION_FAILED = 0xC000016A
	DISK_RESET_FAILED = 0xC000016B
	SHARED_IRQ_BUSY = 0xC000016C
	FT_ORPHANING = 0xC000016D
	BIOS_FAILED_TO_CONNECT_INTERRUPT = 0xC000016E
	PARTITION_FAILURE = 0xC0000172
	INVALID_BLOCK_LENGTH = 0xC0000173
	DEVICE_NOT_PARTITIONED = 0xC0000174
	UNABLE_TO_LOCK_MEDIA = 0xC0000175
	UNABLE_TO_UNLOAD_MEDIA = 0xC0000176
	EOM_OVERFLOW = 0xC0000177
	NO_MEDIA = 0xC0000178
	NO_SUCH_MEMBER = 0xC000017A
	INVALID_MEMBER = 0xC000017B
	KEY_DELETED = 0xC000017C
	NO_LOG_SPACE = 0xC000017D
	TOO_MANY_SIDS = 0xC000017E
	LM_CROSS_ENCRYPTION_REQUIRED = 0xC000017F
	KEY_HAS_CHILDREN = 0xC0000180
	CHILD_MUST_BE_VOLATILE = 0xC0000181
	DEVICE_CONFIGURATION_ERROR = 0xC0000182
	DRIVER_INTERNAL_ERROR = 0xC0000183
	INVALID_DEVICE_STATE = 0xC0000184
	IO_DEVICE_ERROR = 0xC0000185
	DEVICE_PROTOCOL_ERROR = 0xC0000186
	BACKUP_CONTROLLER = 0xC0000187
	LOG_FILE_FULL = 0xC0000188
	TOO_LATE = 0xC0000189
	NO_TRUST_LSA_SECRET = 0xC000018A
	NO_TRUST_SAM_ACCOUNT = 0xC000018B
	TRUSTED_DOMAIN_FAILURE = 0xC000018C
	TRUSTED_RELATIONSHIP_FAILURE = 0xC000018D
	EVENTLOG_FILE_CORRUPT = 0xC000018E
	EVENTLOG_CANT_START = 0xC000018F
	TRUST_FAILURE = 0xC0000190
	MUTANT_LIMIT_EXCEEDED = 0xC0000191
	NETLOGON_NOT_STARTED = 0xC0000192
	ACCOUNT_EXPIRED = 0xC0000193
	POSSIBLE_DEADLOCK = 0xC0000194
	NETWORK_CREDENTIAL_CONFLICT = 0xC0000195
	REMOTE_SESSION_LIMIT = 0xC0000196
	EVENTLOG_FILE_CHANGED = 0xC0000197
	NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 0xC0000198
	NOLOGON_WORKSTATION_TRUST_ACCOUNT = 0xC0000199
	NOLOGON_SERVER_TRUST_ACCOUNT = 0xC000019A
	DOMAIN_TRUST_INCONSISTENT = 0xC000019B
	FS_DRIVER_REQUIRED = 0xC000019C
	IMAGE_ALREADY_LOADED_AS_DLL = 0xC000019D
	INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING = 0xC000019E
	SHORT_NAMES_NOT_ENABLED_ON_VOLUME = 0xC000019F
	SECURITY_STREAM_IS_INCONSISTENT = 0xC00001A0
	INVALID_LOCK_RANGE = 0xC00001A1
	INVALID_ACE_CONDITION = 0xC00001A2
	IMAGE_SUBSYSTEM_NOT_PRESENT = 0xC00001A3
	NOTIFICATION_GUID_ALREADY_DEFINED = 0xC00001A4
	NETWORK_OPEN_RESTRICTION = 0xC0000201
	NO_USER_SESSION_KEY = 0xC0000202
	USER_SESSION_DELETED = 0xC0000203
	RESOURCE_LANG_NOT_FOUND = 0xC0000204
	INSUFF_SERVER_RESOURCES = 0xC0000205
	INVALID_BUFFER_SIZE = 0xC0000206
	INVALID_ADDRESS_COMPONENT = 0xC0000207
	INVALID_ADDRESS_WILDCARD = 0xC0000208
	TOO_MANY_ADDRESSES = 0xC0000209
	ADDRESS_ALREADY_EXISTS = 0xC000020A
	ADDRESS_CLOSED = 0xC000020B
	CONNECTION_DISCONNECTED = 0xC000020C
	CONNECTION_RESET = 0xC000020D
	TOO_MANY_NODES = 0xC000020E
	TRANSACTION_ABORTED = 0xC000020F
	TRANSACTION_TIMED_OUT = 0xC0000210
	TRANSACTION_NO_RELEASE = 0xC0000211
	TRANSACTION_NO_MATCH = 0xC0000212
	TRANSACTION_RESPONDED = 0xC0000213
	TRANSACTION_INVALID_ID = 0xC0000214
	TRANSACTION_INVALID_TYPE = 0xC0000215
	NOT_SERVER_SESSION = 0xC0000216
	NOT_CLIENT_SESSION = 0xC0000217
	CANNOT_LOAD_REGISTRY_FILE = 0xC0000218
	DEBUG_ATTACH_FAILED = 0xC0000219
	SYSTEM_PROCESS_TERMINATED = 0xC000021A
	DATA_NOT_ACCEPTED = 0xC000021B
	NO_BROWSER_SERVERS_FOUND = 0xC000021C
	VDM_HARD_ERROR = 0xC000021D
	DRIVER_CANCEL_TIMEOUT = 0xC000021E
	REPLY_MESSAGE_MISMATCH = 0xC000021F
	MAPPED_ALIGNMENT = 0xC0000220
	IMAGE_CHECKSUM_MISMATCH = 0xC0000221
	LOST_WRITEBEHIND_DATA = 0xC0000222
	CLIENT_SERVER_PARAMETERS_INVALID = 0xC0000223
	PASSWORD_MUST_CHANGE = 0xC0000224
	NOT_FOUND = 0xC0000225
	NOT_TINY_STREAM = 0xC0000226
	RECOVERY_FAILURE = 0xC0000227
	STACK_OVERFLOW_READ = 0xC0000228
	FAIL_CHECK = 0xC0000229
	DUPLICATE_OBJECTID = 0xC000022A
	OBJECTID_EXISTS = 0xC000022B
	CONVERT_TO_LARGE = 0xC000022C
	RETRY = 0xC000022D
	FOUND_OUT_OF_SCOPE = 0xC000022E
	ALLOCATE_BUCKET = 0xC000022F
	PROPSET_NOT_FOUND = 0xC0000230
	MARSHALL_OVERFLOW = 0xC0000231
	INVALID_VARIANT = 0xC0000232
	DOMAIN_CONTROLLER_NOT_FOUND = 0xC0000233
	ACCOUNT_LOCKED_OUT = 0xC0000234
	HANDLE_NOT_CLOSABLE = 0xC0000235
	CONNECTION_REFUSED = 0xC0000236
	GRACEFUL_DISCONNECT = 0xC0000237
	ADDRESS_ALREADY_ASSOCIATED = 0xC0000238
	ADDRESS_NOT_ASSOCIATED = 0xC0000239
	CONNECTION_INVALID = 0xC000023A
	CONNECTION_ACTIVE = 0xC000023B
	NETWORK_UNREACHABLE = 0xC000023C
	HOST_UNREACHABLE = 0xC000023D
	PROTOCOL_UNREACHABLE = 0xC000023E
	PORT_UNREACHABLE = 0xC000023F
	REQUEST_ABORTED = 0xC0000240
	CONNECTION_ABORTED = 0xC0000241
	BAD_COMPRESSION_BUFFER = 0xC0000242
	USER_MAPPED_FILE = 0xC0000243
	AUDIT_FAILED = 0xC0000244
	TIMER_RESOLUTION_NOT_SET = 0xC0000245
	CONNECTION_COUNT_LIMIT = 0xC0000246
	LOGIN_TIME_RESTRICTION = 0xC0000247
	LOGIN_WKSTA_RESTRICTION = 0xC0000248
	IMAGE_MP_UP_MISMATCH = 0xC0000249
	INSUFFICIENT_LOGON_INFO = 0xC0000250
	BAD_DLL_ENTRYPOINT = 0xC0000251
	BAD_SERVICE_ENTRYPOINT = 0xC0000252
	LPC_REPLY_LOST = 0xC0000253
	IP_ADDRESS_CONFLICT1 = 0xC0000254
	IP_ADDRESS_CONFLICT2 = 0xC0000255
	REGISTRY_QUOTA_LIMIT = 0xC0000256
	PATH_NOT_COVERED = 0xC0000257
	NO_CALLBACK_ACTIVE = 0xC0000258
	LICENSE_QUOTA_EXCEEDED = 0xC0000259
	PWD_TOO_SHORT = 0xC000025A
	PWD_TOO_RECENT = 0xC000025B
	PWD_HISTORY_CONFLICT = 0xC000025C
	PLUGPLAY_NO_DEVICE = 0xC000025E
	UNSUPPORTED_COMPRESSION = 0xC000025F
	INVALID_HW_PROFILE = 0xC0000260
	INVALID_PLUGPLAY_DEVICE_PATH = 0xC0000261
	DRIVER_ORDINAL_NOT_FOUND = 0xC0000262
	DRIVER_ENTRYPOINT_NOT_FOUND = 0xC0000263
	RESOURCE_NOT_OWNED = 0xC0000264
	TOO_MANY_LINKS = 0xC0000265
	QUOTA_LIST_INCONSISTENT = 0xC0000266
	FILE_IS_OFFLINE = 0xC0000267
	EVALUATION_EXPIRATION = 0xC0000268
	ILLEGAL_DLL_RELOCATION = 0xC0000269
	LICENSE_VIOLATION = 0xC000026A
	DLL_INIT_FAILED_LOGOFF = 0xC000026B
	DRIVER_UNABLE_TO_LOAD = 0xC000026C
	DFS_UNAVAILABLE = 0xC000026D
	VOLUME_DISMOUNTED = 0xC000026E
	WX86_INTERNAL_ERROR = 0xC000026F
	WX86_FLOAT_STACK_CHECK = 0xC0000270
	VALIDATE_CONTINUE = 0xC0000271
	NO_MATCH = 0xC0000272
	NO_MORE_MATCHES = 0xC0000273
	NOT_A_REPARSE_POINT = 0xC0000275
	IO_REPARSE_TAG_INVALID = 0xC0000276
	IO_REPARSE_TAG_MISMATCH = 0xC0000277
	IO_REPARSE_DATA_INVALID = 0xC0000278
	IO_REPARSE_TAG_NOT_HANDLED = 0xC0000279
	REPARSE_POINT_NOT_RESOLVED = 0xC0000280
	DIRECTORY_IS_A_REPARSE_POINT = 0xC0000281
	RANGE_LIST_CONFLICT = 0xC0000282
	SOURCE_ELEMENT_EMPTY = 0xC0000283
	DESTINATION_ELEMENT_FULL = 0xC0000284
	ILLEGAL_ELEMENT_ADDRESS = 0xC0000285
	MAGAZINE_NOT_PRESENT = 0xC0000286
	REINITIALIZATION_NEEDED = 0xC0000287
	DEVICE_REQUIRES_CLEANING = 0x80000288
	DEVICE_DOOR_OPEN = 0x80000289
	ENCRYPTION_FAILED = 0xC000028A
	DECRYPTION_FAILED = 0xC000028B
	RANGE_NOT_FOUND = 0xC000028C
	NO_RECOVERY_POLICY = 0xC000028D
	NO_EFS = 0xC000028E
	WRONG_EFS = 0xC000028F
	NO_USER_KEYS = 0xC0000290
	FILE_NOT_ENCRYPTED = 0xC0000291
	NOT_EXPORT_FORMAT = 0xC0000292
	FILE_ENCRYPTED = 0xC0000293
	WAKE_SYSTEM = 0x40000294
	WMI_GUID_NOT_FOUND = 0xC0000295
	WMI_INSTANCE_NOT_FOUND = 0xC0000296
	WMI_ITEMID_NOT_FOUND = 0xC0000297
	WMI_TRY_AGAIN = 0xC0000298
	SHARED_POLICY = 0xC0000299
	POLICY_OBJECT_NOT_FOUND = 0xC000029A
	POLICY_ONLY_IN_DS = 0xC000029B
	VOLUME_NOT_UPGRADED = 0xC000029C
	REMOTE_STORAGE_NOT_ACTIVE = 0xC000029D
	REMOTE_STORAGE_MEDIA_ERROR = 0xC000029E
	NO_TRACKING_SERVICE = 0xC000029F
	SERVER_SID_MISMATCH = 0xC00002A0
	DS_NO_ATTRIBUTE_OR_VALUE = 0xC00002A1
	DS_INVALID_ATTRIBUTE_SYNTAX = 0xC00002A2
	DS_ATTRIBUTE_TYPE_UNDEFINED = 0xC00002A3
	DS_ATTRIBUTE_OR_VALUE_EXISTS = 0xC00002A4
	DS_BUSY = 0xC00002A5
	DS_UNAVAILABLE = 0xC00002A6
	DS_NO_RIDS_ALLOCATED = 0xC00002A7
	DS_NO_MORE_RIDS = 0xC00002A8
	DS_INCORRECT_ROLE_OWNER = 0xC00002A9
	DS_RIDMGR_INIT_ERROR = 0xC00002AA
	DS_OBJ_CLASS_VIOLATION = 0xC00002AB
	DS_CANT_ON_NON_LEAF = 0xC00002AC
	DS_CANT_ON_RDN = 0xC00002AD
	DS_CANT_MOD_OBJ_CLASS = 0xC00002AE
	DS_CROSS_DOM_MOVE_FAILED = 0xC00002AF
	DS_GC_NOT_AVAILABLE = 0xC00002B0
	DIRECTORY_SERVICE_REQUIRED = 0xC00002B1
	REPARSE_ATTRIBUTE_CONFLICT = 0xC00002B2
	CANT_ENABLE_DENY_ONLY = 0xC00002B3
	FLOAT_MULTIPLE_FAULTS = 0xC00002B4
	FLOAT_MULTIPLE_TRAPS = 0xC00002B5
	DEVICE_REMOVED = 0xC00002B6
	JOURNAL_DELETE_IN_PROGRESS = 0xC00002B7
	JOURNAL_NOT_ACTIVE = 0xC00002B8
	NOINTERFACE = 0xC00002B9
	DS_ADMIN_LIMIT_EXCEEDED = 0xC00002C1
	DRIVER_FAILED_SLEEP = 0xC00002C2
	MUTUAL_AUTHENTICATION_FAILED = 0xC00002C3
	CORRUPT_SYSTEM_FILE = 0xC00002C4
	DATATYPE_MISALIGNMENT_ERROR = 0xC00002C5
	WMI_READ_ONLY = 0xC00002C6
	WMI_SET_FAILURE = 0xC00002C7
	COMMITMENT_MINIMUM = 0xC00002C8
	REG_NAT_CONSUMPTION = 0xC00002C9
	TRANSPORT_FULL = 0xC00002CA
	DS_SAM_INIT_FAILURE = 0xC00002CB
	ONLY_IF_CONNECTED = 0xC00002CC
	DS_SENSITIVE_GROUP_VIOLATION = 0xC00002CD
	PNP_RESTART_ENUMERATION = 0xC00002CE
	JOURNAL_ENTRY_DELETED = 0xC00002CF
	DS_CANT_MOD_PRIMARYGROUPID = 0xC00002D0
	SYSTEM_IMAGE_BAD_SIGNATURE = 0xC00002D1
	PNP_REBOOT_REQUIRED = 0xC00002D2
	POWER_STATE_INVALID = 0xC00002D3
	DS_INVALID_GROUP_TYPE = 0xC00002D4
	DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 0xC00002D5
	DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 0xC00002D6
	DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 0xC00002D7
	DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 0xC00002D8
	DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 0xC00002D9
	DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 0xC00002DA
	DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 0xC00002DB
	DS_HAVE_PRIMARY_MEMBERS = 0xC00002DC
	WMI_NOT_SUPPORTED = 0xC00002DD
	INSUFFICIENT_POWER = 0xC00002DE
	SAM_NEED_BOOTKEY_PASSWORD = 0xC00002DF
	SAM_NEED_BOOTKEY_FLOPPY = 0xC00002E0
	DS_CANT_START = 0xC00002E1
	DS_INIT_FAILURE = 0xC00002E2
	SAM_INIT_FAILURE = 0xC00002E3
	DS_GC_REQUIRED = 0xC00002E4
	DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 0xC00002E5
	DS_NO_FPO_IN_UNIVERSAL_GROUPS = 0xC00002E6
	DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 0xC00002E7
	MULTIPLE_FAULT_VIOLATION = 0xC00002E8
	CURRENT_DOMAIN_NOT_ALLOWED = 0xC00002E9
	CANNOT_MAKE = 0xC00002EA
	SYSTEM_SHUTDOWN = 0xC00002EB
	DS_INIT_FAILURE_CONSOLE = 0xC00002EC
	DS_SAM_INIT_FAILURE_CONSOLE = 0xC00002ED
	UNFINISHED_CONTEXT_DELETED = 0xC00002EE
	NO_TGT_REPLY = 0xC00002EF
	OBJECTID_NOT_FOUND = 0xC00002F0
	NO_IP_ADDRESSES = 0xC00002F1
	WRONG_CREDENTIAL_HANDLE = 0xC00002F2
	CRYPTO_SYSTEM_INVALID = 0xC00002F3
	MAX_REFERRALS_EXCEEDED = 0xC00002F4
	MUST_BE_KDC = 0xC00002F5
	STRONG_CRYPTO_NOT_SUPPORTED = 0xC00002F6
	TOO_MANY_PRINCIPALS = 0xC00002F7
	NO_PA_DATA = 0xC00002F8
	PKINIT_NAME_MISMATCH = 0xC00002F9
	SMARTCARD_LOGON_REQUIRED = 0xC00002FA
	KDC_INVALID_REQUEST = 0xC00002FB
	KDC_UNABLE_TO_REFER = 0xC00002FC
	KDC_UNKNOWN_ETYPE = 0xC00002FD
	SHUTDOWN_IN_PROGRESS = 0xC00002FE
	SERVER_SHUTDOWN_IN_PROGRESS = 0xC00002FF
	NOT_SUPPORTED_ON_SBS = 0xC0000300
	WMI_GUID_DISCONNECTED = 0xC0000301
	WMI_ALREADY_DISABLED = 0xC0000302
	WMI_ALREADY_ENABLED = 0xC0000303
	MFT_TOO_FRAGMENTED = 0xC0000304
	COPY_PROTECTION_FAILURE = 0xC0000305
	CSS_AUTHENTICATION_FAILURE = 0xC0000306
	CSS_KEY_NOT_PRESENT = 0xC0000307
	CSS_KEY_NOT_ESTABLISHED = 0xC0000308
	CSS_SCRAMBLED_SECTOR = 0xC0000309
	CSS_REGION_MISMATCH = 0xC000030A
	CSS_RESETS_EXHAUSTED = 0xC000030B
	PKINIT_FAILURE = 0xC0000320
	SMARTCARD_SUBSYSTEM_FAILURE = 0xC0000321
	NO_KERB_KEY = 0xC0000322
	HOST_DOWN = 0xC0000350
	UNSUPPORTED_PREAUTH = 0xC0000351
	EFS_ALG_BLOB_TOO_BIG = 0xC0000352
	PORT_NOT_SET = 0xC0000353
	DEBUGGER_INACTIVE = 0xC0000354
	DS_VERSION_CHECK_FAILURE = 0xC0000355
	AUDITING_DISABLED = 0xC0000356
	PRENT4_MACHINE_ACCOUNT = 0xC0000357
	DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = 0xC0000358
	INVALID_IMAGE_WIN_32 = 0xC0000359
	INVALID_IMAGE_WIN_64 = 0xC000035A
	BAD_BINDINGS = 0xC000035B
	NETWORK_SESSION_EXPIRED = 0xC000035C
	APPHELP_BLOCK = 0xC000035D
	ALL_SIDS_FILTERED = 0xC000035E
	NOT_SAFE_MODE_DRIVER = 0xC000035F
	ACCESS_DISABLED_BY_POLICY_DEFAULT = 0xC0000361
	ACCESS_DISABLED_BY_POLICY_PATH = 0xC0000362
	ACCESS_DISABLED_BY_POLICY_PUBLISHER = 0xC0000363
	ACCESS_DISABLED_BY_POLICY_OTHER = 0xC0000364
	FAILED_DRIVER_ENTRY = 0xC0000365
	DEVICE_ENUMERATION_ERROR = 0xC0000366
	MOUNT_POINT_NOT_RESOLVED = 0xC0000368
	INVALID_DEVICE_OBJECT_PARAMETER = 0xC0000369
	MCA_OCCURED = 0xC000036A
	DRIVER_BLOCKED_CRITICAL = 0xC000036B
	DRIVER_BLOCKED = 0xC000036C
	DRIVER_DATABASE_ERROR = 0xC000036D
	SYSTEM_HIVE_TOO_LARGE = 0xC000036E
	INVALID_IMPORT_OF_NON_DLL = 0xC000036F
	DS_SHUTTING_DOWN = 0x40000370
	NO_SECRETS = 0xC0000371
	ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY = 0xC0000372
	FAILED_STACK_SWITCH = 0xC0000373
	HEAP_CORRUPTION = 0xC0000374
	SMARTCARD_WRONG_PIN = 0xC0000380
	SMARTCARD_CARD_BLOCKED = 0xC0000381
	SMARTCARD_CARD_NOT_AUTHENTICATED = 0xC0000382
	SMARTCARD_NO_CARD = 0xC0000383
	SMARTCARD_NO_KEY_CONTAINER = 0xC0000384
	SMARTCARD_NO_CERTIFICATE = 0xC0000385
	SMARTCARD_NO_KEYSET = 0xC0000386
	SMARTCARD_IO_ERROR = 0xC0000387
	DOWNGRADE_DETECTED = 0xC0000388
	SMARTCARD_CERT_REVOKED = 0xC0000389
	ISSUING_CA_UNTRUSTED = 0xC000038A
	REVOCATION_OFFLINE_C = 0xC000038B
	PKINIT_CLIENT_FAILURE = 0xC000038C
	SMARTCARD_CERT_EXPIRED = 0xC000038D
	DRIVER_FAILED_PRIOR_UNLOAD = 0xC000038E
	SMARTCARD_SILENT_CONTEXT = 0xC000038F
	PER_USER_TRUST_QUOTA_EXCEEDED = 0xC0000401
	ALL_USER_TRUST_QUOTA_EXCEEDED = 0xC0000402
	USER_DELETE_TRUST_QUOTA_EXCEEDED = 0xC0000403
	DS_NAME_NOT_UNIQUE = 0xC0000404
	DS_DUPLICATE_ID_FOUND = 0xC0000405
	DS_GROUP_CONVERSION_ERROR = 0xC0000406
	VOLSNAP_PREPARE_HIBERNATE = 0xC0000407
	USER2USER_REQUIRED = 0xC0000408
	STACK_BUFFER_OVERRUN = 0xC0000409
	NO_S4U_PROT_SUPPORT = 0xC000040A
	CROSSREALM_DELEGATION_FAILURE = 0xC000040B
	REVOCATION_OFFLINE_KDC = 0xC000040C
	ISSUING_CA_UNTRUSTED_KDC = 0xC000040D
	KDC_CERT_EXPIRED = 0xC000040E
	KDC_CERT_REVOKED = 0xC000040F
	PARAMETER_QUOTA_EXCEEDED = 0xC0000410
	HIBERNATION_FAILURE = 0xC0000411
	DELAY_LOAD_FAILED = 0xC0000412
	AUTHENTICATION_FIREWALL_FAILED = 0xC0000413
	VDM_DISALLOWED = 0xC0000414
	HUNG_DISPLAY_DRIVER_THREAD = 0xC0000415
	INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE = 0xC0000416
	INVALID_CRUNTIME_PARAMETER = 0xC0000417
	NTLM_BLOCKED = 0xC0000418
	DS_SRC_SID_EXISTS_IN_FOREST = 0xC0000419
	DS_DOMAIN_NAME_EXISTS_IN_FOREST = 0xC000041A
	DS_FLAT_NAME_EXISTS_IN_FOREST = 0xC000041B
	INVALID_USER_PRINCIPAL_NAME = 0xC000041C
	FATAL_USER_CALLBACK_EXCEPTION = 0xC000041D
	ASSERTION_FAILURE = 0xC0000420
	VERIFIER_STOP = 0xC0000421
	CALLBACK_POP_STACK = 0xC0000423
	INCOMPATIBLE_DRIVER_BLOCKED = 0xC0000424
	HIVE_UNLOADED = 0xC0000425
	COMPRESSION_DISABLED = 0xC0000426
	FILE_SYSTEM_LIMITATION = 0xC0000427
	INVALID_IMAGE_HASH = 0xC0000428
	NOT_CAPABLE = 0xC0000429
	REQUEST_OUT_OF_SEQUENCE = 0xC000042A
	IMPLEMENTATION_LIMIT = 0xC000042B
	ELEVATION_REQUIRED = 0xC000042C
	NO_SECURITY_CONTEXT = 0xC000042D
	PKU2U_CERT_FAILURE = 0xC000042F
	BEYOND_VDL = 0xC0000432
	ENCOUNTERED_WRITE_IN_PROGRESS = 0xC0000433
	PTE_CHANGED = 0xC0000434
	PURGE_FAILED = 0xC0000435
	CRED_REQUIRES_CONFIRMATION = 0xC0000440
	CS_ENCRYPTION_INVALID_SERVER_RESPONSE = 0xC0000441
	CS_ENCRYPTION_UNSUPPORTED_SERVER = 0xC0000442
	CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE = 0xC0000443
	CS_ENCRYPTION_NEW_ENCRYPTED_FILE = 0xC0000444
	CS_ENCRYPTION_FILE_NOT_CSE = 0xC0000445
	INVALID_LABEL = 0xC0000446
	DRIVER_PROCESS_TERMINATED = 0xC0000450
	AMBIGUOUS_SYSTEM_DEVICE = 0xC0000451
	SYSTEM_DEVICE_NOT_FOUND = 0xC0000452
	RESTART_BOOT_APPLICATION = 0xC0000453
	INSUFFICIENT_NVRAM_RESOURCES = 0xC0000454
	INVALID_TASK_NAME = 0xC0000500
	INVALID_TASK_INDEX = 0xC0000501
	THREAD_ALREADY_IN_TASK = 0xC0000502
	CALLBACK_BYPASS = 0xC0000503
	FAIL_FAST_EXCEPTION = 0xC0000602
	IMAGE_CERT_REVOKED = 0xC0000603
	PORT_CLOSED = 0xC0000700
	MESSAGE_LOST = 0xC0000701
	INVALID_MESSAGE = 0xC0000702
	REQUEST_CANCELED = 0xC0000703
	RECURSIVE_DISPATCH = 0xC0000704
	LPC_RECEIVE_BUFFER_EXPECTED = 0xC0000705
	LPC_INVALID_CONNECTION_USAGE = 0xC0000706
	LPC_REQUESTS_NOT_ALLOWED = 0xC0000707
	RESOURCE_IN_USE = 0xC0000708
	HARDWARE_MEMORY_ERROR = 0xC0000709
	THREADPOOL_HANDLE_EXCEPTION = 0xC000070A
	THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED = 0xC000070B
	THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED = 0xC000070C
	THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED = 0xC000070D
	THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED = 0xC000070E
	THREADPOOL_RELEASED_DURING_OPERATION = 0xC000070F
	CALLBACK_RETURNED_WHILE_IMPERSONATING = 0xC0000710
	APC_RETURNED_WHILE_IMPERSONATING = 0xC0000711
	PROCESS_IS_PROTECTED = 0xC0000712
	MCA_EXCEPTION = 0xC0000713
	CERTIFICATE_MAPPING_NOT_UNIQUE = 0xC0000714
	SYMLINK_CLASS_DISABLED = 0xC0000715
	INVALID_IDN_NORMALIZATION = 0xC0000716
	NO_UNICODE_TRANSLATION = 0xC0000717
	ALREADY_REGISTERED = 0xC0000718
	CONTEXT_MISMATCH = 0xC0000719
	PORT_ALREADY_HAS_COMPLETION_LIST = 0xC000071A
	CALLBACK_RETURNED_THREAD_PRIORITY = 0xC000071B
	INVALID_THREAD = 0xC000071C
	CALLBACK_RETURNED_TRANSACTION = 0xC000071D
	CALLBACK_RETURNED_LDR_LOCK = 0xC000071E
	CALLBACK_RETURNED_LANG = 0xC000071F
	CALLBACK_RETURNED_PRI_BACK = 0xC0000720
	CALLBACK_RETURNED_THREAD_AFFINITY = 0xC0000721
	DISK_REPAIR_DISABLED = 0xC0000800
	DS_DOMAIN_RENAME_IN_PROGRESS = 0xC0000801
	DISK_QUOTA_EXCEEDED = 0xC0000802
	DATA_LOST_REPAIR = 0x80000803
	CONTENT_BLOCKED = 0xC0000804
	BAD_CLUSTERS = 0xC0000805
	VOLUME_DIRTY = 0xC0000806
	FILE_CHECKED_OUT = 0xC0000901
	CHECKOUT_REQUIRED = 0xC0000902
	BAD_FILE_TYPE = 0xC0000903
	FILE_TOO_LARGE = 0xC0000904
	FORMS_AUTH_REQUIRED = 0xC0000905
	VIRUS_INFECTED = 0xC0000906
	VIRUS_DELETED = 0xC0000907
	BAD_MCFG_TABLE = 0xC0000908
	CANNOT_BREAK_OPLOCK = 0xC0000909
	WOW_ASSERTION = 0xC0009898
	INVALID_SIGNATURE = 0xC000A000
	HMAC_NOT_SUPPORTED = 0xC000A001
	AUTH_TAG_MISMATCH = 0xC000A002
	IPSEC_QUEUE_OVERFLOW = 0xC000A010
	ND_QUEUE_OVERFLOW = 0xC000A011
	HOPLIMIT_EXCEEDED = 0xC000A012
	PROTOCOL_NOT_SUPPORTED = 0xC000A013
	FASTPATH_REJECTED = 0xC000A014
	LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED = 0xC000A080
	LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR = 0xC000A081
	LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR = 0xC000A082
	XML_PARSE_ERROR = 0xC000A083
	XMLDSIG_ERROR = 0xC000A084
	WRONG_COMPARTMENT = 0xC000A085
	AUTHIP_FAILURE = 0xC000A086
	DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS = 0xC000A087
	DS_OID_NOT_FOUND = 0xC000A088
	HASH_NOT_SUPPORTED = 0xC000A100
	HASH_NOT_PRESENT = 0xC000A101
	ACPI_INVALID_OPCODE = 0xC0140001
	ACPI_STACK_OVERFLOW = 0xC0140002
	ACPI_ASSERT_FAILED = 0xC0140003
	ACPI_INVALID_INDEX = 0xC0140004
	ACPI_INVALID_ARGUMENT = 0xC0140005
	ACPI_FATAL = 0xC0140006
	ACPI_INVALID_SUPERNAME = 0xC0140007
	ACPI_INVALID_ARGTYPE = 0xC0140008
	ACPI_INVALID_OBJTYPE = 0xC0140009
	ACPI_INVALID_TARGETTYPE = 0xC014000A
	ACPI_INCORRECT_ARGUMENT_COUNT = 0xC014000B
	ACPI_ADDRESS_NOT_MAPPED = 0xC014000C
	ACPI_INVALID_EVENTTYPE = 0xC014000D
	ACPI_HANDLER_COLLISION = 0xC014000E
	ACPI_INVALID_DATA = 0xC014000F
	ACPI_INVALID_REGION = 0xC0140010
	ACPI_INVALID_ACCESS_SIZE = 0xC0140011
	ACPI_ACQUIRE_GLOBAL_LOCK = 0xC0140012
	ACPI_ALREADY_INITIALIZED = 0xC0140013
	ACPI_NOT_INITIALIZED = 0xC0140014
	ACPI_INVALID_MUTEX_LEVEL = 0xC0140015
	ACPI_MUTEX_NOT_OWNED = 0xC0140016
	ACPI_MUTEX_NOT_OWNER = 0xC0140017
	ACPI_RS_ACCESS = 0xC0140018
	ACPI_INVALID_TABLE = 0xC0140019
	ACPI_REG_HANDLER_FAILED = 0xC0140020
	ACPI_POWER_REQUEST_FAILED = 0xC0140021
	CTX_WINSTATION_NAME_INVALID = 0xC00A0001
	CTX_INVALID_PD = 0xC00A0002
	CTX_PD_NOT_FOUND = 0xC00A0003
	CTX_CDM_CONNECT = 0x400A0004
	CTX_CDM_DISCONNECT = 0x400A0005
	CTX_CLOSE_PENDING = 0xC00A0006
	CTX_NO_OUTBUF = 0xC00A0007
	CTX_MODEM_INF_NOT_FOUND = 0xC00A0008
	CTX_INVALID_MODEMNAME = 0xC00A0009
	CTX_RESPONSE_ERROR = 0xC00A000A
	CTX_MODEM_RESPONSE_TIMEOUT = 0xC00A000B
	CTX_MODEM_RESPONSE_NO_CARRIER = 0xC00A000C
	CTX_MODEM_RESPONSE_NO_DIALTONE = 0xC00A000D
	CTX_MODEM_RESPONSE_BUSY = 0xC00A000E
	CTX_MODEM_RESPONSE_VOICE = 0xC00A000F
	CTX_TD_ERROR = 0xC00A0010
	CTX_LICENSE_CLIENT_INVALID = 0xC00A0012
	CTX_LICENSE_NOT_AVAILABLE = 0xC00A0013
	CTX_LICENSE_EXPIRED = 0xC00A0014
	CTX_WINSTATION_NOT_FOUND = 0xC00A0015
	CTX_WINSTATION_NAME_COLLISION = 0xC00A0016
	CTX_WINSTATION_BUSY = 0xC00A0017
	CTX_BAD_VIDEO_MODE = 0xC00A0018
	CTX_GRAPHICS_INVALID = 0xC00A0022
	CTX_NOT_CONSOLE = 0xC00A0024
	CTX_CLIENT_QUERY_TIMEOUT = 0xC00A0026
	CTX_CONSOLE_DISCONNECT = 0xC00A0027
	CTX_CONSOLE_CONNECT = 0xC00A0028
	CTX_SHADOW_DENIED = 0xC00A002A
	CTX_WINSTATION_ACCESS_DENIED = 0xC00A002B
	CTX_INVALID_WD = 0xC00A002E
	CTX_WD_NOT_FOUND = 0xC00A002F
	CTX_SHADOW_INVALID = 0xC00A0030
	CTX_SHADOW_DISABLED = 0xC00A0031
	RDP_PROTOCOL_ERROR = 0xC00A0032
	CTX_CLIENT_LICENSE_NOT_SET = 0xC00A0033
	CTX_CLIENT_LICENSE_IN_USE = 0xC00A0034
	CTX_SHADOW_ENDED_BY_MODE_CHANGE = 0xC00A0035
	CTX_SHADOW_NOT_RUNNING = 0xC00A0036
	CTX_LOGON_DISABLED = 0xC00A0037
	CTX_SECURITY_LAYER_ERROR = 0xC00A0038
	TS_INCOMPATIBLE_SESSIONS = 0xC00A0039
	TS_VIDEO_SUBSYSTEM_ERROR = 0xC00A003A
	PNP_BAD_MPS_TABLE = 0xC0040035
	PNP_TRANSLATION_FAILED = 0xC0040036
	PNP_IRQ_TRANSLATION_FAILED = 0xC0040037
	PNP_INVALID_ID = 0xC0040038
	IO_REISSUE_AS_CACHED = 0xC0040039
	MUI_FILE_NOT_FOUND = 0xC00B0001
	MUI_INVALID_FILE = 0xC00B0002
	MUI_INVALID_RC_CONFIG = 0xC00B0003
	MUI_INVALID_LOCALE_NAME = 0xC00B0004
	MUI_INVALID_ULTIMATEFALLBACK_NAME = 0xC00B0005
	MUI_FILE_NOT_LOADED = 0xC00B0006
	RESOURCE_ENUM_USER_STOP = 0xC00B0007
	FLT_NO_HANDLER_DEFINED = 0xC01C0001
	FLT_CONTEXT_ALREADY_DEFINED = 0xC01C0002
	FLT_INVALID_ASYNCHRONOUS_REQUEST = 0xC01C0003
	FLT_DISALLOW_FAST_IO = 0xC01C0004
	FLT_INVALID_NAME_REQUEST = 0xC01C0005
	FLT_NOT_SAFE_TO_POST_OPERATION = 0xC01C0006
	FLT_NOT_INITIALIZED = 0xC01C0007
	FLT_FILTER_NOT_READY = 0xC01C0008
	FLT_POST_OPERATION_CLEANUP = 0xC01C0009
	FLT_INTERNAL_ERROR = 0xC01C000A
	FLT_DELETING_OBJECT = 0xC01C000B
	FLT_MUST_BE_NONPAGED_POOL = 0xC01C000C
	FLT_DUPLICATE_ENTRY = 0xC01C000D
	FLT_CBDQ_DISABLED = 0xC01C000E
	FLT_DO_NOT_ATTACH = 0xC01C000F
	FLT_DO_NOT_DETACH = 0xC01C0010
	FLT_INSTANCE_ALTITUDE_COLLISION = 0xC01C0011
	FLT_INSTANCE_NAME_COLLISION = 0xC01C0012
	FLT_FILTER_NOT_FOUND = 0xC01C0013
	FLT_VOLUME_NOT_FOUND = 0xC01C0014
	FLT_INSTANCE_NOT_FOUND = 0xC01C0015
	FLT_CONTEXT_ALLOCATION_NOT_FOUND = 0xC01C0016
	FLT_INVALID_CONTEXT_REGISTRATION = 0xC01C0017
	FLT_NAME_CACHE_MISS = 0xC01C0018
	FLT_NO_DEVICE_OBJECT = 0xC01C0019
	FLT_VOLUME_ALREADY_MOUNTED = 0xC01C001A
	FLT_ALREADY_ENLISTED = 0xC01C001B
	FLT_CONTEXT_ALREADY_LINKED = 0xC01C001C
	FLT_NO_WAITER_FOR_REPLY = 0xC01C0020
	SXS_SECTION_NOT_FOUND = 0xC0150001
	SXS_CANT_GEN_ACTCTX = 0xC0150002
	SXS_INVALID_ACTCTXDATA_FORMAT = 0xC0150003
	SXS_ASSEMBLY_NOT_FOUND = 0xC0150004
	SXS_MANIFEST_FORMAT_ERROR = 0xC0150005
	SXS_MANIFEST_PARSE_ERROR = 0xC0150006
	SXS_ACTIVATION_CONTEXT_DISABLED = 0xC0150007
	SXS_KEY_NOT_FOUND = 0xC0150008
	SXS_VERSION_CONFLICT = 0xC0150009
	SXS_WRONG_SECTION_TYPE = 0xC015000A
	SXS_THREAD_QUERIES_DISABLED = 0xC015000B
	SXS_ASSEMBLY_MISSING = 0xC015000C
	SXS_RELEASE_ACTIVATION_CONTEXT = 0x4015000D
	SXS_PROCESS_DEFAULT_ALREADY_SET = 0xC015000E
	SXS_EARLY_DEACTIVATION = 0xC015000F
	SXS_INVALID_DEACTIVATION = 0xC0150010
	SXS_MULTIPLE_DEACTIVATION = 0xC0150011
	SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY = 0xC0150012
	SXS_PROCESS_TERMINATION_REQUESTED = 0xC0150013
	SXS_CORRUPT_ACTIVATION_STACK = 0xC0150014
	SXS_CORRUPTION = 0xC0150015
	SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE = 0xC0150016
	SXS_INVALID_IDENTITY_ATTRIBUTE_NAME = 0xC0150017
	SXS_IDENTITY_DUPLICATE_ATTRIBUTE = 0xC0150018
	SXS_IDENTITY_PARSE_ERROR = 0xC0150019
	SXS_COMPONENT_STORE_CORRUPT = 0xC015001A
	SXS_FILE_HASH_MISMATCH = 0xC015001B
	SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT = 0xC015001C
	SXS_IDENTITIES_DIFFERENT = 0xC015001D
	SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT = 0xC015001E
	SXS_FILE_NOT_PART_OF_ASSEMBLY = 0xC015001F
	ADVANCED_INSTALLER_FAILED = 0xC0150020
	XML_ENCODING_MISMATCH = 0xC0150021
	SXS_MANIFEST_TOO_BIG = 0xC0150022
	SXS_SETTING_NOT_REGISTERED = 0xC0150023
	SXS_TRANSACTION_CLOSURE_INCOMPLETE = 0xC0150024
	SMI_PRIMITIVE_INSTALLER_FAILED = 0xC0150025
	GENERIC_COMMAND_FAILED = 0xC0150026
	SXS_FILE_HASH_MISSING = 0xC0150027
	CLUSTER_INVALID_NODE = 0xC0130001
	CLUSTER_NODE_EXISTS = 0xC0130002
	CLUSTER_JOIN_IN_PROGRESS = 0xC0130003
	CLUSTER_NODE_NOT_FOUND = 0xC0130004
	CLUSTER_LOCAL_NODE_NOT_FOUND = 0xC0130005
	CLUSTER_NETWORK_EXISTS = 0xC0130006
	CLUSTER_NETWORK_NOT_FOUND = 0xC0130007
	CLUSTER_NETINTERFACE_EXISTS = 0xC0130008
	CLUSTER_NETINTERFACE_NOT_FOUND = 0xC0130009
	CLUSTER_INVALID_REQUEST = 0xC013000A
	CLUSTER_INVALID_NETWORK_PROVIDER = 0xC013000B
	CLUSTER_NODE_DOWN = 0xC013000C
	CLUSTER_NODE_UNREACHABLE = 0xC013000D
	CLUSTER_NODE_NOT_MEMBER = 0xC013000E
	CLUSTER_JOIN_NOT_IN_PROGRESS = 0xC013000F
	CLUSTER_INVALID_NETWORK = 0xC0130010
	CLUSTER_NO_NET_ADAPTERS = 0xC0130011
	CLUSTER_NODE_UP = 0xC0130012
	CLUSTER_NODE_PAUSED = 0xC0130013
	CLUSTER_NODE_NOT_PAUSED = 0xC0130014
	CLUSTER_NO_SECURITY_CONTEXT = 0xC0130015
	CLUSTER_NETWORK_NOT_INTERNAL = 0xC0130016
	CLUSTER_POISONED = 0xC0130017
	CLUSTER_NON_CSV_PATH = 0xC0130018
	CLUSTER_CSV_VOLUME_NOT_LOCAL = 0xC0130019
	TRANSACTIONAL_CONFLICT = 0xC0190001
	INVALID_TRANSACTION = 0xC0190002
	TRANSACTION_NOT_ACTIVE = 0xC0190003
	TM_INITIALIZATION_FAILED = 0xC0190004
	RM_NOT_ACTIVE = 0xC0190005
	RM_METADATA_CORRUPT = 0xC0190006
	TRANSACTION_NOT_JOINED = 0xC0190007
	DIRECTORY_NOT_RM = 0xC0190008
	COULD_NOT_RESIZE_LOG = 0x80190009
	TRANSACTIONS_UNSUPPORTED_REMOTE = 0xC019000A
	LOG_RESIZE_INVALID_SIZE = 0xC019000B
	REMOTE_FILE_VERSION_MISMATCH = 0xC019000C
	CRM_PROTOCOL_ALREADY_EXISTS = 0xC019000F
	TRANSACTION_PROPAGATION_FAILED = 0xC0190010
	CRM_PROTOCOL_NOT_FOUND = 0xC0190011
	TRANSACTION_SUPERIOR_EXISTS = 0xC0190012
	TRANSACTION_REQUEST_NOT_VALID = 0xC0190013
	TRANSACTION_NOT_REQUESTED = 0xC0190014
	TRANSACTION_ALREADY_ABORTED = 0xC0190015
	TRANSACTION_ALREADY_COMMITTED = 0xC0190016
	TRANSACTION_INVALID_MARSHALL_BUFFER = 0xC0190017
	CURRENT_TRANSACTION_NOT_VALID = 0xC0190018
	LOG_GROWTH_FAILED = 0xC0190019
	OBJECT_NO_LONGER_EXISTS = 0xC0190021
	STREAM_MINIVERSION_NOT_FOUND = 0xC0190022
	STREAM_MINIVERSION_NOT_VALID = 0xC0190023
	MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION = 0xC0190024
	CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT = 0xC0190025
	CANT_CREATE_MORE_STREAM_MINIVERSIONS = 0xC0190026
	HANDLE_NO_LONGER_VALID = 0xC0190028
	NO_TXF_METADATA = 0x80190029
	LOG_CORRUPTION_DETECTED = 0xC0190030
	CANT_RECOVER_WITH_HANDLE_OPEN = 0x80190031
	RM_DISCONNECTED = 0xC0190032
	ENLISTMENT_NOT_SUPERIOR = 0xC0190033
	RECOVERY_NOT_NEEDED = 0x40190034
	RM_ALREADY_STARTED = 0x40190035
	FILE_IDENTITY_NOT_PERSISTENT = 0xC0190036
	CANT_BREAK_TRANSACTIONAL_DEPENDENCY = 0xC0190037
	CANT_CROSS_RM_BOUNDARY = 0xC0190038
	TXF_DIR_NOT_EMPTY = 0xC0190039
	INDOUBT_TRANSACTIONS_EXIST = 0xC019003A
	TM_VOLATILE = 0xC019003B
	ROLLBACK_TIMER_EXPIRED = 0xC019003C
	TXF_ATTRIBUTE_CORRUPT = 0xC019003D
	EFS_NOT_ALLOWED_IN_TRANSACTION = 0xC019003E
	TRANSACTIONAL_OPEN_NOT_ALLOWED = 0xC019003F
	TRANSACTED_MAPPING_UNSUPPORTED_REMOTE = 0xC0190040
	TXF_METADATA_ALREADY_PRESENT = 0x80190041
	TRANSACTION_SCOPE_CALLBACKS_NOT_SET = 0x80190042
	TRANSACTION_REQUIRED_PROMOTION = 0xC0190043
	CANNOT_EXECUTE_FILE_IN_TRANSACTION = 0xC0190044
	TRANSACTIONS_NOT_FROZEN = 0xC0190045
	TRANSACTION_FREEZE_IN_PROGRESS = 0xC0190046
	NOT_SNAPSHOT_VOLUME = 0xC0190047
	NO_SAVEPOINT_WITH_OPEN_FILES = 0xC0190048
	SPARSE_NOT_ALLOWED_IN_TRANSACTION = 0xC0190049
	TM_IDENTITY_MISMATCH = 0xC019004A
	FLOATED_SECTION = 0xC019004B
	CANNOT_ACCEPT_TRANSACTED_WORK = 0xC019004C
	CANNOT_ABORT_TRANSACTIONS = 0xC019004D
	TRANSACTION_NOT_FOUND = 0xC019004E
	RESOURCEMANAGER_NOT_FOUND = 0xC019004F
	ENLISTMENT_NOT_FOUND = 0xC0190050
	TRANSACTIONMANAGER_NOT_FOUND = 0xC0190051
	TRANSACTIONMANAGER_NOT_ONLINE = 0xC0190052
	TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION = 0xC0190053
	TRANSACTION_NOT_ROOT = 0xC0190054
	TRANSACTION_OBJECT_EXPIRED = 0xC0190055
	COMPRESSION_NOT_ALLOWED_IN_TRANSACTION = 0xC0190056
	TRANSACTION_RESPONSE_NOT_ENLISTED = 0xC0190057
	TRANSACTION_RECORD_TOO_LONG = 0xC0190058
	NO_LINK_TRACKING_IN_TRANSACTION = 0xC0190059
	OPERATION_NOT_SUPPORTED_IN_TRANSACTION = 0xC019005A
	TRANSACTION_INTEGRITY_VIOLATED = 0xC019005B
	TRANSACTIONMANAGER_IDENTITY_MISMATCH = 0xC019005C
	RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT = 0xC019005D
	TRANSACTION_MUST_WRITETHROUGH = 0xC019005E
	TRANSACTION_NO_SUPERIOR = 0xC019005F
	EXPIRED_HANDLE = 0xC0190060
	TRANSACTION_NOT_ENLISTED = 0xC0190061
	LOG_SECTOR_INVALID = 0xC01A0001
	LOG_SECTOR_PARITY_INVALID = 0xC01A0002
	LOG_SECTOR_REMAPPED = 0xC01A0003
	LOG_BLOCK_INCOMPLETE = 0xC01A0004
	LOG_INVALID_RANGE = 0xC01A0005
	LOG_BLOCKS_EXHAUSTED = 0xC01A0006
	LOG_READ_CONTEXT_INVALID = 0xC01A0007
	LOG_RESTART_INVALID = 0xC01A0008
	LOG_BLOCK_VERSION = 0xC01A0009
	LOG_BLOCK_INVALID = 0xC01A000A
	LOG_READ_MODE_INVALID = 0xC01A000B
	LOG_NO_RESTART = 0x401A000C
	LOG_METADATA_CORRUPT = 0xC01A000D
	LOG_METADATA_INVALID = 0xC01A000E
	LOG_METADATA_INCONSISTENT = 0xC01A000F
	LOG_RESERVATION_INVALID = 0xC01A0010
	LOG_CANT_DELETE = 0xC01A0011
	LOG_CONTAINER_LIMIT_EXCEEDED = 0xC01A0012
	LOG_START_OF_LOG = 0xC01A0013
	LOG_POLICY_ALREADY_INSTALLED = 0xC01A0014
	LOG_POLICY_NOT_INSTALLED = 0xC01A0015
	LOG_POLICY_INVALID = 0xC01A0016
	LOG_POLICY_CONFLICT = 0xC01A0017
	LOG_PINNED_ARCHIVE_TAIL = 0xC01A0018
	LOG_RECORD_NONEXISTENT = 0xC01A0019
	LOG_RECORDS_RESERVED_INVALID = 0xC01A001A
	LOG_SPACE_RESERVED_INVALID = 0xC01A001B
	LOG_TAIL_INVALID = 0xC01A001C
	LOG_FULL = 0xC01A001D
	LOG_MULTIPLEXED = 0xC01A001E
	LOG_DEDICATED = 0xC01A001F
	LOG_ARCHIVE_NOT_IN_PROGRESS = 0xC01A0020
	LOG_ARCHIVE_IN_PROGRESS = 0xC01A0021
	LOG_EPHEMERAL = 0xC01A0022
	LOG_NOT_ENOUGH_CONTAINERS = 0xC01A0023
	LOG_CLIENT_ALREADY_REGISTERED = 0xC01A0024
	LOG_CLIENT_NOT_REGISTERED = 0xC01A0025
	LOG_FULL_HANDLER_IN_PROGRESS = 0xC01A0026
	LOG_CONTAINER_READ_FAILED = 0xC01A0027
	LOG_CONTAINER_WRITE_FAILED = 0xC01A0028
	LOG_CONTAINER_OPEN_FAILED = 0xC01A0029
	LOG_CONTAINER_STATE_INVALID = 0xC01A002A
	LOG_STATE_INVALID = 0xC01A002B
	LOG_PINNED = 0xC01A002C
	LOG_METADATA_FLUSH_FAILED = 0xC01A002D
	LOG_INCONSISTENT_SECURITY = 0xC01A002E
	LOG_APPENDED_FLUSH_FAILED = 0xC01A002F
	LOG_PINNED_RESERVATION = 0xC01A0030
	VIDEO_HUNG_DISPLAY_DRIVER_THREAD = 0xC01B00EA
	VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED = 0x801B00EB
	VIDEO_DRIVER_DEBUG_REPORT_REQUEST = 0x401B00EC
	MONITOR_NO_DESCRIPTOR = 0xC01D0001
	MONITOR_UNKNOWN_DESCRIPTOR_FORMAT = 0xC01D0002
	MONITOR_INVALID_DESCRIPTOR_CHECKSUM = 0xC01D0003
	MONITOR_INVALID_STANDARD_TIMING_BLOCK = 0xC01D0004
	MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED = 0xC01D0005
	MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK = 0xC01D0006
	MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK = 0xC01D0007
	MONITOR_NO_MORE_DESCRIPTOR_DATA = 0xC01D0008
	MONITOR_INVALID_DETAILED_TIMING_BLOCK = 0xC01D0009
	MONITOR_INVALID_MANUFACTURE_DATE = 0xC01D000A
	GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER = 0xC01E0000
	GRAPHICS_INSUFFICIENT_DMA_BUFFER = 0xC01E0001
	GRAPHICS_INVALID_DISPLAY_ADAPTER = 0xC01E0002
	GRAPHICS_ADAPTER_WAS_RESET = 0xC01E0003
	GRAPHICS_INVALID_DRIVER_MODEL = 0xC01E0004
	GRAPHICS_PRESENT_MODE_CHANGED = 0xC01E0005
	GRAPHICS_PRESENT_OCCLUDED = 0xC01E0006
	GRAPHICS_PRESENT_DENIED = 0xC01E0007
	GRAPHICS_CANNOTCOLORCONVERT = 0xC01E0008
	GRAPHICS_DRIVER_MISMATCH = 0xC01E0009
	GRAPHICS_PARTIAL_DATA_POPULATED = 0x401E000A
	GRAPHICS_PRESENT_REDIRECTION_DISABLED = 0xC01E000B
	GRAPHICS_PRESENT_UNOCCLUDED = 0xC01E000C
	GRAPHICS_NO_VIDEO_MEMORY = 0xC01E0100
	GRAPHICS_CANT_LOCK_MEMORY = 0xC01E0101
	GRAPHICS_ALLOCATION_BUSY = 0xC01E0102
	GRAPHICS_TOO_MANY_REFERENCES = 0xC01E0103
	GRAPHICS_TRY_AGAIN_LATER = 0xC01E0104
	GRAPHICS_TRY_AGAIN_NOW = 0xC01E0105
	GRAPHICS_ALLOCATION_INVALID = 0xC01E0106
	GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE = 0xC01E0107
	GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED = 0xC01E0108
	GRAPHICS_CANT_EVICT_PINNED_ALLOCATION = 0xC01E0109
	GRAPHICS_INVALID_ALLOCATION_USAGE = 0xC01E0110
	GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION = 0xC01E0111
	GRAPHICS_ALLOCATION_CLOSED = 0xC01E0112
	GRAPHICS_INVALID_ALLOCATION_INSTANCE = 0xC01E0113
	GRAPHICS_INVALID_ALLOCATION_HANDLE = 0xC01E0114
	GRAPHICS_WRONG_ALLOCATION_DEVICE = 0xC01E0115
	GRAPHICS_ALLOCATION_CONTENT_LOST = 0xC01E0116
	GRAPHICS_GPU_EXCEPTION_ON_DEVICE = 0xC01E0200
	GRAPHICS_INVALID_VIDPN_TOPOLOGY = 0xC01E0300
	GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED = 0xC01E0301
	GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED = 0xC01E0302
	GRAPHICS_INVALID_VIDPN = 0xC01E0303
	GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE = 0xC01E0304
	GRAPHICS_INVALID_VIDEO_PRESENT_TARGET = 0xC01E0305
	GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED = 0xC01E0306
	GRAPHICS_MODE_NOT_PINNED = 0x401E0307
	GRAPHICS_INVALID_VIDPN_SOURCEMODESET = 0xC01E0308
	GRAPHICS_INVALID_VIDPN_TARGETMODESET = 0xC01E0309
	GRAPHICS_INVALID_FREQUENCY = 0xC01E030A
	GRAPHICS_INVALID_ACTIVE_REGION = 0xC01E030B
	GRAPHICS_INVALID_TOTAL_REGION = 0xC01E030C
	GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE = 0xC01E0310
	GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE = 0xC01E0311
	GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET = 0xC01E0312
	GRAPHICS_PATH_ALREADY_IN_TOPOLOGY = 0xC01E0313
	GRAPHICS_MODE_ALREADY_IN_MODESET = 0xC01E0314
	GRAPHICS_INVALID_VIDEOPRESENTSOURCESET = 0xC01E0315
	GRAPHICS_INVALID_VIDEOPRESENTTARGETSET = 0xC01E0316
	GRAPHICS_SOURCE_ALREADY_IN_SET = 0xC01E0317
	GRAPHICS_TARGET_ALREADY_IN_SET = 0xC01E0318
	GRAPHICS_INVALID_VIDPN_PRESENT_PATH = 0xC01E0319
	GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY = 0xC01E031A
	GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET = 0xC01E031B
	GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE = 0xC01E031C
	GRAPHICS_FREQUENCYRANGE_NOT_IN_SET = 0xC01E031D
	GRAPHICS_NO_PREFERRED_MODE = 0x401E031E
	GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET = 0xC01E031F
	GRAPHICS_STALE_MODESET = 0xC01E0320
	GRAPHICS_INVALID_MONITOR_SOURCEMODESET = 0xC01E0321
	GRAPHICS_INVALID_MONITOR_SOURCE_MODE = 0xC01E0322
	GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN = 0xC01E0323
	GRAPHICS_MODE_ID_MUST_BE_UNIQUE = 0xC01E0324
	GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION = 0xC01E0325
	GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES = 0xC01E0326
	GRAPHICS_PATH_NOT_IN_TOPOLOGY = 0xC01E0327
	GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE = 0xC01E0328
	GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET = 0xC01E0329
	GRAPHICS_INVALID_MONITORDESCRIPTORSET = 0xC01E032A
	GRAPHICS_INVALID_MONITORDESCRIPTOR = 0xC01E032B
	GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET = 0xC01E032C
	GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET = 0xC01E032D
	GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE = 0xC01E032E
	GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE = 0xC01E032F
	GRAPHICS_RESOURCES_NOT_RELATED = 0xC01E0330
	GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE = 0xC01E0331
	GRAPHICS_TARGET_ID_MUST_BE_UNIQUE = 0xC01E0332
	GRAPHICS_NO_AVAILABLE_VIDPN_TARGET = 0xC01E0333
	GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER = 0xC01E0334
	GRAPHICS_NO_VIDPNMGR = 0xC01E0335
	GRAPHICS_NO_ACTIVE_VIDPN = 0xC01E0336
	GRAPHICS_STALE_VIDPN_TOPOLOGY = 0xC01E0337
	GRAPHICS_MONITOR_NOT_CONNECTED = 0xC01E0338
	GRAPHICS_SOURCE_NOT_IN_TOPOLOGY = 0xC01E0339
	GRAPHICS_INVALID_PRIMARYSURFACE_SIZE = 0xC01E033A
	GRAPHICS_INVALID_VISIBLEREGION_SIZE = 0xC01E033B
	GRAPHICS_INVALID_STRIDE = 0xC01E033C
	GRAPHICS_INVALID_PIXELFORMAT = 0xC01E033D
	GRAPHICS_INVALID_COLORBASIS = 0xC01E033E
	GRAPHICS_INVALID_PIXELVALUEACCESSMODE = 0xC01E033F
	GRAPHICS_TARGET_NOT_IN_TOPOLOGY = 0xC01E0340
	GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT = 0xC01E0341
	GRAPHICS_VIDPN_SOURCE_IN_USE = 0xC01E0342
	GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN = 0xC01E0343
	GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL = 0xC01E0344
	GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION = 0xC01E0345
	GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED = 0xC01E0346
	GRAPHICS_INVALID_GAMMA_RAMP = 0xC01E0347
	GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED = 0xC01E0348
	GRAPHICS_MULTISAMPLING_NOT_SUPPORTED = 0xC01E0349
	GRAPHICS_MODE_NOT_IN_MODESET = 0xC01E034A
	GRAPHICS_DATASET_IS_EMPTY = 0x401E034B
	GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET = 0x401E034C
	GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON = 0xC01E034D
	GRAPHICS_INVALID_PATH_CONTENT_TYPE = 0xC01E034E
	GRAPHICS_INVALID_COPYPROTECTION_TYPE = 0xC01E034F
	GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS = 0xC01E0350
	GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED = 0x401E0351
	GRAPHICS_INVALID_SCANLINE_ORDERING = 0xC01E0352
	GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED = 0xC01E0353
	GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS = 0xC01E0354
	GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT = 0xC01E0355
	GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM = 0xC01E0356
	GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN = 0xC01E0357
	GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT = 0xC01E0358
	GRAPHICS_MAX_NUM_PATHS_REACHED = 0xC01E0359
	GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION = 0xC01E035A
	GRAPHICS_INVALID_CLIENT_TYPE = 0xC01E035B
	GRAPHICS_CLIENTVIDPN_NOT_SET = 0xC01E035C
	GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED = 0xC01E0400
	GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED = 0xC01E0401
	GRAPHICS_UNKNOWN_CHILD_STATUS = 0x401E042F
	GRAPHICS_NOT_A_LINKED_ADAPTER = 0xC01E0430
	GRAPHICS_LEADLINK_NOT_ENUMERATED = 0xC01E0431
	GRAPHICS_CHAINLINKS_NOT_ENUMERATED = 0xC01E0432
	GRAPHICS_ADAPTER_CHAIN_NOT_READY = 0xC01E0433
	GRAPHICS_CHAINLINKS_NOT_STARTED = 0xC01E0434
	GRAPHICS_CHAINLINKS_NOT_POWERED_ON = 0xC01E0435
	GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE = 0xC01E0436
	GRAPHICS_LEADLINK_START_DEFERRED = 0x401E0437
	GRAPHICS_NOT_POST_DEVICE_DRIVER = 0xC01E0438
	GRAPHICS_POLLING_TOO_FREQUENTLY = 0x401E0439
	GRAPHICS_START_DEFERRED = 0x401E043A
	GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED = 0xC01E043B
	GRAPHICS_OPM_NOT_SUPPORTED = 0xC01E0500
	GRAPHICS_COPP_NOT_SUPPORTED = 0xC01E0501
	GRAPHICS_UAB_NOT_SUPPORTED = 0xC01E0502
	GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS = 0xC01E0503
	GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST = 0xC01E0505
	GRAPHICS_OPM_INTERNAL_ERROR = 0xC01E050B
	GRAPHICS_OPM_INVALID_HANDLE = 0xC01E050C
	GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH = 0xC01E050E
	GRAPHICS_OPM_SPANNING_MODE_ENABLED = 0xC01E050F
	GRAPHICS_OPM_THEATER_MODE_ENABLED = 0xC01E0510
	GRAPHICS_PVP_HFS_FAILED = 0xC01E0511
	GRAPHICS_OPM_INVALID_SRM = 0xC01E0512
	GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP = 0xC01E0513
	GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP = 0xC01E0514
	GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA = 0xC01E0515
	GRAPHICS_OPM_HDCP_SRM_NEVER_SET = 0xC01E0516
	GRAPHICS_OPM_RESOLUTION_TOO_HIGH = 0xC01E0517
	GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE = 0xC01E0518
	GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS = 0xC01E051A
	GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS = 0xC01E051C
	GRAPHICS_OPM_INVALID_INFORMATION_REQUEST = 0xC01E051D
	GRAPHICS_OPM_DRIVER_INTERNAL_ERROR = 0xC01E051E
	GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS = 0xC01E051F
	GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED = 0xC01E0520
	GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST = 0xC01E0521
	GRAPHICS_I2C_NOT_SUPPORTED = 0xC01E0580
	GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST = 0xC01E0581
	GRAPHICS_I2C_ERROR_TRANSMITTING_DATA = 0xC01E0582
	GRAPHICS_I2C_ERROR_RECEIVING_DATA = 0xC01E0583
	GRAPHICS_DDCCI_VCP_NOT_SUPPORTED = 0xC01E0584
	GRAPHICS_DDCCI_INVALID_DATA = 0xC01E0585
	GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE = 0xC01E0586
	GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING = 0xC01E0587
	GRAPHICS_MCA_INTERNAL_ERROR = 0xC01E0588
	GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND = 0xC01E0589
	GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH = 0xC01E058A
	GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM = 0xC01E058B
	GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE = 0xC01E058C
	GRAPHICS_MONITOR_NO_LONGER_EXISTS = 0xC01E058D
	GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED = 0xC01E05E0
	GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME = 0xC01E05E1
	GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP = 0xC01E05E2
	GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED = 0xC01E05E3
	GRAPHICS_INVALID_POINTER = 0xC01E05E4
	GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE = 0xC01E05E5
	GRAPHICS_PARAMETER_ARRAY_TOO_SMALL = 0xC01E05E6
	GRAPHICS_INTERNAL_ERROR = 0xC01E05E7
	GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS = 0xC01E05E8
	FVE_LOCKED_VOLUME = 0xC0210000
	FVE_NOT_ENCRYPTED = 0xC0210001
	FVE_BAD_INFORMATION = 0xC0210002
	FVE_TOO_SMALL = 0xC0210003
	FVE_FAILED_WRONG_FS = 0xC0210004
	FVE_BAD_PARTITION_SIZE = 0xC0210005
	FVE_FS_NOT_EXTENDED = 0xC0210006
	FVE_FS_MOUNTED = 0xC0210007
	FVE_NO_LICENSE = 0xC0210008
	FVE_ACTION_NOT_ALLOWED = 0xC0210009
	FVE_BAD_DATA = 0xC021000A
	FVE_VOLUME_NOT_BOUND = 0xC021000B
	FVE_NOT_DATA_VOLUME = 0xC021000C
	FVE_CONV_READ_ERROR = 0xC021000D
	FVE_CONV_WRITE_ERROR = 0xC021000E
	FVE_OVERLAPPED_UPDATE = 0xC021000F
	FVE_FAILED_SECTOR_SIZE = 0xC0210010
	FVE_FAILED_AUTHENTICATION = 0xC0210011
	FVE_NOT_OS_VOLUME = 0xC0210012
	FVE_KEYFILE_NOT_FOUND = 0xC0210013
	FVE_KEYFILE_INVALID = 0xC0210014
	FVE_KEYFILE_NO_VMK = 0xC0210015
	FVE_TPM_DISABLED = 0xC0210016
	FVE_TPM_SRK_AUTH_NOT_ZERO = 0xC0210017
	FVE_TPM_INVALID_PCR = 0xC0210018
	FVE_TPM_NO_VMK = 0xC0210019
	FVE_PIN_INVALID = 0xC021001A
	FVE_AUTH_INVALID_APPLICATION = 0xC021001B
	FVE_AUTH_INVALID_CONFIG = 0xC021001C
	FVE_DEBUGGER_ENABLED = 0xC021001D
	FVE_DRY_RUN_FAILED = 0xC021001E
	FVE_BAD_METADATA_POINTER = 0xC021001F
	FVE_OLD_METADATA_COPY = 0xC0210020
	FVE_REBOOT_REQUIRED = 0xC0210021
	FVE_RAW_ACCESS = 0xC0210022
	FVE_RAW_BLOCKED = 0xC0210023
	FVE_NO_AUTOUNLOCK_MASTER_KEY = 0xC0210024
	FVE_MOR_FAILED = 0xC0210025
	FVE_NO_FEATURE_LICENSE = 0xC0210026
	FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED = 0xC0210027
	FVE_CONV_RECOVERY_FAILED = 0xC0210028
	FVE_VIRTUALIZED_SPACE_TOO_BIG = 0xC0210029
	FVE_INVALID_DATUM_TYPE = 0xC021002A
	FVE_VOLUME_TOO_SMALL = 0xC0210030
	FVE_ENH_PIN_INVALID = 0xC0210031
	FWP_CALLOUT_NOT_FOUND = 0xC0220001
	FWP_CONDITION_NOT_FOUND = 0xC0220002
	FWP_FILTER_NOT_FOUND = 0xC0220003
	FWP_LAYER_NOT_FOUND = 0xC0220004
	FWP_PROVIDER_NOT_FOUND = 0xC0220005
	FWP_PROVIDER_CONTEXT_NOT_FOUND = 0xC0220006
	FWP_SUBLAYER_NOT_FOUND = 0xC0220007
	FWP_NOT_FOUND = 0xC0220008
	FWP_ALREADY_EXISTS = 0xC0220009
	FWP_IN_USE = 0xC022000A
	FWP_DYNAMIC_SESSION_IN_PROGRESS = 0xC022000B
	FWP_WRONG_SESSION = 0xC022000C
	FWP_NO_TXN_IN_PROGRESS = 0xC022000D
	FWP_TXN_IN_PROGRESS = 0xC022000E
	FWP_TXN_ABORTED = 0xC022000F
	FWP_SESSION_ABORTED = 0xC0220010
	FWP_INCOMPATIBLE_TXN = 0xC0220011
	FWP_TIMEOUT = 0xC0220012
	FWP_NET_EVENTS_DISABLED = 0xC0220013
	FWP_INCOMPATIBLE_LAYER = 0xC0220014
	FWP_KM_CLIENTS_ONLY = 0xC0220015
	FWP_LIFETIME_MISMATCH = 0xC0220016
	FWP_BUILTIN_OBJECT = 0xC0220017
	FWP_TOO_MANY_CALLOUTS = 0xC0220018
	FWP_NOTIFICATION_DROPPED = 0xC0220019
	FWP_TRAFFIC_MISMATCH = 0xC022001A
	FWP_INCOMPATIBLE_SA_STATE = 0xC022001B
	FWP_NULL_POINTER = 0xC022001C
	FWP_INVALID_ENUMERATOR = 0xC022001D
	FWP_INVALID_FLAGS = 0xC022001E
	FWP_INVALID_NET_MASK = 0xC022001F
	FWP_INVALID_RANGE = 0xC0220020
	FWP_INVALID_INTERVAL = 0xC0220021
	FWP_ZERO_LENGTH_ARRAY = 0xC0220022
	FWP_NULL_DISPLAY_NAME = 0xC0220023
	FWP_INVALID_ACTION_TYPE = 0xC0220024
	FWP_INVALID_WEIGHT = 0xC0220025
	FWP_MATCH_TYPE_MISMATCH = 0xC0220026
	FWP_TYPE_MISMATCH = 0xC0220027
	FWP_OUT_OF_BOUNDS = 0xC0220028
	FWP_RESERVED = 0xC0220029
	FWP_DUPLICATE_CONDITION = 0xC022002A
	FWP_DUPLICATE_KEYMOD = 0xC022002B
	FWP_ACTION_INCOMPATIBLE_WITH_LAYER = 0xC022002C
	FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER = 0xC022002D
	FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER = 0xC022002E
	FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT = 0xC022002F
	FWP_INCOMPATIBLE_AUTH_METHOD = 0xC0220030
	FWP_INCOMPATIBLE_DH_GROUP = 0xC0220031
	FWP_EM_NOT_SUPPORTED = 0xC0220032
	FWP_NEVER_MATCH = 0xC0220033
	FWP_PROVIDER_CONTEXT_MISMATCH = 0xC0220034
	FWP_INVALID_PARAMETER = 0xC0220035
	FWP_TOO_MANY_SUBLAYERS = 0xC0220036
	FWP_CALLOUT_NOTIFICATION_FAILED = 0xC0220037
	FWP_INVALID_AUTH_TRANSFORM = 0xC0220038
	FWP_INVALID_CIPHER_TRANSFORM = 0xC0220039
	FWP_INCOMPATIBLE_CIPHER_TRANSFORM = 0xC022003A
	FWP_INVALID_TRANSFORM_COMBINATION = 0xC022003B
	FWP_DUPLICATE_AUTH_METHOD = 0xC022003C
	FWP_TCPIP_NOT_READY = 0xC0220100
	FWP_INJECT_HANDLE_CLOSING = 0xC0220101
	FWP_INJECT_HANDLE_STALE = 0xC0220102
	FWP_CANNOT_PEND = 0xC0220103
	FWP_DROP_NOICMP = 0xC0220104
	NDIS_CLOSING = 0xC0230002
	NDIS_BAD_VERSION = 0xC0230004
	NDIS_BAD_CHARACTERISTICS = 0xC0230005
	NDIS_ADAPTER_NOT_FOUND = 0xC0230006
	NDIS_OPEN_FAILED = 0xC0230007
	NDIS_DEVICE_FAILED = 0xC0230008
	NDIS_MULTICAST_FULL = 0xC0230009
	NDIS_MULTICAST_EXISTS = 0xC023000A
	NDIS_MULTICAST_NOT_FOUND = 0xC023000B
	NDIS_REQUEST_ABORTED = 0xC023000C
	NDIS_RESET_IN_PROGRESS = 0xC023000D
	NDIS_NOT_SUPPORTED = 0xC02300BB
	NDIS_INVALID_PACKET = 0xC023000F
	NDIS_ADAPTER_NOT_READY = 0xC0230011
	NDIS_INVALID_LENGTH = 0xC0230014
	NDIS_INVALID_DATA = 0xC0230015
	NDIS_BUFFER_TOO_SHORT = 0xC0230016
	NDIS_INVALID_OID = 0xC0230017
	NDIS_ADAPTER_REMOVED = 0xC0230018
	NDIS_UNSUPPORTED_MEDIA = 0xC0230019
	NDIS_GROUP_ADDRESS_IN_USE = 0xC023001A
	NDIS_FILE_NOT_FOUND = 0xC023001B
	NDIS_ERROR_READING_FILE = 0xC023001C
	NDIS_ALREADY_MAPPED = 0xC023001D
	NDIS_RESOURCE_CONFLICT = 0xC023001E
	NDIS_MEDIA_DISCONNECTED = 0xC023001F
	NDIS_INVALID_ADDRESS = 0xC0230022
	NDIS_INVALID_DEVICE_REQUEST = 0xC0230010
	NDIS_PAUSED = 0xC023002A
	NDIS_INTERFACE_NOT_FOUND = 0xC023002B
	NDIS_UNSUPPORTED_REVISION = 0xC023002C
	NDIS_INVALID_PORT = 0xC023002D
	NDIS_INVALID_PORT_STATE = 0xC023002E
	NDIS_LOW_POWER_STATE = 0xC023002F
	NDIS_DOT11_AUTO_CONFIG_ENABLED = 0xC0232000
	NDIS_DOT11_MEDIA_IN_USE = 0xC0232001
	NDIS_DOT11_POWER_STATE_INVALID = 0xC0232002
	NDIS_PM_WOL_PATTERN_LIST_FULL = 0xC0232003
	NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL = 0xC0232004
	NDIS_INDICATION_REQUIRED = 0x40230001
	NDIS_OFFLOAD_POLICY = 0xC023100F
	NDIS_OFFLOAD_CONNECTION_REJECTED = 0xC0231012
	NDIS_OFFLOAD_PATH_REJECTED = 0xC0231013
	HV_INVALID_HYPERCALL_CODE = 0xC0350002
	HV_INVALID_HYPERCALL_INPUT = 0xC0350003
	HV_INVALID_ALIGNMENT = 0xC0350004
	HV_INVALID_PARAMETER = 0xC0350005
	HV_ACCESS_DENIED = 0xC0350006
	HV_INVALID_PARTITION_STATE = 0xC0350007
	HV_OPERATION_DENIED = 0xC0350008
	HV_UNKNOWN_PROPERTY = 0xC0350009
	HV_PROPERTY_VALUE_OUT_OF_RANGE = 0xC035000A
	HV_INSUFFICIENT_MEMORY = 0xC035000B
	HV_PARTITION_TOO_DEEP = 0xC035000C
	HV_INVALID_PARTITION_ID = 0xC035000D
	HV_INVALID_VP_INDEX = 0xC035000E
	HV_INVALID_PORT_ID = 0xC0350011
	HV_INVALID_CONNECTION_ID = 0xC0350012
	HV_INSUFFICIENT_BUFFERS = 0xC0350013
	HV_NOT_ACKNOWLEDGED = 0xC0350014
	HV_ACKNOWLEDGED = 0xC0350016
	HV_INVALID_SAVE_RESTORE_STATE = 0xC0350017
	HV_INVALID_SYNIC_STATE = 0xC0350018
	HV_OBJECT_IN_USE = 0xC0350019
	HV_INVALID_PROXIMITY_DOMAIN_INFO = 0xC035001A
	HV_NO_DATA = 0xC035001B
	HV_INACTIVE = 0xC035001C
	HV_NO_RESOURCES = 0xC035001D
	HV_FEATURE_UNAVAILABLE = 0xC035001E
	HV_NOT_PRESENT = 0xC0351000
	VID_DUPLICATE_HANDLER = 0xC0370001
	VID_TOO_MANY_HANDLERS = 0xC0370002
	VID_QUEUE_FULL = 0xC0370003
	VID_HANDLER_NOT_PRESENT = 0xC0370004
	VID_INVALID_OBJECT_NAME = 0xC0370005
	VID_PARTITION_NAME_TOO_LONG = 0xC0370006
	VID_MESSAGE_QUEUE_NAME_TOO_LONG = 0xC0370007
	VID_PARTITION_ALREADY_EXISTS = 0xC0370008
	VID_PARTITION_DOES_NOT_EXIST = 0xC0370009
	VID_PARTITION_NAME_NOT_FOUND = 0xC037000A
	VID_MESSAGE_QUEUE_ALREADY_EXISTS = 0xC037000B
	VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT = 0xC037000C
	VID_MB_STILL_REFERENCED = 0xC037000D
	VID_CHILD_GPA_PAGE_SET_CORRUPTED = 0xC037000E
	VID_INVALID_NUMA_SETTINGS = 0xC037000F
	VID_INVALID_NUMA_NODE_INDEX = 0xC0370010
	VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED = 0xC0370011
	VID_INVALID_MEMORY_BLOCK_HANDLE = 0xC0370012
	VID_PAGE_RANGE_OVERFLOW = 0xC0370013
	VID_INVALID_MESSAGE_QUEUE_HANDLE = 0xC0370014
	VID_INVALID_GPA_RANGE_HANDLE = 0xC0370015
	VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE = 0xC0370016
	VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED = 0xC0370017
	VID_INVALID_PPM_HANDLE = 0xC0370018
	VID_MBPS_ARE_LOCKED = 0xC0370019
	VID_MESSAGE_QUEUE_CLOSED = 0xC037001A
	VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED = 0xC037001B
	VID_STOP_PENDING = 0xC037001C
	VID_INVALID_PROCESSOR_STATE = 0xC037001D
	VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT = 0xC037001E
	VID_KM_INTERFACE_ALREADY_INITIALIZED = 0xC037001F
	VID_MB_PROPERTY_ALREADY_SET_RESET = 0xC0370020
	VID_MMIO_RANGE_DESTROYED = 0xC0370021
	VID_INVALID_CHILD_GPA_PAGE_SET = 0xC0370022
	VID_RESERVE_PAGE_SET_IS_BEING_USED = 0xC0370023
	VID_RESERVE_PAGE_SET_TOO_SMALL = 0xC0370024
	VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE = 0xC0370025
	VID_MBP_COUNT_EXCEEDED_LIMIT = 0xC0370026
	VID_SAVED_STATE_CORRUPT = 0xC0370027
	VID_SAVED_STATE_UNRECOGNIZED_ITEM = 0xC0370028
	VID_SAVED_STATE_INCOMPATIBLE = 0xC0370029
	VID_REMOTE_NODE_PARENT_GPA_PAGES_USED = 0x80370001
	IPSEC_BAD_SPI = 0xC0360001
	IPSEC_SA_LIFETIME_EXPIRED = 0xC0360002
	IPSEC_WRONG_SA = 0xC0360003
	IPSEC_REPLAY_CHECK_FAILED = 0xC0360004
	IPSEC_INVALID_PACKET = 0xC0360005
	IPSEC_INTEGRITY_CHECK_FAILED = 0xC0360006
	IPSEC_CLEAR_TEXT_DROP = 0xC0360007
	IPSEC_AUTH_FIREWALL_DROP = 0xC0360008
	IPSEC_THROTTLE_DROP = 0xC0360009
	IPSEC_DOSP_BLOCK = 0xC0368000
	IPSEC_DOSP_RECEIVED_MULTICAST = 0xC0368001
	IPSEC_DOSP_INVALID_PACKET = 0xC0368002
	IPSEC_DOSP_STATE_LOOKUP_FAILED = 0xC0368003
	IPSEC_DOSP_MAX_ENTRIES = 0xC0368004
	IPSEC_DOSP_KEYMOD_NOT_ALLOWED = 0xC0368005
	IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES = 0xC0368006
	VOLMGR_INCOMPLETE_REGENERATION = 0x80380001
	VOLMGR_INCOMPLETE_DISK_MIGRATION = 0x80380002
	VOLMGR_DATABASE_FULL = 0xC0380001
	VOLMGR_DISK_CONFIGURATION_CORRUPTED = 0xC0380002
	VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC = 0xC0380003
	VOLMGR_PACK_CONFIG_UPDATE_FAILED = 0xC0380004
	VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME = 0xC0380005
	VOLMGR_DISK_DUPLICATE = 0xC0380006
	VOLMGR_DISK_DYNAMIC = 0xC0380007
	VOLMGR_DISK_ID_INVALID = 0xC0380008
	VOLMGR_DISK_INVALID = 0xC0380009
	VOLMGR_DISK_LAST_VOTER = 0xC038000A
	VOLMGR_DISK_LAYOUT_INVALID = 0xC038000B
	VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS = 0xC038000C
	VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED = 0xC038000D
	VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL = 0xC038000E
	VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS = 0xC038000F
	VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS = 0xC0380010
	VOLMGR_DISK_MISSING = 0xC0380011
	VOLMGR_DISK_NOT_EMPTY = 0xC0380012
	VOLMGR_DISK_NOT_ENOUGH_SPACE = 0xC0380013
	VOLMGR_DISK_REVECTORING_FAILED = 0xC0380014
	VOLMGR_DISK_SECTOR_SIZE_INVALID = 0xC0380015
	VOLMGR_DISK_SET_NOT_CONTAINED = 0xC0380016
	VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS = 0xC0380017
	VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES = 0xC0380018
	VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED = 0xC0380019
	VOLMGR_EXTENT_ALREADY_USED = 0xC038001A
	VOLMGR_EXTENT_NOT_CONTIGUOUS = 0xC038001B
	VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION = 0xC038001C
	VOLMGR_EXTENT_NOT_SECTOR_ALIGNED = 0xC038001D
	VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION = 0xC038001E
	VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH = 0xC038001F
	VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED = 0xC0380020
	VOLMGR_INTERLEAVE_LENGTH_INVALID = 0xC0380021
	VOLMGR_MAXIMUM_REGISTERED_USERS = 0xC0380022
	VOLMGR_MEMBER_IN_SYNC = 0xC0380023
	VOLMGR_MEMBER_INDEX_DUPLICATE = 0xC0380024
	VOLMGR_MEMBER_INDEX_INVALID = 0xC0380025
	VOLMGR_MEMBER_MISSING = 0xC0380026
	VOLMGR_MEMBER_NOT_DETACHED = 0xC0380027
	VOLMGR_MEMBER_REGENERATING = 0xC0380028
	VOLMGR_ALL_DISKS_FAILED = 0xC0380029
	VOLMGR_NO_REGISTERED_USERS = 0xC038002A
	VOLMGR_NO_SUCH_USER = 0xC038002B
	VOLMGR_NOTIFICATION_RESET = 0xC038002C
	VOLMGR_NUMBER_OF_MEMBERS_INVALID = 0xC038002D
	VOLMGR_NUMBER_OF_PLEXES_INVALID = 0xC038002E
	VOLMGR_PACK_DUPLICATE = 0xC038002F
	VOLMGR_PACK_ID_INVALID = 0xC0380030
	VOLMGR_PACK_INVALID = 0xC0380031
	VOLMGR_PACK_NAME_INVALID = 0xC0380032
	VOLMGR_PACK_OFFLINE = 0xC0380033
	VOLMGR_PACK_HAS_QUORUM = 0xC0380034
	VOLMGR_PACK_WITHOUT_QUORUM = 0xC0380035
	VOLMGR_PARTITION_STYLE_INVALID = 0xC0380036
	VOLMGR_PARTITION_UPDATE_FAILED = 0xC0380037
	VOLMGR_PLEX_IN_SYNC = 0xC0380038
	VOLMGR_PLEX_INDEX_DUPLICATE = 0xC0380039
	VOLMGR_PLEX_INDEX_INVALID = 0xC038003A
	VOLMGR_PLEX_LAST_ACTIVE = 0xC038003B
	VOLMGR_PLEX_MISSING = 0xC038003C
	VOLMGR_PLEX_REGENERATING = 0xC038003D
	VOLMGR_PLEX_TYPE_INVALID = 0xC038003E
	VOLMGR_PLEX_NOT_RAID5 = 0xC038003F
	VOLMGR_PLEX_NOT_SIMPLE = 0xC0380040
	VOLMGR_STRUCTURE_SIZE_INVALID = 0xC0380041
	VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS = 0xC0380042
	VOLMGR_TRANSACTION_IN_PROGRESS = 0xC0380043
	VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE = 0xC0380044
	VOLMGR_VOLUME_CONTAINS_MISSING_DISK = 0xC0380045
	VOLMGR_VOLUME_ID_INVALID = 0xC0380046
	VOLMGR_VOLUME_LENGTH_INVALID = 0xC0380047
	VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE = 0xC0380048
	VOLMGR_VOLUME_NOT_MIRRORED = 0xC0380049
	VOLMGR_VOLUME_NOT_RETAINED = 0xC038004A
	VOLMGR_VOLUME_OFFLINE = 0xC038004B
	VOLMGR_VOLUME_RETAINED = 0xC038004C
	VOLMGR_NUMBER_OF_EXTENTS_INVALID = 0xC038004D
	VOLMGR_DIFFERENT_SECTOR_SIZE = 0xC038004E
	VOLMGR_BAD_BOOT_DISK = 0xC038004F
	VOLMGR_PACK_CONFIG_OFFLINE = 0xC0380050
	VOLMGR_PACK_CONFIG_ONLINE = 0xC0380051
	VOLMGR_NOT_PRIMARY_PACK = 0xC0380052
	VOLMGR_PACK_LOG_UPDATE_FAILED = 0xC0380053
	VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID = 0xC0380054
	VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID = 0xC0380055
	VOLMGR_VOLUME_MIRRORED = 0xC0380056
	VOLMGR_PLEX_NOT_SIMPLE_SPANNED = 0xC0380057
	VOLMGR_NO_VALID_LOG_COPIES = 0xC0380058
	VOLMGR_PRIMARY_PACK_PRESENT = 0xC0380059
	VOLMGR_NUMBER_OF_DISKS_INVALID = 0xC038005A
	VOLMGR_MIRROR_NOT_SUPPORTED = 0xC038005B
	VOLMGR_RAID5_NOT_SUPPORTED = 0xC038005C
	BCD_NOT_ALL_ENTRIES_IMPORTED = 0x80390001
	BCD_TOO_MANY_ELEMENTS = 0xC0390002
	BCD_NOT_ALL_ENTRIES_SYNCHRONIZED = 0x80390003
	VHD_DRIVE_FOOTER_MISSING = 0xC03A0001
	VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH = 0xC03A0002
	VHD_DRIVE_FOOTER_CORRUPT = 0xC03A0003
	VHD_FORMAT_UNKNOWN = 0xC03A0004
	VHD_FORMAT_UNSUPPORTED_VERSION = 0xC03A0005
	VHD_SPARSE_HEADER_CHECKSUM_MISMATCH = 0xC03A0006
	VHD_SPARSE_HEADER_UNSUPPORTED_VERSION = 0xC03A0007
	VHD_SPARSE_HEADER_CORRUPT = 0xC03A0008
	VHD_BLOCK_ALLOCATION_FAILURE = 0xC03A0009
	VHD_BLOCK_ALLOCATION_TABLE_CORRUPT = 0xC03A000A
	VHD_INVALID_BLOCK_SIZE = 0xC03A000B
	VHD_BITMAP_MISMATCH = 0xC03A000C
	VHD_PARENT_VHD_NOT_FOUND = 0xC03A000D
	VHD_CHILD_PARENT_ID_MISMATCH = 0xC03A000E
	VHD_CHILD_PARENT_TIMESTAMP_MISMATCH = 0xC03A000F
	VHD_METADATA_READ_FAILURE = 0xC03A0010
	VHD_METADATA_WRITE_FAILURE = 0xC03A0011
	VHD_INVALID_SIZE = 0xC03A0012
	VHD_INVALID_FILE_SIZE = 0xC03A0013
	VIRTDISK_PROVIDER_NOT_FOUND = 0xC03A0014
	VIRTDISK_NOT_VIRTUAL_DISK = 0xC03A0015
	VHD_PARENT_VHD_ACCESS_DENIED = 0xC03A0016
	VHD_CHILD_PARENT_SIZE_MISMATCH = 0xC03A0017
	VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED = 0xC03A0018
	VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT = 0xC03A0019
	VIRTUAL_DISK_LIMITATION = 0xC03A001A
	VHD_INVALID_TYPE = 0xC03A001B
	VHD_INVALID_STATE = 0xC03A001C
	VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE = 0xC03A001D
	QUERY_STORAGE_ERROR = 0x803A0001
	DIS_NOT_PRESENT = 0xC03C0001
	DIS_ATTRIBUTE_NOT_FOUND = 0xC03C0002
	DIS_UNRECOGNIZED_ATTRIBUTE = 0xC03C0003
	DIS_PARTIAL_DATA = 0xC03C0004
