<div align="center" markdown>
<a name="readme-top"></a>

![melon](https://socialify.git.ci/liblaf/melon/image?description=1&forks=1&issues=1&language=1&logo=https%3A%2F%2Fraw.githubusercontent.com%2Fmicrosoft%2Ffluentui-emoji%2Frefs%2Fheads%2Fmain%2Fassets%2FWatermelon%2F3D%2Fwatermelon_3d.png&name=1&owner=1&pattern=Transparent&pulls=1&stargazers=1&theme=Auto)

**[Explore the docs »](https://liblaf.github.io/melon/)**

<!-- tangerine-start: badges/python.md -->

[![codecov](https://codecov.io/gh/liblaf/melon/graph/badge.svg)](https://codecov.io/gh/liblaf/melon)
[![MegaLinter](https://github.com/liblaf/melon/actions/workflows/mega-linter.yaml/badge.svg)](https://github.com/liblaf/melon/actions/workflows/mega-linter.yaml)
[![Test](https://github.com/liblaf/melon/actions/workflows/test.yaml/badge.svg)](https://github.com/liblaf/melon/actions/workflows/test.yaml)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/liblaf/melon/main.svg)](https://results.pre-commit.ci/latest/github/liblaf/melon/main)
[![CodSpeed Badge](https://img.shields.io/endpoint?url=https://codspeed.io/badge.json)](https://codspeed.io/liblaf/melon)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/liblaf-melon?logo=PyPI&label=Downloads)](https://pypi.org/project/liblaf-melon)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/liblaf-melon?logo=Python&label=Python)](https://pypi.org/project/liblaf-melon)
[![PyPI - Version](https://img.shields.io/pypi/v/liblaf-melon?logo=PyPI&label=PyPI)](https://pypi.org/project/liblaf-melon)

<!-- tangerine-end -->

[Changelog](https://github.com/liblaf/melon/blob/main/CHANGELOG.md) · [Report Bug](https://github.com/liblaf/melon/issues) · [Request Feature](https://github.com/liblaf/melon/issues)

![](https://cdn.jsdelivr.net/gh/andreasbm/readme/assets/lines/rainbow.png)

</div>

## ✨ Features

- 🗂️ **Advanced I/O:** Supports reading and writing various mesh formats (OBJ, PLY, STL, VTK, VTP, VTU) with seamless integration to PyVista and Trimesh;
- 📍 **Proximity Analysis:** Provides efficient algorithms for nearest point and nearest point on surface queries with configurable thresholds and normal-based filtering;
- 🔧 **External Tool Integration:** Wraps powerful external tools like MeshFix for mesh repair and TetWild for tetrahedral mesh generation;
- 📐 **Barycentric Utilities:** Includes functions for converting barycentric coordinates to points and sampling barycentric coordinates for simulation and analysis;
- ⌨️ **Command-Line Interface:** Offers a CLI for common tasks such as landmark annotation and mesh information display;
- 🏷️ **Type Safety:** Utilizes modern Python type hints and static analysis tools for robust and maintainable code.

## 📦 Installation

To install `liblaf-melon`, run the following command:

```bash
uv add liblaf-melon
```

## ⌨️ Local Development

You can use Github Codespaces for online development:

[![](https://github.com/codespaces/badge.svg)](https://codespaces.new/liblaf/melon)

Or clone it for local development:

```bash
gh repo clone liblaf/melon
cd melon
mise run install
```

## 🤝 Contributing

Contributions of all types are more than welcome, if you are interested in contributing code, feel free to check out our GitHub [Issues](https://github.com/liblaf/melon/issues) to get stuck in to show us what you're made of.

[![PR Welcome](https://img.shields.io/badge/%F0%9F%A4%AF%20PR%20WELCOME-%E2%86%92-ffcb47?labelColor=black&style=for-the-badge)](https://github.com/liblaf/melon/pulls)

[![Contributors](https://contrib.nn.ci/api?repo=liblaf/melon)](https://github.com/liblaf/melon/graphs/contributors)

## 🔗 More Projects

<!-- tangerine-start: projects/fruits.md -->

- **[🍇 Grapes](https://github.com/liblaf/grapes)** - Supercharge your Python with rich logging, precise timing, and seamless serialization.
- **[🍉 Melon](https://github.com/liblaf/melon)** - A comprehensive Python library for 3D mesh processing with advanced I/O capabilities, proximity analysis, and integration with external mesh processing tools.
- **[🍊 Tangerine](https://github.com/liblaf/tangerine)** - Squeeze dynamic content into your files with Tangerine's template magic.
- **[🍋‍🟩 Lime](https://github.com/liblaf/lime)** - AI-powered Git commit assistant and repository documentation generator
- **[🍎 Apple](https://github.com/liblaf/apple)** - A JAX and Warp library for differentiable physics simulation, featuring elastic energy models and finite element methods.
- **[🍒 Cherries](https://github.com/liblaf/cherries)** - Sweet experiment tracking with Comet, DVC, and Git integration.
<!-- tangerine-end -->

---

#### 📝 License

Copyright © 2025 [liblaf](https://github.com/liblaf). <br />
This project is [MIT](https://github.com/liblaf/melon/blob/main/LICENSE) licensed.
