# Generated by Django 4.0.3 on 2022-06-03 13:30

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("eveuniverse", "0007_evetype_description"),
        ("authentication", "0019_merge_20211026_0919"),
        ("eveonline", "0015_factions"),
        ("auth", "0012_alter_user_first_name_max_length"),
        ("killtracker", "0004_django4_update"),
    ]

    operations = [
        migrations.AddField(
            model_name="tracker",
            name="exclude_victim_alliances",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Exclude killmails where the victim belongs to one of these alliances. ",
                related_name="+",
                to="eveonline.eveallianceinfo",
            ),
        ),
        migrations.AddField(
            model_name="tracker",
            name="exclude_victim_corporations",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Exclude killmails where the victim belongs to one of these corporations. ",
                related_name="+",
                to="eveonline.evecorporationinfo",
            ),
        ),
        migrations.AddField(
            model_name="tracker",
            name="require_attacker_organizations_final_blow",
            field=models.BooleanField(
                blank=True,
                default=False,
                help_text="Only include killmails where at least one of the specified <b>required attacker corporations</b> or <b>required attacker alliances</b> has the final blow.",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="color",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Optional color for embed on Discord - #000000 / black means no color selected.",
                max_length=7,
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_attacker_alliances",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Exclude killmails with attackers from one of these alliances. ",
                related_name="+",
                to="eveonline.eveallianceinfo",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_attacker_corporations",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Exclude killmails with attackers from one of these corporations. ",
                related_name="+",
                to="eveonline.evecorporationinfo",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_attacker_states",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Exclude killmails with characters belonging to users with these Auth states. ",
                related_name="+",
                to="authentication.state",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_blue_attackers",
            field=models.BooleanField(
                default=False, help_text="Exclude killmails with blue attackers."
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_high_sec",
            field=models.BooleanField(
                default=False,
                help_text="Exclude killmails from high sec. Also exclude high sec systems in route finder for jumps from origin.",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_low_sec",
            field=models.BooleanField(
                default=False, help_text="Exclude killmails from low sec."
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_npc_kills",
            field=models.BooleanField(default=False, help_text="Exclude npc kills."),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_null_sec",
            field=models.BooleanField(
                default=False, help_text="Exclude killmails from null sec."
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="exclude_w_space",
            field=models.BooleanField(
                default=False, help_text="Exclude killmails from WH space."
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="identify_fleets",
            field=models.BooleanField(
                default=False,
                help_text="When true: kills are interpreted and shown as fleet kills.",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="is_enabled",
            field=models.BooleanField(
                db_index=True,
                default=True,
                help_text="Toogle for activating or deactivating a tracker.",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="is_posting_name",
            field=models.BooleanField(
                default=True,
                help_text="Whether posted messages include the tracker's name.",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="name",
            field=models.CharField(
                help_text="Name to identify tracker. Will be shown on alerts posts.",
                max_length=100,
                unique=True,
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="origin_solar_system",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Solar system to calculate distance and jumps from. When provided distance and jumps will be shown on killmail messages.",
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="+",
                to="eveuniverse.evesolarsystem",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="ping_groups",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Option to ping specific group members. ",
                related_name="+",
                to="auth.group",
                verbose_name="group pings",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="ping_type",
            field=models.CharField(
                choices=[("PN", "(none)"), ("PH", "@here"), ("PE", "@everybody")],
                default="PN",
                help_text="Option to ping every member of the channel.",
                max_length=2,
                verbose_name="channel pings",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_attacker_alliances",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails with attackers from one of these alliances. ",
                related_name="+",
                to="eveonline.eveallianceinfo",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_attacker_corporations",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails with attackers from one of these corporations. ",
                related_name="+",
                to="eveonline.evecorporationinfo",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_attacker_states",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails with characters belonging to users with these Auth states. ",
                related_name="+",
                to="authentication.state",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_attackers_ship_groups",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails where at least one attacker is flying one of these ship groups. ",
                related_name="+",
                to="eveuniverse.evegroup",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_attackers_ship_types",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails where at least one attacker is flying one of these ship types. ",
                related_name="+",
                to="eveuniverse.evetype",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_blue_victim",
            field=models.BooleanField(
                default=False,
                help_text="Only include killmails where the victim has standing with our group.",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_constellations",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails that occurred in one of these regions. ",
                related_name="+",
                to="eveuniverse.eveconstellation",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_max_attackers",
            field=models.PositiveIntegerField(
                blank=True,
                default=None,
                help_text="Require killmails to have no more than max number of attackers.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_max_distance",
            field=models.FloatField(
                blank=True,
                default=None,
                help_text="Require all killmails to be max x LY away from origin solar system.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_max_jumps",
            field=models.PositiveIntegerField(
                blank=True,
                default=None,
                help_text="Require all killmails to be max x jumps away from origin solar system.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_min_attackers",
            field=models.PositiveIntegerField(
                blank=True,
                default=None,
                help_text="Require killmails to have at least given number of attackers.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_min_value",
            field=models.PositiveIntegerField(
                blank=True,
                default=None,
                help_text="Require killmail's value to be greater or equal to the given value in M ISK.",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_npc_kills",
            field=models.BooleanField(
                default=False, help_text="Only include killmails that are npc kills."
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_regions",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails that occurred in one of these regions. ",
                related_name="+",
                to="eveuniverse.everegion",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_solar_systems",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails that occurred in one of these regions. ",
                related_name="+",
                to="eveuniverse.evesolarsystem",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_victim_alliances",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails where the victim belongs to one of these alliances. ",
                related_name="+",
                to="eveonline.eveallianceinfo",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_victim_corporations",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails where the victim belongs to one of these corporations. ",
                related_name="+",
                to="eveonline.evecorporationinfo",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_victim_ship_groups",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails where victim is flying one of these ship groups. ",
                related_name="+",
                to="eveuniverse.evegroup",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_victim_ship_types",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails where victim is flying one of these ship types. ",
                related_name="+",
                to="eveuniverse.evetype",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="require_victim_states",
            field=models.ManyToManyField(
                blank=True,
                default=None,
                help_text="Only include killmails where the victim characters belong to users with these Auth states. ",
                related_name="+",
                to="authentication.state",
            ),
        ),
        migrations.AlterField(
            model_name="tracker",
            name="webhook",
            field=models.ForeignKey(
                help_text="Webhook URL for a channel on Discord to sent all alerts to.",
                on_delete=django.db.models.deletion.CASCADE,
                to="killtracker.webhook",
            ),
        ),
    ]
