import os
import toml
import logging
from pathlib import Path

# Configure logging
logging.basicConfig(level=logging.INFO, format="%(levelname)s: %(message)s")
logger = logging.getLogger(__name__)

class WorkspaceManager:
    """
    Auto-generated by mulch based on scaffold.json.
    """

    WORKSPACES_DIR_NAME = "workspaces"

    SCAFFOLD_DIR_NAME = {"dirs": ["data", "data/raw", "data/processed/monthly", "queries/historical/archive"], "files": ["queries/historical/default-queries.toml", "data/processed/monthly/README.md", "secrets/secrets-example.yaml"]}


    DEFAULT_WORKSPACE_TOML = "default-workspace.toml"
    SECRETS_YAML = "secrets.yaml"
    SECRETS_EXAMPLE_YAML = "secrets-example.yaml"
    DEFAULT_QUERIES_TOML = "default-queries.toml"

    ROOT_DIR = Path(__file__).resolve().parents[2]

    def __init__(self, workspace_name):
        self.workspace_name = workspace_name
        self.workspace_dir = self.ROOT_DIR / self.WORKSPACES_DIR_NAME / workspace_name
        self.ensure_structure()

    def ensure_structure(self):
        """
        Ensures all directories and files from scaffold exist in the workspace.
        """

        base = self.workspace_dir / "scaffold"

        path = base / "dirs"
        if "." in "dirs":
            if not path.exists():
                path.parent.mkdir(parents=True, exist_ok=True)
                path.touch()
                logging.DEBUG(f"Created file: dirs")
        else:
            if not path.exists():
                path.mkdir(parents=True, exist_ok=True)
                logging.DEBUG(f"Created folder: dirs")

        path = base / "files"
        if "." in "files":
            if not path.exists():
                path.parent.mkdir(parents=True, exist_ok=True)
                path.touch()
                logging.DEBUG(f"Created file: files")
        else:
            if not path.exists():
                path.mkdir(parents=True, exist_ok=True)
                logging.DEBUG(f"Created folder: files")



    def get_workspace_path(self):
        return self.workspace_dir

    def get_config_path(self, filename=DEFAULT_WORKSPACE_TOML):
        return self.workspace_dir / "config" / filename

    def get_secrets_path(self):
        return self.workspace_dir / "secrets" / self.SECRETS_YAML

    def get_queries_path(self):
        return self.workspace_dir / "queries" / self.DEFAULT_QUERIES_TOML


if __name__ == "__main__":
    wm = WorkspaceManager("")
    logger.debug("Workspace initialized:", wm.get_workspace_path())