"""
Tokenizer Exceptions.
Source: https://forkortelse.dk/ and various others.
"""

from ...symbols import NORM, ORTH
from ...util import update_exc
from ..tokenizer_exceptions import BASE_EXCEPTIONS

_exc = {}

# Abbreviations for weekdays "søn." (for "søndag") as well as "Tor." and "Tors."
# (for "torsdag") are left out because they are ambiguous. The same is the case
# for abbreviations "jul." and "Jul." ("juli").
for exc_data in [
    {ORTH: "Kbh.", NORM: "København"},
    {ORTH: "jan.", NORM: "januar"},
    {ORTH: "febr.", NORM: "februar"},
    {ORTH: "feb.", NORM: "februar"},
    {ORTH: "mar.", NORM: "marts"},
    {ORTH: "apr.", NORM: "april"},
    {ORTH: "jun.", NORM: "juni"},
    {ORTH: "aug.", NORM: "august"},
    {ORTH: "sept.", NORM: "september"},
    {ORTH: "sep.", NORM: "september"},
    {ORTH: "okt.", NORM: "oktober"},
    {ORTH: "nov.", NORM: "november"},
    {ORTH: "dec.", NORM: "december"},
    {ORTH: "man.", NORM: "mandag"},
    {ORTH: "tirs.", NORM: "tirsdag"},
    {ORTH: "ons.", NORM: "onsdag"},
    {ORTH: "tor.", NORM: "torsdag"},
    {ORTH: "tors.", NORM: "torsdag"},
    {ORTH: "fre.", NORM: "fredag"},
    {ORTH: "lør.", NORM: "lørdag"},
    {ORTH: "Jan.", NORM: "januar"},
    {ORTH: "Febr.", NORM: "februar"},
    {ORTH: "Feb.", NORM: "februar"},
    {ORTH: "Mar.", NORM: "marts"},
    {ORTH: "Apr.", NORM: "april"},
    {ORTH: "Jun.", NORM: "juni"},
    {ORTH: "Aug.", NORM: "august"},
    {ORTH: "Sept.", NORM: "september"},
    {ORTH: "Sep.", NORM: "september"},
    {ORTH: "Okt.", NORM: "oktober"},
    {ORTH: "Nov.", NORM: "november"},
    {ORTH: "Dec.", NORM: "december"},
    {ORTH: "Man.", NORM: "mandag"},
    {ORTH: "Tirs.", NORM: "tirsdag"},
    {ORTH: "Ons.", NORM: "onsdag"},
    {ORTH: "Fre.", NORM: "fredag"},
    {ORTH: "Lør.", NORM: "lørdag"},
    {ORTH: "og/eller", NORM: "og/eller"},
]:
    _exc[exc_data[ORTH]] = [exc_data]


# Specified case only
for orth in [
    "diam.",
    "ib.",
    "mia.",
    "mik.",
    "pers.",
    "A.D.",
    "A/B",
    "a/s",
    "A/S",
    "B.C.",
    "BK.",
    "B.T.",
    "Dr.",
    "Boul.",
    "Chr.",
    "Dronn.",
    "H.K.H.",
    "H.M.",
    "Hf.",
    "i/s",
    "I/S",
    "Inc.",
    "Kprs.",
    "L.A.",
    "Ll.",
    "m/k",
    "m/s",
    "m/sek.",
    "M/S",
    "Mag.",
    "Mr.",
    "Ndr.",
    "Ph.d.",
    "Prs.",
    "Rcp.",
    "Sdr.",
    "Skt.",
    "Spl.",
    "TCP/IP",
    "Vg.",
]:
    _exc[orth] = [{ORTH: orth}]


for orth in [
    "aarh.",
    "ac.",
    "adj.",
    "adr.",
    "adsk.",
    "adv.",
    "afb.",
    "afd.",
    "afg.",
    "afk.",
    "afs.",
    "aht.",
    "alg.",
    "alk.",
    "alm.",
    "amer.",
    "ang.",
    "ank.",
    "anl.",
    "anv.",
    "arb.",
    "arr.",
    "att.",
    "bd.",
    "bdt.",
    "beg.",
    "begr.",
    "beh.",
    "bet.",
    "bev.",
    "bhk.",
    "bib.",
    "bibl.",
    "bidr.",
    "bildl.",
    "bill.",
    "biol.",
    "bk.",
    "bl.",
    "bl.a.",
    "borgm.",
    "br.",
    "brolægn.",
    "bto.",
    "bygn.",
    "c/o",
    "ca.",
    "cm.",
    "cand.",
    "d.d.",
    "d.m.",
    "d.s.",
    "d.s.s.",
    "d.y.",
    "d.å.",
    "d.æ.",
    "dagl.",
    "dat.",
    "dav.",
    "def.",
    "dek.",
    "dep.",
    "desl.",
    "dir.",
    "disp.",
    "distr.",
    "div.",
    "dkr.",
    "dl.",
    "do.",
    "dobb.",
    "dr.",
    "dr.h.c",
    "dr.phil.",
    "ds.",
    "dvs.",
    "d.v.s.",
    "e.b.",
    "e.l.",
    "e.o.",
    "e.v.t.",
    "eftf.",
    "eftm.",
    "egl.",
    "eks.",
    "eksam.",
    "ekskl.",
    "eksp.",
    "ekspl.",
    "el.lign.",
    "emer.",
    "endv.",
    "eng.",
    "enk.",
    "etc.",
    "etym.",
    "eur.",
    "evt.",
    "exam.",
    "f.eks.",
    "f.m.",
    "f.n.",
    "f.o.",
    "f.o.m.",
    "f.s.v.",
    "f.t.",
    "f.v.t.",
    "f.å.",
    "fa.",
    "fakt.",
    "fam.",
    "ff.",
    "fg.",
    "fhv.",
    "fig.",
    "filol.",
    "filos.",
    "fl.",
    "flg.",
    "fm.",
    "fmd.",
    "fol.",
    "forb.",
    "foreg.",
    "foren.",
    "forf.",
    "fork.",
    "forr.",
    "fors.",
    "forsk.",
    "forts.",
    "fr.",
    "fr.u.",
    "frk.",
    "fsva.",
    "fuldm.",
    "fung.",
    "fx.",
    "fys.",
    "fær.",
    "g.d.",
    "g.m.",
    "gd.",
    "gdr.",
    "genuds.",
    "gl.",
    "gn.",
    "gns.",
    "gr.",
    "grdl.",
    "gross.",
    "h.a.",
    "h.c.",
    "hdl.",
    "henv.",
    "hhv.",
    "hj.hj.",
    "hj.spl.",
    "hort.",
    "hosp.",
    "hpl.",
    "hr.",
    "hrs.",
    "hum.",
    "hvp.",
    "i.e.",
    "id.",
    "if.",
    "iflg.",
    "ifm.",
    "ift.",
    "iht.",
    "ill.",
    "indb.",
    "indreg.",
    "inf.",
    "ing.",
    "inh.",
    "inj.",
    "inkl.",
    "insp.",
    "instr.",
    "isl.",
    "istf.",
    "it.",
    "ital.",
    "iv.",
    "jap.",
    "jf.",
    "jfr.",
    "jnr.",
    "j.nr.",
    "jr.",
    "jur.",
    "jvf.",
    "kap.",
    "kbh.",
    "kem.",
    "kg.",
    "kgs.",
    "kgl.",
    "kl.",
    "kld.",
    "km.",
    "km/t",
    "km/t.",
    "knsp.",
    "komm.",
    "kons.",
    "korr.",
    "kp.",
    "kr.",
    "kst.",
    "kt.",
    "ktr.",
    "kv.",
    "kvm.",
    "kvt.",
    "l.c.",
    "lab.",
    "lat.",
    "lb.m.",
    "lb.nr.",
    "lejl.",
    "lgd.",
    "lic.",
    "lign.",
    "lin.",
    "ling.merc.",
    "litt.",
    "loc.cit.",
    "lok.",
    "lrs.",
    "ltr.",
    "m.a.o.",
    "m.fl.",
    "m.m.",
    "m.v.",
    "m.v.h.",
    "maks.",
    "md.",
    "mdr.",
    "mdtl.",
    "mezz.",
    "mfl.",
    "m.h.p.",
    "m.h.t.",
    "mht.",
    "mill.",
    "mio.",
    "modt.",
    "mrk.",
    "mul.",
    "mv.",
    "n.br.",
    "n.f.",
    "nb.",
    "nedenst.",
    "nl.",
    "nr.",
    "nto.",
    "nuv.",
    "o/m",
    "o/m.",
    "o.a.",
    "o.fl.",
    "o.h.",
    "o.l.",
    "o.lign.",
    "o.m.a.",
    "o.s.fr.",
    "obl.",
    "obs.",
    "odont.",
    "oecon.",
    "off.",
    "ofl.",
    "omg.",
    "omkr.",
    "omr.",
    "omtr.",
    "opg.",
    "opl.",
    "opr.",
    "org.",
    "orig.",
    "osv.",
    "ovenst.",
    "overs.",
    "ovf.",
    "p.a.",
    "p.b.a",
    "p.b.v",
    "p.c.",
    "p.m.",
    "p.m.v.",
    "p.n.",
    "p.p.",
    "p.p.s.",
    "p.s.",
    "p.t.",
    "p.v.a.",
    "p.v.c.",
    "pag.",
    "pass.",
    "pcs.",
    "pct.",
    "pd.",
    "pens.",
    "pft.",
    "pg.",
    "pga.",
    "pgl.",
    "pinx.",
    "pk.",
    "pkt.",
    "polit.",
    "polyt.",
    "pos.",
    "pp.",
    "ppm.",
    "pr.",
    "prc.",
    "priv.",
    "prod.",
    "prof.",
    "pron.",
    "præd.",
    "præf.",
    "præt.",
    "psych.",
    "pt.",
    "pæd.",
    "q.e.d.",
    "rad.",
    "red.",
    "ref.",
    "reg.",
    "regn.",
    "rel.",
    "rep.",
    "repr.",
    "resp.",
    "rest.",
    "rm.",
    "rtg.",
    "russ.",
    "s.br.",
    "s.d.",
    "s.f.",
    "s.m.b.a.",
    "s.u.",
    "s.å.",
    "sa.",
    "sb.",
    "sc.",
    "scient.",
    "scil.",
    "sek.",
    "sekr.",
    "self.",
    "sem.",
    "shj.",
    "sign.",
    "sing.",
    "sj.",
    "skr.",
    "slutn.",
    "sml.",
    "smp.",
    "snr.",
    "soc.",
    "soc.dem.",
    "sp.",
    "spec.",
    "spm.",
    "spr.",
    "spsk.",
    "statsaut.",
    "st.",
    "stk.",
    "str.",
    "stud.",
    "subj.",
    "subst.",
    "suff.",
    "sup.",
    "suppl.",
    "sv.",
    "såk.",
    "sædv.",
    "t/r",
    "t.h.",
    "t.o.",
    "t.o.m.",
    "t.v.",
    "tbl.",
    "tcp/ip",
    "td.",
    "tdl.",
    "tdr.",
    "techn.",
    "tekn.",
    "temp.",
    "th.",
    "theol.",
    "tidl.",
    "tilf.",
    "tilh.",
    "till.",
    "tilsv.",
    "tjg.",
    "tkr.",
    "tlf.",
    "tlgr.",
    "tr.",
    "trp.",
    "tsk.",
    "tv.",
    "ty.",
    "u/b",
    "udb.",
    "udbet.",
    "ugtl.",
    "undt.",
    "v.f.",
    "vb.",
    "vedk.",
    "vedl.",
    "vedr.",
    "vejl.",
    "vh.",
    "vha.",
    "vind.",
    "vs.",
    "vsa.",
    "vær.",
    "zool.",
    "ø.lgd.",
    "øvr.",
    "årg.",
    "årh.",
]:
    _exc[orth] = [{ORTH: orth}]
    capitalized = orth.capitalize()
    _exc[capitalized] = [{ORTH: capitalized}]

for exc_data in [
    {ORTH: "s'gu", NORM: "s'gu"},
    {ORTH: "S'gu", NORM: "s'gu"},
    {ORTH: "sgu'", NORM: "s'gu"},
    {ORTH: "Sgu'", NORM: "s'gu"},
    {ORTH: "sku'", NORM: "skulle"},
    {ORTH: "ku'", NORM: "kunne"},
    {ORTH: "Ku'", NORM: "kunne"},
    {ORTH: "ka'", NORM: "kan"},
    {ORTH: "Ka'", NORM: "kan"},
    {ORTH: "gi'", NORM: "giv"},
    {ORTH: "Gi'", NORM: "giv"},
    {ORTH: "li'", NORM: "lide"},
    {ORTH: "ha'", NORM: "have"},
    {ORTH: "Ha'", NORM: "have"},
    {ORTH: "ik'", NORM: "ikke"},
    {ORTH: "Ik'", NORM: "ikke"},
]:
    _exc[exc_data[ORTH]] = [exc_data]


# Dates
for h in range(1, 31 + 1):
    for period in ["."]:
        _exc[f"{h}{period}"] = [{ORTH: f"{h}."}]

_custom_base_exc = {"i.": [{ORTH: "i", NORM: "i"}, {ORTH: "."}]}
_exc.update(_custom_base_exc)

TOKENIZER_EXCEPTIONS = update_exc(BASE_EXCEPTIONS, _exc)
