"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.aws_vpc import AWSVPC
from reconcile.gql_definitions.fragments.jumphost_common_fields import CommonJumphostFields
from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment AWSVPC on AWSVPC_v1 {
  name
  description
  account {
    name
    uid
    terraformUsername
    automationToken {
      ... VaultSecret
    }
  }
  region
  vpc_id
  cidr_block
  subnets {
    id
  }
}

fragment CommonJumphostFields on ClusterJumpHost_v1 {
  hostname
  knownHosts
  user
  port
  remotePort
  identity {
    ... VaultSecret
  }
}

fragment VaultSecret on VaultSecret_v1 {
    path
    field
    version
    format
}

query TerraformResourcesNamespaces {
  namespaces: namespaces_v1 {
    name
    delete
    clusterAdmin
    managedExternalResources
    externalResources {
      provider
      provisioner {
        name
      }
      ... on NamespaceTerraformProviderResourceAWS_v1 {
        resources {
            output_format {
            provider
            ... on NamespaceTerraformResourceGenericSecretOutputFormat_v1 {
                data
            }
            }
            provider
            ... on NamespaceTerraformResourceRDS_v1 {
                region
                identifier
                defaults
                availability_zone
                parameter_group
                old_parameter_group
                overrides
                output_resource_name
                enhanced_monitoring
                replica_source
                output_resource_db_name
                reset_password
                ca_cert {
                    ... VaultSecret
                }
                annotations
                event_notifications {
                    destination
                    source_type
                    event_categories
                }
                data_classification {
                    loss_impact
                }
                managed_by_erv2
            }
            ... on NamespaceTerraformResourceS3_v1 {
                region
                identifier
                defaults
                overrides
                sqs_identifier
                s3_events
                event_notifications {
                    destination_type
                    destination
                    event_type
                    filter_prefix
                    filter_suffix
                }
                bucket_policy
                output_resource_name
                storage_class
                annotations
            }
            ... on NamespaceTerraformResourceElastiCache_v1 {
                identifier
                defaults
                parameter_group
                region
                overrides
                output_resource_name
                annotations
                managed_by_erv2
            }
            ... on NamespaceTerraformResourceServiceAccount_v1 {
                identifier
                variables
                policies
                user_policy
                output_resource_name
                annotations
                aws_infrastructure_access {
                    cluster {
                        name
                    }
                    access_level
                    assume_role
                }
            }
            ... on NamespaceTerraformResourceSecretsManagerServiceAccount_v1 {
                identifier
                secrets_prefix
                output_resource_name
                annotations
            }
            ... on NamespaceTerraformResourceRole_v1 {
                identifier
                assume_role {
                    AWS
                    Service
                    Federated
                }
                assume_condition
                assume_action
                inline_policy
                role_policy
                policies
                output_resource_name
                annotations
                lifecycle {
                  create_before_destroy
                  prevent_destroy
                  ignore_changes
                }
                managed_by_erv2
                max_session_duration
            }
            ... on NamespaceTerraformResourceSQS_v1 {
                region
                identifier
                output_resource_name
                annotations
                specs {
                    defaults
                    queues {
                        key
                        value
                    }
                }
            }
            ... on NamespaceTerraformResourceSNSTopic_v1 {
                defaults
                region
                identifier
                output_resource_name
                fifo_topic
                inline_policy
                annotations
                subscriptions
                {
                    protocol
                    endpoint
                }
            }
            ... on NamespaceTerraformResourceDynamoDB_v1 {
                region
                identifier
                output_resource_name
                annotations
                specs {
                    defaults
                    tables {
                        key
                        value
                    }
                }
            }
            ... on NamespaceTerraformResourceECR_v1 {
                identifier
                region
                output_resource_name
                public
                annotations
            }
            ... on NamespaceTerraformResourceS3CloudFront_v1 {
                region
                identifier
                defaults
                output_resource_name
                storage_class
                annotations
            }
            ... on NamespaceTerraformResourceS3SQS_v1 {
                region
                identifier
                defaults
                kms_encryption
                output_resource_name
                storage_class
                annotations
            }
            ... on NamespaceTerraformResourceCloudWatch_v1 {
                region
                identifier
                defaults
                es_identifier
                filter_pattern
                output_resource_name
                annotations
                managed_by_erv2
            }
            ... on NamespaceTerraformResourceKMS_v1 {
                region
                identifier
                defaults
                overrides
                output_resource_name
                annotations
                managed_by_erv2
            }
            ... on NamespaceTerraformResourceElasticSearch_v1 {
                region
                identifier
                defaults
                output_resource_name
                annotations
                publish_log_types
            }
            ... on NamespaceTerraformResourceACM_v1 {
                region
                identifier
                secret {
                    ... VaultSecret
                }
                domain {
                    domain_name
                    alternate_names
                }
                output_resource_name
                annotations
            }
            ... on NamespaceTerraformResourceKinesis_v1 {
                region
                identifier
                defaults
                es_identifier
                output_resource_name
                annotations
            }
            ... on NamespaceTerraformResourceS3CloudFrontPublicKey_v1 {
                region
                identifier
                secret {
                    ... VaultSecret
                }
                output_resource_name
                annotations
            }
            ... on NamespaceTerraformResourceALB_v1 {
                region
                identifier
                vpc {
                    ... AWSVPC
                }
                certificate_arn
                ingress_cidr_blocks
                idle_timeout
                enable_http2
                ip_address_type
                access_logs
                ssl_policy
                mutual_authentication {
                    mode
                    ca_cert_bundle_s3_bucket_name
                    ca_cert_bundle_s3_bucket_key
                }
                targets {
                    name
                    default
                    ips
                    openshift_service
                    protocol
                    protocol_version
                    health_check {
                        unhealthy_threshold
                        timeout
                        interval
                        healthy_threshold
                        path
                        port
                        protocol
                    }
                }
                rules {
                    condition {
                        type
                        ... on NamespaceTerraformResourceALBConditionHostHeader_v1 {
                            host_header
                        }
                        ... on NamespaceTerraformResourceALBConditionHTTPRequestMethod_v1 {
                            http_request_method
                        }
                        ... on NamespaceTerraformResourceALBConditionPathPattern_v1 {
                            path_pattern
                        }
                        ... on NamespaceTerraformResourceALBConditionSourceIP_v1 {
                            source_ip
                        }
                        ... on NamespaceTerraformResourceALBConditionQueryString_v1 {
                            query_string {
                                key
                                value
                            }
                        }
                    }
                    action {
                        type
                        ... on NamespaceTerraformResourceALBActionForward_v1 {
                            forward {
                                target_group {
                                    target
                                    weight
                                }
                            }
                        }
                        ... on NamespaceTerraformResourceALBActionFixedResponse_v1 {
                            fixed_response {
                                content_type
                                message_body
                                status_code
                            }
                        }
                        ... on NamespaceTerraformResourceALBActionRedirect_v1 {
                            redirect {
                                host
                                path
                                port
                                protocol
                                query
                                status_code
                            }
                        }
                    }
                }
                output_resource_name
                annotations
            }
            ... on NamespaceTerraformResourceSecretsManager_v1 {
                region
                identifier
                secret {
                    ... VaultSecret
                }
                output_resource_name
                annotations
            }
            ... on NamespaceTerraformResourceASG_v1 {
                region
                identifier
                defaults
                cloudinit_configs {
                    filename
                    content_type
                    content
                }
                variables
                overrides
                extra_tags
                image {
                    provider
                    ... on ASGImageGit_v1 {
                    tag_name
                    url
                    ref
                    upstream {
                        instance {
                            name
                            token {
                                ... VaultSecret
                            }
                        }
                        name
                    }
                    }
                    ... on ASGImageStatic_v1 {
                        tag_name
                        value
                    }
                }
                output_resource_name
                annotations
            }
            ... on NamespaceTerraformResourceRoute53Zone_v1 {
                region
                identifier
                name
                output_resource_name
                annotations
                records {
                    name
                    type
                    ttl
                    alias {
                        name
                        zone_id
                        evaluate_target_health
                    }
                    weighted_routing_policy {
                        weight
                    }
                    geolocation_routing_policy {
                        continent
                        country
                        subdivision
                    }
                    set_identifier
                    records
                }
            }
            ... on NamespaceTerraformResourceRosaAuthenticator_V1 {
                region
                identifier
                api_proxy_uri
                cognito_callback_bucket_name
                certificate_arn
                domain_name
                network_interface_ids
                openshift_ingress_load_balancer_arn
                insights_callback_urls
                output_resource_name
                annotations
                vpc_id
                subnet_ids
                vpce_id
                defaults
            }
            ... on NamespaceTerraformResourceRosaAuthenticatorVPCE_V1 {
                region
                identifier
                subnet_ids,
                vpc_id,
                output_resource_name
                annotations
                defaults
            }
            ... on NamespaceTerraformResourceMsk_v1 {
                region
                identifier
                output_resource_name
                defaults
                annotations
                users {
                  name
                  secret {
                    ...VaultSecret
                  }
                }
                managed_by_erv2
            }
        }
      }
    }
    environment {
      name
    }
    app {
      name
    }
    cluster {
      name
      serverUrl
      insecureSkipTLSVerify
      jumpHost {
        ... CommonJumphostFields
      }
      automationToken {
        ... VaultSecret
      }
      clusterAdminAutomationToken {
        ... VaultSecret
      }
      spec {
        region
      }
      internal
      disable {
        integrations
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class ExternalResourcesProvisionerV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class NamespaceExternalResourceV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")
    provisioner: ExternalResourcesProvisionerV1 = Field(..., alias="provisioner")


class NamespaceTerraformResourceOutputFormatV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class NamespaceTerraformResourceGenericSecretOutputFormatV1(NamespaceTerraformResourceOutputFormatV1):
    data: Optional[str] = Field(..., alias="data")


class NamespaceTerraformResourceAWSV1(ConfiguredBaseModel):
    output_format: Optional[Union[NamespaceTerraformResourceGenericSecretOutputFormatV1, NamespaceTerraformResourceOutputFormatV1]] = Field(..., alias="output_format")
    provider: str = Field(..., alias="provider")


class AWSRDSEventNotificationV1(ConfiguredBaseModel):
    destination: str = Field(..., alias="destination")
    source_type: Optional[str] = Field(..., alias="source_type")
    event_categories: Optional[list[str]] = Field(..., alias="event_categories")


class AWSRDSDataClassificationV1(ConfiguredBaseModel):
    loss_impact: Optional[str] = Field(..., alias="loss_impact")


class NamespaceTerraformResourceRDSV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    availability_zone: Optional[str] = Field(..., alias="availability_zone")
    parameter_group: Optional[str] = Field(..., alias="parameter_group")
    old_parameter_group: Optional[str] = Field(..., alias="old_parameter_group")
    overrides: Optional[str] = Field(..., alias="overrides")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    enhanced_monitoring: Optional[bool] = Field(..., alias="enhanced_monitoring")
    replica_source: Optional[str] = Field(..., alias="replica_source")
    output_resource_db_name: Optional[str] = Field(..., alias="output_resource_db_name")
    reset_password: Optional[str] = Field(..., alias="reset_password")
    ca_cert: Optional[VaultSecret] = Field(..., alias="ca_cert")
    annotations: Optional[str] = Field(..., alias="annotations")
    event_notifications: Optional[list[AWSRDSEventNotificationV1]] = Field(..., alias="event_notifications")
    data_classification: Optional[AWSRDSDataClassificationV1] = Field(..., alias="data_classification")
    managed_by_erv2: Optional[bool] = Field(..., alias="managed_by_erv2")


class AWSS3EventNotificationV1(ConfiguredBaseModel):
    destination_type: str = Field(..., alias="destination_type")
    destination: str = Field(..., alias="destination")
    event_type: list[str] = Field(..., alias="event_type")
    filter_prefix: Optional[str] = Field(..., alias="filter_prefix")
    filter_suffix: Optional[str] = Field(..., alias="filter_suffix")


class NamespaceTerraformResourceS3V1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    overrides: Optional[str] = Field(..., alias="overrides")
    sqs_identifier: Optional[str] = Field(..., alias="sqs_identifier")
    s3_events: Optional[list[str]] = Field(..., alias="s3_events")
    event_notifications: Optional[list[AWSS3EventNotificationV1]] = Field(..., alias="event_notifications")
    bucket_policy: Optional[str] = Field(..., alias="bucket_policy")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    storage_class: Optional[str] = Field(..., alias="storage_class")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceElastiCacheV1(NamespaceTerraformResourceAWSV1):
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    parameter_group: Optional[str] = Field(..., alias="parameter_group")
    region: Optional[str] = Field(..., alias="region")
    overrides: Optional[str] = Field(..., alias="overrides")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    managed_by_erv2: Optional[bool] = Field(..., alias="managed_by_erv2")


class ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class NamespaceTerraformResourceServiceAccountAWSInfrastructureAccessV1(ConfiguredBaseModel):
    cluster: Optional[ClusterV1] = Field(..., alias="cluster")
    access_level: Optional[str] = Field(..., alias="access_level")
    assume_role: Optional[str] = Field(..., alias="assume_role")


class NamespaceTerraformResourceServiceAccountV1(NamespaceTerraformResourceAWSV1):
    identifier: str = Field(..., alias="identifier")
    variables: Optional[str] = Field(..., alias="variables")
    policies: Optional[list[str]] = Field(..., alias="policies")
    user_policy: Optional[str] = Field(..., alias="user_policy")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    aws_infrastructure_access: Optional[NamespaceTerraformResourceServiceAccountAWSInfrastructureAccessV1] = Field(..., alias="aws_infrastructure_access")


class NamespaceTerraformResourceSecretsManagerServiceAccountV1(NamespaceTerraformResourceAWSV1):
    identifier: str = Field(..., alias="identifier")
    secrets_prefix: str = Field(..., alias="secrets_prefix")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")


class AssumeRoleV1(ConfiguredBaseModel):
    aws: Optional[list[str]] = Field(..., alias="AWS")
    service: Optional[list[str]] = Field(..., alias="Service")
    federated: Optional[str] = Field(..., alias="Federated")


class NamespaceTerraformResourceLifecycleV1(ConfiguredBaseModel):
    create_before_destroy: Optional[bool] = Field(..., alias="create_before_destroy")
    prevent_destroy: Optional[bool] = Field(..., alias="prevent_destroy")
    ignore_changes: Optional[list[str]] = Field(..., alias="ignore_changes")


class NamespaceTerraformResourceRoleV1(NamespaceTerraformResourceAWSV1):
    identifier: str = Field(..., alias="identifier")
    assume_role: AssumeRoleV1 = Field(..., alias="assume_role")
    assume_condition: Optional[str] = Field(..., alias="assume_condition")
    assume_action: Optional[str] = Field(..., alias="assume_action")
    inline_policy: Optional[str] = Field(..., alias="inline_policy")
    role_policy: Optional[str] = Field(..., alias="role_policy")
    policies: Optional[list[str]] = Field(..., alias="policies")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    lifecycle: Optional[NamespaceTerraformResourceLifecycleV1] = Field(..., alias="lifecycle")
    managed_by_erv2: Optional[bool] = Field(..., alias="managed_by_erv2")
    max_session_duration: Optional[int] = Field(..., alias="max_session_duration")


class KeyValueV1(ConfiguredBaseModel):
    key: str = Field(..., alias="key")
    value: str = Field(..., alias="value")


class SQSQueuesSpecsV1(ConfiguredBaseModel):
    defaults: str = Field(..., alias="defaults")
    queues: list[KeyValueV1] = Field(..., alias="queues")


class NamespaceTerraformResourceSQSV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    specs: list[SQSQueuesSpecsV1] = Field(..., alias="specs")


class NamespaceTerraformResourceSNSSubscriptionV1(ConfiguredBaseModel):
    protocol: str = Field(..., alias="protocol")
    endpoint: str = Field(..., alias="endpoint")


class NamespaceTerraformResourceSNSTopicV1(NamespaceTerraformResourceAWSV1):
    defaults: str = Field(..., alias="defaults")
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    fifo_topic: Optional[bool] = Field(..., alias="fifo_topic")
    inline_policy: Optional[str] = Field(..., alias="inline_policy")
    annotations: Optional[str] = Field(..., alias="annotations")
    subscriptions: Optional[list[NamespaceTerraformResourceSNSSubscriptionV1]] = Field(..., alias="subscriptions")


class DynamoDBTableSpecsV1_KeyValueV1(ConfiguredBaseModel):
    key: str = Field(..., alias="key")
    value: str = Field(..., alias="value")


class DynamoDBTableSpecsV1(ConfiguredBaseModel):
    defaults: str = Field(..., alias="defaults")
    tables: list[DynamoDBTableSpecsV1_KeyValueV1] = Field(..., alias="tables")


class NamespaceTerraformResourceDynamoDBV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    specs: list[DynamoDBTableSpecsV1] = Field(..., alias="specs")


class NamespaceTerraformResourceECRV1(NamespaceTerraformResourceAWSV1):
    identifier: str = Field(..., alias="identifier")
    region: Optional[str] = Field(..., alias="region")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    public: Optional[bool] = Field(..., alias="public")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceS3CloudFrontV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    storage_class: Optional[str] = Field(..., alias="storage_class")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceS3SQSV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    kms_encryption: Optional[bool] = Field(..., alias="kms_encryption")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    storage_class: Optional[str] = Field(..., alias="storage_class")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceCloudWatchV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    es_identifier: Optional[str] = Field(..., alias="es_identifier")
    filter_pattern: Optional[str] = Field(..., alias="filter_pattern")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    managed_by_erv2: Optional[bool] = Field(..., alias="managed_by_erv2")


class NamespaceTerraformResourceKMSV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    overrides: Optional[str] = Field(..., alias="overrides")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    managed_by_erv2: Optional[bool] = Field(..., alias="managed_by_erv2")


class NamespaceTerraformResourceElasticSearchV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    publish_log_types: Optional[list[str]] = Field(..., alias="publish_log_types")


class ACMDomainV1(ConfiguredBaseModel):
    domain_name: str = Field(..., alias="domain_name")
    alternate_names: Optional[list[str]] = Field(..., alias="alternate_names")


class NamespaceTerraformResourceACMV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    secret: Optional[VaultSecret] = Field(..., alias="secret")
    domain: Optional[ACMDomainV1] = Field(..., alias="domain")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceKinesisV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    es_identifier: Optional[str] = Field(..., alias="es_identifier")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceS3CloudFrontPublicKeyV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    secret: Optional[VaultSecret] = Field(..., alias="secret")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceALBMutualAuthenticationV1(ConfiguredBaseModel):
    mode: str = Field(..., alias="mode")
    ca_cert_bundle_s3_bucket_name: Optional[str] = Field(..., alias="ca_cert_bundle_s3_bucket_name")
    ca_cert_bundle_s3_bucket_key: Optional[str] = Field(..., alias="ca_cert_bundle_s3_bucket_key")


class NamespaceTerraformResourceALBTargetHealthcheckV1(ConfiguredBaseModel):
    unhealthy_threshold: Optional[int] = Field(..., alias="unhealthy_threshold")
    timeout: Optional[int] = Field(..., alias="timeout")
    interval: Optional[int] = Field(..., alias="interval")
    healthy_threshold: Optional[int] = Field(..., alias="healthy_threshold")
    path: Optional[str] = Field(..., alias="path")
    port: Optional[int] = Field(..., alias="port")
    protocol: Optional[str] = Field(..., alias="protocol")


class NamespaceTerraformResourceALBTargetsV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    default: bool = Field(..., alias="default")
    ips: Optional[list[str]] = Field(..., alias="ips")
    openshift_service: Optional[str] = Field(..., alias="openshift_service")
    protocol: Optional[str] = Field(..., alias="protocol")
    protocol_version: Optional[str] = Field(..., alias="protocol_version")
    health_check: Optional[NamespaceTerraformResourceALBTargetHealthcheckV1] = Field(..., alias="health_check")


class NamespaceTerraformResourceALBConditionV1(ConfiguredBaseModel):
    q_type: str = Field(..., alias="type")


class NamespaceTerraformResourceALBConditionHostHeaderV1(NamespaceTerraformResourceALBConditionV1):
    host_header: list[str] = Field(..., alias="host_header")


class NamespaceTerraformResourceALBConditionHTTPRequestMethodV1(NamespaceTerraformResourceALBConditionV1):
    http_request_method: list[str] = Field(..., alias="http_request_method")


class NamespaceTerraformResourceALBConditionPathPatternV1(NamespaceTerraformResourceALBConditionV1):
    path_pattern: list[str] = Field(..., alias="path_pattern")


class NamespaceTerraformResourceALBConditionSourceIPV1(NamespaceTerraformResourceALBConditionV1):
    source_ip: list[str] = Field(..., alias="source_ip")


class NamespaceTerraformResourceALBConditionQueryStringKeyValueV1(ConfiguredBaseModel):
    key: Optional[str] = Field(..., alias="key")
    value: str = Field(..., alias="value")


class NamespaceTerraformResourceALBConditionQueryStringV1(NamespaceTerraformResourceALBConditionV1):
    query_string: list[NamespaceTerraformResourceALBConditionQueryStringKeyValueV1] = Field(..., alias="query_string")


class NamespaceTerraformResourceALBActionV1(ConfiguredBaseModel):
    q_type: str = Field(..., alias="type")


class NamespaceTerraformResourceALBTargetGroupV1(ConfiguredBaseModel):
    target: str = Field(..., alias="target")
    weight: int = Field(..., alias="weight")


class NamespaceTerraformResourceALBActionForwardSettingsV1(ConfiguredBaseModel):
    target_group: list[NamespaceTerraformResourceALBTargetGroupV1] = Field(..., alias="target_group")


class NamespaceTerraformResourceALBActionForwardV1(NamespaceTerraformResourceALBActionV1):
    forward: NamespaceTerraformResourceALBActionForwardSettingsV1 = Field(..., alias="forward")


class NamespaceTerraformResourceALBActionFixedResponseSettingsV1(ConfiguredBaseModel):
    content_type: str = Field(..., alias="content_type")
    message_body: str = Field(..., alias="message_body")
    status_code: str = Field(..., alias="status_code")


class NamespaceTerraformResourceALBActionFixedResponseV1(NamespaceTerraformResourceALBActionV1):
    fixed_response: NamespaceTerraformResourceALBActionFixedResponseSettingsV1 = Field(..., alias="fixed_response")


class NamespaceTerraformResourceALBActionRedirectSettingsV1(ConfiguredBaseModel):
    host: Optional[str] = Field(..., alias="host")
    path: Optional[str] = Field(..., alias="path")
    port: Optional[int] = Field(..., alias="port")
    protocol: Optional[str] = Field(..., alias="protocol")
    query: Optional[str] = Field(..., alias="query")
    status_code: Optional[str] = Field(..., alias="status_code")


class NamespaceTerraformResourceALBActionRedirectV1(NamespaceTerraformResourceALBActionV1):
    redirect: NamespaceTerraformResourceALBActionRedirectSettingsV1 = Field(..., alias="redirect")


class NamespaceTerraformResourceALBRulesV1(ConfiguredBaseModel):
    condition: list[Union[NamespaceTerraformResourceALBConditionHostHeaderV1, NamespaceTerraformResourceALBConditionHTTPRequestMethodV1, NamespaceTerraformResourceALBConditionPathPatternV1, NamespaceTerraformResourceALBConditionSourceIPV1, NamespaceTerraformResourceALBConditionQueryStringV1, NamespaceTerraformResourceALBConditionV1]] = Field(..., alias="condition")
    action: Union[NamespaceTerraformResourceALBActionForwardV1, NamespaceTerraformResourceALBActionFixedResponseV1, NamespaceTerraformResourceALBActionRedirectV1, NamespaceTerraformResourceALBActionV1] = Field(..., alias="action")


class NamespaceTerraformResourceALBV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    vpc: AWSVPC = Field(..., alias="vpc")
    certificate_arn: str = Field(..., alias="certificate_arn")
    ingress_cidr_blocks: list[str] = Field(..., alias="ingress_cidr_blocks")
    idle_timeout: Optional[int] = Field(..., alias="idle_timeout")
    enable_http2: Optional[bool] = Field(..., alias="enable_http2")
    ip_address_type: Optional[str] = Field(..., alias="ip_address_type")
    access_logs: Optional[bool] = Field(..., alias="access_logs")
    ssl_policy: Optional[str] = Field(..., alias="ssl_policy")
    mutual_authentication: Optional[NamespaceTerraformResourceALBMutualAuthenticationV1] = Field(..., alias="mutual_authentication")
    targets: list[NamespaceTerraformResourceALBTargetsV1] = Field(..., alias="targets")
    rules: list[NamespaceTerraformResourceALBRulesV1] = Field(..., alias="rules")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")


class NamespaceTerraformResourceSecretsManagerV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    secret: Optional[VaultSecret] = Field(..., alias="secret")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")


class CloudinitConfigV1(ConfiguredBaseModel):
    filename: Optional[str] = Field(..., alias="filename")
    content_type: Optional[str] = Field(..., alias="content_type")
    content: str = Field(..., alias="content")


class ASGImageV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class JenkinsInstanceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    token: VaultSecret = Field(..., alias="token")


class SaasResourceTemplateTargetUpstreamV1(ConfiguredBaseModel):
    instance: JenkinsInstanceV1 = Field(..., alias="instance")
    name: str = Field(..., alias="name")


class ASGImageGitV1(ASGImageV1):
    tag_name: str = Field(..., alias="tag_name")
    url: str = Field(..., alias="url")
    ref: str = Field(..., alias="ref")
    upstream: Optional[SaasResourceTemplateTargetUpstreamV1] = Field(..., alias="upstream")


class ASGImageStaticV1(ASGImageV1):
    tag_name: str = Field(..., alias="tag_name")
    value: str = Field(..., alias="value")


class NamespaceTerraformResourceASGV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    defaults: str = Field(..., alias="defaults")
    cloudinit_configs: Optional[list[CloudinitConfigV1]] = Field(..., alias="cloudinit_configs")
    variables: Optional[str] = Field(..., alias="variables")
    overrides: Optional[str] = Field(..., alias="overrides")
    extra_tags: Optional[str] = Field(..., alias="extra_tags")
    image: list[Union[ASGImageGitV1, ASGImageStaticV1, ASGImageV1]] = Field(..., alias="image")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")


class DnsRecordAliasV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    zone_id: str = Field(..., alias="zone_id")
    evaluate_target_health: bool = Field(..., alias="evaluate_target_health")


class DnsRecordWeightedRoutingPolicyV1(ConfiguredBaseModel):
    weight: Optional[int] = Field(..., alias="weight")


class DnsRecordGeolocationRoutingPolicyV1(ConfiguredBaseModel):
    continent: Optional[str] = Field(..., alias="continent")
    country: Optional[str] = Field(..., alias="country")
    subdivision: Optional[str] = Field(..., alias="subdivision")


class DnsRecordV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    q_type: str = Field(..., alias="type")
    ttl: Optional[int] = Field(..., alias="ttl")
    alias: Optional[DnsRecordAliasV1] = Field(..., alias="alias")
    weighted_routing_policy: Optional[DnsRecordWeightedRoutingPolicyV1] = Field(..., alias="weighted_routing_policy")
    geolocation_routing_policy: Optional[DnsRecordGeolocationRoutingPolicyV1] = Field(..., alias="geolocation_routing_policy")
    set_identifier: Optional[str] = Field(..., alias="set_identifier")
    records: Optional[list[str]] = Field(..., alias="records")


class NamespaceTerraformResourceRoute53ZoneV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    name: str = Field(..., alias="name")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    records: Optional[list[DnsRecordV1]] = Field(..., alias="records")


class NamespaceTerraformResourceRosaAuthenticatorV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    api_proxy_uri: str = Field(..., alias="api_proxy_uri")
    cognito_callback_bucket_name: str = Field(..., alias="cognito_callback_bucket_name")
    certificate_arn: str = Field(..., alias="certificate_arn")
    domain_name: str = Field(..., alias="domain_name")
    network_interface_ids: Optional[list[str]] = Field(..., alias="network_interface_ids")
    openshift_ingress_load_balancer_arn: Optional[str] = Field(..., alias="openshift_ingress_load_balancer_arn")
    insights_callback_urls: Optional[list[str]] = Field(..., alias="insights_callback_urls")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    vpc_id: str = Field(..., alias="vpc_id")
    subnet_ids: list[str] = Field(..., alias="subnet_ids")
    vpce_id: Optional[str] = Field(..., alias="vpce_id")
    defaults: str = Field(..., alias="defaults")


class NamespaceTerraformResourceRosaAuthenticatorVPCEV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    subnet_ids: list[str] = Field(..., alias="subnet_ids")
    vpc_id: str = Field(..., alias="vpc_id")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    annotations: Optional[str] = Field(..., alias="annotations")
    defaults: str = Field(..., alias="defaults")


class MskSecretParametersV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    secret: VaultSecret = Field(..., alias="secret")


class NamespaceTerraformResourceMskV1(NamespaceTerraformResourceAWSV1):
    region: Optional[str] = Field(..., alias="region")
    identifier: str = Field(..., alias="identifier")
    output_resource_name: Optional[str] = Field(..., alias="output_resource_name")
    defaults: str = Field(..., alias="defaults")
    annotations: Optional[str] = Field(..., alias="annotations")
    users: Optional[list[MskSecretParametersV1]] = Field(..., alias="users")
    managed_by_erv2: Optional[bool] = Field(..., alias="managed_by_erv2")


class NamespaceTerraformProviderResourceAWSV1(NamespaceExternalResourceV1):
    resources: list[Union[NamespaceTerraformResourceRDSV1, NamespaceTerraformResourceALBV1, NamespaceTerraformResourceRosaAuthenticatorV1, NamespaceTerraformResourceRoleV1, NamespaceTerraformResourceS3V1, NamespaceTerraformResourceASGV1, NamespaceTerraformResourceElastiCacheV1, NamespaceTerraformResourceSNSTopicV1, NamespaceTerraformResourceCloudWatchV1, NamespaceTerraformResourceServiceAccountV1, NamespaceTerraformResourceS3SQSV1, NamespaceTerraformResourceKMSV1, NamespaceTerraformResourceRosaAuthenticatorVPCEV1, NamespaceTerraformResourceMskV1, NamespaceTerraformResourceS3CloudFrontV1, NamespaceTerraformResourceElasticSearchV1, NamespaceTerraformResourceACMV1, NamespaceTerraformResourceKinesisV1, NamespaceTerraformResourceRoute53ZoneV1, NamespaceTerraformResourceSQSV1, NamespaceTerraformResourceDynamoDBV1, NamespaceTerraformResourceECRV1, NamespaceTerraformResourceS3CloudFrontPublicKeyV1, NamespaceTerraformResourceSecretsManagerV1, NamespaceTerraformResourceSecretsManagerServiceAccountV1, NamespaceTerraformResourceAWSV1]] = Field(..., alias="resources")


class EnvironmentV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class AppV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class ClusterSpecV1(ConfiguredBaseModel):
    region: str = Field(..., alias="region")


class DisableClusterAutomationsV1(ConfiguredBaseModel):
    integrations: Optional[list[str]] = Field(..., alias="integrations")


class NamespaceV1_ClusterV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    server_url: str = Field(..., alias="serverUrl")
    insecure_skip_tls_verify: Optional[bool] = Field(..., alias="insecureSkipTLSVerify")
    jump_host: Optional[CommonJumphostFields] = Field(..., alias="jumpHost")
    automation_token: Optional[VaultSecret] = Field(..., alias="automationToken")
    cluster_admin_automation_token: Optional[VaultSecret] = Field(..., alias="clusterAdminAutomationToken")
    spec: Optional[ClusterSpecV1] = Field(..., alias="spec")
    internal: Optional[bool] = Field(..., alias="internal")
    disable: Optional[DisableClusterAutomationsV1] = Field(..., alias="disable")


class NamespaceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    delete: Optional[bool] = Field(..., alias="delete")
    cluster_admin: Optional[bool] = Field(..., alias="clusterAdmin")
    managed_external_resources: Optional[bool] = Field(..., alias="managedExternalResources")
    external_resources: Optional[list[Union[NamespaceTerraformProviderResourceAWSV1, NamespaceExternalResourceV1]]] = Field(..., alias="externalResources")
    environment: EnvironmentV1 = Field(..., alias="environment")
    app: AppV1 = Field(..., alias="app")
    cluster: NamespaceV1_ClusterV1 = Field(..., alias="cluster")


class TerraformResourcesNamespacesQueryData(ConfiguredBaseModel):
    namespaces: Optional[list[NamespaceV1]] = Field(..., alias="namespaces")


def query(query_func: Callable, **kwargs: Any) -> TerraformResourcesNamespacesQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        TerraformResourcesNamespacesQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return TerraformResourcesNamespacesQueryData(**raw_data)
