# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ComputeClusterVmHostRuleArgs', 'ComputeClusterVmHostRule']

@pulumi.input_type
class ComputeClusterVmHostRuleArgs:
    def __init__(__self__, *,
                 compute_cluster_id: pulumi.Input[_builtins.str],
                 vm_group_name: pulumi.Input[_builtins.str],
                 affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 anti_affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ComputeClusterVmHostRule resource.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[_builtins.str] vm_group_name: The name of the virtual machine group to use
               with this rule.
        :param pulumi.Input[_builtins.str] affinity_host_group_name: When this field is used, the virtual
               machines defined in `vm_group_name` will be run on the
               hosts defined in this host group.
        :param pulumi.Input[_builtins.str] anti_affinity_host_group_name: When this field is used, the
               virtual machines defined in `vm_group_name` will _not_ be
               run on the hosts defined in this host group.
        :param pulumi.Input[_builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[_builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** One of `affinity_host_group_name` or
               `anti_affinity_host_group_name` must be
               defined, but not both.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique in the
               cluster.
        """
        pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        pulumi.set(__self__, "vm_group_name", vm_group_name)
        if affinity_host_group_name is not None:
            pulumi.set(__self__, "affinity_host_group_name", affinity_host_group_name)
        if anti_affinity_host_group_name is not None:
            pulumi.set(__self__, "anti_affinity_host_group_name", anti_affinity_host_group_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compute_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="vmGroupName")
    def vm_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the virtual machine group to use
        with this rule.
        """
        return pulumi.get(self, "vm_group_name")

    @vm_group_name.setter
    def vm_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_group_name", value)

    @_builtins.property
    @pulumi.getter(name="affinityHostGroupName")
    def affinity_host_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this field is used, the virtual
        machines defined in `vm_group_name` will be run on the
        hosts defined in this host group.
        """
        return pulumi.get(self, "affinity_host_group_name")

    @affinity_host_group_name.setter
    def affinity_host_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "affinity_host_group_name", value)

    @_builtins.property
    @pulumi.getter(name="antiAffinityHostGroupName")
    def anti_affinity_host_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this field is used, the
        virtual machines defined in `vm_group_name` will _not_ be
        run on the hosts defined in this host group.
        """
        return pulumi.get(self, "anti_affinity_host_group_name")

    @anti_affinity_host_group_name.setter
    def anti_affinity_host_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "anti_affinity_host_group_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.

        > **NOTE:** One of `affinity_host_group_name` or
        `anti_affinity_host_group_name` must be
        defined, but not both.

        > **NOTE:** The namespace for rule names on this resource (defined by the
        `name` argument) is shared with all rules in the cluster - consider
        this when naming your rules.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mandatory", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule. This must be unique in the
        cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ComputeClusterVmHostRuleState:
    def __init__(__self__, *,
                 affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 anti_affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeClusterVmHostRule resources.
        :param pulumi.Input[_builtins.str] affinity_host_group_name: When this field is used, the virtual
               machines defined in `vm_group_name` will be run on the
               hosts defined in this host group.
        :param pulumi.Input[_builtins.str] anti_affinity_host_group_name: When this field is used, the
               virtual machines defined in `vm_group_name` will _not_ be
               run on the hosts defined in this host group.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[_builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[_builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** One of `affinity_host_group_name` or
               `anti_affinity_host_group_name` must be
               defined, but not both.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique in the
               cluster.
        :param pulumi.Input[_builtins.str] vm_group_name: The name of the virtual machine group to use
               with this rule.
        """
        if affinity_host_group_name is not None:
            pulumi.set(__self__, "affinity_host_group_name", affinity_host_group_name)
        if anti_affinity_host_group_name is not None:
            pulumi.set(__self__, "anti_affinity_host_group_name", anti_affinity_host_group_name)
        if compute_cluster_id is not None:
            pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vm_group_name is not None:
            pulumi.set(__self__, "vm_group_name", vm_group_name)

    @_builtins.property
    @pulumi.getter(name="affinityHostGroupName")
    def affinity_host_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this field is used, the virtual
        machines defined in `vm_group_name` will be run on the
        hosts defined in this host group.
        """
        return pulumi.get(self, "affinity_host_group_name")

    @affinity_host_group_name.setter
    def affinity_host_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "affinity_host_group_name", value)

    @_builtins.property
    @pulumi.getter(name="antiAffinityHostGroupName")
    def anti_affinity_host_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        When this field is used, the
        virtual machines defined in `vm_group_name` will _not_ be
        run on the hosts defined in this host group.
        """
        return pulumi.get(self, "anti_affinity_host_group_name")

    @anti_affinity_host_group_name.setter
    def anti_affinity_host_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "anti_affinity_host_group_name", value)

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compute_cluster_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.

        > **NOTE:** One of `affinity_host_group_name` or
        `anti_affinity_host_group_name` must be
        defined, but not both.

        > **NOTE:** The namespace for rule names on this resource (defined by the
        `name` argument) is shared with all rules in the cluster - consider
        this when naming your rules.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mandatory", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule. This must be unique in the
        cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="vmGroupName")
    def vm_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the virtual machine group to use
        with this rule.
        """
        return pulumi.get(self, "vm_group_name")

    @vm_group_name.setter
    def vm_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_group_name", value)


@pulumi.type_token("vsphere:index/computeClusterVmHostRule:ComputeClusterVmHostRule")
class ComputeClusterVmHostRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 anti_affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The `ComputeClusterVmHostRule` resource can be used to manage
        VM-to-host rules in a cluster, either created by the
        `ComputeCluster` resource or looked up
        by the `ComputeCluster` data source.

        This resource can create both _affinity rules_, where virtual machines run on
        specified hosts, or _anti-affinity_ rules, where virtual machines run on hosts
        outside of the ones specified in the rule. Virtual machines and hosts are
        supplied via groups, which can be managed via the
        `ComputeClusterVmGroup` and
        `ComputeClusterHostGroup`
        resources.

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        ## Example Usage

        The example below creates a virtual machine in a cluster using the
        `VirtualMachine` resource in a cluster
        looked up by the `ComputeCluster`
        data source. It then creates a group with this virtual machine. It also creates
        a host group off of the host looked up via the
        `Host` data source. Finally, this
        virtual machine is configured to run specifically on that host via a
        `ComputeClusterVmHostRule` resource.

        > Note how `vm_group_name` and
        `affinity_host_group_name` are sourced off of the
        `name` attributes from the
        `ComputeClusterVmGroup` and
        `ComputeClusterHostGroup`
        resources. This is to ensure that the rule is not created before the groups
        exist, which may not possibly happen in the event that the names came from a
        "static" source such as a variable.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore = vsphere.get_datastore(name="datastore1",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="network1",
            datacenter_id=datacenter.id)
        vm = vsphere.VirtualMachine("vm",
            name="test",
            resource_pool_id=cluster.resource_pool_id,
            datastore_id=datastore.id,
            num_cpus=2,
            memory=2048,
            guest_id="otherLinux64Guest",
            network_interfaces=[{
                "network_id": network.id,
            }],
            disks=[{
                "label": "disk0",
                "size": 20,
            }])
        cluster_vm_group = vsphere.ComputeClusterVmGroup("cluster_vm_group",
            name="test-cluster-vm-group",
            compute_cluster_id=cluster.id,
            virtual_machine_ids=[vm.id])
        cluster_host_group = vsphere.ComputeClusterHostGroup("cluster_host_group",
            name="test-cluster-vm-group",
            compute_cluster_id=cluster.id,
            host_system_ids=[host.id])
        cluster_vm_host_rule = vsphere.ComputeClusterVmHostRule("cluster_vm_host_rule",
            compute_cluster_id=cluster.id,
            name="test-cluster-vm-host-rule",
            vm_group_name=cluster_vm_group.name,
            affinity_host_group_name=cluster_host_group.name)
        ```

        ## Import

        An existing rule can be imported into this resource by supplying

        both the path to the cluster, and the name the rule. If the name or cluster is

        not found, or if the rule is of a different type, an error will be returned. An

        example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/computeClusterVmHostRule:ComputeClusterVmHostRule cluster_vm_host_rule \\
        ```

          '{"compute_cluster_path": "/dc1/host/cluster1", \\

          "name": "pulumi-test-cluster-vm-host-rule"}'

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] affinity_host_group_name: When this field is used, the virtual
               machines defined in `vm_group_name` will be run on the
               hosts defined in this host group.
        :param pulumi.Input[_builtins.str] anti_affinity_host_group_name: When this field is used, the
               virtual machines defined in `vm_group_name` will _not_ be
               run on the hosts defined in this host group.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[_builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[_builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** One of `affinity_host_group_name` or
               `anti_affinity_host_group_name` must be
               defined, but not both.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique in the
               cluster.
        :param pulumi.Input[_builtins.str] vm_group_name: The name of the virtual machine group to use
               with this rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeClusterVmHostRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ComputeClusterVmHostRule` resource can be used to manage
        VM-to-host rules in a cluster, either created by the
        `ComputeCluster` resource or looked up
        by the `ComputeCluster` data source.

        This resource can create both _affinity rules_, where virtual machines run on
        specified hosts, or _anti-affinity_ rules, where virtual machines run on hosts
        outside of the ones specified in the rule. Virtual machines and hosts are
        supplied via groups, which can be managed via the
        `ComputeClusterVmGroup` and
        `ComputeClusterHostGroup`
        resources.

        > **NOTE:** This resource requires vCenter and is not available on direct ESXi
        connections.

        ## Example Usage

        The example below creates a virtual machine in a cluster using the
        `VirtualMachine` resource in a cluster
        looked up by the `ComputeCluster`
        data source. It then creates a group with this virtual machine. It also creates
        a host group off of the host looked up via the
        `Host` data source. Finally, this
        virtual machine is configured to run specifically on that host via a
        `ComputeClusterVmHostRule` resource.

        > Note how `vm_group_name` and
        `affinity_host_group_name` are sourced off of the
        `name` attributes from the
        `ComputeClusterVmGroup` and
        `ComputeClusterHostGroup`
        resources. This is to ensure that the rule is not created before the groups
        exist, which may not possibly happen in the event that the names came from a
        "static" source such as a variable.

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        datacenter = vsphere.get_datacenter(name="dc-01")
        datastore = vsphere.get_datastore(name="datastore1",
            datacenter_id=datacenter.id)
        cluster = vsphere.get_compute_cluster(name="cluster-01",
            datacenter_id=datacenter.id)
        host = vsphere.get_host(name="esxi-01.example.com",
            datacenter_id=datacenter.id)
        network = vsphere.get_network(name="network1",
            datacenter_id=datacenter.id)
        vm = vsphere.VirtualMachine("vm",
            name="test",
            resource_pool_id=cluster.resource_pool_id,
            datastore_id=datastore.id,
            num_cpus=2,
            memory=2048,
            guest_id="otherLinux64Guest",
            network_interfaces=[{
                "network_id": network.id,
            }],
            disks=[{
                "label": "disk0",
                "size": 20,
            }])
        cluster_vm_group = vsphere.ComputeClusterVmGroup("cluster_vm_group",
            name="test-cluster-vm-group",
            compute_cluster_id=cluster.id,
            virtual_machine_ids=[vm.id])
        cluster_host_group = vsphere.ComputeClusterHostGroup("cluster_host_group",
            name="test-cluster-vm-group",
            compute_cluster_id=cluster.id,
            host_system_ids=[host.id])
        cluster_vm_host_rule = vsphere.ComputeClusterVmHostRule("cluster_vm_host_rule",
            compute_cluster_id=cluster.id,
            name="test-cluster-vm-host-rule",
            vm_group_name=cluster_vm_group.name,
            affinity_host_group_name=cluster_host_group.name)
        ```

        ## Import

        An existing rule can be imported into this resource by supplying

        both the path to the cluster, and the name the rule. If the name or cluster is

        not found, or if the rule is of a different type, an error will be returned. An

        example is below:

        [docs-import]: https://developer.hashicorp.com/terraform/cli/import

        ```sh
        $ pulumi import vsphere:index/computeClusterVmHostRule:ComputeClusterVmHostRule cluster_vm_host_rule \\
        ```

          '{"compute_cluster_path": "/dc1/host/cluster1", \\

          "name": "pulumi-test-cluster-vm-host-rule"}'

        :param str resource_name: The name of the resource.
        :param ComputeClusterVmHostRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeClusterVmHostRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 anti_affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mandatory: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeClusterVmHostRuleArgs.__new__(ComputeClusterVmHostRuleArgs)

            __props__.__dict__["affinity_host_group_name"] = affinity_host_group_name
            __props__.__dict__["anti_affinity_host_group_name"] = anti_affinity_host_group_name
            if compute_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'compute_cluster_id'")
            __props__.__dict__["compute_cluster_id"] = compute_cluster_id
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["mandatory"] = mandatory
            __props__.__dict__["name"] = name
            if vm_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'vm_group_name'")
            __props__.__dict__["vm_group_name"] = vm_group_name
        super(ComputeClusterVmHostRule, __self__).__init__(
            'vsphere:index/computeClusterVmHostRule:ComputeClusterVmHostRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            anti_affinity_host_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            compute_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            mandatory: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            vm_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeClusterVmHostRule':
        """
        Get an existing ComputeClusterVmHostRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] affinity_host_group_name: When this field is used, the virtual
               machines defined in `vm_group_name` will be run on the
               hosts defined in this host group.
        :param pulumi.Input[_builtins.str] anti_affinity_host_group_name: When this field is used, the
               virtual machines defined in `vm_group_name` will _not_ be
               run on the hosts defined in this host group.
        :param pulumi.Input[_builtins.str] compute_cluster_id: The managed object reference
               ID of the cluster to put the group in.  Forces a new
               resource if changed.
        :param pulumi.Input[_builtins.bool] enabled: Enable this rule in the cluster. Default: `true`.
        :param pulumi.Input[_builtins.bool] mandatory: When this value is `true`, prevents any virtual
               machine operations that may violate this rule. Default: `false`.
               
               > **NOTE:** One of `affinity_host_group_name` or
               `anti_affinity_host_group_name` must be
               defined, but not both.
               
               > **NOTE:** The namespace for rule names on this resource (defined by the
               `name` argument) is shared with all rules in the cluster - consider
               this when naming your rules.
        :param pulumi.Input[_builtins.str] name: The name of the rule. This must be unique in the
               cluster.
        :param pulumi.Input[_builtins.str] vm_group_name: The name of the virtual machine group to use
               with this rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeClusterVmHostRuleState.__new__(_ComputeClusterVmHostRuleState)

        __props__.__dict__["affinity_host_group_name"] = affinity_host_group_name
        __props__.__dict__["anti_affinity_host_group_name"] = anti_affinity_host_group_name
        __props__.__dict__["compute_cluster_id"] = compute_cluster_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["mandatory"] = mandatory
        __props__.__dict__["name"] = name
        __props__.__dict__["vm_group_name"] = vm_group_name
        return ComputeClusterVmHostRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="affinityHostGroupName")
    def affinity_host_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When this field is used, the virtual
        machines defined in `vm_group_name` will be run on the
        hosts defined in this host group.
        """
        return pulumi.get(self, "affinity_host_group_name")

    @_builtins.property
    @pulumi.getter(name="antiAffinityHostGroupName")
    def anti_affinity_host_group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        When this field is used, the
        virtual machines defined in `vm_group_name` will _not_ be
        run on the hosts defined in this host group.
        """
        return pulumi.get(self, "anti_affinity_host_group_name")

    @_builtins.property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The managed object reference
        ID of the cluster to put the group in.  Forces a new
        resource if changed.
        """
        return pulumi.get(self, "compute_cluster_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable this rule in the cluster. Default: `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def mandatory(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When this value is `true`, prevents any virtual
        machine operations that may violate this rule. Default: `false`.

        > **NOTE:** One of `affinity_host_group_name` or
        `anti_affinity_host_group_name` must be
        defined, but not both.

        > **NOTE:** The namespace for rule names on this resource (defined by the
        `name` argument) is shared with all rules in the cluster - consider
        this when naming your rules.
        """
        return pulumi.get(self, "mandatory")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule. This must be unique in the
        cluster.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="vmGroupName")
    def vm_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the virtual machine group to use
        with this rule.
        """
        return pulumi.get(self, "vm_group_name")

