# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetConfigurationProfileResult',
    'AwaitableGetConfigurationProfileResult',
    'get_configuration_profile',
    'get_configuration_profile_output',
]

@pulumi.output_type
class GetConfigurationProfileResult:
    """
    A collection of values returned by getConfigurationProfile.
    """
    def __init__(__self__, cluster_id=None, configuration=None, id=None, schema=None):
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if configuration and not isinstance(configuration, str):
            raise TypeError("Expected argument 'configuration' to be a str")
        pulumi.set(__self__, "configuration", configuration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> _builtins.str:
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter
    def configuration(self) -> _builtins.str:
        """
        The current configuration which is active on the cluster.
        """
        return pulumi.get(self, "configuration")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> _builtins.str:
        """
        The JSON schema for the profile.
        """
        return pulumi.get(self, "schema")


class AwaitableGetConfigurationProfileResult(GetConfigurationProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationProfileResult(
            cluster_id=self.cluster_id,
            configuration=self.configuration,
            id=self.id,
            schema=self.schema)


def get_configuration_profile(cluster_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationProfileResult:
    """
    The `ConfigurationProfile` data source can be used to export the configuration and schema
    of a cluster that is already managed via configuration profiles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    compute_cluster = vsphere.get_compute_cluster(name="cluster-01",
        datacenter_id=datacenter.id)
    profile = vsphere.get_configuration_profile(cluster_id=compute_cluster.id)
    ```


    :param _builtins.str cluster_id: The identifier of the compute cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vsphere:index/getConfigurationProfile:getConfigurationProfile', __args__, opts=opts, typ=GetConfigurationProfileResult).value

    return AwaitableGetConfigurationProfileResult(
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        configuration=pulumi.get(__ret__, 'configuration'),
        id=pulumi.get(__ret__, 'id'),
        schema=pulumi.get(__ret__, 'schema'))
def get_configuration_profile_output(cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationProfileResult]:
    """
    The `ConfigurationProfile` data source can be used to export the configuration and schema
    of a cluster that is already managed via configuration profiles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_vsphere as vsphere

    datacenter = vsphere.get_datacenter(name="dc-01")
    compute_cluster = vsphere.get_compute_cluster(name="cluster-01",
        datacenter_id=datacenter.id)
    profile = vsphere.get_configuration_profile(cluster_id=compute_cluster.id)
    ```


    :param _builtins.str cluster_id: The identifier of the compute cluster.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('vsphere:index/getConfigurationProfile:getConfigurationProfile', __args__, opts=opts, typ=GetConfigurationProfileResult)
    return __ret__.apply(lambda __response__: GetConfigurationProfileResult(
        cluster_id=pulumi.get(__response__, 'cluster_id'),
        configuration=pulumi.get(__response__, 'configuration'),
        id=pulumi.get(__response__, 'id'),
        schema=pulumi.get(__response__, 'schema')))
