# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['VirtualMachineClassArgs', 'VirtualMachineClass']

@pulumi.input_type
class VirtualMachineClassArgs:
    def __init__(__self__, *,
                 cpus: pulumi.Input[_builtins.int],
                 memory: pulumi.Input[_builtins.int],
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vgpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a VirtualMachineClass resource.
        :param pulumi.Input[_builtins.int] cpus: The number of CPUs.
        :param pulumi.Input[_builtins.int] memory: The amount of memory in MB.
        :param pulumi.Input[_builtins.int] cpu_reservation: The percentage of the available CPU capacity which will be reserved.
        :param pulumi.Input[_builtins.int] memory_reservation: The percentage of memory reservation.
        :param pulumi.Input[_builtins.str] name: The name for the class.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vgpu_devices: The identifiers of the vGPU devices for the class. If this is set memory reservation needs to be 100.
        """
        pulumi.set(__self__, "cpus", cpus)
        pulumi.set(__self__, "memory", memory)
        if cpu_reservation is not None:
            pulumi.set(__self__, "cpu_reservation", cpu_reservation)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vgpu_devices is not None:
            pulumi.set(__self__, "vgpu_devices", vgpu_devices)

    @_builtins.property
    @pulumi.getter
    def cpus(self) -> pulumi.Input[_builtins.int]:
        """
        The number of CPUs.
        """
        return pulumi.get(self, "cpus")

    @cpus.setter
    def cpus(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cpus", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Input[_builtins.int]:
        """
        The amount of memory in MB.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of the available CPU capacity which will be reserved.
        """
        return pulumi.get(self, "cpu_reservation")

    @cpu_reservation.setter
    def cpu_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_reservation", value)

    @_builtins.property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of memory reservation.
        """
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_reservation", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the class.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="vgpuDevices")
    def vgpu_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The identifiers of the vGPU devices for the class. If this is set memory reservation needs to be 100.
        """
        return pulumi.get(self, "vgpu_devices")

    @vgpu_devices.setter
    def vgpu_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vgpu_devices", value)


@pulumi.input_type
class _VirtualMachineClassState:
    def __init__(__self__, *,
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 cpus: Optional[pulumi.Input[_builtins.int]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vgpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering VirtualMachineClass resources.
        :param pulumi.Input[_builtins.int] cpu_reservation: The percentage of the available CPU capacity which will be reserved.
        :param pulumi.Input[_builtins.int] cpus: The number of CPUs.
        :param pulumi.Input[_builtins.int] memory: The amount of memory in MB.
        :param pulumi.Input[_builtins.int] memory_reservation: The percentage of memory reservation.
        :param pulumi.Input[_builtins.str] name: The name for the class.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vgpu_devices: The identifiers of the vGPU devices for the class. If this is set memory reservation needs to be 100.
        """
        if cpu_reservation is not None:
            pulumi.set(__self__, "cpu_reservation", cpu_reservation)
        if cpus is not None:
            pulumi.set(__self__, "cpus", cpus)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if memory_reservation is not None:
            pulumi.set(__self__, "memory_reservation", memory_reservation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if vgpu_devices is not None:
            pulumi.set(__self__, "vgpu_devices", vgpu_devices)

    @_builtins.property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of the available CPU capacity which will be reserved.
        """
        return pulumi.get(self, "cpu_reservation")

    @cpu_reservation.setter
    def cpu_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpu_reservation", value)

    @_builtins.property
    @pulumi.getter
    def cpus(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CPUs.
        """
        return pulumi.get(self, "cpus")

    @cpus.setter
    def cpus(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cpus", value)

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The amount of memory in MB.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory", value)

    @_builtins.property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of memory reservation.
        """
        return pulumi.get(self, "memory_reservation")

    @memory_reservation.setter
    def memory_reservation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "memory_reservation", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the class.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="vgpuDevices")
    def vgpu_devices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The identifiers of the vGPU devices for the class. If this is set memory reservation needs to be 100.
        """
        return pulumi.get(self, "vgpu_devices")

    @vgpu_devices.setter
    def vgpu_devices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "vgpu_devices", value)


@pulumi.type_token("vsphere:index/virtualMachineClass:VirtualMachineClass")
class VirtualMachineClass(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 cpus: Optional[pulumi.Input[_builtins.int]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vgpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a resource for configuring a Virtual Machine class.

        ## Example Usage

        ### S

        ### Create a Basic Class

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        basic_class = vsphere.VirtualMachineClass("basic_class",
            name="basic-class",
            cpus=4,
            memory=4096)
        ```

        ### Create a Class with a vGPU

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        vgp_class = vsphere.VirtualMachineClass("vgp_class",
            name="vgpu-class",
            cpus=4,
            memory=4096,
            memory_reservation=100,
            vgpu_devices=["vgpu1"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cpu_reservation: The percentage of the available CPU capacity which will be reserved.
        :param pulumi.Input[_builtins.int] cpus: The number of CPUs.
        :param pulumi.Input[_builtins.int] memory: The amount of memory in MB.
        :param pulumi.Input[_builtins.int] memory_reservation: The percentage of memory reservation.
        :param pulumi.Input[_builtins.str] name: The name for the class.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vgpu_devices: The identifiers of the vGPU devices for the class. If this is set memory reservation needs to be 100.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualMachineClassArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for configuring a Virtual Machine class.

        ## Example Usage

        ### S

        ### Create a Basic Class

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        basic_class = vsphere.VirtualMachineClass("basic_class",
            name="basic-class",
            cpus=4,
            memory=4096)
        ```

        ### Create a Class with a vGPU

        ```python
        import pulumi
        import pulumi_vsphere as vsphere

        vgp_class = vsphere.VirtualMachineClass("vgp_class",
            name="vgpu-class",
            cpus=4,
            memory=4096,
            memory_reservation=100,
            vgpu_devices=["vgpu1"])
        ```

        :param str resource_name: The name of the resource.
        :param VirtualMachineClassArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualMachineClassArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 cpus: Optional[pulumi.Input[_builtins.int]] = None,
                 memory: Optional[pulumi.Input[_builtins.int]] = None,
                 memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 vgpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualMachineClassArgs.__new__(VirtualMachineClassArgs)

            __props__.__dict__["cpu_reservation"] = cpu_reservation
            if cpus is None and not opts.urn:
                raise TypeError("Missing required property 'cpus'")
            __props__.__dict__["cpus"] = cpus
            if memory is None and not opts.urn:
                raise TypeError("Missing required property 'memory'")
            __props__.__dict__["memory"] = memory
            __props__.__dict__["memory_reservation"] = memory_reservation
            __props__.__dict__["name"] = name
            __props__.__dict__["vgpu_devices"] = vgpu_devices
        super(VirtualMachineClass, __self__).__init__(
            'vsphere:index/virtualMachineClass:VirtualMachineClass',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cpu_reservation: Optional[pulumi.Input[_builtins.int]] = None,
            cpus: Optional[pulumi.Input[_builtins.int]] = None,
            memory: Optional[pulumi.Input[_builtins.int]] = None,
            memory_reservation: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            vgpu_devices: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'VirtualMachineClass':
        """
        Get an existing VirtualMachineClass resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cpu_reservation: The percentage of the available CPU capacity which will be reserved.
        :param pulumi.Input[_builtins.int] cpus: The number of CPUs.
        :param pulumi.Input[_builtins.int] memory: The amount of memory in MB.
        :param pulumi.Input[_builtins.int] memory_reservation: The percentage of memory reservation.
        :param pulumi.Input[_builtins.str] name: The name for the class.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] vgpu_devices: The identifiers of the vGPU devices for the class. If this is set memory reservation needs to be 100.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualMachineClassState.__new__(_VirtualMachineClassState)

        __props__.__dict__["cpu_reservation"] = cpu_reservation
        __props__.__dict__["cpus"] = cpus
        __props__.__dict__["memory"] = memory
        __props__.__dict__["memory_reservation"] = memory_reservation
        __props__.__dict__["name"] = name
        __props__.__dict__["vgpu_devices"] = vgpu_devices
        return VirtualMachineClass(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cpuReservation")
    def cpu_reservation(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The percentage of the available CPU capacity which will be reserved.
        """
        return pulumi.get(self, "cpu_reservation")

    @_builtins.property
    @pulumi.getter
    def cpus(self) -> pulumi.Output[_builtins.int]:
        """
        The number of CPUs.
        """
        return pulumi.get(self, "cpus")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> pulumi.Output[_builtins.int]:
        """
        The amount of memory in MB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter(name="memoryReservation")
    def memory_reservation(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The percentage of memory reservation.
        """
        return pulumi.get(self, "memory_reservation")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name for the class.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="vgpuDevices")
    def vgpu_devices(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The identifiers of the vGPU devices for the class. If this is set memory reservation needs to be 100.
        """
        return pulumi.get(self, "vgpu_devices")

