from typing import Literal, TypeAlias, Union

PACKAGES_NAMES_DEV = Literal[
    "ngrok",
    "Visual Studio Code",
    "aider",
    "github-copilot-cli",
    "gemini",
    "crush",
    "opencode-ai",
    "warp",
    "q",
    "cursor-cli",
    "droid",
    "Alacritty",
    "Brave",
    "bypass-paywalls-chrome",
    "Cursor",
    "espanso",
    "Gorilla",
    "lvim",
    "nerdfont",
    "Redis",
    "Wezterm",
    "winget",
    "ytui-music",
    "youtube-tui",
    "termusic",
    "kronos",
    "transmission",
    "nnn",
    "exa",
    "bytehound",
    "atuin",
    "browsh",
    "carbonyl",
    "patat",
    "SqliteBrowser",
    "DBeaver",
    "rainfrog",
    "duckdb",
    "cpz",
    "rmz",
    "mermaid-cli",
    "html2markdown",
    "xcrawl3r",
    "obsidian",
    "marp",
    "presenterm",
    "pandoc",
    "devcontainer",
    "bitwarden",
    "OBS Background removal",
    "rustdesk",
    "evcxr",
    "forward-cli",
    "bandwhich",
    "ipinfo",
    "dust",
    "ots",
    "ffsend",
    "portal",
    "qrcp",
    "qrscan",
    "termscp",
    "qr",
    "filebrowser",
    "cloudreve",
    "restic",
    "syncthing",
    "istio",
    "openpomodoro-cli",
    "rust-analyzer",
    "kondo",
    "tokei",
    "lazygit",
    "lazydocker",
    "onefetch",
    "gitcs",
    "just",
    "navi",
    "tealdeer",
    "sniffnet",
    "hyperfine",
    "ollama",
    "cointop",
    "vtm",
    "edex-ui",
    "extraterm",
    "nushell",
    "geckodriver",
    "lolcatjs",
    "figlet-cli",
    "sharewifi",
    "share-wifi",
]

PACKAGES_NAMES_ESSENTIAL = Literal[
    "gh",
    "hx",
    "speedtest",
    "pistol",
    "diskonaut",
    "xplr",
    "btop",
    "gotty",
    "joshuto",
    "zellij",
    "boxes",
    "ugrep",
    "zoomit",
    "ntop",
    "devtunnel",
    "bat",
    "broot",
    "btm",
    "chatgpt",
    "cloudflared",
    "cpufetch",
    "delta",
    "dua",
    "fastfetch",
    "fd",
    "fzf",
    "gitui",
    "glow",
    "gum",
    "lf",
    "lsd",
    "m365",
    "mcfly",
    "mods",
    "mprocs",
    "ouch",
    "procs",
    "rclone",
    "rg",
    "rga",
    "starship",
    "tere",
    "topgrade",
    "ttyd",
    "viu",
    "watchexec",
    "yazi",
    "zoxide",
]

PACKAGE_GROUPS: TypeAlias = Literal["ESSENTIAL", "DEV", "ESSENTIAL_SYSTEM", "DEV_SYSTEM"]
PACKAGE_GROUP2NAMES: dict[PACKAGE_GROUPS, list[str]] = {
    "ESSENTIAL": list(PACKAGES_NAMES_ESSENTIAL.__args__),
    "DEV": list(PACKAGES_NAMES_DEV.__args__),
    "ESSENTIAL_SYSTEM": [],
    "DEV_SYSTEM": [],
}

_ = Union
