# sage_setup: distribution = sagemath-schemes
r"""
Design notes

The implementation depends on the fact that we have dimension formulas
(see ``dims.py``) for spaces of modular forms with character, and new
subspaces, so that we don't have to compute `q`-expansions for the whole
space in order to compute `q`-expansions / elements / and dimensions of
certain subspaces.  Also, the following design is much simpler than
the one I used in MAGMA because submodules don't have lots of
complicated special labels.  A modular forms module can consist of the
span of any elements; they need not be Hecke equivariant or anything
else.

The internal basis of `q`-expansions of modular forms for the ambient
space is defined as follows::

  First Block:   Cuspidal Subspace
  Second Block:  Eisenstein Subspace

      Cuspidal Subspace:    Block for each level `M` dividing `N`, from highest
                            level to lowest. The block for level `M`
                            contains the images at level `N` of the
                            newsubspace of level `M` (basis, then
                            basis(q**d), then basis(q**e), etc.)

     Eisenstein Subspace:   characters, etc.

Since we can compute dimensions of cuspidal subspaces quickly and
easily, it should be easy to locate any of the above blocks.  Hence,
e.g., to compute basis for new cuspidal subspace, just have to return
first n standard basis vector where n is the dimension.  However, we
can also create completely arbitrary subspaces as well.

The base ring is the ring generated by the character values (or
bigger).  In MAGMA the base was always `\ZZ`, which is confusing.
"""

#########################################################################
#       Copyright (C) 2006 William Stein <wstein@gmail.com>
#
#  Distributed under the terms of the GNU General Public License (GPL)
#
#                  http://www.gnu.org/licenses/
#########################################################################
