# hydrobricks

A modular hydrological modelling framework.

[![DOI](https://zenodo.org/badge/301952016.svg)](https://zenodo.org/badge/latestdoi/301952016)
[![GitHub release](https://img.shields.io/github/v/release/hydrobricks/hydrobricks)](https://github.com/hydrobricks/hydrobricks/releases)
[![PyPI](https://img.shields.io/pypi/v/hydrobricks)](https://pypi.org/project/hydrobricks/)
![Static Badge](https://img.shields.io/badge/python-%3E%3D3.10-blue)
[![Core Tests](https://github.com/hydrobricks/hydrobricks/actions/workflows/core-tests-linux.yml/badge.svg)](https://github.com/hydrobricks/hydrobricks/actions/workflows/core-tests-linux.yml)
[![Python Tests](https://github.com/hydrobricks/hydrobricks/actions/workflows/python-tests-linux.yml/badge.svg)](https://github.com/hydrobricks/hydrobricks/actions/workflows/python-tests-linux.yml)
[![Python Wheels](https://github.com/hydrobricks/hydrobricks/actions/workflows/python-wheels.yml/badge.svg)](https://github.com/hydrobricks/hydrobricks/actions/workflows/python-wheels.yml)
[![Core Doxygen](https://github.com/hydrobricks/hydrobricks/actions/workflows/core-doxygen.yml/badge.svg)](https://github.com/hydrobricks/hydrobricks/actions/workflows/core-doxygen.yml)
[![Documentation Status](https://readthedocs.org/projects/hydrobricks/badge/?version=latest)](https://hydrobricks.readthedocs.io/en/latest/?badge=latest)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/hydrobricks/hydrobricks/main.svg)](https://results.pre-commit.ci/latest/github/hydrobricks/hydrobricks/main)
[![Codecov](https://img.shields.io/codecov/c/github/hydrobricks/hydrobricks)](https://codecov.io/gh/hydrobricks/hydrobricks)
[![Codacy Badge](https://app.codacy.com/project/badge/Grade/639e5bb76690488f9aac5feb89722bfa)](https://www.codacy.com/gh/hydrobricks/hydrobricks/dashboard?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=hydrobricks/hydrobricks&amp;utm_campaign=Badge_Grade)


## Install

Wheels are available to install from PyPI (https://pypi.org/project/hydrobricks/)

Install: ```pip install hydrobricks```

## Main resources
*   **Documentation**: https://hydrobricks.readthedocs.io/en/latest/
*   **Examples**: https://github.com/hydrobricks/hydrobricks/tree/main/python/examples
*   How to build: https://github.com/hydrobricks/hydrobricks/wiki
*   Code documentation of the core: https://hydrobricks.github.io/hydrobricks-doc-core/

## Additional resources
*   Code for downscaling hydrobricks outputs to sub-daily timescales (daily flow duration curves) in alpine glacierized catchments: https://github.com/ALArgentin/glacial-discharge-downscaling

## Contribute

We very much welcome contribution to hydrobricks! To do so:
1. Fork the repo
2. Code something
3. Push your contribution to your forked repo
4. Create a pull request

Thank you!
