########
# Copyright (c) 2016 GigaSpaces Technologies Ltd. All rights reserved
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import absolute_import


import subprocess
import sys

import proxy_tools
import sh

from docl.configuration import configuration


def bake(cmd):
    return cmd.bake(_err_to_out=True,
                    _out=lambda l: sys.stdout.write(l),
                    _tee=True)


def docker_proxy():
    return bake(sh.docker).bake('-H', configuration.docker_host)


docker = proxy_tools.Proxy(docker_proxy)
ssh_keygen = bake(sh.Command('ssh-keygen'))
cfy = bake(sh.cfy)


def ssh(ip, keypath):
    subprocess.call(['ssh', '-i', keypath, 'root@{}'.format(ip)])
