# Riveter Documentation

Welcome to the Riveter documentation hub. This directory is organized to help you find the information you need quickly.

## 📚 Documentation Structure

### For Users (Start Here!)
- **[Getting Started](user/README.md)** - Installation, quick start, and basic usage
- **[Rule Packs](user/rule-packs.md)** - Pre-built compliance and security rule collections
- **[Visual Guides](user/visual-guides.md)** - Architecture diagrams, flowcharts, and comparisons
- **[Troubleshooting](user/troubleshooting.md)** - Common issues and solutions

### Technical Documentation
- **[TECHNICAL.md](TECHNICAL.md)** - Comprehensive technical documentation
- **[tutorial.md](tutorial.md)** - Detailed tutorial

### Visual Documentation (Advanced)
- **[Architecture Diagrams](ARCHITECTURE_DIAGRAMS.md)** - Detailed system architecture
- **[Rule Evaluation Flowcharts](RULE_EVALUATION_FLOWCHARTS.md)** - Complete evaluation processes
- **[Rule Pack Comparisons](RULE_PACK_COMPARISONS.md)** - Comprehensive coverage analysis
- **[Visual Design System](VISUAL_DESIGN_SYSTEM.md)** - Design standards and templates

## 🎯 Quick Navigation by Goal

| I want to... | Go to... |
|--------------|----------|
| **Get started with Riveter** | [Getting Started](user/README.md) |
| **Choose the right rule packs** | [Rule Packs Guide](user/rule-packs.md) |
| **Understand how Riveter works** | [Visual Guides](user/visual-guides.md) |
| **Fix validation issues** | [Troubleshooting](user/troubleshooting.md) |
| **Deep technical details** | [Technical Documentation](TECHNICAL.md) |
| **Detailed architecture** | [Architecture Diagrams](ARCHITECTURE_DIAGRAMS.md) |

---

*This documentation structure prioritizes user needs while keeping detailed technical information accessible.*
