# Riveter Examples

This directory contains comprehensive examples organized by learning progression and use case complexity.

## Directory Structure

```
examples/
├── quickstart/           # 5-minute success examples
├── by-complexity/        # Examples organized by difficulty
│   ├── beginner/         # Single resource, simple rules
│   ├── intermediate/     # Multi-resource, complex rules
│   └── advanced/         # Enterprise patterns
├── by-use-case/          # Real-world scenarios
│   ├── web-application/
│   ├── data-pipeline/
│   ├── microservices/
│   └── compliance/
├── by-cloud/             # Cloud-specific examples
│   ├── aws/
│   ├── azure/
│   ├── gcp/
│   └── multi-cloud/
└── ci-cd/                # CI/CD integration examples
    ├── github-actions/
    ├── gitlab-ci/
    ├── jenkins/
    └── azure-devops/
```

## How to Use These Examples

### For New Users
Start with `quickstart/` examples to get your first success in under 5 minutes.

### By Experience Level
- **Beginner**: Start with `by-complexity/beginner/`
- **Intermediate**: Move to `by-complexity/intermediate/`
- **Advanced**: Explore `by-complexity/advanced/`

### By Use Case
Browse `by-use-case/` to find examples that match your infrastructure patterns.

### By Cloud Provider
Find cloud-specific examples in `by-cloud/` or multi-cloud patterns in `by-cloud/multi-cloud/`.

### For CI/CD Integration
Check `ci-cd/` for complete pipeline examples with your preferred CI/CD platform.

## Example Metadata

Each example includes a `metadata.yml` file with:
- Learning objectives
- Prerequisites
- Estimated completion time
- Skill level indicators
- Related examples

## Quick Navigation

| I want to... | Go to... |
|--------------|----------|
| Get started quickly | `quickstart/` |
| Learn step by step | `by-complexity/beginner/` |
| See real-world patterns | `by-use-case/` |
| Find cloud-specific examples | `by-cloud/` |
| Set up CI/CD integration | `ci-cd/` |
